moment.locale( 'es' ); //// fechas en español

var periodos = 
    [
        {
            Name: '1 day',
            Label: '1 day',
            TimeframePeriod: 15,
            TimeframeHeaders: 
                [
                    'dddd D MMMM YYYY',
                    'HH',
                    'mm'
                ]
        }
    ];

//------------Jornada Dia---------------------------------//
var dia;

var jornadaDia = {
    Periods: [],

    Items: [],     // actividades
    Sections: [], // trabajadores

    Init: function ( entrada, fechaI ) {
        dia = moment( fechaI, 'DD-MM-YYYY' ).startOf( 'd' );

        TimeScheduler.Options.GetSections = jornadaDia.GetSections;
        TimeScheduler.Options.GetSchedule = jornadaDia.GetSchedule;
        TimeScheduler.Options.Start = dia.add( entrada, 'hours' );
        TimeScheduler.Options.Periods = jornadaDia.Periods;
        TimeScheduler.Options.SelectedPeriod = '1 day';
        TimeScheduler.Options.Element = $( 'div#dia' );

        TimeScheduler.Options.Events.ItemClicked = jornadaDia.Item_Clicked;

        TimeScheduler.Init();
    },

    GetSections: function ( callback ) {
        callback( jornadaDia.Sections );
    },

    GetSchedule: function ( callback, start, end ) {
        callback( jornadaDia.Items );
    },

    Item_Clicked: function ( item ) {
        if ( item.mov == 'Cita Servicio' || item.mov == 'Orden Servicio' )
        {
            $( 'div.modal-header > h4#tipoMov' ).text( item.mov +' - '+ item.movId );
    
            var asesorNombreCompleto;
            var coment;
            coment = item.Comentarios == null ? item.Observaciones : item.Comentarios;
            asesorNombreCompleto = item.nombreAsesor == null ? ' ' : item.nombreAsesor + ' ';
            asesorNombreCompleto += item.apPaternoAsesor == null ? ' ' : item.apPaternoAsesor + ' ';
            asesorNombreCompleto += item.apMaternoAsesor == null ? ' ' : item.apMaternoAsesor;

            item.estatus = item.estatus == null ? '-' : item.estatus;

            var situacion;
            item.mov == 'Orden Servicio' ? situacion = '<dt>Situación</dt><dd>' + item.situacion + '</dd>' : situacion = '';

            // datos cliente
            item.nomCte = item.nomCte == null ? '-' : item.nomCte;
            
            var ladaTel = '';
            if ( item.ladaCte != null )
                ladaTel = item.ladaCte + ' - ';
            if ( item.telCte != null )
                ladaTel += item.telCte;

            item.emailCte = item.emailCte == null ? '-' : item.emailCte;

            // datos servicio
            item.tipoOrden = item.tipoOrden == null ? '-' : item.tipoOrden;
            item.tipoOperacion = item.tipoOperacion == null ? '-' : item.tipoOperacion;

            var torre = '';
            if ( item.mov == 'Orden Servicio' )
            {
                item.torre = item.torre == null ? '-' : item.torre;
                item.noTorre = item.noTorre == null ? '-' : item.noTorre;

                torre =
                    '<dt>Torre</dt>' +
                    '<dd>' + item.torre + '</dd>' +
                    '<dt>No. Torre</dt>' +
                    '<dd>' + item.noTorre + '</dd>';
            }

            // datos VIN
            item.serie = item.serie == null ? '-' : item.serie;
            item.cveModelo = item.cveModelo == null ? '-' : item.cveModelo;
            item.modelo = item.modelo == null ? '-' : item.modelo;
            item.anioModelo = item.anioModelo == null ? '-' : item.anioModelo;

            $( 'div.modal-body#detalles' ).html(
                '<dl class="dl-horizontal">' + 
                    '<dt>Asesor</dt>' +
                    '<dd>' + item.claveAsesor + ' - ' + asesorNombreCompleto + '</dd>' +
                    '<dt>Inicio</dt>' +
                    '<dd>' + item.fechaIni.format( 'dddd D MMMM, HH:mm:ss' ) + '</dd>' +
                    '<dt>Fin</dt>' +
                    '<dd>' + item.fechaFin.format( 'dddd D MMMM, HH:mm:ss' ) + '</dd>' +
                    '<dt>Estatus</dt>' +
                    '<dd>' + item.estatus + '</dd>' +
                    situacion +
                '</dl>' +
                '<center><b>Cliente</b></center>'+
                '<dl class="dl-horizontal">' +
                    '<dt>Nombre</dt>' +
                    '<dd>' + item.nomCte + '</dd>' +
                    '<dt>Lada - Tél.</dt>' +
                    '<dd>' + ladaTel + '</dd>' +
                    '<dt>Correo</dt>' +
                    '<dd>' + item.emailCte + '</dd>' +
                '</dl>'+
                '<center><b>Servicio</b></center>' +
                '<dl class="dl-horizontal">' +
                    '<dt>Tipo Orden</dt>' +
                    '<dd>' + item.tipoOrden + '</dd>' +
                    '<dt>Tipo Operación</dt>' +
                    '<dd>' + item.tipoOperacion + '</dd>' +
                    torre +
                    '<dt>Hora Llegada</dt>' +
                    '<dd>' + item.hrLlegada + '</dd>' +
                    '<dt>Hora Prometida</dt>' +
                    '<dd>' + item.hrPromesa + '</dd>' +
                '</dl>' +
                '<center><b>Vin</b></center>' +
                '<dl class="dl-horizontal">' +
                    '<dt>Serie</dt>' +
                    '<dd>' + item.serie + '</dd>' +
                    '<dt>Modelo</dt>' +
                    '<dd>' + item.modelo + '</dd>' +
                    '<dt>Año</dt>' +
                    '<dd>' + item.anioModelo + '</dd>' +
                    '<dt>Clave Modelo</dt>' +
                    '<dd>' + item.cveModelo + '</dd>' +
                    '<dt>Placas</dt>' +
                    '<dd>' + item.placas + '</dd>' +
                    '<dt>Comentarios</dt>' +
                    '<dd>' + coment + '<dd> <a id="abrirComentariosTecnico"> Ver mas...</a>' +
                '</dl>'
            );

            $( 'div#detallesModal' ).modal( 'show' );
            
            // ===============================================================
            // Inicia llenado del modal con los comentario del técnico
            // ===============================================================
            $('#tituloComentarios').text(item.mov +' - '+ item.movId + ' - Comentarios Técnico')
                        
            var tblComments
            $('#comentariosDelTecnico').empty()

            cantidadComentarios = item.comentariosTecnico.length

            if(cantidadComentarios != 0){
                // Tabla con los comentarios del tecnico 
                tblComments         = $('<table>').addClass('table table-responsive');
                var encabezado      = $('<thead>').appendTo(tblComments);
                var titulosColumnas = $('<tr>').appendTo(encabezado);

                for (var i=0; i< cantidadComentarios ; i++) {
                    // En la primera iteracion se agregan los cabeceros de las columnas
                    if(i === 0 ){
                        $.each(item.comentariosTecnico[0], function(index, comments){
                            $('<th>').text(index).appendTo(titulosColumnas);
                        })        
                    }

                    var fila = $('<tr>').appendTo(tblComments)
                    $.each(item.comentariosTecnico[i], function(indexField, field){
                        $('<td>').text((field ?? '-') ).appendTo(fila)
                    })
                }
            }
            else{
                tblComments = $('<div>').text('El técnico aun no agrega comentarios de su operación.')
                tblComments.css({
                    'font-size': '1.5rem',
                    'font-weight': 'bold'
                });
            }

            $('#comentariosDelTecnico').append(tblComments)
            // ===============================================================
            // Termina llenado del modal con los comentario del técnico
            // ===============================================================

        }
        else if ( item.opReal )
        {
            $( 'div.modal-header > h4#tipoMov' ).text( 'Orden Servicio - '+ item.movId );

            var estado, comentarios;
            if ( item.estado )
                estado = '<dt>Estatus</dt>' +
                         '<dd>' + item.estado + '</dd>';
            else
                estado = '';
            if ( item.comentarios )
                comentarios = '<dt>Comentarios</dt>' +
                              '<dd>' + item.comentarios + '</dd>';
            else
                comentarios = '';

            $( 'div.modal-body#detalles' ).html(
                '<dl class="dl-horizontal">' +
                    '<dt>Clave Asesor</dt>' +
                    '<dd>' + item.claveAsesor + '</dd>' +
                    '<dt>Inicio Real</dt>' +
                    '<dd>' + item.fechaIni.format( 'dddd D MMMM, HH:mm:ss' ) + '</dd>' +
                    '<dt>Fin Real</dt>' +
                    '<dd>' + item.fechaFin.format( 'dddd D MMMM, HH:mm:ss' ) + '</dd>' +
                    '<dt>Inicio Estimado</dt>' +
                    '<dd>' + item.inicioEst + '</dd>' +
                    '<dt>Fin Estimado</dt>' +
                    '<dd>' + item.finEst + '</dd>' +
                    '<dt>Clave Operación</dt>' +
                    '<dd>' + item.cveOp + '</dd>' +
                    '<dt>Descripción</dt>' +
                    '<dd>' + item.descripcion + '</dd>' +
                    '<dt>Duración Real</dt>' +
                    '<dd>' + item.duracionReal + ' hrs.</dd>' +
                    '<dt>Duración Estimada</dt>' +
                    '<dd>' + item.duracionEst + ' hrs.</dd>' +
                    '<dt>Tiempo Trabajado</dt>' +
                    '<dd>' + item.duracionTrabajado + ' hrs.</dd>' +
                    estado +
                    comentarios +
                '</dl>'
            );

            $( 'div#detallesModal' ).modal( 'show' );
        }
    }
};
//------------Termina Jornada Dia---------------------------------//