﻿<?php
    $this->load->view( 'plantillas/encabezado/includes' );
    $this->load->view( 'plantillas/encabezado/menu-torre' );
?>

<link rel="stylesheet" href="<?php echo base_url();?>assets/css/estilo.css">

<script src="<?php echo base_url();?>assets/js/dias.js"></script>
<script src="<?php echo base_url();?>assets/js/funciones.js"></script>

<script>
$( document ).ready( function() {
    $( 'title' ).text( 'Torre Control - Semana' );

    // peticion ajax sin cache
    $.ajaxSetup( { cache: false } );

    // contador de clicks sig semana inicia en 0
    var cntdr = 0;

    var status = 'ok';

    // que se va a solicitar, de acuerdo al menu
    var peticion = 'nada';

    $.when( peticionAjax( 1, peticion, 'Todos' ) )
        .done( function() {
            reiniciarIntervalo();
        });

    // peticion ajax para obtener agentes, actividades, suc, horario, etc.
    function peticionAjax( idSucursal, peticion, idPiso )
    {
        clearInterval( intervalo );
        
        $( '[data-toggle=tooltip]' ).tooltip( 'hide' );

        $( 'img#loading' ).removeClass( 'hidden' );

        var paramsNotify = {
                theme:  'relax',
                layout: 'topCenter',
                killer:  true,
                timeout: 3000,
                text:    '',
                type:    ''
            };

        return $.get(
            "<?php echo site_url();?>/horario/obtenerTodo",
            {
                sucursal: idSucursal,        // select sucursal
                piso: idPiso,
                peticion: peticion,         // que se esta solicitando
                lunes: moment().add( cntdr, 'w' ).weekday( 1 ).startOf( 'day' ).format( 'DD-MM-YYYY HH:mm:ss' ),
                sabado: moment().add( cntdr, 'w' ).weekday( 6 ).endOf( 'day' ).format( 'DD-MM-YYYY HH:mm:ss' )
            },
            function ( data ) 
            {
                llenarSucursales( data.sucursales, idSucursal );
                llenarSucursalesPiso( data.sucursalesPiso, idPiso);

                if ( data.jornada.status == 'error' )
                {
                    $( 'img#loading' ).addClass( 'hidden' );

                    status = 'ko';

                    paramsNotify.text ='<b>Sin datos para mostrar</b>';
                    paramsNotify.type = 'warning';
                    noty( paramsNotify );
                }
                else
                {
                    // vaciar/recargar actividades, agentes, periodos
                    vaciarObjetos();

                    ponerAgentes( data.agentes );

                    // solo los primeros 2 digitos de la hr, sin min ni seg
                    var entrada = data.jornada.entrada.substring( 0, 2 );
                    var salida = data.jornada.salida.substring( 0, 2 );
                    if( data.jornada.salida.substring( 3, 5 ) > 0 )
                        salida++;

                    ponerCitasServicio( data.citasServicio, entrada, salida );

                    ponerOrdenesServicio( data.ordenesServicio, entrada, salida );

                    switch ( peticion )
                    {
                        case 'ordenesReal' :
                            ponerOrdenesReal( data.ordenesReal );
                            break;
                        case 'ordenesRealHist' :
                            ponerOrdenesRealHist( data.ordenesRealHist );
                            break;
                        case 'operacionesReal' :
                            ponerOperacionesReal( data.operacionesReal );
                            break;
                        case 'operacionesRealHist' :
                            ponerOperacionesRealHist( data.operacionesRealHist );
                    }

                    
			//Marcar horario no hábil antes y después de la jornada
                    ponerFueraHorario( data.fueraHorario );
		    ponerNoDisponibilidad( data.horarioDisponibilidad );

                    // igualar actividades en los 5 obj
                    jornadaMartes.Items = jornadaMiercoles.Items = jornadaJueves.Items =
                    jornadaViernes.Items = jornadaSabado.Items = jornadaLunes.Items;

                    // igualar secciones en los otros 5 obj
                    jornadaMartes.Sections = jornadaMiercoles.Sections = jornadaJueves.Sections =
                    jornadaViernes.Sections = jornadaSabado.Sections = jornadaLunes.Sections;

                    // asignar los periodos a todas las jornadas
                    jornadaMartes.Periods = jornadaMiercoles.Periods = jornadaJueves.Periods =
                    jornadaViernes.Periods = jornadaSabado.Periods = jornadaLunes.Periods =
                        periodos;

                    // igualar duracion en los otros 5 obj
                    jornadaLunes.Periods[ 0 ].TimeframeOverall = jornadaMartes.Periods[ 0 ].TimeframeOverall =
                    jornadaMiercoles.Periods[ 0 ].TimeframeOverall = jornadaJueves.Periods[ 0 ].TimeframeOverall =
                    jornadaViernes.Periods[ 0 ].TimeframeOverall = jornadaSabado.Periods[ 0 ].TimeframeOverall =
                        ( 60 * ( salida - entrada ) ); // data.jornada.duracion => salida, termina jornada

                    // escribir titulo de la semana
                    ponerTextoSemana( cntdr );

                    // inicializar los otros 5 obj
                    jornadaLunes.Init( entrada, cntdr );
                    jornadaMartes.Init( entrada, cntdr );
                    jornadaMiercoles.Init( entrada, cntdr );
                    jornadaJueves.Init( entrada, cntdr );
                    jornadaViernes.Init( entrada, cntdr );
                    jornadaSabado.Init( entrada, cntdr );

                    // diseño
                    aplicarColores( peticion, data.colores );

                    $( 'table > thead > tr:nth-child(1) > td.time-sch-date-header' ).addClass( 'alert-info' );
                    $( 'div#lunes > div.time-sch-wrapper > div.time-sch-header-wrapper.time-sch-clearfix' ).remove();
                    $( 'div.textoActividad' ).tooltip({
                        container: 'body',
                        placement: 'left'
                    });
                    $( ':checkbox[name=cita], :checkbox[name=servicio]' ).trigger( 'change' );

                    // asignar fechas de todos los dias de la semana, para peticion info de mecanicos
                    $( 'div.dia' ).each( function ( index ) {
                        $( this ).attr( 'data-fecha',  moment().add( cntdr, 'w' ).weekday( index + 1 ).format( 'DD-MM-YYYY' ) );
                    });

                    // evento click sobre mecanico, horas trabajas - horas estimadas
                    $( 'u.mecanico' ).click( function() {
                        var mecanico = $( this ).data( 'mecanico' );

                        $( 'img#loading' ).removeClass( 'hidden' );

                        $.get(
                            "<?php echo site_url();?>/horario/obtenerDatosMecanico",
                            {
                                mecanico: mecanico, // mecanico en el que dio click
                                fecha: $( this ).parents( 'div.dia' ).data( 'fecha' ), // dia en el que dio click
                            },
                            function ( data )
                            {
                                $( 'h4#cveMecanico' ).text( mecanico );

                                var realHrs = moment.duration( data.TiempoReal, 'm' ).hours();
                                if ( realHrs < 1 ) realHrs = ' ';
                                else if ( realHrs === 1 ) realHrs += ' hora ';
                                else realHrs += ' horas ';

                                var realMin = moment.duration( data.TiempoReal, 'm' ).minutes();
                                if ( realMin < 1 ) realMin = '';
                                else if ( realMin === 1 ) realMin += ' minuto';
                                else realMin += ' minutos';

                                var estimadoHrs = moment.duration( data.TiempoEstimado, 'm' ).hours();
                                if ( estimadoHrs < 1 ) estimadoHrs = ' ';
                                else if ( estimadoHrs === 1 ) estimadoHrs += ' hora ';
                                else estimadoHrs += ' horas ';

                                var estimadoMin = moment.duration( data.TiempoEstimado, 'm' ).minutes();
                                if ( estimadoMin < 1 ) estimadoMin = '';
                                else if ( estimadoMin === 1 ) estimadoMin += ' minuto';
                                else estimadoMin += ' minutos';

                                var trabajadoHrs = moment.duration( data.TiempoTrabajado, 'm' ).hours();
                                if ( trabajadoHrs < 1 ) trabajadoHrs = ' ';
                                else if ( trabajadoHrs === 1 ) trabajadoHrs += ' hora ';
                                else trabajadoHrs += ' horas ';

                                var trabajadoMin = moment.duration( data.TiempoTrabajado, 'm' ).minutes();
                                if ( trabajadoMin < 1 ) trabajadoMin = '';
                                else if ( trabajadoMin === 1 ) trabajadoMin += ' minuto';
                                else trabajadoMin += ' minutos';

                                $( 'tr#duraciones' ).html(
                                    '<td>' + estimadoHrs + estimadoMin + '</td>' +
                                    '<td>' + realHrs + realMin + '</td>' +
                                    '<td>' + trabajadoHrs + trabajadoMin + '</td>'
                                );

                                $( 'div#mecanicoModal' ).modal( 'show' );
                            },
                            'json'
                        );
                    });

                    status = 'ok';

                    $( 'img#loading' ).addClass( 'hidden' );
		    reiniciarIntervalo();//No actualizaba con Ordenes y Operaciones
                }
            },
            'json'
        ).fail(
            function()
            {
                status = 'ko';

                $( 'button' ).button( 'reset' );

                $( 'img#loading' ).addClass( 'hidden' );

                paramsNotify.text ='<b>Ocurrió un error, vuelve a intentar</b>';
                paramsNotify.type = 'error';
                noty( paramsNotify );
            }
        );
    }

    // modal de duraciones, al mostrarlo se oculta loading
    $( 'div#mecanicoModal' ).on( 'show.bs.modal', function(){
        $( 'img#loading' ).addClass( 'hidden' );
    });

    // tooltip para botones
    $( 'div.col-md-3 > button, div.col-md-3 > a' ).tooltip( {
        container: 'body'
    });

    // evento cambia de sucursal, skin jquery ui
    $( 'select#sucursal' ).selectmenu( {
        change: function( event, data ) {
            // al cambiar de sucursal, sucursal = data.item.value
            $.when( peticionAjax( data.item.value, peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    reiniciarIntervalo();
                });
        }
    });

    // evento cambia de sucursal, skin jquery ui
    $( 'select#sucursalPiso' ).selectmenu( {
        change: function( event, data ) {
            // al cambiar de sucursal, sucursal = data.item.value
            $.when( peticionAjax( $( 'select#sucursal' ).val(), peticion, data.item.value ) )
                .done( function() {
                    reiniciarIntervalo();
                });
        }
    });

    // se actualiza sobre la sucursal seleccionada y la semana que se esta viendo, input semana
    $( 'button#btnActualizar' ).click( function() {
        var btn = $( this ).button( 'loading' );

        $.when( peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    reiniciarIntervalo();
                    
                    btn.button( 'reset' );
                });
    });

    // boton para regresar a semana actual, sucursal seleccionada y se obtiene semana actual,
    // contador reinicia en semana actual
    $( 'button#btnSemanaActual' ).click( function() {
        var btn = $( this ).button( 'loading' );

        cntdr = 0;

        $.when( peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    reiniciarIntervalo();
                    
                    btn.button( 'reset' );
                });
    });

    // boton para avanzar de semana, aumenta contador de semana,
    // si hubo algun 'error' (obtenerJornadaSemana), no aumenta contador, se hace peticion
    $( 'button#btnSigSemana' ).click( function() {
        var btn = $( this ).button( 'loading' );

        cntdr ++;

        $.when( peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                        cntdr --;

                    reiniciarIntervalo();
                    
                    btn.button( 'reset' );
                });
    });

    // boton para retoceder de semana, disminuye contador de semana,
    // si hubo algun 'error' (obtenerJornadaSemana), no disminuye contador, se hace peticion
    $( 'button#btnAntSemana' ).click( function() {
        var btn = $( this ).button( 'loading' );

        cntdr --

        $.when( peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                        cntdr ++;

                    reiniciarIntervalo();
                    
                    btn.button( 'reset' );
                });
    });    

    // slide menu
    $( 'nav#displayOpt' ).mmenu({
        classes: 'mm-light',
        offCanvas: {
            zposition: 'front'
        }
    }).removeClass( 'hidden' );
    
    // ###### opciones de visualizacion ######
    /*  los tiempos estimados se quedan igual, se muestran/ocultan
        los tiempos reales ya no se muestran/ocultan,
        se hace una peticion y se obtiene solo lo solicitado en el menu */

    // general citas, ocultar/mostrar todo lo relacionado a citas
    $( ':checkbox[name=cita]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
            if ( $( ':checkbox[name=estimado]' ).is( ':checked' ) )
                $( '.cita' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.cita' ).parents( '.time-sch-item' ).addClass( 'hidden' );
        else
            $( '.cita' ).parents( '.time-sch-item' ).addClass( 'hidden' );
    });

    // general servicios, ocultar/mostrar todo lo relacionado a servicios
    $( ':checkbox[name=servicio]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
        {
            // estimado
            if ( $( ':checkbox[name=estimado]' ).is( ':checked' ) )
                $( '.servicioEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

            // real
            $( '.operacionReal, .operacionRealH, .ordenReal, .ordenRealH' )
                    .parents( '.time-sch-item' ).addClass( 'hidden' );

            switch ( peticion )
            {
                case 'ordenesReal' :
                    $( '.ordenReal' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'ordenesRealHist' :
                    $( '.ordenRealH' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'operacionesReal' :
                    $( '.operacionReal' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'operacionesRealHist' :
                    $( '.operacionRealH' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            }
        }
        else
            $( '.servicio' ).parents( '.time-sch-item' ).addClass( 'hidden' );
    });

    // tiempo estimado
    $( ':checkbox[name=estimado]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
        {
            if ( $( ':checkbox[name=cita]' ).is( ':checked' ) )
                $( '.citaEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.citaEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

            if ( $( ':checkbox[name=servicio]' ).is( ':checked' ) )
                $( '.servicioEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );
        }
        else
            $( '.citaEst, .servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

    });

    $( ':radio[name=hOrden]' ).change( function ( e ) {
        if ( $( this ).val() == 'no' )
            peticion = 'ordenesReal';
        else if ( $( this ).val() == 'si' )
            peticion = 'ordenesRealHist';

        peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    $( ':radio[name=hOperacion]' ).change( function ( e ) {
        if ( $( this ).val() == 'no' )
            peticion = 'operacionesReal';
        else if ( $( this ).val() == 'si' )
            peticion = 'operacionesRealHist';

        peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    // tiempo real, que nivel? (orden, operacion)
    $( ':radio[name=realNivel]' ).change( function ( e ) {
        if ( $( this ).val() == 'ordenR' )
        {
            $( ':radio[name=hOrden]' ).prop( 'checked', false );
            $( 'li.histOperacion' ).hide();
            $( 'li.histOrden' ).show();
        }
        else if ( $( this ).val() == 'operacionR' )
        {
            $( ':radio[name=hOperacion]' ).prop( 'checked', false );
            $( 'li.histOrden' ).hide();
            $( 'li.histOperacion' ).show();
        }

        peticion = 'nada';
        peticionAjax( $( 'select#sucursal' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    // ###### termina opciones de visualizacion ########

    // Abre modal con los comentarios del técnico
    $(document).on('click', '#abrirComentariosTecnico',  function(){
        $('div#detallesModal').modal('hide')
        $('#comentariosModal').modal('show')
    });
    // Si se cierra el modal de comentarios vuelve a abrir el modal principal
    $('#comentariosModal').on('hidden.bs.modal', function (e) {
        $('div#detallesModal').modal('show')
        $('#comentariosModal').modal('hide')
    });

    $( document ).scroll( function() {
        $( '#sucursal' ).selectmenu( 'close' );
    });
});
</script>

<!-- slide menu -->
<nav id="displayOpt" class="hidden">
    <ul>
        <li>
            <a href="<?php echo base_url();?>index.php/color" id="conf_color">
                <i class="fa fa-paint-brush"></i> <strong>Configurar Colores</strong>
            </a>
        </li>
        <li>
            <span>Citas Servicio</span> <!-- Todo lo relacionado a citas -->
            <input type="checkbox" name="cita" class="Toggle" checked="cheked">
        </li>
        <li>
            <span>Ordenes Servicio</span> <!-- Todo lo relacionado a ordenes -->
            <input type="checkbox" name="servicio" class="Toggle" checked="cheked">
        </li>
        <li>
            <span>Tiempo Estimado</span> <!-- Tiempo estimado de ambas, citas y ordenes -->
            <input type="checkbox" name="estimado" class="Toggle" checked="cheked">
        </li>
        <li>
            <center><b>Tiempo Real</b></center>
        </li>
        <li>
            <span>Por Orden</span>
            <input type="radio" name="realNivel" class="Toggle" value="ordenR">
        </li>
        <li>
            <span>Por Operación</span>
            <input type="radio" name="realNivel" class="Toggle" value="operacionR">
        </li>
        <li>
            <center><b>Historial</b></center>
        </li>
        <li class="histOrden">
            <span>Con Historial de Situaciones</span>
            <input type="radio" name="hOrden" class="Toggle" value="si">
        </li>
        <li class="histOrden">
            <span>Sin Historial de Situaciones</span>
            <input type="radio" name="hOrden" class="Toggle" value="no">
        </li>
        <li class="histOperacion">
            <span>Con Historial de Estatus</span>
            <input type="radio" name="hOperacion" class="Toggle" value="si">
        </li>
        <li class="histOperacion">
            <span>Sin Historial de Estatus</span>
            <input type="radio" name="hOperacion" class="Toggle" value="no">
        </li>
    </ul>
</nav>

<img id="loading" src="<?php echo base_url();?>assets/img/ajax-loading.gif" class="hidden"> 

<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
    <div class="container-fluid" id="menu">
        <div class="col-md-3 pull-left btn-xs">
            <select name="sucursal" id="sucursal">
                <optgroup label="Seleccionar Sucursal"></optgroup>
            </select>
        </div>
        <div class="col-md-2 pull-left btn-xs">
            <select name="sucursalPiso" id="sucursalPiso">
                <optgroup label="Seleccionar Piso"></optgroup>
            </select>
        </div>
        <div class="col-md-4">
            <b><center id="textoSemana"></center></b>
        </div>
        <div class="col-md-3">
            <button type="button" id="btnActualizar" class="btn btn-success pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Actualizar">
                <span class="glyphicon glyphicon-refresh"></span>
            </button>
            <button type="button" id="btnSemanaActual" class="btn btn-info pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Ir a Semana Actual">
                <span class="glyphicon glyphicon-hand-down"></span>
            </button>
            <button type="button" id="btnSigSemana" class="btn btn-warning pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Siguiente Semana">
                <span class="glyphicon glyphicon-chevron-right"></span>
            </button>
            <button type="button" id="btnAntSemana" class="btn btn-warning pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Semana Anterior">
                <span class="glyphicon glyphicon-chevron-left"></span>
            </button>
            <a href="<?php echo base_url();?>index.php/horario/verDia" class="btn btn-primary pull-right" data-placement="bottom" data-toggle="tooltip" title="Ver por Día">
                <span class="glyphicon glyphicon-pushpin"></span>
            </a>
        </div>
    </div>
</nav>
<div id="lunes" class="dia" data-fecha=""></div>

<div id="martes" class="dia" data-fecha=""></div>

<div id="miercoles" class="dia" data-fecha=""></div>

<div id="jueves" class="dia" data-fecha=""></div>

<div id="viernes" class="dia" data-fecha=""></div>

<div id="sabado" class="dia" data-fecha=""></div>

<!-- Modal con mas info sobre la orden o cita dervicio -->
<div class="modal fade" id="detallesModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="tipoMov"></h4>
            </div>
            <div class="modal-body" id="detalles"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="comentariosModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="tituloComentarios">Comentarios del técnico</h4>
            </div>
            <div class="modal-body" style="text-align: center; " id="comentariosDelTecnico"></div>
        </div>
    </div>
</div>

<!-- Modal con mas info sobre el mecanico -->
<div class="modal fade" id="mecanicoModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="cveMecanico"></h4>
            </div>
            <div class="modal-body">
                <table style="width: 100%;">
                    <thead>
                        <tr>
                            <th>Tiempo Estimado</th><th>Tiempo Real</th><th>Tiempo Trabajado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr id="duraciones"></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view( 'plantillas/pie' ) ?>