﻿<?php
    $this->load->view( 'plantillas/encabezado/includes' );
    $this->load->view( 'plantillas/encabezado/menu-torre' );
?>

<link rel="stylesheet" href="<?php echo base_url();?>assets/css/estiloDia.css">

<script src="<?php echo base_url();?>assets/js/dia.js"></script>
<script src="<?php echo base_url();?>assets/js/funcionesDia.js"></script>

<script>
$( document ).ready( function() {
    $( 'title' ).text( 'Torre Control - Día' );

	// peticion ajax sin cache
    $.ajaxSetup( { cache: false } );

    // al cargar la pag por primera vez, sucursal = 1, obtener fecha de hoy
    $( 'input#fechaI' ).val( moment().format( 'DD-MM-YYYY' ) );
    $( 'input#fechaD' ).val( $( 'input#fechaI' ).val() );

    // contador para controlar sig/ant dia, inicia en 0
    var contadorDia = 0;

    var status = 'ok';

    // que se va a solicitar, de acuerdo al menu
    var peticion = 'nada';

    $.when( peticionAjax( 1, $( 'input#fechaI' ).val(), peticion, 'Todos' ) )
        .done( function() {
            reiniciarIntervalo();
        });

    // peticion ajax para obtener agentes, actividades, suc, horario, etc.
    function peticionAjax( idSucursal, fechaI, peticion, idPiso )
    {
        clearInterval( intervalo );

        $( '[data-toggle=tooltip]' ).tooltip( 'hide' );

        $( 'img#loading' ).removeClass( 'hidden' );

        var paramsNotify = {
                theme:  'relax',
                layout: 'topCenter',
                killer:  true,
                timeout: 3000,
                text:    '',
                type:    ''
            };

        return $.get(
            "<?php echo site_url();?>/horario/obtenerTodo",
            {
                sucursal: idSucursal,        // select sucursal
                piso: idPiso,
                fecha: fechaI,           	// fecha input hidden, click sig dia ++
                peticion: peticion         // que se esta solicitando
            },
            function ( data )
            {
                llenarSucursales( data.sucursales, idSucursal );
                llenarSucursalesPiso( data.sucursalesPiso, idPiso);

                if ( data.jornada.status == 'error' || ! data.agentes.length )
                {
                    $( 'img#loading' ).addClass( 'hidden' );

                    status = 'ko';

                    paramsNotify.text ='<b>Sin datos para mostrar</b>';
                    paramsNotify.type = 'warning';
                    noty( paramsNotify );
                }
                else 
                {
                    // vaciar/recargar actividades, agentes, periodos
                    vaciarObjetos();

                    ponerAgentes( data.agentes );

                    // solo los primeros 2 digitos de la hr, sin min ni seg
                    var entrada = data.jornada.entrada.substring( 0, 2 );
                    var salida = data.jornada.salida.substring( 0, 2 );
                    if( data.jornada.salida.substring( 3, 5 ) > 0 )
                        salida++;

                    ponerCitasServicio( data.citasServicio, entrada, salida );

                    ponerOrdenesServicio( data.ordenesServicio, entrada, salida );

                    switch ( peticion )
                    {
                        case 'ordenesReal' :
                            ponerOrdenesReal( data.ordenesReal );
                            break;
                        case 'ordenesRealHist' :
                            ponerOrdenesRealHist( data.ordenesRealHist );
                            break;
                        case 'operacionesReal' :
                            ponerOperacionesReal( data.operacionesReal );
                            break;
                        case 'operacionesRealHist' :
                            ponerOperacionesRealHist( data.operacionesRealHist );
                    }

                    ponerNoDisponibilidad( data.horarioDisponibilidad );

                    
			//Marcar horario no hábil antes y después de la jornada
                    ponerFueraHorario( data.fueraHorario );
			// asignar los periodos a todas la jornada
                    jornadaDia.Periods = periodos;

                    // data.jornada.duracion => salida, termina jornada, no. de horas en minutos
                    jornadaDia.Periods[ 0 ].TimeframeOverall = ( 60 * ( salida - entrada ) );

                    // inicializar objeto
                    jornadaDia.Init( entrada, fechaI );
                
                    // diseño
                    aplicarColores( peticion, data.colores );
                    
                    $( 'table > thead > tr:nth-child(1) > td.time-sch-date-header' ).addClass( 'alert-info' );
                    $( 'div#dia > div.time-sch-wrapper > div.time-sch-header-wrapper.time-sch-clearfix' ).remove();

                    $( 'div.textoActividad' ).tooltip({
                        container: 'body',
                        placement: 'left'
                    });

                    $( ':checkbox[name=cita], :checkbox[name=servicio]' ).trigger( 'change' );

                    // evento click sobre mecanico, horas trabajas - horas estimadas
                    $( 'u.mecanico' ).click( function() {
                        var mecanico = $( this ).data( 'mecanico' );

                        $( 'img#loading' ).removeClass( 'hidden' );

                        $.get(
                            "<?php echo site_url();?>/horario/obtenerDatosMecanico",
                            {
                                mecanico: mecanico, // mecanico en el que dio click
                                fecha: $( 'input#fechaI' ).val()
                            },
                            function ( data )
                            {
                                $( 'h4#cveMecanico' ).text( mecanico );

                                var realHrs = moment.duration( data.TiempoReal, 'm' ).hours();
                                if ( realHrs < 1 ) realHrs = ' ';
                                else if ( realHrs === 1 ) realHrs += ' hora ';
                                else realHrs += ' horas ';
                                
                                var realMin = moment.duration( data.TiempoReal, 'm' ).minutes();
                                if ( realMin < 1 ) realMin = '';
                                else if ( realMin === 1 ) realMin += ' minuto';
                                else realMin += ' minutos';
                                
                                var estimadoHrs = moment.duration( data.TiempoEstimado, 'm' ).hours();
                                if ( estimadoHrs < 1 ) estimadoHrs = ' ';
                                else if ( estimadoHrs === 1 ) estimadoHrs += ' hora ';
                                else estimadoHrs += ' horas ';

                                var estimadoMin = moment.duration( data.TiempoEstimado, 'm' ).minutes();
                                if ( estimadoMin < 1 ) estimadoMin = '';
                                else if ( estimadoMin === 1 ) estimadoMin += ' minuto';
                                else estimadoMin += ' minutos';

                                var trabajadoHrs = moment.duration( data.TiempoTrabajado, 'm' ).hours();
                                if ( trabajadoHrs < 1 ) trabajadoHrs = ' ';
                                else if ( trabajadoHrs === 1 ) trabajadoHrs += ' hora ';
                                else trabajadoHrs += ' horas ';

                                var trabajadoMin = moment.duration( data.TiempoTrabajado, 'm' ).minutes();
                                if ( trabajadoMin < 1 ) trabajadoMin = '';
                                else if ( trabajadoMin === 1 ) trabajadoMin += ' minuto';
                                else trabajadoMin += ' minutos';

                                $( 'tr#duraciones' ).html(
                                    '<td>' + estimadoHrs + estimadoMin + '</td>' +
                                    '<td>' + realHrs + realMin + '</td>' +
                                    '<td>' + trabajadoHrs + trabajadoMin + '</td>'
                                );

                                $( 'div#mecanicoModal' ).modal( 'show' );
                            },
                            'json'
                        );
                    });

                    status = 'ok';

                    $( 'img#loading' ).addClass( 'hidden' );
		    reiniciarIntervalo();//No Actualizaba en Ordenes y Operaciones	
                }
            },
            'json'
        ).fail(
            function()
            {
                status = 'ko';

                $( 'button' ).button( 'reset' );

                $( 'img#loading' ).addClass( 'hidden' );
            
                paramsNotify.text ='<b>Ocurrió un error, vuelve a intentar</b>';
                paramsNotify.type = 'error';
                noty( paramsNotify );
            }
        );
    }

    // modal de duraciones, al mostrarlo se oculta loading
    $( 'div#mecanicoModal' ).on( 'show.bs.modal', function(){
        $( 'img#loading' ).addClass( 'hidden' );
    });

    // tooltip para botones
    $( 'div.col-md-3 > button, a' ).tooltip( {
        container: 'body'
    });

    // evento cambia de sucursal, skin jquery ui
    $( 'select#sucursal' ).selectmenu( {
        change: function( event, data ) {
            // al cambiar de sucursal, sucursal = data.item.value
            $.when( peticionAjax( data.item.value, $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    reiniciarIntervalo();
                });
            // $( 'select#sucursal' ).val(data.item.value);
        }
    });

    $( 'select#sucursalPiso' ).selectmenu( {
        change: function( event, data ) {
            // al cambiar de sucursal, sucursal = data.item.value
            $.when( peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, data.item.value ) )
                .done( function() {
                    reiniciarIntervalo();
                });
        }
    });

    // datepicker
    datepickerES();

    $( 'input#fechaI' ).datepicker({
    	dateFormat: 'dd-mm-yy',
    	onSelect: function( selected, evt ) {
            var backUp = $( 'input#fechaD' ).val();

    		$( 'input#fechaD' ).val( selected );
    		contadorDia = 0;

            var btn = $( 'button#btnDia' ).button( 'loading' );

        	$.when( peticionAjax( $( 'select#sucursal' ).val(), selected, peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                        $( 'input#fechaD, input#fechaI' ).val( backUp );
                    
                    reiniciarIntervalo();

                    btn.button( 'reset' );
                });
    	}
    });

    // click en boton abre datepicker
    $( 'button#btnDia' ).click( function() {
    	$( 'input#fechaI' ).datepicker( 'show' );
    });

    // se actualiza sobre la sucursal seleccionada y el dia que se esta viendo
    $( 'button#btnActualizar' ).click( function() {
        var btn = $( this ).button( 'loading' );

        $.when( peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    reiniciarIntervalo();

                    btn.button( 'reset' );
                });
    });

    // boton para regresar dia de hoy, sucursal seleccionada
    // contador dia reinicia en 0
    $( 'button#btnHoy' ).click( function() {
        var btn = $( this ).button( 'loading' );

        var backUp = $( 'input#fechaD' ).val();

        $( 'input#fechaI' ).val( moment().format( 'DD-MM-YYYY' ) );
        $( 'input#fechaD' ).val( $( 'input#fechaI' ).val() );

        contadorDia = 0;

        $.when( peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                        $( 'input#fechaD, input#fechaI' ).val( backUp );

                    reiniciarIntervalo();

                    btn.button( 'reset' );
                });
    });

    // boton para avanzar dia, aumenta contador dia,
    // si hubo algun 'error' (obtenerJornadaDia), no aumenta contador, se hace peticion
    $( 'button#btnSigDia' ).click( function() {
        var btn = $( this ).button( 'loading' );

        contadorDia ++;

        $( 'input#fechaI' ).val( moment( $( 'input#fechaD' ).val(), 'DD-MM-YYYY' ).add( contadorDia, 'days' )
                                        .format( 'DD-MM-YYYY' ) );

        if ( moment( $( 'input#fechaI' ).val(), 'DD-MM-YYYY' ).weekday() == 0 )
        {
            contadorDia ++;

            $( 'input#fechaI' ).val( moment( $( 'input#fechaD' ).val(), 'DD-MM-YYYY' ).add( contadorDia, 'days' )
                                        .format( 'DD-MM-YYYY' ) );
        }

        $.when( peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                    {
                        contadorDia --;
                    
                        $( 'input#fechaI' ).val( moment().subtract( contadorDia*-1, 'days' ).format( 'DD-MM-YYYY' ) );

                        if ( moment( $( 'input#fechaI' ).val(), 'DD-MM-YYYY' ).weekday() == 0 )
                        {
                            contadorDia --;

                            $( 'input#fechaI' ).val( moment().subtract( contadorDia*-1, 'days' ).format( 'DD-MM-YYYY' ) );
                        }
                    }

                    reiniciarIntervalo();

                    btn.button( 'reset' );
                });
    });

    // boton para retroceder dia, disminuye contador dia,
    // si hubo algun 'error' (obtenerJornadaDia), no disminuye contador, se hace peticion
    $( 'button#btnAntDia' ).click( function() {
        var btn = $( this ).button( 'loading' );

        contadorDia --;

        $( 'input#fechaI' ).val( moment( $( 'input#fechaD' ).val(), 'DD-MM-YYYY' ).subtract( (contadorDia * -1 ), 'days' )
                                     .format( 'DD-MM-YYYY' ) );

        if ( moment( $( 'input#fechaI' ).val(), 'DD-MM-YYYY' ).weekday() == 0 )
        {
            contadorDia --;
        
            $( 'input#fechaI' ).val( moment( $( 'input#fechaD' ).val(), 'DD-MM-YYYY' ).subtract( (contadorDia * -1 ), 'days' )
                                     .format( 'DD-MM-YYYY' ) );
        }

        $.when( peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() ) )
                .done( function() {
                    if ( status == 'ko' )
                    {
                        contadorDia ++;
                    
                        $( 'input#fechaI' ).val( moment().add( contadorDia, 'days' ).format( 'DD-MM-YYYY' ) );

                        if ( moment( $( 'input#fechaI' ).val(), 'DD-MM-YYYY' ).weekday() == 0 )
                        {
                            contadorDia ++;

                            $( 'input#fechaI' ).val( moment().add( contadorDia, 'days' ).format( 'DD-MM-YYYY' ) );
                        }
                    }

                    reiniciarIntervalo();

                    btn.button( 'reset' );
                });
    });

	// slide menu
    $( 'nav#displayOpt' ).mmenu({
        classes: 'mm-light',
        offCanvas: {
            zposition: 'front'
        }
    }).removeClass( 'hidden' );

    // ###### opciones de visualizacion ######
    /*  los tiempos estimados se quedan igual, se muestran/ocultan
        los tiempos reales ya no se muestran/ocultan,
        se hace una peticion y se obtiene solo lo solicitado en el menu */

    // general citas, ocultar/mostrar todo lo relacionado a citas
    $( ':checkbox[name=cita]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
            if ( $( ':checkbox[name=estimado]' ).is( ':checked' ) )
                $( '.cita' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.cita' ).parents( '.time-sch-item' ).addClass( 'hidden' );
        else
            $( '.cita' ).parents( '.time-sch-item' ).addClass( 'hidden' );
    });

    // general servicios, ocultar/mostrar todo lo relacionado a servicios
    $( ':checkbox[name=servicio]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
        {
            // estimado
            if ( $( ':checkbox[name=estimado]' ).is( ':checked' ) )
                $( '.servicioEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

            // real
            $( '.operacionReal, .operacionRealH, .ordenReal, .ordenRealH' )
                    .parents( '.time-sch-item' ).addClass( 'hidden' );

            switch ( peticion )
            {
                case 'ordenesReal' :
                    $( '.ordenReal' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'ordenesRealHist' :
                    $( '.ordenRealH' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'operacionesReal' :
                    $( '.operacionReal' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
                    break;
                case 'operacionesRealHist' :
                    $( '.operacionRealH' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            }
        }
        else
            $( '.servicio' ).parents( '.time-sch-item' ).addClass( 'hidden' );
    });

    // tiempo estimado
    $( ':checkbox[name=estimado]' ).change( function ( e ) {
        if ( $( this ).is( ':checked' ) )
        {
            if ( $( ':checkbox[name=cita]' ).is( ':checked' ) )
                $( '.citaEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.citaEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

            if ( $( ':checkbox[name=servicio]' ).is( ':checked' ) )
                $( '.servicioEst' ).parents( '.time-sch-item' ).removeClass( 'hidden' );
            else
                $( '.servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );
        }
        else
            $( '.citaEst, .servicioEst' ).parents( '.time-sch-item' ).addClass( 'hidden' );

    });

    $( ':radio[name=hOrden]' ).change( function ( e ) {
        if ( $( this ).val() == 'no' )
            peticion = 'ordenesReal';
        else if ( $( this ).val() == 'si' )
            peticion = 'ordenesRealHist';

        peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    $( ':radio[name=hOperacion]' ).change( function ( e ) {
        if ( $( this ).val() == 'no' )
            peticion = 'operacionesReal';
        else if ( $( this ).val() == 'si' )
            peticion = 'operacionesRealHist';

        peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    // tiempo real, que nivel? (orden, operacion)
    $( ':radio[name=realNivel]' ).change( function ( e ) {
        if ( $( this ).val() == 'ordenR' )
        {
            $( ':radio[name=hOrden]' ).prop( 'checked', false );
            $( 'li.histOperacion' ).hide();
            $( 'li.histOrden' ).show();
        }
        else if ( $( this ).val() == 'operacionR' )
        {
            $( ':radio[name=hOperacion]' ).prop( 'checked', false );
            $( 'li.histOrden' ).hide();
            $( 'li.histOperacion' ).show();
        }

        peticion = 'nada';
        peticionAjax( $( 'select#sucursal' ).val(), $( 'input#fechaI' ).val(), peticion, $( 'select#sucursalPiso' ).val() );
    });

    // ###### termina opciones de visualizacion ########

    $( document ).scroll( function() {
        $( '#sucursal' ).selectmenu( 'close' );
    });

    $(document).on('click', '#abrirComentariosTecnico',  function(){
        $('div#detallesModal').modal('hide')
        $('#comentariosModal').modal('show')
    });
    // Si se cierra el modal de comentarios vuelve a abrir el modal principal
    $('#comentariosModal').on('hidden.bs.modal', function (e) {
        $('div#detallesModal').modal('show')
        $('#comentariosModal').modal('hide')
    });
});
</script>

<!-- slide menu -->
<nav id="displayOpt" class="hidden">
    <ul>
        <li>
            <a href="<?php echo base_url();?>index.php/color" id="conf_color">
                <i class="fa fa-paint-brush"></i> <strong>Configurar Colores</strong>
            </a>
        </li>
        <li>
            <span>Citas Servicio</span>
            <input type="checkbox" name="cita" class="Toggle" checked="cheked">
        </li>
        <li>
            <span>Ordenes Servicio</span>
            <input type="checkbox" name="servicio" class="Toggle" checked="cheked">
        </li>
        <li>
            <span>Tiempo Estimado</span>
            <input type="checkbox" name="estimado" class="Toggle" checked="cheked">
        </li>
        <li>
            <center><b>Tiempo Real</b></center>
        </li>
        <li>
            <span>Por Orden</span>
            <input type="radio" name="realNivel" class="Toggle" value="ordenR">
        </li>
        <li>
            <span>Por Operación</span>
            <input type="radio" name="realNivel" class="Toggle" value="operacionR">
        </li>
        <li>
            <center><b>Historial</b></center>
        </li>
        <li class="histOrden">
            <span>Con Historial de Situaciones</span>
            <input type="radio" name="hOrden" class="Toggle" value="si">
        </li>
        <li class="histOrden">
            <span>Sin Historial de Situaciones</span>
            <input type="radio" name="hOrden" class="Toggle" value="no">
        </li>
        <li class="histOperacion">
            <span>Con Historial de Estatus</span>
            <input type="radio" name="hOperacion" class="Toggle" value="si">
        </li>
        <li class="histOperacion">
            <span>Sin Historial de Estatus</span>
            <input type="radio" name="hOperacion" class="Toggle" value="no">
        </li>
    </ul>
</nav>

<!-- menu -->
<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
<div class="container-fluid" id="menu">
    <div class="col-md-3 pull-left btn-xs">
        <select name="sucursal" id="sucursal">
            <optgroup label="Seleccionar Sucursal"></optgroup>
        </select>
    </div>
    <div class="col-md-2 pull-left btn-xs">
        <select name="sucursalPiso" id="sucursalPiso">
            <optgroup label="Seleccionar Piso"></optgroup>
        </select>
    </div>
    <div class="col-md-4">
    	<input type="text" name="fechaI" id="fechaI" class="form-control pull-right" disabled="disabled" style="width: 25%;">
    </div>
    <div class="col-md-3 pull-right">
        <button type="button" id="btnActualizar" class="btn btn-success pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Actualizar">
            <span class="glyphicon glyphicon-refresh"></span>
        </button>
        <button type="button" id="btnHoy" class="btn btn-info pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Hoy">
            <span class="glyphicon glyphicon-hand-down"></span>
        </button>
        <button type="button" id="btnSigDia" class="btn btn-warning pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Siguiente Día">
            <span class="glyphicon glyphicon-chevron-right"></span>
        </button>
        <button type="button" id="btnAntDia" class="btn btn-warning pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Día Anterior">
            <span class="glyphicon glyphicon-chevron-left"></span>
        </button>
        <a href="<?php echo base_url();?>" class="btn btn-primary pull-right" data-placement="bottom" data-toggle="tooltip" title="Ver por Semana">
            <span class="glyphicon glyphicon-pushpin"></span>
        </a>
        <button type="button" id="btnDia" class="btn btn-info pull-right" data-loading-text="..." autocomplete="off" data-placement="bottom" data-toggle="tooltip" title="Elegir Día">
            <span class="glyphicon glyphicon-calendar"></span>
        </button>
    </div>
</div>
</nav>
<img id="loading" src="<?php echo base_url();?>assets/img/ajax-loading.gif" class="hidden"> 

<input type="hidden" name="fechaD" id="fechaD">

<div id="dia"></div>

<!-- Modal con mas info sobre la orden o cita dervicio -->
<div class="modal fade" id="detallesModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="tipoMov"></h4>
            </div>
            <div class="modal-body" id="detalles"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="comentariosModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="tituloComentarios">Comentarios del técnico</h4>
            </div>
            <div class="modal-body" style="text-align: center; " id="comentariosDelTecnico"></div>
        </div>
    </div>
</div>

<!-- Modal con mas info sobre el mecanico -->
<div class="modal fade" id="mecanicoModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header alert-info" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="cveMecanico"></h4>
            </div>
            <div class="modal-body">
                <table style="width: 100%;">
                    <thead>
                        <tr>
                            <th>Tiempo Estimado</th><th>Tiempo Real</th><th>Tiempo Trabajado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr id="duraciones"></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view( 'plantillas/pie' ) ?>
