<?php
    $this->load->view( 'plantillas/encabezado/includes' );
    $this->load->view( 'plantillas/encabezado/colores' );
?>

<style>
div#main-container { margin-top: 10px; }

img#loading
{
    position: fixed;
    top: 50%;
    left: 50%;
    margin-top: -100px;
    margin-left: -100px;
    z-index: 5;
}
</style>

<script>
$( document ).ready( function() {

	$( 'title' ).text( 'Torre Control - Colores' );

	var	site_url = '<?php echo site_url()?>';

	$( 'input.minicolors' ).minicolors( {
		theme: 'bootstrap',
		letterCase: 'uppercase',
		defaultValue: '#000000'
	});

	// para regresar al color inicial, se tien un input oculto,
	// se asigna el valor de este al input correspondiente
	$( 'button.regresarColor' ).on( 'click', function() {
		var colorInicial = $( this ).parent().siblings( 'input.regresarColor' ).val();

		$( this ).parent().siblings( 'div.minicolors' )
							.children().first()
								.minicolors( 'value', colorInicial );
	});

	// documentacion....................
	$( 'button.guardarColor' ).on( 'click', function() {
		var paramsNotify = {
				theme:  'relax',
				layout: 'topCenter',
				killer:  true,
				timeout: 3000,
				text:    '',
				type:    ''
			};

		$( 'img#loading' ).removeClass( 'hidden' );
		$( this ).button( 'loading' );

		var tabla = $( this ).data( 'tabla' );
		var data = {};

		// en un switch se arman los datos a guardar en variable data
		switch ( tabla )
		{
			case 'CatColorTC':
				data =
				{
					tabla: ConfigVersionIntelisis == 'V6000' ? 'CA_CatColorTC' : 'CatColorTC',
					colores:
					{
						estCita:
						{
							id: $( 'input#estCita' ).data( 'idtabla' ),
							color: $( 'input#estCita' ).val()
						},
						estOrdenServ:
						{
							id: $( 'input#estOrdenServ' ).data( 'idtabla' ),
							color: $( 'input#estOrdenServ' ).val()
						},
						estimadoProc:
						{
							id: $( 'input#estimadoProc' ).data( 'idtabla' ),
							color: $( 'input#estimadoProc' ).val()
						},
						estimadoDet:
						{
							id: $( 'input#estimadoDet' ).data( 'idtabla' ),
							color: $( 'input#estimadoDet' ).val()
						},
						estimadoFin:
						{
							id: $( 'input#estimadoFin' ).data( 'idtabla' ),
							color: $( 'input#estimadoFin' ).val()
						}
					}
				};

				break;

			case 'CatColorTCOO':
				data =
				{
					tabla: ConfigVersionIntelisis == 'V6000' ? 'CA_CatColorTC' : 'CatColorTC',
					colores:
					{
						ordenes:
						{
							id: $( 'input#ordenR' ).data( 'idtabla' ),
							color: $( 'input#ordenR' ).val()
						},
						operaciones:
						{
							id: $( 'input#opR' ).data( 'idtabla' ),
							color: $( 'input#opR' ).val()
						}
					}
				};

				break;

			case 'CatOrdenesSituaciones':
				data[ 'tabla' ] = ConfigVersionIntelisis == 'V6000' ? 'CA_CatOrdenesSituaciones' : 'CatOrdenesSituaciones';
				data[ 'colores' ] = [];

				$( 'input.minicolors.sitOrden' ).each( function ( index ) {
					data[ 'colores' ].push( {
		        		'id': $( this ).data( 'idtabla' ),
		        		'color': $( this ).val()
		        	});
				});

				break;

			case 'CatOperacionesEstados':
				data[ 'tabla' ] = ConfigVersionIntelisis == 'V6000' ? 'CA_CatOperacionesEstados' : 'CatOperacionesEstados';
				data[ 'colores' ] = [];

				$( 'input.minicolors.estOp' ).each( function ( index ) {
					data[ 'colores' ].push( {
		        		'id': $( this ).data( 'idtabla' ),
		        		'color': $( this ).val()
		        	});
				});

				break;

			case 'CatColorTCOtros':
				data =
				{
					tabla: ConfigVersionIntelisis == 'V6000' ? 'CA_CatColorTC' : 'CatColorTC',
					colores:
					{
						tiempoRetraso:
						{
							id: $( 'input#tRetraso' ).data( 'idtabla' ),
							color: $( 'input#tRetraso' ).val()
						},
						tiempoDescanso:
						{
							id: $( 'input#tDescanso' ).data( 'idtabla' ),
							color: $( 'input#tDescanso' ).val()
						},
						tiempoDescanso:
						{
							id: $( 'input#alerta' ).data( 'idtabla' ),
							color: $( 'input#alerta' ).val()
						}
					}
				};
		}

		data[ 'csrf_test_name' ] = $( 'input#token' ).val();

		// guardar con ajax
		$.post(
			site_url + '/color/actualizar',
			data,
			function ( respuesta )
			{
				if ( respuesta.status )
				{
					// setear los colores actualizados
					switch ( tabla )
					{
						case 'CatColorTC':
							$( 'input#estCita' ).minicolors( 'value', respuesta.colores[ 0 ][ 'color' ] );
							$( 'input#estCitaReg' ).val( respuesta.colores[ 0 ][ 'color' ] );

							$( 'input#estOrdenServ' ).minicolors( 'value', respuesta.colores[ 1 ][ 'color' ] );;
							$( 'input#estOrdenServReg' ).val( respuesta.colores[ 1 ][ 'color' ] );

							$( 'input#estimadoProc' ).minicolors( 'value', respuesta.colores[ 6 ][ 'color' ] );;
							$( 'input#estimadoProcReg' ).val( respuesta.colores[ 6 ][ 'color' ] );

							$( 'input#estimadoDet' ).minicolors( 'value', respuesta.colores[ 7 ][ 'color' ] );;
							$( 'input#estimadoDetReg' ).val( respuesta.colores[ 7 ][ 'color' ] );

							$( 'input#estimadoFin' ).minicolors( 'value', respuesta.colores[ 8 ][ 'color' ] );;
							$( 'input#estimadoFinReg' ).val( respuesta.colores[ 8 ][ 'color' ] );

							break;

						case 'CatColorTCOO':
							$( 'input#ordenR' ).minicolors( 'value', respuesta.colores[ 4 ][ 'color' ] );
							$( 'input#ordenRReg' ).val( respuesta.colores[ 4 ][ 'color' ] );

							$( 'input#opR' ).minicolors( 'value', respuesta.colores[ 5 ][ 'color' ] );;
							$( 'input#opRReg' ).val( respuesta.colores[ 5 ][ 'color' ] );

							break;

						case 'CatOrdenesSituaciones':
							$.each( respuesta.colores, function ( index, situacion  ) {
								$( 'input.sitOrden#' + situacion.situacionSeg.replace( / /g, '' ) ).minicolors( 'value', situacion.color );
								$( 'input.sitOrden#' + situacion.situacionSeg.replace( / /g, '' ) + 'Reg' ).val( situacion.color );
							});

							break;

						case 'CatOperacionesEstados':
							$.each( respuesta.colores, function ( index, operacion  ) {
								$( 'input.estOp#' + operacion.estadoSeg.replace( / /g, '' ) ).minicolors( 'value', operacion.color );
								$( 'input.estOp#' + operacion.estadoSeg.replace( / /g, '' ) + 'Reg' ).val( operacion.color );
							});

							break;

						case 'CatColorTCOtros':
							$( 'input#tDescanso' ).minicolors( 'value', respuesta.colores[ 2 ][ 'color' ] );;
							$( 'input#tDescansoReg' ).val( respuesta.colores[ 2 ][ 'color' ] );
							
							$( 'input#tRetraso' ).minicolors( 'value', respuesta.colores[ 3 ][ 'color' ] );
							$( 'input#tRetrasoReg' ).val( respuesta.colores[ 3 ][ 'color' ] );

							$( 'input#alerta' ).minicolors( 'value', respuesta.colores[ 9 ][ 'color' ] );
							$( 'input#alertaReg' ).val( respuesta.colores[ 9 ][ 'color' ] );
					}

					paramsNotify.text = '<b>Se actualizó con exito</b>';
					paramsNotify.type = 'success';
					noty( paramsNotify );
				}
				else
				{
					paramsNotify.text = '<b>Ocurrió un error, vuelve a intentar</b>';
					paramsNotify.type = 'error';
					noty( paramsNotify );
				}
			},
			'json'
		).done( function() {
			$( 'img#loading' ).addClass( 'hidden' );
			$( 'button.guardarColor' ).button( 'reset' );
		}).fail( function() {
			$( 'img#loading' ).addClass( 'hidden' );
			$( 'button.guardarColor' ).button( 'reset' );

			paramsNotify.text = '<b>Ocurrió un error, vuelve a intentar</b>';
			paramsNotify.type = 'error';
			noty( paramsNotify );
		});
		//termina guardar con ajax
	});

}); //termina document ready
</script>

<img id="loading" src="<?php echo base_url();?>assets/img/ajax-loading.gif" class="hidden"> 

<input type="hidden" id="token" name="token" value="<?php echo $this->security->get_csrf_hash();?>">

<div class="container-fluid" id="main-container">
	<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
  		<div class="panel panel-info">
    		<div class="panel-heading" role="tab" id="titulo1">
      			<h4 class="panel-title">
	        		<a data-toggle="collapse" data-parent="#accordion" href="#collapse1" aria-expanded="true" aria-controls="collapse1">
	          			Tiempos Estimados
	        		</a>
     			</h4>
    		</div>
    		<div id="collapse1" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="titulo1">
			    <div class="panel-body">
			    	<div class="row">
			    		<div class="form-group col-md-3">
			    			<label for="estCita" class="input-group">Cita de Servicio</label>
		    				<div class="input-group">
					    		<input type="text" name="estCita" id="estCita" value="<?php echo $siempre[0]['color']?>" class="form-control minicolors" data-idtabla="1">
					    		<input type="text" id="estCitaReg" value="<?php echo $siempre[0]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
			    					<button class="btn btn-warning regresarColor" type="button">
			    						<span class="fa fa-undo" aria-hidden="true"></span> Regresar
			    					</button>
			    				</span>
			    			</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="estOrdenServ" class="input-group">Orden de Servicio</label>
			    			<div class="input-group">
					    		<input type="text" name="estOrdenServ" id="estOrdenServ" value="<?php echo $siempre[1]['color']?>" class="form-control minicolors" data-idtabla="2">
			    				<input type="text" id="estOrdenServReg" value="<?php echo $siempre[1]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
			    	</div>
			    	<div class="row">
			    		<div class="form-group col-md-3">
			    			<label for="estimadoProc" class="input-group">Orden de Servicio - En Proceso</label>
		    				<div class="input-group">
					    		<input type="text" name="estimadoProc" id="estimadoProc" value="<?php echo $siempre[3]['color']?>" class="form-control minicolors" data-idtabla="7">
					    		<input type="text" id="estimadoProcReg" value="<?php echo $siempre[3]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
			    					<button class="btn btn-warning regresarColor" type="button">
			    						<span class="fa fa-undo" aria-hidden="true"></span> Regresar
			    					</button>
			    				</span>
			    			</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="estimadoDet" class="input-group">Orden de Servicio - Detenida</label>
			    			<div class="input-group">
					    		<input type="text" name="estimadoDet" id="estimadoDet" value="<?php echo $siempre[4]['color']?>" class="form-control minicolors" data-idtabla="8">
			    				<input type="text" id="estimadoDetReg" value="<?php echo $siempre[4]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="estimadoFin" class="input-group">Orden de Servicio - Finalizada</label>
			    			<div class="input-group">
					    		<input type="text" name="estimadoFin" id="estimadoFin" value="<?php echo $siempre[5]['color']?>" class="form-control minicolors" data-idtabla="9">
			    				<input type="text" id="estimadoFinReg" value="<?php echo $siempre[5]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
			    	</div>
			    	<button type="button" class="btn btn-success guardarColor" data-tabla="CatColorTC" data-loading-text="Guardando..." autocomplete="off">
						<span class="fa fa-floppy-o" aria-hidden="true"></span> Guardar
					</button>
			    </div>
    		</div>
 		</div>

		<div class="panel panel-info">
			<div class="panel-heading" role="tab" id="titulo2">
				<h4 class="panel-title">
					<a class="collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapse2" aria-expanded="false" aria-controls="collapse2">
						Tiempo Real
					</a>
				</h4>
			</div>
			<div id="collapse2" class="panel-collapse collapse" role="tabpanel" aria-labelledby="titulo2">
				<div class="panel-body">
					<div class="row">
			    		<div class="form-group col-md-3">
			    			<label for="ordenR" class="input-group">Ordenes</label>
		    				<div class="input-group">
					    		<input type="text" name="ordenR" id="ordenR" value="<?php echo $CatColorTC[1]['color']?>" class="form-control minicolors" data-idtabla="5">
					    		<input type="text" id="ordenRReg" value="<?php echo $CatColorTC[1]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
			    					<button class="btn btn-warning regresarColor" type="button">
			    						<span class="fa fa-undo" aria-hidden="true"></span> Regresar
			    					</button>
			    				</span>
			    			</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="opR" class="input-group">Operaciones</label>
			    			<div class="input-group">
					    		<input type="text" name="opR" id="opR" value="<?php echo $CatColorTC[2]['color']?>" class="form-control minicolors" data-idtabla="6">
			    				<input type="text" id="opRReg" value="<?php echo $CatColorTC[2]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
			    	</div>
			    	<button type="button" class="btn btn-success guardarColor" data-tabla="CatColorTCOO" data-loading-text="Guardando..." autocomplete="off">
						<span class="fa fa-floppy-o" aria-hidden="true"></span> Guardar
					</button>
				</div>
			</div>
		</div>

		<div class="panel panel-info">
			<div class="panel-heading" role="tab" id="titulo3">
				<h4 class="panel-title">
					<a class="collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapse3" aria-expanded="false" aria-controls="collapse3">
					  	Tiempo Real - Situaciones de Orden
					</a>
				</h4>
			</div>
			<div id="collapse3" class="panel-collapse collapse" role="tabpanel" aria-labelledby="titulo3">
				<div class="panel-body">
					<div class="row">
		<?php
			$i = 0;

			foreach ( $CatOrdenesSituaciones as $situacion )
			{
				if ( $i < 4 )
					$i ++;
				else
				{
					$i = 1;

					echo '</div>'; // row
					echo '<div class="row">';
				}

					echo '<div class="form-group col-md-3">';
						echo '<label for="" class="input-group">'.$situacion['situacionSeg'].'</label>';
						echo '<div class="input-group">';
							echo '<input type="text" name="'.str_replace( ' ', '', $situacion['situacionSeg'] ).'" id="'.str_replace( ' ', '', $situacion['situacionSeg'] ).'" value="'.$situacion['color'].'" class="form-control minicolors sitOrden" data-idtabla="'.$situacion['id'].'">';
							echo '<input type="text" name="'.str_replace( ' ', '', $situacion['situacionSeg'] ).'Reg" id="'.str_replace( ' ', '', $situacion['situacionSeg'] ).'Reg" value="'.$situacion['color'].'" class="hidden regresarColor sitOrden">';
			    			echo '<span class="input-group-btn">';
			    				echo '<button class="btn btn-warning regresarColor" type="button">';
	    							echo '<span class="fa fa-undo" aria-hidden="true"></span> Regresar';
	    						echo '</button>';
			    			echo '</span>';
	    				echo '</div>';
		    		echo '</div>';
			}
		?>
			    	</div>
			    	<button type="button" class="btn btn-success guardarColor" data-tabla="CatOrdenesSituaciones" data-loading-text="Guardando..." autocomplete="off">
						<span class="fa fa-floppy-o" aria-hidden="true"></span> Guardar
					</button>
				</div>
			</div>
		</div>

		<div class="panel panel-info">
			<div class="panel-heading" role="tab" id="titulo4">
				<h4 class="panel-title">
					<a class="collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapse4" aria-expanded="false" aria-controls="collapse4">
					  	Tiempo Real - Estados de Operación
					</a>
				</h4>
			</div>
			<div id="collapse4" class="panel-collapse collapse" role="tabpanel" aria-labelledby="titulo4">
				<div class="panel-body">
					<div class="row">
		<?php
			$i = 0;

			foreach ( $CatOperacionesEstados as $operacion )
			{
				if ( $i < 4 )
					$i ++;
				else
				{
					$i = 1;

					echo '</div>'; // row
					echo '<div class="row">';
				}

					echo '<div class="form-group col-md-3">';
						echo '<label for="" class="input-group">'.$operacion['estadoSeg'].'</label>';
						echo '<div class="input-group">';
							echo '<input type="text" name="'.str_replace( ' ', '', $operacion['estadoSeg'] ).'" id="'.str_replace( ' ', '', $operacion['estadoSeg'] ).'" value="'.$operacion['color'].'" class="form-control minicolors estOp" data-idtabla="'.$operacion['id'].'">';
							echo '<input type="text" name="'.str_replace( ' ', '', $operacion['estadoSeg'] ).'Reg" id="'.str_replace( ' ', '', $operacion['estadoSeg'] ).'Reg" value="'.$operacion['color'].'" class="hidden regresarColor estOp">';
			    			echo '<span class="input-group-btn">';
			    				echo '<button class="btn btn-warning regresarColor" type="button">';
	    							echo '<span class="fa fa-undo" aria-hidden="true"></span> Regresar';
	    						echo '</button>';
			    			echo '</span>';
	    				echo '</div>';
		    		echo '</div>';
			}
		?>
					</div>
					<button type="button" class="btn btn-success guardarColor" data-tabla="CatOperacionesEstados" data-loading-text="Guardando..." autocomplete="off">
						<span class="fa fa-floppy-o" aria-hidden="true"></span> Guardar
					</button>
				</div>
			</div>
		</div>

		<div class="panel panel-info">
    		<div class="panel-heading" role="tab" id="titulo5">
      			<h4 class="panel-title">
	        		<a data-toggle="collapse" data-parent="#accordion" href="#collapse5" aria-expanded="true" aria-controls="collapse5">
	          			Otros
	        		</a>
     			</h4>
    		</div>
    		<div id="collapse5" class="panel-collapse collapse" role="tabpanel" aria-labelledby="titulo5">
			    <div class="panel-body">
			    	<div class="row">
			    		<div class="form-group col-md-3">
			    			<label for="tRetraso" class="input-group">Tiempo Retraso</label>
		    				<div class="input-group">
					    		<input type="text" name="tRetraso" id="tRetraso" value="<?php echo $CatColorTC[0]['color']?>" class="form-control minicolors" data-idtabla="4">
					    		<input type="text" id="tRetrasoReg" value="<?php echo $CatColorTC[0]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
			    					<button class="btn btn-warning regresarColor" type="button">
			    						<span class="fa fa-undo" aria-hidden="true"></span> Regresar
			    					</button>
			    				</span>
			    			</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="tDescanso" class="input-group">Hora de Comida, Permisos</label>
			    			<div class="input-group">
					    		<input type="text" name="tDescanso" id="tDescanso" value="<?php echo $siempre[2]['color']?>" class="form-control minicolors" data-idtabla="3">
			    				<input type="text" id="tDescansoReg" value="<?php echo $siempre[2]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
				    	<div class="form-group col-md-3">
				    		<label for="alerta" class="input-group">Alerta 15 minutos</label>
			    			<div class="input-group">
					    		<input type="text" name="alerta" id="alerta" value="<?php echo $siempre[6]['color']?>" class="form-control minicolors" data-idtabla="10">
			    				<input type="text" id="alertaReg" value="<?php echo $siempre[6]['color']?>" class="hidden regresarColor">
					    		<span class="input-group-btn">
					    			<button class="btn btn-warning regresarColor" type="button">
					    				<span class="fa fa-undo" aria-hidden="true"></span> Regresar
					    			</button>
					    		</span>
					    	</div>
				    	</div>
			    	</div>
			    	<button type="button" class="btn btn-success guardarColor" data-tabla="CatColorTCOtros" data-loading-text="Guardando..." autocomplete="off">
						<span class="fa fa-floppy-o" aria-hidden="true"></span> Guardar
					</button>
			    </div>
    		</div>
 		</div>
	</div>
</div>

<?php $this->load->view( 'plantillas/pie' ) ?>