<?php
	/**
	* 
	*/
	class HorarioModel extends CI_Model
	{
		public function obtenerAgentesDeSucursal( $input = NULL )
		{
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_VistaAgenteDisponibilidad'  : 'VistaAgenteDisponibilidad';
			$this->db->select( 'DISTINCT vad.Agente, vad.PersonalNombres, vad.PersonalApellidoPaterno, vad.SucursalEmpresa' )
						->from( "{$vista} vad" )
						->join( 'Agente', 'vad.Agente = Agente.Agente' )
							->where( "vad.SucursalEmpresa" , $input[ 'sucursal' ] )
							->where( "vad.Tipo" , "Mecanico" )
							->where( "vad.Estatus" , "Alta" )
							->where( "vad.Jornada <>" , '' );
			if ( $input[ 'piso' ] != 'Todos' )
				$this->db->where( "Zona" , $input[ 'piso' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( 'CONVERT(CHAR(10), vad.Entrada, 105) = ', $input[ 'fecha' ] );
			else if ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "vad.Entrada BETWEEN '$input[lunes]' AND '$input[sabado]'" );

			return $this->db->get()->result_array();
		}

		/*
			Obtiene sucursales para llenar el select y poder cambiar de sucursal.
			Regresa solo las sucursales, que tengan Mecanicos con jornada asignada.
		*/
		public function obtenerSucursales()
		{
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_VistaAgentePersonal'  : 'VistaAgentePersonal';
			$sub_query = "SELECT COUNT(VA2.Tipo) FROM {$vista} AS VA2 
				WHERE VA2.Tipo = 'Mecanico' AND VA1.SucursalEmpresa = VA2.SucursalEmpresa AND VA2.Jornada <> '' "; 					

			$query = $this->db->select( "DISTINCT VA1.SucursalEmpresa AS id, Sucursal.Nombre" )
								->from( "{$vista} AS VA1" )
									->where( "( $sub_query ) > 0 ", NULL, FALSE )
									->join( 'Sucursal', 'Sucursal.Sucursal = VA1.SucursalEmpresa' )
									->get()->result_array();

			return $query;
		}

		/*
			Obtiene pisos de sucursales para llenar el select y poder cambiar de piso.
			Regresa solo los pisos, que tengan Mecanicos con jornada asignada.
		*/
		public function obtenerSucursalesPiso()
		{
			$query = $this->db->select( "DISTINCT Zona AS Piso" )
								->from( "Agente" )
									->where( "Zona is not NULL" )
									->get()->result_array();

			return $query;
		}

		/*
			Recibe numero de semana.
			Obtiene la hora de entrada mas 'temprana' y la hora de salida mas 'tarde',
			asi como la duracion de la jornada, esto de una semana en especifico.
		*/
		public function obtenerJornada( $input = null )
		{
			$jornada[ 'status' ] = 'error';
				$tabla = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'CA_JornadaTiempoDia' : 'JornadaTiempoDia';
			// si no recibe numSemana
			if ( ! isset( $input[ 'lunes' ] ) && ! isset( $input[ 'fecha' ] ) )
				return $jornada;

			if ( isset( $input[ 'fecha' ] ) )
			{
				$jornada[ 'entrada' ] = $this->db->select_min( 'CONVERT(CHAR(08), Entrada, 108)', 'Entrada' )
		    	->from( $tabla )
		    	->where( 'CONVERT(CHAR(10), Fecha, 105) = ', $input[ 'fecha' ] )
		    	->get()->row()->Entrada;

			    $jornada[ 'salida' ] = $this->db->select_max( 'CONVERT(CHAR(08), Salida, 108)', 'Salida' )
			    	->from( $tabla )
			    	->where( 'CONVERT(CHAR(10), Fecha, 105) = ', $input[ 'fecha' ] )
			    	->get()->row()->Salida;
			    	//echo $this->db->last_query();
			}
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
			{
				// $semana = $this->obtenerLuSab( $input[ 'numSemana' ] );
				// para sqlsrv 2005 => CONVERT(CHAR(08), Entrada, 108)
				// $jornada[ 'entrada' ] = $this->db->select_min( 'CONVERT(CHAR(08), Entrada, 108)', 'Entrada' )
			   	$jornada[ 'entrada' ] = $this->db->select_min( 'CONVERT(CHAR(08), Entrada, 108)', 'Entrada' )
			    	->from( $tabla )
			    	->where( "Fecha BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "'" )
			    	->get()->row()->Entrada;

			    $jornada[ 'salida' ] = $this->db->select_max( 'CONVERT(CHAR(08), Salida, 108)', 'Salida' )
			    	->from( $tabla )
			    	->where( "Fecha BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "'" )
			    	->get()->row()->Salida;
			}

		    // si el resultado de la consulta no devuelve algo
		    if ( ! isset( $jornada[ 'entrada' ] ) || ! isset( $jornada[ 'salida' ] ) )
		    {
		    	unset( $jornada[ 'entrada' ], $jornada[ 'salida' ] );

		    	return $jornada;
		    }

		    $jornada[ 'status' ] = 'ok';
// print_r($this->db->last_query());
		    return $jornada;
		}

		public function obtenerCitasServicio( $input = null )
		{
			$select  = 'Mov, MovID, Situacion, Estatus, Agente, MIN(CCFechaIni) AS FechaIn, MAX(CCFechaFin) AS FechaFn, ';
			$select .= 'PersonalNombres AS nombreAsesor, PersonalApellidoPaterno AS apPaternoAsesor, ';
			$select .= 'PersonalApellidoMaterno AS apMaternoAsesor, ClaveAsesor, ';
			$select .= 'CteNombre, CteCorreo, CteLada, CteTel, ';
			$select .= 'ServicioTipoOperacion, ServicioTipoOrden, Torre, ColorTorre, HoraLlegada, HoraPromesa, ';
			$select .= 'VIN, ClaveModelo, AnoModelo, Modelo,ServicioPlacas,Observaciones, Comentarios';
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_VistaMonitorTallerOperaciones' : 'VistaMonitorTallerOperaciones';
			$this->db->select( $select )
				->from( $vista )
					->where( 'Mov', 'Cita Servicio' )
					->where( 'Estatus', 'CONFIRMAR' )
					->where( 'Sucursal', $input[ 'sucursal' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), CCFechaIni, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), CCFechaFin, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), CCFechaIni, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), CCFechaFin, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( ( CCFechaIni BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' ) " )
					->or_where( " ( CCFechaFin BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' ) )" );
			$this->db->group_by( [ 'Mov', 'MovID', 'Situacion', 'Estatus', 'Agente', 'PersonalNombres',
				'PersonalApellidoPaterno','PersonalApellidoMaterno, ClaveAsesor',
				'CteNombre', 'CteCorreo', 'CteLada', 'CteTel',
				'ServicioTipoOperacion', 'ServicioTipoOrden', 'Torre', 'ColorTorre', 'HoraLlegada', 'HoraPromesa',
				'VIN, ClaveModelo, AnoModelo, Modelo, ServicioPlacas,Observaciones,Comentarios' ] );
					
			return $this->db->get()->result_array();		
		}

		public function obtenerOrdenesServicio( $input = null )
		{
			$select  = 'ID, Mov, MovID, Situacion, Estatus, Agente, MIN(CCFechaIni) AS FechaIn, MAX(CCFechaFin) AS FechaFn, ';
			$select .= 'PersonalNombres AS nombreAsesor, PersonalApellidoPaterno AS apPaternoAsesor, ';
			$select .= 'PersonalApellidoMaterno AS apMaternoAsesor, ClaveAsesor, EstadoColor, ';
			$select .= 'CteNombre, CteCorreo, CteLada, CteTel, ';
			$select .= 'ServicioTipoOperacion, ServicioTipoOrden, Torre, ColorTorre, HoraLlegada, HoraPromesa, ';
			$select .= 'VIN, ClaveModelo, AnoModelo, Modelo, ServicioPlacas,Observaciones, Comentarios';
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_VistaMonitorTallerOperaciones' : 'VistaMonitorTallerOperaciones';
			$this->db->select( $select )
				->from( $vista )
					->where( 'Mov', 'Servicio' )
					->where( 'Estatus' , 'Pendiente' )
					// ->where( 'Situacion <>', 'Orden Cerrada' )
					->where( 'Sucursal' , $input[ 'sucursal' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), CCFechaIni, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), CCFechaFin, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), CCFechaIni, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), CCFechaFin, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( ( CCFechaIni BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' ) " )
					->or_where( " ( CCFechaFin BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' ) )" );
			$this->db->group_by( ['ID', 'Mov', 'MovID', 'Situacion', 'Estatus', 'Agente', 'PersonalNombres',
				'PersonalApellidoPaterno', 'PersonalApellidoMaterno, ClaveAsesor, EstadoColor',
				'CteNombre', 'CteCorreo', 'CteLada', 'CteTel',
				'ServicioTipoOperacion', 'ServicioTipoOrden', 'Torre', 'ColorTorre', 'HoraLlegada', 'HoraPromesa',
				'VIN', 'ClaveModelo', 'AnoModelo', 'Modelo, ServicioPlacas,Observaciones, Comentarios' ] );

			$ordenes = $this->db->get()->result_array();
			// Se buscan los comentarios del tecnico en cada operacion
			if($ordenes){
				$tabla = "SeguimientoOperaciones";
				$queries = "so.Estado, convert(varchar(20), so.FechaInicio,100) AS FechaInicio , convert(varchar(20), so.FechafIN,100) AS FechaFin, so.Usuario, vd.Agente, so.Comentarios";
				if ($this->config->item('ConfigVersionIntelisis') == 'V6000'){
				$tabla = "CA_SeguimientoOperaciones";
				$queries = "so.Estado, convert(varchar(20), so.FechaInicio,100) AS FechaInicio , convert(varchar(20), so.FechafIN,100) AS FechaFin, so.Usuario, vd.Agente, so.Comentarios";
				}
				for ($i = 0; $i < count($ordenes); ++$i){
					$id = $ordenes[$i]['ID'];
					$comentarios = $this->db
					->select($queries)
					->from("{$tabla} so")
					->join( "Venta v", "so.IdVenta = v.ID" )
					->join( "VentaD vd", "so.IdVenta = vd.ID AND so.Renglon = vd.Renglon and so.RenglonId = vd.RenglonID" )
					->where('idventa', $id)
					->order_by('so.id', 'asc')
					->get()->result_array();
					/*echo "<pre>";
					print_r($comentarios);
					echo "</pre>";*/
					
					$ordenes[$i]['comentariosTecnico'] = $comentarios;
					

				}
			}

			return $ordenes;
		}

		public function obtenterHorarioDisponibilidad( $input = null )
		{
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_VistaAgenteDisponibilidad'  : 'VistaAgenteDisponibilidad';
			$this->db->from( $vista)
						->where( 'SucursalEmpresa' , $input[ 'sucursal' ] )
						->where( 'Tipo' , 'Mecanico' )
						->where( 'Estatus' , 'Alta' )
						->where( 'Jornada <>' , '' );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( 'CONVERT(CHAR(10), Entrada, 105) = ', $input[ 'fecha' ] );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "Entrada BETWEEN '$input[lunes]' AND '$input[sabado]'" );

			return $this->db->get()->result_array();
		}

		public function obtenerFueraHorario( $jornada, $horario )
		{
			$tam = sizeof( $horario );
			for ( $i = 0; $i < $tam; $i++ )  
			{ 
				$fecha = substr( $horario[ $i ][ 'Entrada' ], 0,-13 );
				$ret[ $i ][ 'entrada' ] = $fecha." ".substr( $jornada[ 'entrada' ], 0,-4 );
				$ret[ $i ][ 'inicia' ] = $horario[ $i ][ 'Entrada' ];
				$ret[ $i ][ 'agente' ] = $horario[ $i ][ 'Agente' ];
				$ret[ $i + $tam ][ 'termina' ] = $horario[ $i ][ 'Salida' ];
				$ret[ $i + $tam ][ 'salida' ] = $fecha." ".substr( $jornada[ 'salida' ], 0,-4 );
				$ret[ $i + $tam ][ 'agente' ] = $horario[ $i ][ 'Agente' ];
			}
			if( $tam == 0 )
				$ret["FueraHorario"] = "No hay jornadas dadas de alta";

			return $ret;
		}
		
		public function obtenerOperacionesReal( $input = null )
		{
			$vista = $this->config->item('ConfigVersionIntelisis')  == 'V6000' ? 'vwCA_MTOperaciones' : 'MTOperaciones';
			$this->db->select( '*' ) // todo, despues decidimos que campos
				->from( $vista )
					->where( 'Sucursal', $input[ 'sucursal' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), InicioReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), FinReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), InicioReal, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), FinReal, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( InicioReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"FinReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"InicioReal < '". $input[ 'lunes' ] ."' AND FinReal > '". $input[ 'sabado' ] . "' )" );
			$this->db->order_by( 'MovID' , 'ASC' );

			return $this->_generarSalidaOperacionesReal( $this->db->get()->result_array() );
		}

		public function obtenerOperacionesRealHist( $input = null )
		{
			$vista_MTOOperacionesSeg = $this->config->item('ConfigVersionIntelisis') == 'V6000' ?  'vwCA_MTOperacionesSeg' : 'MTOperacionesSeg';
			$tabla_CatOperacionesEstados = $this->config->item('ConfigVersionIntelisis') == 'V6000' ?  'CA_CatOperacionesEstados' : 'CatOperacionesEstados';
			$this->db->select( "{$vista_MTOOperacionesSeg}.*, {$tabla_CatOperacionesEstados}.estadoSeg AS color" ) // todo, despues decidimos que campos
				->from( $vista_MTOOperacionesSeg )
					->where( 'Sucursal', $input[ 'sucursal' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), InicioReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), FinReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), InicioReal, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), FinReal, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( InicioReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"FinReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"InicioReal < '". $input[ 'lunes' ] ."' AND FinReal > '". $input[ 'sabado' ] . "' )" );
			$this->db->join( $tabla_CatOperacionesEstados, "{$vista_MTOOperacionesSeg}.EstadoSeg = {$tabla_CatOperacionesEstados}.estadoSeg" )
							->order_by( 'IdVenta' , 'ASC' )
							->order_by( 'Renglon' , 'ASC' );
// $this->db->get()->result_array();
// echo $this->db->last_query();
// die;
			return $this->_generarSalidaOperacionesRealHist( $this->db->get()->result_array() );
		}

		public function obtenerOrdenesReal( $input = null )
		{
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_MTOrdenes' : 'MTOrdenes';
			$this->db->select( '*' ) // todo, despues decidimos que campos
				->from( $vista )
					->where( 'Sucursal', $input[ 'sucursal' ] );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), InicioReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), FinReal, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), InicioReal, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), FinReal, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( InicioReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"FinReal BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"InicioReal < '". $input[ 'lunes' ] ."' AND FinReal > '". $input[ 'sabado' ] . "' )" );

			return $this->db->get()->result_array();
		}

		public function obtenerOrdenesRealHist( $input = null )
		{
			$vista_MTOrdenesSituaciones = $this->config->item('ConfigVersionIntelisis') == 'V6000' ?  'vwCA_MTOrdenesSituaciones' : 'MTOrdenesSituaciones';
			$tabla_CatOrdenesSituaciones = $this->config->item('ConfigVersionIntelisis') == 'V6000' ?  'CA_CatOrdenesSituaciones' : 'CatOrdenesSituaciones';
			$this->db->select( "{$vista_MTOrdenesSituaciones}.*, {$tabla_CatOrdenesSituaciones}.situacionSeg AS color" ) // todo, despues decidimos que campos
				->from( $vista_MTOrdenesSituaciones )
					->where( 'Sucursal', $input[ 'sucursal' ] )
					->where( 'Mecanico <>', '' );
			if ( isset( $input[ 'fecha' ] ) )
				$this->db->where( "( CONVERT(CHAR(10), FechaIniSituacion, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "CONVERT(CHAR(10), FechaFinSituacion, 105) = '". $input[ 'fecha' ] ."'" )
							->or_where( "( CONVERT(CHAR(10), FechaIniSituacion, 105) < '". $input[ 'fecha' ] ."'" )
								->where( "CONVERT(CHAR(10), FechaFinSituacion, 105) > '". $input[ 'fecha' ] ."' ) )" );
			elseif ( isset( $input[ 'lunes' ] ) && isset( $input[ 'sabado' ] ) )
				$this->db->where( "( FechaIniSituacion BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"FechaFinSituacion BETWEEN '" . $input[ 'lunes' ] . "' AND '" . $input[ 'sabado' ] . "' OR ".
								"FechaIniSituacion < '". $input[ 'lunes' ] ."' AND FechaFinSituacion > '". $input[ 'sabado' ] . "' )" );
			$this->db->join( $tabla_CatOrdenesSituaciones, "{$vista_MTOrdenesSituaciones}.SituacionHist = {$tabla_CatOrdenesSituaciones}.situacionSeg" )
				->order_by( 'IdVenta' );

			return $this->_generarSalidaOrdenesRealHist( $this->db->get()->result_array() );
		}

		public function _generarSalidaOrdenesRealHist( $ordenes )
		{
			$salida = [];
			$arreglo = [];

			$indice = 0;
			$nodoSituacion = 0;

			$totalOrdenes = count( $ordenes );

			while ( $indice < $totalOrdenes ) 
			{
				$arreglo = [];

				do
				{
					array_push( $arreglo , $ordenes[ $indice ] );
					$indice ++;
					if( $indice == $totalOrdenes  )
						break;
				} while ( $ordenes[ $indice ][ 'IdVenta' ] == $ordenes[ $indice - 1 ][ 'IdVenta' ] );

				$salida[ $nodoSituacion ] = $arreglo;
				$nodoSituacion ++;
			}

			return $salida;
		}

		public function _generarSalidaOperacionesRealHist( $statusReal )
		{
			$salida = [];
			$arreglo = [];

			$indice = 0;
			$nodoStatus = 0;

			$totalStatus = count( $statusReal );

			while ( $indice < $totalStatus ) 
			{
				$arreglo = [];

				do
				{
					array_push( $arreglo , $statusReal[ $indice ] );
					$indice = $indice + 1;
					if( $indice == $totalStatus  )
						break;
				} while ( ( $statusReal[ $indice ][ 'IdVenta' ] == $statusReal[ $indice - 1 ][ 'IdVenta' ] ) 
					&& ( $statusReal[ $indice ][ 'Renglon' ] == $statusReal[ $indice - 1 ][ 'Renglon' ] ) );

				$salida[ $nodoStatus ] = $arreglo;
				$nodoStatus = $nodoStatus + 1;
			}

			return $salida;
		}

		private function _generarSalidaOperacionesReal( $operacionesReal )
		{
			$salida = [];
			$arreglo = [];

			$indice = 0;

			$operacionesTotal = count( $operacionesReal );

			while ( $indice < $operacionesTotal ) 
			{
				$arreglo = [];

				do
				{
					array_push( $arreglo , $operacionesReal[ $indice ] );	
					$indice = $indice + 1;		
					if( $indice == $operacionesTotal )		
						break;
				} while ( $operacionesReal[ $indice ][ 'MovID' ] == $operacionesReal[ $indice - 1 ][ 'MovID' ] );
				$salida[ $operacionesReal[ $indice - 1 ][ 'MovID' ] ] = $arreglo;
			}

			return $salida;
		}

		public function obtenerDatosMecanico( $input = null )
		{
			$vista = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_MTOperacionesSeg' : 'MTOperacionesSeg';
			$funcionTorreTotalTiempos = $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'fnCA_fnTorreTotalTiempos' : 'fnTorreTotalTiempos';
			$fecha = $input[ 'fecha' ];
			$mecanico = $input[ 'mecanico' ];

			$selectRealTrabajado = 
			"DECLARE @Fecha datetime select @Fecha = '$fecha' 
			Select TiempoReal=SUM(DBO.{$funcionTorreTotalTiempos} (O.Mecanico, @Fecha, O.IdVenta, O.Renglon, IdSeguimiento, 'Real')),
			TiempoTrabajado=SUM(DBO.{$funcionTorreTotalTiempos} (O.Mecanico, @Fecha, O.IdVenta, O.Renglon, IdSeguimiento, 'Trabajado'))
			From {$vista} O
			where Mecanico = '$mecanico'
			group by Mecanico";

			$totalesStatus = $this->db->query( $selectRealTrabajado )->row_array();
			
			$selectDeEstatus = "DECLARE @Fecha datetime
			select @Fecha = '$fecha'
			Select
			DISTINCT
			IdVenta,
			Renglon,
				TiempoEstimado=DBO.{$funcionTorreTotalTiempos} (Mecanico, @Fecha, IdVenta, Renglon, IdSeguimiento, 'Estimado')
				from {$vista}
				where Mecanico = '$mecanico'";

			$totalesStatus[ 'TiempoEstimado' ] = $this->sumTiempoEstimado( $this->db->query( $selectDeEstatus )->result_array() );

			return $totalesStatus;
		}

		public function sumTiempoEstimado( $operaciones )
		{
			$tiempoEstimado = 0;

			foreach ( $operaciones as $operacion )
				$tiempoEstimado += $operacion[ 'TiempoEstimado' ];

			return $tiempoEstimado;
		}
	}