<?php
class ColorModel extends CI_Model
{
	public function actualizar( $input = null )
	{
		$respuesta[ 'status' ] = false;

		$this->db->trans_start();

		foreach ( $input[ 'colores' ] as $color )
		{
			$this->db->where( 'id', $color[ 'id' ] );
			$this->db->update( $input[ 'tabla' ], [ 'color' => $color[ 'color' ] ] );
		}

		if ( $this->db->trans_complete() )
		{
			$respuesta[ 'colores' ] = $this->db->select( '*' )->from( $input[ 'tabla' ] )->order_by( 'id' )->get()->result_array();
			$respuesta[ 'status' ] = true;
		}
		
		return $respuesta;
	}

	public function obtener( $peticion = null )
	{
		$colores = [];

		$tablaCatColorTC =  $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'CA_CatColorTC' : 'CatColorTC';
		$tablaCatOrdenesSituaciones =  $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'CA_CatOrdenesSituaciones' : 'CatOrdenesSituaciones';
		$tablaCatOperacionesEstados =  $this->config->item('ConfigVersionIntelisis') == 'V6000' ? 'CA_CatOperacionesEstados' : 'CatOperacionesEstados';

		// 1 => cita estimado, 2 => servicio estimado, 3 => permisos
		$colores[ 'siempre' ] =
			$this->db->select( '*' )->from( $tablaCatColorTC )
						->where_in( 'id', [ 1, 2, 3, 7, 8, 9, 10 ] )->order_by( 'id' )
							->get()->result_array();

		if ( is_null( $peticion ) )
		{
			// 4 => excedente, 5 => orden sin h, 3 => operacion sin h
			$colores[ 'CatColorTC' ] = $this->db->select( '*' )->from( $tablaCatColorTC )
												->where_in( 'id', [ 4, 5, 6 ] )->order_by( 'id' )
													->get()->result_array();

			// situaciones de orden
			$colores[ 'CatOrdenesSituaciones' ] = $this->db->select( '*' )->from( $tablaCatOrdenesSituaciones )
																->get()->result_array();

			// operaciones
			$colores[ 'CatOperacionesEstados' ] = $this->db->select( '*' )->from( $tablaCatOperacionesEstados )
																->get()->result_array();
		}
		else
		{
			$colores[ 'tRetraso' ] = $this->db->select( '*' )->from( $tablaCatColorTC )->where( 'id', 4 )->get()->row_array();

			switch ( $peticion )
			{
				case 'ordenesReal':
					$colores[ $peticion ] = $this->db->select( '*' )->from( $tablaCatColorTC )->where( 'id', 5 )->get()->row_array();
					break;
				case 'ordenesRealHist':
					$colores[ $peticion ] = $this->db->select( '*' )->from( $tablaCatOrdenesSituaciones )->get()->result_array();
					break;
				case 'operacionesReal':
					$colores[ $peticion ] = $this->db->select( '*' )->from( $tablaCatColorTC )->where( 'id', 6 )->get()->row_array();
					break;
				case 'operacionesRealHist':
					$colores[ $peticion ] = $this->db->select( '*' )->from( $tablaCatOperacionesEstados )->get()->result_array();
			}
		}

		return $colores;
	}
}