<?php
class VerifyLogin extends MY_Controller {
 
    function __construct()
    {
        parent::__construct();

        $this->load->model( 'user', '', TRUE );
    }

    public function index()
    {
        //This method will have the credentials validation
        $this->load->library( 'form_validation' );

        $this->form_validation->set_rules( 'username', 'Usuario', 'trim|required|xss_clean' );
        $this->form_validation->set_rules( 'password', 'Contraseña', 'trim|required|xss_clean|callback_check_database' );
        $this->form_validation->set_message( 'required', 'El campo <b>%s</b> es obligatorio' );
        if( $this->form_validation->run() == FALSE )
            //Field validation failed.  User redirected to login page
            $this->load->view( 'login/login' );
        else
            //Go to private area
            redirect( 'horario', 'refresh' );
    }
 
    public function check_database( $password = NULL )
    {
        if ( ! isset( $this->form_validation ) )
            show_404();

        //Field validation succeeded.  Validate against database
        $username = $this->input->post( 'username' );

        //query the database
        $result = $this->user->login( $username, $password );

        if( $result )
        {
            $sess_array = array();

            foreach( $result as $row )
            {
               $sess_array = array(
                    'id' => $row->Id,
                    'username' => $row->Usuario
                );

                $this->session->set_userdata( 'logged_in', $sess_array );
                $this->versionIntelisis($row->sucursal_int);
            }

            return TRUE;
        }
        else
        {
            $this->form_validation->set_message( 'check_database', 'Usuario o contraseña incorrectos' );
         
            return FALSE;
        }
    }

}