<?php
	if(!defined('BASEPATH')) exit('No direct script access allowed');
	/**
	* 
	*/

	session_start();

	class Horario extends MY_Controller
	{

		function __construct()
		{
			parent::__construct();

			if ( ! $this->session->userdata( 'logged_in' ) )
				redirect( 'login', 'refresh' );

			$this->load->model( [ 'horariomodel', 'colormodel' ] );
		}

		public function index()
		{
			$this->load->view( 'horario/semana' );
		}

		public function verDia()
		{
			$this->load->view( 'horario/dia' );
		}

		private function _obtenerAgentesDeSucursal()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerAgentesDeSucursal( $input );
			else
				echo 'Solo por AJAX';
		}

		private function _obtenerAgentesDeSucursalDia()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerAgentesDeSucursalDia( $input );
			else
				echo 'Solo por AJAX';
		}		

		private function _obtenerSucursales()
		{
			if ( $this->input->is_ajax_request() )
				return  $this->horariomodel->obtenerSucursales();
			else
				echo 'Solo por AJAX';
		}

		private function _obtenerSucursalesPiso()
		{
			if ( $this->input->is_ajax_request() )
				return  $this->horariomodel->obtenerSucursalesPiso();
			else
				echo 'Solo por AJAX';
		}

		public function _obtenerJornada()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerJornada( $input );
			else
				echo 'Solo por AJAX';
		}

		public function _obtenerCitasServicio()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerCitasServicio( $input );
			else
				echo 'Solo por AJAX';
		}

		public function _obtenerCitasServicioDia()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerCitasServicioDia( $input );
			else
				echo 'Solo por AJAX';
		}

		public function _obtenerOrdenesServicio()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOrdenesServicio( $input );
			else
				echo 'Solo por AJAX';
		}

		public function _obtenerOrdenesServicioDia()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOrdenesServicioDia( $input );
			else
				echo 'Solo por AJAX';
		}

		private function _obtenterHorarioDisponibilidad()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenterHorarioDisponibilidad( $input );
			else
				echo 'Solo por AJAX';
		}

		private function _obtenerOperacionesReal()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOperacionesReal( $input );
			else
				echo 'Solo por AJAX';	
		}

		private function _obtenerOperacionesRealHist()
		{

			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOperacionesRealHist( $input );
			else
				echo 'Solo por AJAX';
		}

		private function _obtenerOrdenesReal()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOrdenesReal( $input );
			else
				echo 'Solo por AJAX';
		}

		private function _obtenerOrdenesRealHist()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				return $this->horariomodel->obtenerOrdenesRealHist( $input );
			else
				echo 'Solo por AJAX';
		}

		public function obtenerTodo()
		{
			if ( $this->input->is_ajax_request() )
			{
				// se recibe en input el indice del array y el metodo que se ejecutara ( Tiempos Reales )
				$peticion = $this->input->get( 'peticion' );
				$respuesta = '';

				switch ( $peticion )
				{
					case 'ordenesReal':
						$respuesta = $this->_obtenerOrdenesReal();
						break;
					case 'ordenesRealHist':
						$respuesta = $this->_obtenerOrdenesRealHist();
						break;
					case 'operacionesReal':
						$respuesta = $this->_obtenerOperacionesReal();
						break;
					case 'operacionesRealHist':
						$respuesta = $this->_obtenerOperacionesRealHist();
				}

				$data = [
					'jornada'               => $this->_obtenerJornada(),
					'sucursales'            => $this->_obtenerSucursales(),
					'sucursalesPiso'   	    => $this->_obtenerSucursalesPiso(),
					'agentes'               => $this->_obtenerAgentesDeSucursal(),
					'citasServicio'         => $this->_obtenerCitasServicio(),
					'ordenesServicio'       => $this->_obtenerOrdenesServicio(),
					$peticion               => $respuesta,
					'horarioDisponibilidad' => $this->_obtenterHorarioDisponibilidad(),
					'colores'               => $this->_obtenerColores( $peticion )
				];
				$data[ 'fueraHorario' ] = $this->horariomodel->obtenerFueraHorario( $data[ 'jornada' ], $data[ 'horarioDisponibilidad' ] );
				echo json_encode( $data );
			}
			else
				echo 'Solo por AJAX';
		}

		public function obtenerDatosMecanico()
		{
			$input = $this->input->get();

			if ( $this->input->is_ajax_request() )
				echo json_encode( $this->horariomodel->obtenerDatosMecanico( $input ) );
			else
				show_404();
		}

		private function _obtenerColores( $peticion = null )
		{
			if ( $this->input->is_ajax_request() )
				return $this->colormodel->obtener( $peticion );
			else
				echo 'Solo por AJAX';
		}

		public function logout()
		{
			$this->session->unset_userdata( 'logged_in' );
			
			session_destroy();
			
			redirect( 'login', 'refresh' );
		}
	}