<?php
	if(!defined('BASEPATH')) exit('No direct script access allowed');
	
	session_start();

	class Color extends MY_Controller
	{
		function __construct()
		{
			parent::__construct();

			if ( ! $this->session->userdata( 'logged_in' ) )
				redirect( 'login', 'refresh' );

			$this->load->model( 'colormodel' );
		}

		public function index()
		{
			$colores = $this->colormodel->obtener();
			
			$this->load->view( 'color/configurar', $colores );
		}

		public function actualizar()
		{
			$input = $this->input->post();

			$respuesta = $this->colormodel->actualizar( $input );

			echo json_encode( $respuesta );
		}
	}