$(document).ready(function(){
    var id_orden = 0;
    var today = new Date();
    $('#fechaini, #fechafin').val(today.toISOString().substr(0, 10));
    
    var otableordenes = $(".atableordenes").dataTable({
        "oLanguage": {
            "sProcessing":     "Procesando...",
            "sLengthMenu":     "Mostrar _MENU_ registros",
            "sZeroRecords":    "No se encontraron resultados",
            "sEmptyTable":     "Ning&uacute;n dato disponible en esta tabla",
            "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
            "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix":    "",
            "sSearch":         "Buscar:",
            "sUrl":            "",
            "sInfoThousands":  ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst":    "<i class='fa fa-step-backward'></i>",
                "sLast":     "<i class='fa fa-step-forward'></i>",
                "sNext":     "<i class='fa fa-forward'></i>",
                "sPrevious": "<i class='fa fa-backward'></i>"
                        },
            "oAria": {
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                    }
            },
        "bSort": false,
        "bDestroy": true,
        "sPaginationType": "full_numbers",
        "aoColumnDefs": [
            {
            "bVisible": false,
            "aTargets": [0,1,2]
            }
        ],"rowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
            switch(aData[2]){
        		case 1:
        			$(nRow).addClass('realizada');
        		break;
        		case 2:
        			$(nRow).addClass('firmadaBloq');
        		break;
        		case 0:
        		break;
        	}
        }
    });
    // Botones del menu lateral
    $("#btn_hoja_mult_edit").hide();

    // Obtiene el listado de ordenes por medio del boton de 'Mostrar'
	$(document).off("click","#mostrar_ordenes").on("click","#mostrar_ordenes", function(){
		$( 'img#loading' ).removeClass( 'hidden' );
		$.ajax({
			cache: false,
			url: base_url+"index.php/multipuntos/recargar/"+$("#fechaini").val()+"/"+$("#fechafin").val(),
			dataType: 'json',
		})
		.done(function(data) {
			 $( 'img#loading' ).addClass( 'hidden' );
			 otableordenes.fnClearTable();
			 //console.log(data.ordenes.length);
			 if(data.ordenes.length == 0){
			 	toastr.info("No se encontraron resultados ...");
			 }
			 $.each(data.ordenes, function(index,value){
 				otableordenes.fnAddData([
	                value['ID'],
	                value['asesor_id'],
	                value['multipuntos'],
	                value['MovID'],
	                (value['FechaEmision']==null) ? '' : value['FechaEmision'].substring(0,10),
	                value['agente_nombre'],
	                value['Cliente'],
	                (value['FechaRequerida']==null) ? '' : value['FechaRequerida'].substring(0,10),
	                value['HoraRequerida'],
	                value['vin']
                ]);  
            });                 
		})
		.fail(function() {
			$( 'img#loading' ).addClass( 'hidden' );
			console.log("error");
		});				
	});

	// Mustra los botones correspondientes al seleccionar una fila de la tabla
	$("#atableordenes").off("click","tr").on("click", "tr",function(index, value){        
	    $("#btn_hoja_mult_edit").show();
		var aPos = otableordenes.fnGetPosition( this );
	    var aData = otableordenes.fnGetData( aPos);
	    id_orden = aData[0];
	     //se guarda la var de la tabla para usar en el boton de editar
	    localStorage.setItem("aPosEdit",aPos);
	    localStorage.setItem("firmadaBloqEdit",$(this).hasClass("firmadaBloq") );

	    $("#atableordenes tbody tr").removeClass('trSelect');		
		$(this).toggleClass('trSelect');
	});

	/*Doble click tabla ordenes*/
	$("#atableordenes").off("dblclick","tr").on("dblclick", "tr",function(index, value){
		// Obtener el id de la orden seleccionada
		id_orden = otableordenes.fnGetData(otableordenes.fnGetPosition(this))[0];
		// Obtener el html del formato para cargar en el modal
        window.open(base_url+'index.php/multipuntos/formato/'+id_orden, "_blank");
	});

	/*Editar Hoja multipuntos a traves de icono para tablet */
	$("#btn_hoja_mult_edit").on("click", function(e){

	// Obtener el id de la orden seleccionada
	id_orden = otableordenes.fnGetData(localStorage.getItem("aPosEdit"))[0]
	// Obtener el html del formato para cargar en el modal
	window.open(base_url+'index.php/multipuntos/formato/'+id_orden, "_blank");

	});

	$(document).off("click","#regresar").on("click","#regresar", function(e){
	    e.preventDefault(); 
	    $("#ordenes").show();
	    $("#multi").hide();
		$(".coloca").html("");
		$("#multiForm")[0].reset();
	});
});