let signaturePads = [];

function disableInputs() {
	const inputs = document.querySelectorAll('input');
	inputs.forEach(input => {
		input.disabled = true;
	});
	const textareas = document.querySelectorAll('textarea');
	textareas.forEach(textarea => {
		textarea.disabled = true;
	});
	const selects = document.querySelectorAll('select');
	selects.forEach(select => {
		select.disabled = true;
	});
}

function saveAsPdf() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('p', 'mm', 'a4');
    
    // Apply print-specific styles
    const originalStyle = document.body.style.cssText;
    document.body.style.width = '210mm';
    document.body.style.margin = '0';
    document.body.style.padding = '10mm';
    document.body.style.backgroundColor = 'white';

    const options = {
        scale: 1,
        useCORS: true,
        scrollX: 0,
        scrollY: 0,
        width: document.body.scrollWidth,
        height: document.body.scrollHeight,
        windowWidth: document.body.scrollWidth,
        windowHeight: document.body.scrollHeight
    };

    html2canvas(document.body, options).then(canvas => {
        const imgData = canvas.toDataURL('image/png');
        const pageWidth = 210; // A4 width in mm
        const pageHeight = 297; // A4 height in mm
        const imgWidth = pageWidth;
        const imgHeight = (canvas.height * imgWidth) / canvas.width;
        
        let heightLeft = imgHeight;
        let position = 0;
        
        // Add first page
        doc.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
        heightLeft -= pageHeight;
        
        // Add subsequent pages
        while (heightLeft >= 0) {
            doc.addPage();
            doc.addImage(imgData, 'PNG', 0, position - pageHeight, imgWidth, imgHeight);
            heightLeft -= pageHeight;
            position -= pageHeight;
        }
        
        // Restore original styles
        document.body.style.cssText = originalStyle;
        
        doc.save('Multipuntos-' + movid + '.pdf');
    });
}

// Show Toast Message
function showToast(message, duration = 3000) {	
	let toast = document.createElement('div');
	toast.id = 'toast';
	toast.className = 'toast hidden';
	document.body.appendChild(toast);
	toast.textContent = message;
	toast.classList.remove('hidden');
	toast.classList.add('visible');

	setTimeout(() => {
		toast.classList.remove('visible');
		setTimeout(() => {
			toast.classList.add('hidden');
		}, 300);
	}, duration);
}

// Send Data
function sendData(data) {
	fetch(base_url+"index.php/multipuntos/guardar/", {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json'
		},
		body: data
	})
	.then(response => response.json())
	.then(data => {
		hideLoadingSpinner();
		if (data.status == "success") {
			showToast("Datos guardados correctamente");
			hiddeSaveButton();
		} else {
			showToast("Error al guardar los datos");
		}
	})
	.catch(error => {
		hideLoadingSpinner();
		console.error('Error:', error);
	});
}

function hideSignaturePad() {
	const signaturePadElement = document.getElementById('signature-pad');
	const signatureImage = document.createElement('img');
	signatureImage.src = signaturePads[0].toDataURL();
	signatureImage.width = 400;
	signatureImage.height = 200;
	signaturePadElement.parentNode.replaceChild(signatureImage, signaturePadElement);
	const clearButton = document.getElementById('clear-signature');
	if (clearButton) {
		clearButton.style.display = 'none';
	}
    // Hide save button when there's a signature
    hiddeSaveButton();
}
function initializeSignaturePad() {
	// Signature panel initialization [Dynamic by .signature-pad]
	const canvases = document.querySelectorAll('.signature-pad');

	canvases.forEach(canvas => {
		let signaturePad = new SignaturePad(canvas);
		signaturePads.push(signaturePad);

		function resizeCanvas() {
			const ratio = Math.max(window.devicePixelRatio || 1, 1);
			canvas.width = canvas.offsetWidth * ratio;
			canvas.height = canvas.offsetHeight * ratio;
			canvas.getContext("2d").scale(ratio, ratio);
			signaturePad.clear();
		}

		window.addEventListener("resize", resizeCanvas);
		resizeCanvas();

		const clearButton = canvas.nextElementSibling;
		if (clearButton && clearButton.id === "clear-signature") {
			clearButton.addEventListener("click", function () {
				signaturePad.clear();
			});
		}
	});
}

function hideLoadingSpinner() {
	document.getElementById('loading-spinner').style.display = 'none';
}
function constructSaveData(){
	const data = {
		evaluation: {},
		data: {
			order_id: orderId,
			comentarios: document.querySelector("#comentarios").value,
			tecnico : document.querySelector("#technical_id").value,
			firma_tecnico: !technicalSignature && signaturePads.length > 0 && !signaturePads[0].isEmpty() ? signaturePads[0].toDataURL() : technicalSignature ? null : null,
			proximo_mantenimiento: document.querySelector("#next_maintenance").value
		}
	};
	document.querySelectorAll('form input').forEach(input => {
		if(input.type == 'checkbox') {
			if(input.checked) {
				data.evaluation[input.name] = input.parentElement.classList[1];
			}
		} else if(input.value !== '') {
			data.evaluation[input.name] = input.value;
		}
	});
	return data;
}

function hiddeSaveButton() {
	document.getElementById('guardarAvance').style.display = 'none';
}

function confirmSignature() {
	return Swal.fire({
		title: 'Bloqueo por firma',
		text: "El formulario ha sido firmado, si continuas no podras volver a realizar cambios",
		icon: 'warning',
		showCancelButton: true,
		confirmButtonText: 'Sí, guardar',
		cancelButtonText: 'Cancelar'
	}).then((result) => {
		return result.isConfirmed;
	});
}

function showLoadingSpinner() {
	document.getElementById('loading-spinner').style.display = 'flex';
}

function isSignatureImage() {
    const signaturePadElement = document.getElementById('signature-pad');
    return !signaturePadElement || signaturePadElement.tagName.toLowerCase() === 'img';
}

function toggleNonPrintableElements(show) {
    const displayStyle = show ? '' : 'none';
    const borderStyle = show ? '1px solid #000' : 'none';
    const textareaBorderStyle = show ? '1px solid #ccc' : 'none';

    const clearSignatureButton = document.getElementById('clear-signature');
    const floatingButtons = document.querySelectorAll('.floating-btn, .floating-btn-pdf');
    const signaturePadElement = document.querySelector('.signature-pad');
    const dynamicTextareas = document.querySelectorAll('.dynamicTextarea');
    const saveButton = document.getElementById('guardarAvance');

    if (clearSignatureButton) {
        clearSignatureButton.style.display = displayStyle;
    }
    floatingButtons.forEach(button => {
        if (button === saveButton && isSignatureImage()) {
            button.style.display = 'none';
        } else {
            button.style.display = displayStyle;
        }
    });
    if (signaturePadElement) {
        signaturePadElement.style.border = borderStyle;
    }
    dynamicTextareas.forEach(textarea => textarea.style.border = textareaBorderStyle);
}

function adjustCommentsFontSize() {
    const textarea = document.getElementById('comentarios');
    if (!textarea) return;
    
    // Reset font size to default
    textarea.style.fontSize = '14px';
    
    // Get the scrollHeight (total height of content)
    const scrollHeight = textarea.scrollHeight;
    const maxHeight = 190; // Fixed max height in pixels
    
    // If content exceeds max height, reduce font size
    if (scrollHeight > maxHeight) {
        // Calculate how much we need to reduce the font
        const ratio = maxHeight / scrollHeight;
        const newSize = Math.max(8, Math.floor(14 * ratio)); // Don't go below 8px
        textarea.style.fontSize = newSize + 'px';
        
        // Check if even with the smallest font we exceed max height
        if (newSize === 8 && textarea.scrollHeight > maxHeight) {
            // Set to 8px to check final height
            textarea.style.fontSize = '8px';
            // If still exceeds, we'll handle this in the input event
        }
    }
    
    // Ajustar la altura del textarea al contenido
    textarea.style.height = 'auto';
    textarea.style.height = Math.min(textarea.scrollHeight, maxHeight) + 'px';
}

function countLinesInTextarea(textarea) {
    // Create a mirror div with the same width and styling
    const mirror = document.createElement('div');
    mirror.style.position = 'absolute';
    mirror.style.left = '-9999px';
    mirror.style.width = textarea.clientWidth + 'px';
    mirror.style.font = window.getComputedStyle(textarea).font;
    mirror.style.lineHeight = window.getComputedStyle(textarea).lineHeight;
    mirror.style.whiteSpace = 'pre-wrap';
    mirror.style.wordBreak = 'break-word';
    document.body.appendChild(mirror);
    
    // Get text and replace newlines with <br>
    const text = textarea.value.replace(/\n/g, '<br>');
    mirror.innerHTML = text + '.'; // Add a period to account for a trailing empty line
    
    // Count the lines
    const lineHeight = parseInt(window.getComputedStyle(textarea).lineHeight);
    const lines = Math.ceil(mirror.clientHeight / lineHeight);
    
    // Clean up
    document.body.removeChild(mirror);
    
    return lines;
}

document.addEventListener("DOMContentLoaded", function() {
    if (isSignatureImage()) {
        disableInputs();
        hiddeSaveButton();
    }
	if (answers !== null) {
		setCheckboxAndInputValues(answers);
	}
	initializeSignaturePad();
    
    // Initialize textarea font size adjustment
    const commentsTextarea = document.getElementById('comentarios');
    if (commentsTextarea) {
        // Asegurar que el textarea se ajuste al cargar la página
        setTimeout(() => {
            adjustCommentsFontSize(); // Run once for existing content
        }, 100); // Pequeño retraso para asegurar que el contenido está renderizado
        
        // Add event listener for input with improved control
        commentsTextarea.addEventListener('input', function(e) {
            const textarea = e.target;
            const maxHeight = 190; // Fixed max height in pixels
            
            // Store current caret position and text
            const caretPos = textarea.selectionStart;
            const previousValue = textarea.value;
            
            // Adjust font size first
            adjustCommentsFontSize();
            
            // Check if content still exceeds max height at minimum font size
            textarea.style.fontSize = '8px'; // Set to minimum to check
            if (textarea.scrollHeight > maxHeight) {
                // Revert to previous value
                textarea.value = previousValue;
                // Prevent default doesn't work well here since input already happened
                e.preventDefault();
                // Flash the textarea to indicate it's at capacity
                const originalBackground = textarea.style.backgroundColor;
                textarea.style.backgroundColor = 'rgba(255,0,0,0.1)';
                setTimeout(() => {
                    textarea.style.backgroundColor = originalBackground;
                }, 200);
            }
            
            // Recalculate optimal font size and restore caret position
            adjustCommentsFontSize();
            if (textarea.value.length >= previousValue.length) {
                textarea.setSelectionRange(caretPos, caretPos);
            }
        });
        
        // Ensure textarea doesn't grow beyond max height
        commentsTextarea.style.maxHeight = '190px';
        commentsTextarea.style.overflowY = 'hidden';
    }

	// Save Data
	document.getElementById("guardarAvance").addEventListener("click", async function () {
		const data = constructSaveData();
		if (data.data.firma_tecnico) {
			const confirmed = await confirmSignature();
			if (confirmed) {
				hideSignaturePad();
				hiddeSaveButton();
				showLoadingSpinner();
				disableInputs()
				sendData(JSON.stringify(data));
			}
		} else {
			showLoadingSpinner();
			sendData(JSON.stringify(data));
		}
	});

	// Download PDF
	document.getElementById("descargarPdf").addEventListener("click", function() {
        // Mostrar spinner de carga
        document.getElementById('loading-spinner').style.display = 'flex';
        
        // Ocultar botones para la captura
        const saveBtn = document.getElementById('guardarAvance');
        const pdfBtn = document.getElementById('descargarPdf');
        const clearBtn = document.getElementById('clear-signature');
        
        if (saveBtn) saveBtn.style.display = 'none';
        if (pdfBtn) pdfBtn.style.display = 'none';
        if (clearBtn) clearBtn.style.display = 'none';
        
        // Configuración mejorada para html2canvas
        const options = {
            scale: 2, // Mayor escala para mejor calidad
            useCORS: true, // Permitir cargar imágenes de otros dominios
            allowTaint: true, // Permitir elementos "tainted" para mejor renderizado
            backgroundColor: '#ffffff', // Fondo blanco
            logging: false, // Deshabilitar logs para mejor rendimiento
            onclone: function(clonedDoc) {
                // Forzar estilos de impresión en el clon
                const style = clonedDoc.createElement('style');
                style.innerHTML = `
                    * {
                        -webkit-print-color-adjust: exact !important;
                        print-color-adjust: exact !important;
                        color-adjust: exact !important;
                    }
                    .cell.green, .text.green { background-color: rgba(0, 128, 0, 0.725) !important; }
                    .cell.yellow, .text.yellow { background-color: rgba(255, 255, 0, 0.816) !important; }
                    .cell.red, .text.red { background-color: rgba(255, 0, 0, 0.771) !important; }
                    .cell.blue, .text.blue { background-color: rgba(0, 0, 255, 0.682) !important; }
                    .section-title { background-color: gray !important; color: white !important; }
                `;
                clonedDoc.head.appendChild(style);
                
                // Fix textarea rendering in PDF
                const originalTextarea = document.getElementById('comentarios');
                if (originalTextarea) {
                    const clonedTextarea = clonedDoc.getElementById('comentarios');
                    if (clonedTextarea) {
                        // Create a div that will replace the textarea
                        const replacementDiv = clonedDoc.createElement('div');
                        
                        // Copy the styling from the textarea
                        const computedStyle = window.getComputedStyle(originalTextarea);
                        replacementDiv.style.width = computedStyle.width;
                        replacementDiv.style.height = computedStyle.height;
                        replacementDiv.style.padding = computedStyle.padding;
                        replacementDiv.style.margin = computedStyle.margin;
                        replacementDiv.style.border = computedStyle.border;
                        replacementDiv.style.fontSize = computedStyle.fontSize;
                        replacementDiv.style.fontFamily = computedStyle.fontFamily;
                        replacementDiv.style.backgroundColor = computedStyle.backgroundColor;
                        replacementDiv.style.color = computedStyle.color;
                        replacementDiv.style.boxSizing = computedStyle.boxSizing;
                        replacementDiv.style.overflowY = 'auto';
                        replacementDiv.style.lineHeight = computedStyle.lineHeight;
                        replacementDiv.style.whiteSpace = 'pre-wrap'; // Preserve line breaks
                        replacementDiv.style.wordWrap = 'break-word'; // Break words that would overflow
                        
                        // Set the content, preserving line breaks
                        replacementDiv.textContent = originalTextarea.value;
                        
                        // Replace the textarea with our div
                        clonedTextarea.parentNode.replaceChild(replacementDiv, clonedTextarea);
                    }
                }
            }
        };
        
        // Capturar el formulario con los estilos aplicados
        const container = document.querySelector('.container');
        
        html2canvas(container, options).then(canvas => {
            // Crear un PDF con mejor calidad y preservación de colores
            const imgData = canvas.toDataURL('image/png', 1.0); // Máxima calidad
            const pdf = new window.jspdf.jsPDF({
                orientation: 'portrait',
                unit: 'mm',
                format: 'letter',
                compress: false // Desactivar compresión para mejor calidad
            });
            
            // Calcular dimensiones para ajustar al PDF correctamente
            const imgWidth = 216; // Letter width in mm (portrait)
            const pageHeight = 279; // Letter height in mm
            const imgHeight = (canvas.height * imgWidth) / canvas.width;
            let heightLeft = imgHeight;
            let position = 0;
            
            // Añadir la primera página
            pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight, '', 'FAST');
            heightLeft -= pageHeight;
            
            // Añadir páginas adicionales si es necesario
            while (heightLeft > 0) {
                position = heightLeft - imgHeight;
                pdf.addPage();
                pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight, '', 'FAST');
                heightLeft -= pageHeight;
            }
            
            // Guardar el PDF con nombre basado en el número de orden
            pdf.save(`InspeccionMultipuntos_${movid}.pdf`);
            
            // Restaurar botones y ocultar spinner
            if (saveBtn) saveBtn.style.display = 'flex';
            if (pdfBtn) pdfBtn.style.display = 'flex';
            if (clearBtn) clearBtn.style.display = 'block';
            document.getElementById('loading-spinner').style.display = 'none';
        }).catch(error => {
            console.error('Error al generar el PDF:', error);
            // Restaurar botones y ocultar spinner en caso de error
            if (saveBtn) saveBtn.style.display = 'flex';
            if (pdfBtn) pdfBtn.style.display = 'flex';
            if (clearBtn) clearBtn.style.display = 'block';
            document.getElementById('loading-spinner').style.display = 'none';
            
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Ocurrió un error al generar el PDF'
            });
        });
    });

	// Clear Signature
	const clearSignatureButton = document.getElementById("clear-signature");
	if (clearSignatureButton) {
		clearSignatureButton.addEventListener("click", function (event) {
			event.preventDefault(); // Prevent default action
			const signaturePadElement = document.getElementById("signature-pad");
			if (signaturePadElement) {
				const signaturePad = signaturePads.find(pad => pad.canvas === signaturePadElement);
				if (signaturePad) {
					signaturePad.clear();
				}
			}
		});
	}

	// ========================================================================================
	// Manejo del DOM de este archivo
	// ========================================================================================

	// Adjust Textarea Height for class dynamicTextarea
	document.querySelectorAll(".dynamicTextarea").forEach(textarea => {
		textarea.addEventListener("input", function () {
			this.style.height = "auto";
			this.style.height = this.scrollHeight + "px";
		});
	});

	// Set Checkbox and Input Values
	function setCheckboxAndInputValues(answers) {
		for (const [key, value] of Object.entries(answers)) {
			const checkboxContainer = document.querySelector(`input[name="${key}"]`).closest('.checkboxs');
			if (checkboxContainer) {
				const checkbox = checkboxContainer.querySelector(`.cell.${value} input[type="checkbox"]`);
				if (checkbox) {
					checkbox.checked = true;
				}
			} else {
				const input = document.querySelector(`input[name="${key}"]`);
				if (input) {
					input.value = value;
				}
			}
		}
	}

	// Checkbox Selection Handling
	document.querySelectorAll('.checkboxs input[type="checkbox"]').forEach(checkbox => {
		checkbox.addEventListener('change', function() {
			if (this.checked) {
				const checkboxes = this.closest('.checkboxs').querySelectorAll('input[type="checkbox"]');
				checkboxes.forEach(cb => {
					if (cb !== this) {
						cb.checked = false;
					}
				});
			}
		});
	});
});
