<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Inspección Multipuntos <?= $orden['movid'] ?></title>
	<link rel="icon" type="image/ico" href="<?php echo base_url();?>assets/img/favicon.ico">
	<?php
	$file_path = FCPATH . 'assets/css/multipuntos-byd.css';
	$last_modified = file_exists($file_path) ? filemtime($file_path) : time();
	?>
	<link rel="stylesheet" href="<?=base_url()?>assets/css/multipuntos-byd.css?v=<?=$last_modified?>">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script>
	const base_url = '<?=base_url()?>'
	const orderId = <?= $orden['id'] ?>;
	const answers = <?= json_encode($inspeccion['answers']) ?>;
	const technicalSignature = '<?= $inspeccion['response']['technical_signature'] ?>';
	const movid = '<?= $orden['movid'] ?>'
	</script>
</head>
<body>
	<form class="container">
		<div class="header section-title">
			<h1 class="">Hoja de Inspección Multipunto</h1>
			<img src="<?=base_url()?>assets/img/logo_byd_blanco.png" alt="BYD Logo" width="100">
		</div>
		<div class="section">
			<!-- Columna Izquierda -->
			<div class="column">
				<div class="info-row evaluation">
					<strong>Cliente:</strong>
					<span class="text-zone" name="nombre-cliente"><?= $orden['cliente'] ?></span>
				</div>
				<div class="info-row evaluation">
					<strong>Kilometraje:</strong>
					<span class="text-zone" name="kilometraje"><?= $orden['kilometraje'] ?></span>
				</div>
				<div class="info-row evaluation">
					<strong>Asesor de Servicio:</strong>
					<span class="text-zone" name="nombre-asesor"><?= $orden['asesor'] ?></span>
				</div>
				<div class="info-row evaluation">
					<strong class="info-row">No. Orden:</strong>
					<span class="text-zone" name="no-orden"><?= $orden['movid'] ?></span>
				</div>
			</div>
			<!-- Columna Derecha -->
			<div class="column">
				<div class="info-row">
					<strong>Año/Modelo:</strong>
					<span class="text-zone" name="modelo"><?= $orden['modelo'] ?></span>
				</div>
				<div class="info-row">
					<strong>VIN:</strong>
					<span class="text-zone" name="vin"><?= $orden['vin'] ?></span>
				</div>
				<div class="info-row">
					<strong>Técnico:</strong>
					<select class="text-zone" name="technical_id" id="technical_id">
						<option value="">No seleccionado</option>
						<?php foreach ($tecnicos as $tecnico): ?>
							<option value="<?= $tecnico['id'] ?>" <?= $tecnico['id'] == $inspeccion['response']['technical_id'] ? 'selected' : '' ?>><?= $tecnico['nombre'] ?></option>
						<?php endforeach; ?>
					</select>
				</div>
				<div class="info-row">
					<strong>Fecha:</strong>
					<span class="text-zone" name="fecha"><?= $orden['fecha'] ?></span>
				</div>
			</div>
		</div>
		<!-- Section Two -->
		<!-- Seccion inspeccion general -->
		<div class="section-title">
			<h1 class="">Colocar una &#10004; en los recuadros de cada operación</h1>
		</div>
		<div class="section">
			<div class="column">
				<h2 class="">Interior y Exterior</h2>
				<div class="container-colors">
					<div class="row">
						<div class="text green">Correcto funcionamiento</div>
					</div>
					<div class="row">
						<div class="cell green"></div>
						<div class="text yellow">Puede requerir cambio</div>
					</div>
					<div class="row">
						<div class="cell green"></div>
						<div class="cell yellow"></div>
						<div class="text red">Requiere cambio inmediato</div>
					</div>
					<div class="row">
						<div class="cell green"></div>
						<div class="cell yellow"></div>
						<div class="cell red"></div>
						<div class="text blue">N/A</div>
					</div>
				</div>
				<!-- Subsection One -->
				 <!-- 
				Nomenclature of names
				Section-column-subsection-position-question
				   -->
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-1-1"></div>
							<div class="text">Torque de birlos correcto</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-2-1"></div>
							<div class="text">Llave de birlos correcta</div>
						</div>
					</div>
						<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-3-1"></div>
							<div class="text">Testigos</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-4-1"></div>
							<div class="text">Puertas y seguros</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-5-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-5-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-5-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-5-1"></div>
							<div class="text">Elevalunas eléctrico</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-6-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-6-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-6-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-6-1"></div>
							<div class="text">Cinturones de seguridad</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-7-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-7-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-7-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-7-1"></div>
							<div class="text">Partes flojas en carrocería</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-8-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-8-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-8-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-8-1"></div>
							<div class="text">Partes flojas en interiores</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-1-9-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-1-9-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-1-9-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-1-9-1"></div>
							<div class="text">Luces funcionan correctamente</div>
						</div>
					</div>
				</div>
				<!-- Subsection Two -->
				<h2 class="">Batería de Arranque 12v</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-2-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-2-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-2-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-2-1-1"></div>							
							<div class="text">SOH 12v</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-1-2-1-2">
							<div class="info-cell">%</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-2-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-2-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-2-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-2-2-1"></div>
							<div class="text">Voltaje</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-1-2-2-2">
							<div class="info-cell">V</div>
						</div>	
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-1-2-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-1-2-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-1-2-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-1-2-3-1"></div>
							<div class="text">CCA</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-1-2-3-2">
							<div class="info-cell">A</div>
						</div>
						<div>

						</div>
					</div>
				</div>
			</div>
			<div class="column">
				<h2 class="">Debajo de la Carrocería</h2>
				<div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-1-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-1-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-1-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-1-1"></div>
						<div class="text">Fugas de aceite o anticongelante</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-2-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-2-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-2-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-2-1"></div>
						<div class="text">Amortiguadores delanteros</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-3-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-3-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-3-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-3-1"></div>
						<div class="text">Amortiguadores traseros</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-4-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-4-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-4-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-4-1"></div>
						<div class="text">Kit de reparación</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-5-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-5-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-5-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-5-1"></div>
						<div class="text">Llanta de refacción</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-6-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-6-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-6-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-6-1"></div>
						<div class="text">Nivel de líquido de frenos</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-7-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-7-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-7-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-7-1"></div>
						<div class="text">Nivel de anticongelante</div>
					</div>
					<div class="row evaluation checkboxs">
						<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-1-8-1"></div>
						<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-1-8-1"></div>
						<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-1-8-1"></div>
						<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-1-8-1"></div>
						<div class="text">Nivel de líquido de limpiaparabrisas</div>
					</div>
				</div>
				<h2 class="">Alto Voltaje</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-1-1"></div>
							<div class="text">SOC</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-1-2">
							<div class="info-cell">%</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-2-1"></div>
							<div class="text">Voltaje más bajo</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-2-2">
							<div class="info-cell">V</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-3-1"></div>
							<div class="text">Voltaje más alto</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-3-2">
							<div class="info-cell">V</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-4-1"></div>
							<div class="text">Temp más alta</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-4-2">
							<div class="info-cell">C</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-5-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-5-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-5-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-5-1"></div>
							<div class="text">Temp más baja</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-5-2">
							<div class="info-cell">C</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="1-2-2-6-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="1-2-2-6-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="1-2-2-6-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="1-2-2-6-1"></div>
							<div class="text">Voltaje total batería</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="1-2-2-6-2">
							<div class="info-cell">V</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Seccion Ruedas y Frenos -->
		<div class="section-title">
			<h1 class="">Ruedas y Frenos</h1>
		</div>
		<div class="section">
			<div class="column">
				<h2 class="">Delantero Izquierdo</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-1-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-1-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-1-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-1-1-1"></div>
							<div class="text">Presión del neumático</div>
						</div>
						<div class="row evaluation">								
							<input type="number" class="info-cell" name="2-1-1-1-2">
							<div class="info-cell">PSI</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-1-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-1-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-1-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-1-2-1"></div>
							<div class="text">Dibujo del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-1-2-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-1-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-1-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-1-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-1-3-1"></div>
							<div class="text">Pastilla de freno</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-1-3-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-1-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-1-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-1-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-1-4-1"></div>
							<div class="text">Espesor del disco</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-1-4-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
				</div>
				<h2 class="">Trasero Izquierdo</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-2-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-2-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-2-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-2-1-1"></div>
							<div class="text">Presión del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-2-1-2">
							<div class="info-cell">PSI</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-2-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-2-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-2-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-2-2-1"></div>
							<div class="text">Dibujo del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-2-2-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-2-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-2-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-2-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-2-3-1"></div>
							<div class="text">Pastilla de freno</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-2-3-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-1-2-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-1-2-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-1-2-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-1-2-4-1"></div>
							<div class="text">Espesor del disco</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-1-2-4-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
				</div>
			</div>
			<div class="column-img">
				<div class="img-container">
					<img src="<?=base_url()?>assets/img/BYD/presionLlantas.png" alt="" srcset="">
				</div>
				<div class="img-container">
					<img src="<?=base_url()?>assets/img/BYD/disco.png" alt="" srcset="">
				</div>
			</div>
			<div class="column">
				<h2 class="">Delantero Derecho</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-1-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-1-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-1-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-1-1-1"></div>
							<div class="text">Presión del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-1-1-2">
							<div class="info-cell">PSI</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-1-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-1-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-1-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-1-2-1"></div>
							<div class="text">Dibujo del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-1-2-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-1-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-1-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-1-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-1-3-1"></div>
							<div class="text">Pastilla de freno</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-1-3-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-1-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-1-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-1-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-1-4-1"></div>
							<div class="text">Espesor del disco</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-1-4-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
				</div>
				<h2 class="">Trasero Derecho</h2>
				<div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-2-1-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-2-1-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-2-1-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-2-1-1"></div>
							<div class="text">Presión del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-2-1-2">
							<div class="info-cell">PSI</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-2-2-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-2-2-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-2-2-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-2-2-1"></div>
							<div class="text">Dibujo del neumático</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-2-2-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-2-3-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-2-3-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-2-3-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-2-3-1"></div>
							<div class="text">Pastilla de freno</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-2-3-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
					<div class="row">
							<div class="row evaluation checkboxs">
							<div class="cell green"><input type="checkbox" class="checkbox" name="2-2-2-4-1"></div>
							<div class="cell yellow"><input type="checkbox" class="checkbox" name="2-2-2-4-1"></div>
							<div class="cell red"><input type="checkbox" class="checkbox" name="2-2-2-4-1"></div>
							<div class="cell blue"><input type="checkbox" class="checkbox" name="2-2-2-4-1"></div>
							<div class="text">Espesor del disco</div>
						</div>
						<div class="row evaluation">
							<input type="number" class="info-cell" name="2-2-2-4-2">
							<div class="info-cell">mm</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="footer">
			<div class="section">
				<!-- Columna Izquierda -->
				<div class="column">
					<div class="info-row">
						<strong>Próximo mantenimiento:</strong>
						<input id="next_maintenance" type="text" class="inputZone" name="next_maintenance" value="<?= $inspeccion['response']['next_maintenance'] ?>">
					</div>
					<div class="info-row" style="flex-direction: column; align-items: flex-start;">
						<strong>Comentarios y recomendaciones:</strong>
						<textarea class="dynamicTextarea" id="comentarios" placeholder="Recomendaciones..."><?= $inspeccion['response']['comments'] ?></textarea>
					</div>
				</div>
				<!-- Columna Derecha -->
				<div class="column">
					<div class="firmas">
						<strong>Firma de jefe de taller:</strong>
						<?php if (!empty($inspeccion['response']['technical_signature'])): ?>
							<img src="<?= $inspeccion['response']['technical_signature'] ?>" alt="Firma del técnico" width="400" height="200">
						<?php else: ?>
							<canvas id="signature-pad" class="signature-pad" width=400 height=200></canvas>
							<button id="clear-signature">Borrar Firma</button>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</form>
</body>
<div id="loading-spinner" style="display: none;">
	<div class="spinner"></div>
</div>
<button class="floating-btn" id="guardarAvance">💾</button>
<button class="floating-btn-pdf" id="descargarPdf">📄</button>
<?php
	$file_path = FCPATH . 'assets/js/multipuntos_byd.js';
	$last_modifiedJs = file_exists($file_path) ? filemtime($file_path) : time();
	?>
<script src="<?=base_url()?>assets/js/multipuntos_byd.js?v=<?=$last_modifiedJs?>"></script>
</html>
