<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class  Navegacion_model extends CI_Model
{

	public function actualizar_datos( $data )
	{
		if ( $data[ 'pass' ] != '***' ) 
		{
			$data2[ 'Contrasenia' ] = MD5( $this->config->item( 'encryption_key' ).''.$data[ 'pass' ] );
		}

		$this->db->trans_start();
			$this->db->where( "ID", $this->session->userdata( 'id_usuario' ) );
			$this->db->update( 'UsuariosWeb',$data2 );
		$this->db->trans_complete();

		if( $this->db->trans_status() == true )
			$ret[ 'saved' ] = 'si';			
		else
			$ret[ 'saved' ] = 'no';

		return $ret;
	}

	public function autocomplete_Nombre( $nombre )
	{
		$where = "Tipo = 'Mecanico' AND Estatus = 'ALTA' AND Nombre Like '%".$nombre."%'";

		$asesores = $this->db->select( 'Agente as id,  Nombre as value' )
					->from( 'Agente' )
					->where( $where )
					->get()->result_array();

		//echo $this->db->last_query();	
		return $asesores;		
	}

	public function autocomplete_Clave( $clave )
	{
		$where = "Tipo = 'Mecanico' AND Estatus = 'ALTA' AND Agente Like '%".$clave."%'";

		$asesores = $this->db->select( 'Agente as value,  Nombre as id' )
					->from( 'Agente' )
					->where( $where )
					->get()->result_array();

		//echo $this->db->last_query();	
		return $asesores;		
	}

	public function obtener_seguimiento( $data )
	{
		$wheres = [];
		if(FILTROS_FECHAS && $data['fechaBusinic']){
			$wheres['CCFechaIni >='] = $data['fechaBusinic'].' 00:00:00';
		}
		if(FILTROS_FECHAS && $data['fechaBusfin']){
			$wheres['CCFechaIni <='] = $data['fechaBusfin'].' 23:59:59';
		}
		//ID para poner en Datatable y Renglon para la consulta de Fecha Inicio y Fin real.
		//Se realiza cambio para mostrar "Articulo" proveniente de Venta D en lugar de ServicioArticulo proveniente de Venta
		$select = 'ID, Renglon, MovID as Orden, ServicioIdentificador as Torre, ServicioNumero as Numero, Situacion,Articulo as ServicioArticulo,
					Descripcion1,Estado, Cantidad,CCTiempoTab, CCFechaIni, CCFechaFin,RenglonID, ServicioSerie, Comentarios, DescripcionExtra';
		if(OP_CAMBIO_SITUACION){
			$situacions_valids = array('No Asignada', 'Asignada', 'En proceso', 'Detenida por TOT', 'Detenida por Autorización', 'Detenida por Refacciones', 'Detenida por Soporte Planta', 'Detenida por Otros');
		}else{
		$situacions_valids = array('No Asignada', 'Asignada', 'En proceso');
		}

		$movimientos = $this->db->select( $select )
					->from( 'seguimientoTecnicosWeb' )
					->where( 'Estatus', 'PENDIENTE' )
					->where( 'Situacion !=', 'Orden Cerrada' )
					//->where( 'Situacion !=', 'Comienza lavado' )
					//->where( 'Situacion !=', 'Finaliza lavado' )
					->where_in('Situacion',$situacions_valids)
					->where( 'servicioTipoOperacion !=', 'Hojalateria y Pintura' )
					->where( 'Agente', $data[ 'claveAsesor' ] )
					->where( 'Tipo', 'Servicio' )
					//ordenar ordenes por como fueron generadas
					->order_by( 'ID', 'ASC' )
					// ->where( "CCFechaIni BETWEEN '".$data[ 'fechaBusinic' ]." 00:00:00' AND '".$data[ 'fechaBusfin' ]." 23:59:59'" )
					->where($wheres)
					->get()->result_array();
					//echo $this->db->last_query();
					/*echo "<pre>";
					print_r ($this->db->last_query());
					echo "</pre>";*/
		
		$tabla = "SeguimientoOperaciones";
		if ($this->config->item('ConfigVersionIntelisis') == 'V6000') 
			$tabla = "CA_SeguimientoOperaciones";
		
		for ( $i = 0; $i < sizeof( $movimientos ); $i++ ) 
		{ 
			$inicioReal = $this->db->select( 'TOP 1 FechaInicio' )
						->from( $tabla )
						->where( 'IdVenta', $movimientos[ $i ][ 'ID' ] )
						->where( 'Renglon', $movimientos[ $i ][ 'Renglon' ] )
						->order_by( 'ID', 'ASC' )
						->get()->row_array();
			if( $inicioReal )
				$movimientos[ $i ][ 'inicioReal' ] = $inicioReal[ 'FechaInicio' ];
			else
				$movimientos[ $i ][ 'inicioReal' ] = '';

			$finRealEstado = $this->db->select( 'TOP 1 Estado' )
						->from(  $tabla )
						->where( 'IdVenta', $movimientos[ $i ][ 'ID' ] )
						->where( 'Renglon', $movimientos[ $i ][ 'Renglon' ] )
						->order_by( 'ID', 'DESC' )
						->get()->row_array();

			$movimientos[ $i ][ 'finReal' ] = '';			

			if( $finRealEstado )			
			{			
				if( $finRealEstado[ 'Estado' ] == 'Completada' )
				{
					$finReal = $this->db->select( 'TOP 1 FechaInicio' )
								->from(  $tabla )
								->where( 'IdVenta', $movimientos[ $i ][ 'ID' ] )
								->where( 'Renglon', $movimientos[ $i ][ 'Renglon' ] )
								->where( 'Estado', $finRealEstado[ 'Estado' ] )
								//mostrar la ultima completada (F. Real)
								->order_by( 'ID', 'DESC' )
								->get()->row_array();	
					
					$movimientos[ $i ][ 'finReal' ] = $finReal[ 'FechaInicio' ];
				}
			}
			if ($this->config->item('configGarantiasFord') == TRUE){
			$adicional = $this->db->select('Adicional')->from('CA_VentaD')->where(['VentaID' => $movimientos[$i]['ID'], 'RenglonID' => $movimientos[$i]['RenglonID'], 'Renglon' => $movimientos[ $i ][ 'Renglon' ] ])->get()->row_array();							
			$movimientos[ $i ][ 'Adicional' ] = isset($adicional['Adicional']) ? $adicional['Adicional'] : false;
			}
		}
		
		return $movimientos;			
	}

	public function obtener_dataOrden( $movId )
	{
		$select = 'MovID AS MovID, ServicioTipoOrden AS ServicioTipoOrden';

		$dataOrden = $this->db->select( $select )
					->from( 'Venta' )
					->where( 'Movid', $movId )
					->where( 'Mov', 'Servicio' )
					// agregar el modulo revisar con producto
					/// ->where( 'Mov', 'Servicio' )
					->get()->result_array();
					//echo $this->db->last_query();
		return  $dataOrden ;			
	}

	public function validaUnicoMovimiento( $data )
	{
		$estadoNuevo = $this->nombreOperacion( $data[ 'operacionSeleccionada' ] );

		$tabla = "SeguimientoOperaciones";
		if ($this->config->item('ConfigVersionIntelisis') == 'V6000')  
			$tabla = "CA_SeguimientoOperaciones";

		$movIniciado = $this->db->query( "SELECT * FROM VentaD JOIN Art ON VentaD.Articulo = Art.Articulo LEFT OUTER JOIN Agente ON VentaD.Agente = Agente.Agente JOIN Venta ON Venta.ID = VentaD.ID
		WHERE Agente.Agente = '".$data[ 'agente' ]."' AND Art.Tipo = 'Servicio' AND Art.Articulo NOT IN ( 'TOT', 'T.O.T' ) AND Venta.Situacion <> 'Orden Cerrada' AND ventad.cantidad > isnull(ventad.cantidadcancelada,0) 
		AND ( SELECT TOP(1) Estado FROM ". $tabla ." WHERE IdVenta = VentaD.ID AND Renglon = VentaD.Renglon AND
		RenglonId = VentaD.RenglonID ORDER BY Id desc ) = '".$estadoNuevo."'" )->result();

		//echo $this->db->last_query();
		if( $movIniciado ){
		$ret["unico"] = 'no';
		$ret["num"] = $movIniciado[0]->MovID;
		}else{
		$ret["unico"] = 'si';
		$ret["num"]=0;
		}
		return $ret;
	}

	public function validaUnicaOperacion( $data )
	{
		$estadoNuevo = $this->nombreOperacion( $data[ 'operacionSeleccionada' ] );

		$tabla = "SeguimientoOperaciones";
		if ($this->config->item('ConfigVersionIntelisis') == 'V6000')  
			$tabla = "CA_SeguimientoOperaciones";
		
		$movIniciado = $this->db->query( "SELECT * FROM VentaD JOIN Art ON VentaD.Articulo = Art.Articulo LEFT OUTER JOIN Agente ON VentaD.Agente = Agente.Agente JOIN Venta ON Venta.ID = VentaD.ID
									WHERE Agente.Agente = '".$data[ 'agente' ]."' AND Art.Tipo = 'Servicio' AND Art.Articulo NOT IN ( 'TOT', 'T.O.T' ) AND Venta.Situacion <> 'Orden Cerrada'
									AND ( SELECT TOP(1) Estado FROM ". $tabla ." SO WHERE VentaD.ID = SO.IdVenta and ventaD.Cantidad < ventaD.CantidadCancelada AND VentaD.Renglon = SO.Renglon AND 
									VentaD.RenglonID = SO.RenglonId AND IdVenta <> ".$data[ 'idCheck' ]." ORDER BY Id desc ) = '".$estadoNuevo."'" )->result();
	
		if( $movIniciado ){
			$ret["unico"] = 'no';
			$ret["num"] = $movIniciado[0]->MovID;
		}else{
			$ret["unico"] = 'si';
			$ret["num"]=0;
		}
		return $ret;
	}

	//funcion para validar reglas de negocio dashborad
	public function fordValidaPlaneacionRealWeb( $IdVenta = null, $RenglonId = null )
	{
		if (REGLAS_NEG_FORD == FALSE && $this->config->item('ConfigMarca') == 'Ford') {
			$this->db->trans_begin();
			// //$ret[ 'msj' ] = $this->db->select(" dbo.fnCA_fordValidaPlaneacionRealWeb ( ".$data[ 'IdVenta' ]." , ".$data[ 'RenglonId' ]." ) ok ")->get()->row_array();
			$ret = $this->db->select(" dbo.fnCA_fordValidaPlaneacionRealWeb ( ".$IdVenta." , ".$RenglonId." ) msj ")->get()->row_array();
			//echo $this->db->last_query();
			$this->db->trans_commit();
		}
		else
		{
			$ret[ 'msj' ] = 'ok';
		}

		return $ret;
	}
	//funcion para validar autorizacion de operaciones en ordenes de garantía ford
	public function fordValidaPlanRealGrantias( $IdVenta = null, $Renglon = null, $tipoOrden = null )
	{
		$recepcion = $this->load->database("recepcion", TRUE);
		if ( val_garantias ) {
			$this->db->trans_begin();
			$ret = $this->db->select(" dbo.fnCA_fordValidaPlanRealGarantias ( ".$IdVenta." , ".$Renglon." , '".$tipoOrden."' ) msj ")->get()->row_array();
			//echo $this->db->last_query();
			$this->db->trans_commit(); 
		}
		else
		{
			$ret[ 'msj' ] = 'ok';
		}

		return $ret;
	}

	public function seguimientoOperacion( $data )
	{
		$nuevo = $this->nombreOperacion( $data[ 'Nuevo' ] );
		$conceptos = $this->db->query( "DECLARE @Realizado int
        			EXEC xpSeguimientoWeb ".$data[ 'IdVenta' ].",'".$data[ 'Edo' ]."','".$nuevo."','".$data[ 'Situacion' ]."', ".$data[ 'Renglon' ].",".$data[ 'RenglonId' ].",'".$data[ 'Comentarios' ]."', @Realizado OUTPUT, '{$data['agente']}'
        			SELECT @Realizado AS Realizado" )->row_array();
		$ret[ 'sp' ] = 'ok';
		$data[ 'claveAsesor' ] = $data[ 'agente' ];
		/*$data[ 'fechaBusinic' ] = $data[ 'fechaBusinic' ];
		$data[ 'fechaBusfin' ] = $data[ 'fechaBusfin' ];*/
		$ret[ 'movimientos' ] = $this->obtener_seguimiento( $data );
		//echo $this->db->last_query();
		return $ret;
	}

	public function seguimientoSituacion( $data )
	{
		$nuevo = $this->nombreOperacion( $data[ 'operacionSeleccionada' ] );
		switch ( $nuevo ) 
		{
			case 'Detenida por TOT':
			case 'Detenida por Otros':
			case 'Detenida por Soporte Planta':
			case 'Detenida por Autorización':
			case 'Detenida por Refacciones':
				$nuevaSituacion = $nuevo;
			break;
			case 'En Curso':
				$nuevaSituacion = 'En Proceso';
			break; 
			case 'Completada':
				$nuevaSituacion = NULL;
			break;
		}

		$sp2 = $this->db->query( " spCambiaSituacionWeb ".$data[ 'idCheck' ].", '".$data['estadoCheck' ]."', '".$nuevo."', '".$nuevaSituacion."', 'Si'" );
		//echo $this->db->last_query();
		$sp2 = 'ok';

		return $sp2;
	}


	public function nombreOperacion( $boton )
	{
		switch ( $boton ) 
		{
			case 'imgDetenidaTOT':
	            $operacion = 'Detenida por TOT';
	        break;
	        case 'imgDetenidaOtros':
	            $operacion = 'Detenida por Otros';
	        break;
	        case 'imgDetenidaPlanta':
	            $operacion = 'Detenida por Soporte Planta';
	        break;
	        case 'imgDetenidaAutorizacion':
	            $operacion = 'Detenida por Autorización';
	        break;   
	        case 'imgDetenidaRefacciones':
	            $operacion = 'Detenida por Refacciones';
	        break;    
	        case 'imgNoComenzada':
	            $operacion = 'No Comenzada';
	        break; 
	        case 'imgCompletada':
	            $operacion = 'Completada';
	        break;
	        case 'imgEnCurso':
	            $operacion = 'En Curso';
	        break;
		}

		return $operacion;
	}
}