<?php
class  Multipuntos_model extends MY_Model
{
	

	/*  
		Directorio para el guardado de fotos multipuntos
		 Ejem: '../recepcion/assets/uploads/fotografias/'   o  'F:/AppsGMAUT/Aplicaciones/RA/fotografias/'  
	*/
    private $dir_fotos = '../Recepcion/assets/uploads/';
	function __construct()
    {
        parent::__construct();
        $this->dir_fotos = $this->config->item('url_formats');
    }
	/*	=========================================================
	Multipuntos dinamicos
		========================================================= */ 
	public function contenido_din($orden){
		$data['orden']	 = $this->datos_orden($orden);
		$data['inspeccion'] = $this->datos_inspeccion($orden);
		return $data;
	}

	public function datos_orden($orden){
		$data = $this->db->select('
			cte.nombre 		AS cliente,
			v.ServicioKms 	AS kilometraje,
			ag.nombre 		AS asesor,
			v.movid,
			vin.modelo,
			vin.vin,
			CONVERT(varchar, fechaEmision, 23) AS fecha,
			v.id
		')
		->from("venta v")
		->join('agente ag', 'v.agente = ag.agente' )
		->join('vin ', 'v.servicioserie = vin.vin')
		->join('cte ', 'v.cliente = cte.cliente')
		// ->o;in('')
		->where("id", $orden)
		->get()->row_array();
		return $data;
	}
	public function datos_inspeccion($order_id) {
		// Recupera los datos de CA_MultipointResponses
		$this->db->select('*');
		$this->db->where('order_id', $order_id);
		$response = $this->db->get('CA_MultipointResponses')->row_array();

		if ($response) {
			$response_id = $response['id'];

			// Recupera las respuestas de CA_MultipointQuestionAnswers
			$this->db->select('question_identifier, answer_value');
			$this->db->where('response_id', $response_id);
			$answers = $this->db->get('CA_MultipointQuestionAnswers')->result_array();

			// Formatea las respuestas en un array asociativo
			$formatted_answers = [];
			foreach ($answers as $answer) {
				$formatted_answers[$answer['question_identifier']] = $answer['answer_value'];
			}

			// Combina la respuesta y las respuestas formateadas
			$data = [
				'response' => $response,
				'answers' => $formatted_answers
			];

			return $data;
		} else {
			return null;
		}
	}
	public function guardar_respuestas($data, $answers) {
		$this->db->trans_start();
	
		// Insertar en CA_MultipointResponses
		$this->db->insert('CA_MultipointResponses', $data);
		$response_id = $this->db->insert_id();
	
		// Insertar en CA_MultipointQuestionAnswers
		foreach ($answers as $question_identifier => $answer) {
			$answer_data = [
				'response_id' => $response_id,
				'question_identifier' => $question_identifier,
				'answer_value' => is_null($answer) ? null : (string)$answer
			];
	
			$this->db->insert('CA_MultipointQuestionAnswers', $answer_data);
		}
	
		$this->db->trans_complete();
	
		return $this->db->trans_status();
	}

	public function check_existing_record($order_id) {
		$this->db->where('order_id', $order_id);
		$query = $this->db->get('CA_MultipointResponses');
		return $query->row_array();
	}

	public function update_respuestas($info, $evaluation) {
		// Inicia una transacción
		$this->db->trans_start();
	
		// Actualiza las respuestas existentes
		$this->db->where('order_id', $info['order_id']);
		$this->db->update('CA_MultipointResponses', $info);
	
			// Recupera el id de la tabla CA_MultipointResponses
		$this->db->select('id');
		$this->db->where('order_id', $info['order_id']);
		$response = $this->db->get('CA_MultipointResponses')->row_array();
		$response_id = $response['id'];
	
		// Elimina las respuestas previas
		$this->db->where('response_id', $response_id);
		$this->db->delete('CA_MultipointQuestionAnswers');
	
		// Inserta las nuevas respuestas
		foreach ($evaluation as $question_identifier => $answer_value) {
			$data = [
				'response_id' => $response_id,
				'question_identifier' => $question_identifier,
				'answer_value' => $answer_value
			];
			$this->db->insert('CA_MultipointQuestionAnswers', $data);
		}
	
		// Completa la transacción
		$this->db->trans_complete();
	
		// Retorna verdadero si la transacción fue exitosa
		return $this->db->trans_status();
	}
	/*	=========================================================
		Multipuntos dinamicos
		========================================================= */ 
	public function datos_ordenes($fecha_inicio = 0, $fecha_final = 0)
	{

		if($fecha_inicio == 0)
		{
			// $where = " FechaEmision = '".date("d-m-Y")." 00:00:00 '";
			$where = " fecha_creacion between '".date("d-m-Y")." 00:00:00' AND '".date("d-m-Y")." 23:59:59'";
		}else
		{
			// $where = " FechaEmision between '".$fecha_inicio."' AND '".$fecha_final."'";
			$where = " fecha_creacion between '".date('d-m-Y',strtotime($fecha_inicio))." 00:00:00' AND '".date('d-m-Y',strtotime($fecha_final))." 23:59:59'";
		}

		$recepcion = $this->load->database("recepcion", TRUE);

		$temp = $recepcion->select("id_orden_intelisis")->from("orden_servicio")->where("id_sucursal_intelisis", $this->session->userdata("id_suc"))->where("id_orden_intelisis IS NOT NULL")->where($where)->where(["movimiento IS NULL" => null, "tipo_orden !=" => 'Garantia'])->get()->result_array();
		$movs_servicio = $recepcion->select("*")->from("mov_servicio")->where("eliminado",0)->get()->result_array();
		// $recepcion->close();
		$ids = "0,";

		foreach ($temp as $key => $value)
		{
			$ids .= $value['id_orden_intelisis'].",";
		}
		$ids = substr($ids, 0, -1);
		$movs ="";
		foreach ($movs_servicio as $key => $value)
		{
			$movs .= "'".$value['movimiento']."',";
		}
		$movs = substr($movs, 0,-1);
		$datos['ordenes'] = $this->db->select("V.ID, V.MovID, V.FechaEmision, A.Agente as asesor_id, A.Nombre as agente_nombre,V.ServicioSerie as vin,C.Nombre as Cliente, V.FechaRequerida, V.HoraRequerida")
								->from("Venta V")->join("Agente A", "A.Agente = V.Agente")->join("Cte C", "C.Cliente = V.Cliente")->where("V.ID IN($ids)")
								->where("V.MOV IN ($movs)")->where("V.Sucursal", $this->session->userdata("id_suc"))
								//where que evita mostrar ordenes que no estan afectadas
								->where("v.Estatus", "PENDIENTE")
								->get()->result_array();
								// echo $this->db->last_query();
								//->where("V.MOV", "Servicio")->where("V.Estatus",'PENDIENTE')->where("V.Sucursal", $this->session->userdata("id_suc"))->get()->result_array();

		for ($i=0; $i<count($datos['ordenes']) ; $i++)
		{ 
			$datos['ordenes'][$i] += $recepcion->select('multipuntos')->from("orden_servicio")->where("id_sucursal_intelisis",$this->session->userdata("id_suc"))
			->where("id_orden_intelisis", $datos['ordenes'][$i]['ID'])->get()->row_array();
		}
		// echo $this->db->last_query();
		// die;
		return $datos;
	}
	// Obtiene los datos de la orden de servicio para la marca BYD (Ya no se usa la bd de recepcion)
	public function get_listado_multipuntos_byd($fecha_inicio = 0, $fecha_final = 0)
	{
		if($fecha_inicio == 0)
		{
			$whereDate = " v.FechaEmision between '".date("d-m-Y")." 00:00:00' AND '".date("d-m-Y")." 23:59:59'";
		}else
		{
			$whereDate = " v.FechaEmision between '".date('d-m-Y',strtotime($fecha_inicio))." 00:00:00' AND '".date('d-m-Y',strtotime($fecha_final))." 23:59:59'";
		}

		$recepcion = $this->load->database("recepcion", TRUE);

		$datos['ordenes'] = $this->db
		->select("V.ID, V.MovID, V.FechaEmision, A.Agente as asesor_id, A.Nombre as agente_nombre, V.ServicioSerie as vin, C.Nombre as Cliente, V.FechaRequerida, V.HoraRequerida, 
			CASE 
				WHEN CA_MultipointResponses.id IS NULL THEN 0 
				WHEN CA_MultipointResponses.technical_signature IS NULL THEN 1 
				ELSE 2 
			END AS multipuntos")
		->from("Venta V")
		->join("Agente A", "A.Agente = V.Agente")
		->join("Cte C", "C.Cliente = V.Cliente")
		->join("CA_MultipointResponses", "CA_MultipointResponses.order_id = V.ID", "left")
		->join($recepcion->database . ".dbo.orden_servicio os", "os.id_orden_intelisis = V.ID", "right")
		->where("V.MOV IN ('Servicio','servicio2','Servicio HYP','Servicio Garantia','Servicio Reclamacion','Servicio','Serv Linc HYP','Serv Linc Garantia','Serv Linc Reclam','Serv Linc')")
		->where("V.Sucursal", $this->session->userdata("id_suc"))
		->where("v.Estatus", "PENDIENTE")
		->where($whereDate)
		->get()->result_array();

		return $datos;
	}	
	public function guardar_multipuntos($data)
	{
		$recepcion = $this->load->database("recepcion", TRUE);
		
		$sucursal =  $this->session->userdata("id_suc");
		$temp = $recepcion->select("id")->from("orden_servicio")->where("id_orden_intelisis", $data['id_orden'])->where("id_sucursal_intelisis", $sucursal)->get()->row_array();

		$recepcion->trans_start();

		$recepcion->where("id", $temp['id']);
		$recepcion->update("orden_servicio", array("multipuntos"=>1, "comentario_tecnico_multip" => $data["comentario_tec"]));

		$recepcion->where("id_servicio", $temp['id']);
		$recepcion->update("orden_servicio_inspeccion", array("multipuntos"=>1,"multipuntos_box"=>$data['check'],"multipuntos_input"=>$data['input'],'multipuntos_text'=>$data['text'],'multipuntos_radio' =>$data['radio'],'tecnico_inspeccion'=>$data['select']));

		// $recepcion->where("id_servicio", $temp['id']);
		// $recepcion->update("orden_servicio_inspeccion", array("multipuntos_box"=>$data['check'],"multipuntos_input"=>$data['input']));

		$data1 [ 'nivel_carga' ]  		= $data [ 'nvl_carga' ];
		$data1 [ 'corriente_fabrica' ]  = $data [ 'corriente_fabric' ];
    	$data1 [ 'corriente_real' ]     = $data [ 'corrient_real' ];
   		$data1 [ 'bateria' ]            = $data[ 'nivel_bateria' ];
   		$data1 [ 'bateria_cambiado' ]   = $data[ 'btr_Cambiado' ];

		$recepcion->where("id_servicio", $temp['id']);
		$recepcion->update("orden_servicio_inspeccion", $data1);


		
		$recepcion->trans_complete();

		$revision = $this->guardar_revisionIntelisis($temp["id"]);					//guarda datos de la revisi�n en Intelisis
		
		if( $recepcion->trans_status() == true && $revision)
			$ret[ 'saved' ] = 'ok';
		else
			$ret[ 'saved' ] = 'ko';
		return $ret;

	}

	public function guardar_revisionIntelisis($id_orden = null)
	{
		$recepcion = $this->load->database("recepcion", TRUE);

		$datos_orden["orden"] = $recepcion->select("os.id_orden_intelisis AS ventaID, osi.bateria, osi.multipuntos_box, osi.multipuntos_input, osi.multipuntos_text, osi.multipuntos_radio, ISNULL(osi.tecnico_inspeccion, '') AS tecnico")
								 ->from("orden_servicio os")
								 ->join("orden_servicio_inspeccion osi", "os.id = osi.id_servicio")
								 ->where("os.id", $id_orden)
								 ->get()->row_array();
		/*echo "<pre>";
		print_r ($recepcion->last_query());
		echo "</pre>";*/

		$recepcion->close();

		if(isset($datos_orden["orden"]["tecnico"]) && $datos_orden["orden"]["tecnico"] != "")
		{
			$datos_orden["tecnico"] = $this->db->select("Agente")
											   ->from("Agente")
											   ->where("Nombre", $datos_orden["orden"]["tecnico"])
											   //->where("SucursalEmpresa", $this->session->userdata("id_suc"))
											   //->where("Tipo","Mecanico")
											   //->where("Estatus", "Alta")
											   ->get()->row_array();
		}else
		{
			$datos_orden["tecnico"] = null;
		}

		if($datos_orden["tecnico"] != null)
		{
			//Bater�a
			switch($datos_orden["orden"]["bateria"]) 
			{
				case "Bien":
					$bateria = "Verde";
				break;
				case "Requiere Atencion":
					$bateria = "Amarillo";
				break;
				case "Requiere Reparacion":
					$bateria = "Rojo";
				break;
				default:
					$bateria = null;
				break;
			}

			$radioBtn = explode("-", $datos_orden["orden"]["multipuntos_radio"]);
			
			//Balatas
			$total_balatas = 4;
			$arrayBalatasVerde = ["c49", "c69", "c93", "c113"];
			$arrayBalatasAmarillo = ["c50", "c70", "c94", "c114"];
			$arrayBalatasRojo = ["c51", "c71", "c95", "c115"];

			$total_balatasVerde = 0;
			$total_balatasAmarillo = 0;
			$total_balatasRojo = 0;
			foreach($radioBtn as $key => $value) 
			{				 
				if(in_array($value, $arrayBalatasVerde))
				{
					$total_balatasVerde++;
				}

				if(in_array($value, $arrayBalatasAmarillo))
				{
					$total_balatasAmarillo++;
				}

				if(in_array($value, $arrayBalatasRojo))
				{
					$total_balatasRojo++;
				}
			}

			$balatas = null;

			if($total_balatasVerde == $total_balatas)						//si todos van en verde
			{
				$balatas = "Verde";
			}else if($total_balatasRojo >= 1)								//hay al menos un rojo
			{
				$balatas = "Rojo";
			}else 															//hay verdes y amarillos o alguno ven�a sin seleccionar
			{
				$balatas = "Amarillo";
			}

			if($total_balatasVerde == 0 && $total_balatasAmarillo == 0 && $total_balatasRojo == 0)  	//no ven�a ninguno seleccionado
			{
				$balatas = null;
			}

			//Discos
			$total_discos = 4;
			$arrayDiscosVerde = ["c53", "c73", "c97", "c117"];
			$arrayDiscosAmarillo = ["c54", "c74", "c98", "c118"];
			$arrayDiscosRojo = ["c55", "c75", "c99", "c119"];

			$total_discosVerde = 0;
			$total_discosAmarillo = 0;
			$total_discosRojo = 0;
			foreach($radioBtn as $key => $value) 
			{				 
				if(in_array($value, $arrayDiscosVerde))
				{
					$total_discosVerde++;
				}

				if(in_array($value, $arrayDiscosAmarillo))
				{
					$total_discosAmarillo++;
				}

				if(in_array($value, $arrayDiscosRojo))
				{
					$total_discosRojo++;
				}
			}

			$discos = "Verde";

			if($total_discosVerde == $total_discos)						//si todos van en verde
			{
				$discos = "Verde";
			}else if($total_discosRojo >= 1)								//hay al menos un rojo
			{
				$discos = "Rojo";
			}else 															//hay verdes y amarillos o alguno ven�a sin seleccionar
			{
				$discos = "Amarillo";
			}

			if($total_discosVerde == 0 && $total_discosAmarillo == 0 && $total_discosRojo == 0)  	//no ven�a ninguno seleccionado
			{
				$discos = "Verde";
			}

			//Llantas
			$total_llantas = 4;
			$arrayLlantasVerde = ["c37", "c57", "c81", "c101"];
			$arrayLlantasAmarillo = ["c38", "c58", "c82", "c102"];
			$arrayLlantasRojo = ["c39", "c59", "c83", "c103"];

			$total_llantasVerde = 0;
			$total_llantasAmarillo = 0;
			$total_llantasRojo = 0;
			foreach($radioBtn as $key => $value) 
			{				 
				if(in_array($value, $arrayLlantasVerde))
				{
					$total_llantasVerde++;
				}

				if(in_array($value, $arrayLlantasAmarillo))
				{
					$total_llantasAmarillo++;
				}

				if(in_array($value, $arrayLlantasRojo))
				{
					$total_llantasRojo++;
				}
			}

			$llantas = null;

			if($total_llantasVerde == $total_llantas)						//si todos van en verde
			{
				$llantas = "Verde";
			}else if($total_llantasRojo >= 1)								//hay al menos un rojo
			{
				$llantas = "Rojo";
			}else 															//hay verdes y amarillos o alguno ven�a sin seleccionar
			{
				$llantas = "Amarillo";
			}

			if($total_llantasVerde == 0 && $total_llantasAmarillo == 0 && $total_llantasRojo == 0)  	//no ven�a ninguno seleccionado
			{
				$llantas = null;
			}

			//Tambores
			$total_tambores = 2;
			$arrayTamboresVerde = ["c77", "c121"];
			$arrayTamboresAmarillo = ["c78", "c122"];
			$arrayTamboresRojo = ["c79", "c123"];

			$total_tamboresVerde = 0;
			$total_tamboresAmarillo = 0;
			$total_tamboresRojo = 0;
			foreach($radioBtn as $key => $value) 
			{				 
				if(in_array($value, $arrayTamboresVerde))
				{
					$total_tamboresVerde++;
				}

				if(in_array($value, $arrayTamboresAmarillo))
				{
					$total_tamboresAmarillo++;
				}

				if(in_array($value, $arrayTamboresRojo))
				{
					$total_tamboresRojo++;
				}
			}

			$tambores = "Verde";

			if($total_tamboresVerde == $total_tambores)						//si todos van en verde
			{
				$tambores = "Verde";
			}else if($total_tamboresRojo >= 1)								//hay al menos un rojo
			{
				$tambores = "Rojo";
			}else 															//hay verdes y amarillos o alguno ven�a sin seleccionar
			{
				$tambores = "Amarillo";
			}

			if($total_tamboresVerde == 0 && $total_tamboresAmarillo == 0 && $total_tamboresRojo == 0)  	//no ven�a ninguno seleccionado
			{
				$tambores = "Verde";
			}

			//Empiezan inserts/updates
			$CCRevisionAuto["IdVenta"] = $datos_orden["orden"]["ventaID"];
			$CCRevisionAuto["Tecnico"] = $datos_orden["tecnico"]["Agente"];

			$this->db->trans_start();

			$tabla = "CCRevisionAuto";
			if ($this->config->item('ConfigVersionIntelisis') == 'V6000') 
			$tabla = "CA_CCRevisionAuto";
			
			//Bater�a
			//se agrega valores con campo baterias con y sin acento para la comparacion en CCRevisionAuto
			$val = array('Baterias', 'Baterías');
			$existe_bateria = $this->db->select("*")
									   ->from($tabla)
									   ->where("IdVenta", $datos_orden["orden"]["ventaID"])
									   //->where("Elemento", "Baterias")
									   ->where_in("Elemento", $val)
									   ->count_all_results();

			$CCRevisionAuto["strRespuesta"] = $bateria;

			if($existe_bateria == 0)
			{
				$CCRevisionAuto["IdRevision"] = 2024;
				$CCRevisionAuto["Elemento"] = "Baterias";

				$this->db->insert($tabla, $CCRevisionAuto);
			}else 
			{
				$this->db->where("IdVenta", $datos_orden["orden"]["ventaID"]);
				$this->db->where_in("Elemento", $val);
				$this->db->update($tabla, $CCRevisionAuto);
			}

			//Balatas
			$existe_balatas = $this->db->select("*")
									   ->from($tabla)
									   ->where("IdVenta", $datos_orden["orden"]["ventaID"])
									   ->where("Elemento", "Balatas")
									   ->count_all_results();

			$CCRevisionAuto["strRespuesta"] = $balatas;

			if($existe_balatas == 0)
			{
				$CCRevisionAuto["IdRevision"] = 4048;
				$CCRevisionAuto["Elemento"] = "Balatas";

				$this->db->insert($tabla, $CCRevisionAuto);
			}else 
			{
				$this->db->where("IdVenta", $datos_orden["orden"]["ventaID"]);
				$this->db->where("Elemento", "Balatas");
				$this->db->update($tabla, $CCRevisionAuto);
			}

			//Discos
			$existe_discos = $this->db->select("*")
									   ->from($tabla)
									   ->where("IdVenta", $datos_orden["orden"]["ventaID"])
									   ->where("Elemento", "Discos")
									   ->count_all_results();

			$CCRevisionAuto["strRespuesta"] = $discos;

			if($existe_discos == 0)
			{
				$CCRevisionAuto["IdRevision"] = 6072;
				$CCRevisionAuto["Elemento"] = "Discos";

				$this->db->insert($tabla, $CCRevisionAuto);
			}else 
			{
				$this->db->where("IdVenta", $datos_orden["orden"]["ventaID"]);
				$this->db->where("Elemento", "Discos");
				$this->db->update($tabla, $CCRevisionAuto);
			}

			//Tambores
			$existe_tambores = $this->db->select("*")
									   ->from($tabla)
									   ->where("IdVenta", $datos_orden["orden"]["ventaID"])
									   ->where("Elemento", "Tambores")
									   ->count_all_results();

			$CCRevisionAuto["strRespuesta"] = $tambores;

			if($existe_tambores == 0)
			{
				$CCRevisionAuto["IdRevision"] = 8096;
				$CCRevisionAuto["Elemento"] = "Tambores";

				$this->db->insert($tabla, $CCRevisionAuto);
			}else 
			{
				$this->db->where("IdVenta", $datos_orden["orden"]["ventaID"]);
				$this->db->where("Elemento", "Tambores");
				$this->db->update($tabla, $CCRevisionAuto);
			}

			//Llantas
			$existe_llantas = $this->db->select("*")
									   ->from($tabla)
									   ->where("IdVenta", $datos_orden["orden"]["ventaID"])
									   ->where("Elemento", "Llantas")
									   ->count_all_results();

			$CCRevisionAuto["strRespuesta"] = $llantas;

			if($existe_llantas == 0)
			{
				$CCRevisionAuto["IdRevision"] = 10120;
				$CCRevisionAuto["Elemento"] = "Llantas";

				$this->db->insert($tabla, $CCRevisionAuto);
			}else 
			{
				$this->db->where("IdVenta", $datos_orden["orden"]["ventaID"]);
				$this->db->where("Elemento", "Llantas");
				$this->db->update($tabla, $CCRevisionAuto);
			}

			$this->db->trans_complete();

			if($this->db->trans_status() == true)
			{
				$estatus["estatus"] = true;
			}else 
			{
				$estatus["estatus"] = false;
			}
		}else
		{
			$estatus["estatus"] = false;
		}

		return $estatus;					 
	}

	public function obtener_idTblOrden_Servicio($id_tblVenta = null)
	{
		$db2 = $this->load->database("recepcion", TRUE);							//db2 = buscador_citas

		$datos = $db2->select("id")
				     ->from("orden_servicio")
					 ->where("id_orden_intelisis", $id_tblVenta)
					 ->get()->row_array();

		$id_orden = $datos["id"];

		return $id_orden;
	}

	public function ver_datosHojaMult($id_orden = null)
	{
		$db2 = $this->load->database("recepcion", TRUE);							//db2 = buscador_citas
		$db3 = $this->load->database("default", TRUE);					//db3 = RF_MOTORS  			(para pruebas en desarrollo)
		$id_sucursal_int = $this->session->userdata("id_suc");


		$datos["orden_servicio"] = $db2->select("*")
					 				   ->from("orden_servicio")
					 				   ->where("id", $id_orden)
					                   ->get()->row_array();

		$mov_id = $db3->select("MovID, ServicioIdentificador")
					  ->from("Venta")
					  ->where("ID", $datos["orden_servicio"]["id_orden_intelisis"])
					  ->get()->row_array();

		$datos["mov_id"] = (isset($mov_id["MovID"])) ? $mov_id["MovID"] : "";						//el movID lo da hasta que se afecta la orden
		$datos["num_torre"] = (isset($mov_id["ServicioIdentificador"])) ? $mov_id["ServicioIdentificador"] : "";		       

		$datos["orden_inspeccion"]["rev_asesor"] = $db2->select("perdida_fluidos, nivel_fluidos_cambiado, aceiteMotor, direccionHidraulica, liquidoTransmision, liquidoFreno, liquidoLimpiaPara, deposito_refrigerante, pruebaParabrisas, plumas, plumaslimp_cambiado, sistemas1_cambiado, sistemas2_cambiado, luces, parabrisas, bateria, corriente_fabrica, corriente_real, nivel_carga, bateria_cambiado, extension_garantia")
													   ->from("orden_servicio_inspeccion")
													   ->where("id_servicio", $id_orden)
													   ->get()->row_array();

		$datos["orden_inspeccion"]["rev_tecnico"] = $db2->select("multipuntos_box,multipuntos_radio, multipuntos_input, multipuntos_text, tecnico_inspeccion")
														->from("orden_servicio_inspeccion")
													    ->where("id_servicio", $id_orden)
													    ->get()->row_array();

		$datos["sucursal"] = $db2->select("a.razon_social, s.nombre, ds.*")
								 ->from("sucursal s")
								 ->join("datos_sucursal ds", "s.id = ds.id_sucursal")
								 ->join("agencia a", "s.id_agencia = a.id")
								 ->where("s.sucursal_int", $datos["orden_servicio"]["id_sucursal_intelisis"])
								 ->get()->row_array();								

		$datos["firma_cliente"] = $db2->select("firma_multipuntos AS firma")
									 ->from("firma_electronica")
									 ->where("id_orden_servicio", $id_orden)
									 ->get()->row_array();
		$id_tipo=$db2->select("id")
									 ->from("tipo_archivo")
									 ->where("tipo", 'imagen seguimiento')->get()->row_array();
		$datos["imagenes"] = $db2->select("id,ruta_archivo,fecha_actualizacion")->from("archivo")->where("id_orden_servicio", $id_orden)->where("tipo_archivo",$id_tipo["id"])->where("eliminado",0)->get()->result_array();
		if ($this->config->item('configGarantiasFord') == TRUE){
			$datos["manual_garantia"] = $db3->select("AcordeManual AS acorde_manual, NoAcordeManual AS no_acorde_manual, NoAplica AS no_aplica")
														->from("CA_Venta")
													    ->where("IdVenta", $datos["orden_servicio"]["id_orden_intelisis"])
													    ->get()->row_array();
		}
		return $datos;
	}

	public function tecnicos_disponibles($id_orden = 0)
	{
		$temp['tecnicos'] = $this->db->select("DISTINCT agente.nombre")->from("agente")->where("SucursalEmpresa", $this->session->userdata("id_suc"))->where("Tipo","Mecanico")->where("Estatus", "Alta")->get()->result_array();
		//$temp['tecnicos'] = $this->db->select("DISTINCT agente.nombre")->from("agente")->join("ventad ","ventad.agente = agente.agente")->where("ID", $id_orden)->get()->result_array();
		return $temp;
	}
	public function get_tecnicos_disponibles($id_orden = 0)
	{
		$whereSuc = $this->config->item('ConfigEmpresa') === 'BYTRU' ? 'SucursalEmpresa <> 11' : 'SucursalEmpresa = '.$this->session->userdata("id_suc");
		$temp['tecnicos'] = $this->db->select("DISTINCT agente.nombre, agente.agente as id")->from("agente")->where($whereSuc)->where("Tipo","Mecanico")->where("Estatus", "Alta")->get()->result_array();
		return $temp;
	}
	// public function traer_orden_servicio($id){

	// 	$this->db2 = $this->load->database('recepcion',TRUE); 
	// 	$orden = $this->db2->query("
	// 		SELECT
	// 			id
	// 		FROM
	// 			orden_servicio
	// 		WHERE
	// 			id_orden_intelisis = ?
	// 	", array($id));
	// 	if($orden->num_rows() > 0){
	// 		return $orden->row();
	// 	}else
	// 		return false;
	// }
	public function traer_orden_servicio($id){

		$this->db2 = $this->load->database('recepcion',TRUE); 
		$orden = $this->db2->select("id")->from("orden_servicio")->where("id_orden_intelisis", $id)->get()->row_array();

		if($orden){
			return $orden;
		}else{
			return 0;
		}
	}
	public function SaveDocsIntelisis($ruta, $id_orden,$id_vennta){
		//load database
		$this->db2 = $this->load->database("default", TRUE);	
		// variables
		$rama      = 'VTAS';
		$nombre    = 'HojaMultipuntos'.$id_orden.'.pdf';
		$id        = $id_vennta;
		$new_ruta  = str_replace("/", "\\", $ruta);
		$new_ruta  = substr($new_ruta,2);
		//corregir ruta dependiendo de donde esta la instalacion.
		$ruta      = 'C:\wamp\www\WebProyectos2'.$new_ruta;
		$icono     = 754;
		$tipo      = 'Archivo';
		$sucursal  = $this->session->userdata("id_suc");
		$fecha     =  date("d-m-Y");
		$cfd       = 0;
		//insert 
		$this->db2->trans_begin();
	
		$this->db2->query("INSERT INTO AnexoMov (Rama, ID, Nombre, Direccion, Icono, Tipo, Sucursal,
			FechaEmision, CFD) VALUES (?,?,?,?,?,?,?,?,?);", array($rama, $id, $nombre, $ruta, $icono, $tipo, 
			$sucursal,$fecha,$cfd));
		
		$user_id = $this->db2->insert_id();
		if ($this->db2->trans_status() === FALSE){
			$this->db2->trans_rollback();
			return false;
		}else{
			$this->db2->trans_commit();
			return $user_id;
		}
	}
	public function email_refacciones(){
		$this->db2 = $this->load->database("recepcion", TRUE);
		$mail = $this->db2->select("email_refacciones,email_refacciones_multiple")->from("sucursal")->where("id_servicio",$this->session->userdata("id_suc"))->get()->row_array();
		$emails = [];
		if (!empty($mail["email_refacciones"])) {
			$emails[] = $mail["email_refacciones"];
		}
		if (!empty($mail["email_refacciones_multiple"])) {
			$emails = array_merge($emails, explode("; ", $mail["email_refacciones_multiple"]));
		}
		$emails = array_unique(array_map('trim', $emails));
		if (!empty($emails)) {
			$existe["estatus"] = true;
			$existe["correo"] = implode("; ", $emails);
		} else {
			$existe["estatus"] = false;
			$existe["correo"] = "";
		}
		return $existe;
	}
	public function obtener_datosAsesor($id_orden = null)
	{
		$this->db2 = $this->load->database("recepcion", TRUE);

		$asesor = $this->db2->select("u.email, u.nombre, u.apellidos")
						    ->from("orden_servicio os")
						    ->join("usuarios u", "os.clave_asesor = u.cve_intelisis")
						    ->where("os.id_orden_intelisis", $id_orden)
						    ->get()->row_array();

		$this->db2->close();
						    
		return $asesor;
	}

	public function guardar_foto_multipuntos($datos = null)
	{
		$archivo["id_orden_servicio"] = $datos["id_orden_servicio"];
		$this->db2 = $this->load->database("recepcion", TRUE);
		$id_tipo=$this->db2->select("id")
		->from("tipo_archivo")
		->where("tipo", 'imagen seguimiento')->get()->row_array();
		$archivo["tipo_archivo"] = $id_tipo["id"];
		$archivo["fecha_creacion"] = date("d-m-Y H:i:s");
		$archivo["fecha_actualizacion"] = date("d-m-Y H:i:s");
		$archivo["eliminado"] = 0;
		$datos2=$datos;
		for($i=0;$i<sizeof($datos["input_vista_previa"]);$i++){
			$datos2["input_vista_previa"]=$datos["input_vista_previa"][$i];
			$this->db2->trans_start();
			$this->db2->insert("archivo", $archivo);
			$id_registro = $this->db2->select("IDENT_CURRENT('archivo') as id")->get()->row_array();
			$this->db2->trans_complete();
			if($this->db2->trans_status() == true){
				$datos2["id"] = $id_registro["id"];
				$archivo_creado = $this->crear_archivo_multipuntos($datos2);
				$file = ($archivo_creado) ? true : false;
			}else{
				$file = false;
			}
		}
		return $file;
	}
	public function remover_foto_multipuntos($datos = null)
	{
		$this->db2 = $this->load->database("recepcion", TRUE);
		for($i=0;$i<sizeof($datos["input_vista_previa"]);$i++){
			
			$act["eliminado"] = 1;
        	$act["fecha_actualizacion"] = date("d-m-Y H:i:s");
			$this->db2->trans_start();
			$this->db2->where("id", $datos["input_vista_previa"][$i]);
			$this->db2->update("archivo", $act);
			$this->db2->trans_complete();
			if($this->db2->trans_status() == true){
				$file = true;
			}else{
				$file = false;
			}
		}
		return $file;
	}
	public function crear_archivo($datos = null)
	{
		$this->db2 = $this->load->database("recepcion", TRUE);
		$archivo = $datos["input_vista_previa"];
		$datos["vin"] = trim($datos["vin"]);
		$archivo = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $archivo));
		$ruta = $this->dir_fotos.$datos["vin"].'/'.$datos["id_orden_servicio"].'/img'.$datos["id"].'.jpg';
		$ruta_tmp = $this->dir_fotos.$datos["vin"].'/'.$datos["id_orden_servicio"];
		if ($this->config->item('ConfigUnidadRedUso')) {
			$ruta = $this->reemplazar_unidad_red($ruta,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
			$ruta_tmp = $this->reemplazar_unidad_red($ruta_tmp,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
		}
		if(!file_exists($ruta_tmp)) 
        {
            mkdir($ruta_tmp, 0777, true);
        }

        file_put_contents($ruta, $archivo);

        if(file_exists($ruta)) 
        {
        	$ruta_a["ruta_archivo"] = $ruta;
        	$ruta_a["fecha_actualizacion"] = date("d-m-Y H:i:s");

            $this->db2->where("id", $datos["id"]);
            $this->db2->update("archivo", $ruta_a);

            $creado = true;
        }else
        {
        	$creado = false;
        }

        return $creado;
	}
	public function crear_archivo_multipuntos($datos = null)
	{
		$this->db2 = $this->load->database("recepcion", TRUE);
		$archivo = $datos["input_vista_previa"];
		$datos["vin"] = trim($datos["vin"]);
		$archivo = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $archivo));
		$ruta = $this->dir_fotos.$datos["vin"].'/'.$datos["id_orden_servicio"].'/img'.$datos["id"].'.jpg';
		$ruta_tmp = $this->dir_fotos.$datos["vin"].'/'.$datos["id_orden_servicio"];
		if ($this->config->item('ConfigUnidadRedUso')) {
			$ruta = $this->reemplazar_unidad_red($ruta,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
			$ruta_tmp = $this->reemplazar_unidad_red($ruta_tmp,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
		}
		if(!file_exists($ruta_tmp)) 
        {
            mkdir($ruta_tmp, 0777, true);
        }

        file_put_contents($ruta, $archivo);

        if(file_exists($ruta)) 
        {
        	$ruta_a["ruta_archivo"] = $ruta;
			$ruta_a["fecha_actualizacion"] = date("d-m-Y H:i:s");
			$ruta_a["comentario"] = "";

            $this->db2->where("id", $datos["id"]);
            $this->db2->update("archivo", $ruta_a);

            $creado = true;
        }else
        {
        	$creado = false;
        }

        return $creado;
	}
	public function custom_data_orden($id,$values){

		$this->db2 = $this->load->database('recepcion',TRUE); 
		$orden = $this->db2->select($values)->from("orden_servicio")->where("id_orden_intelisis", $id)->get()->row_array();

		if($orden){
			return $orden;
		}else{
			return 0;
		}
	}
	public function get_pictures_multipuntos($id,$values){

		$this->db2 = $this->load->database('recepcion',TRUE);
		$id_tipo=$this->db2->select("id")
		->from("tipo_archivo")
		->where("tipo", 'imagen seguimiento')->get()->row_array();
		$orden = $this->db2->select($values)->from("archivo")->where("id_orden_servicio", $id)->where("tipo_archivo",$id_tipo["id"])->where("eliminado",0)->get()->result_array();
		if($orden){
			return $orden;
		}else{
			return 0;
		}
	}
	public function acorde_manual($id_orden, $datos)
	{
		$radio = explode('-', $datos['radio']);
		/*echo "<pre>";
		print_r(array_search('not2', $radio));
		echo "</pre>";*/
		$existe = $this->db->select("IdVenta")->from("CA_Venta")->where("IdVenta", $id_orden)->get()->row_array();
		$creado = false;
		if(isset($existe["IdVenta"])){
			$data = [
				'AcordeManual'      => array_search('yes1', $radio) !== false ? true : false,
				'NoAcordeManual'    => array_search('not2', $radio) !== false ? true : false,
				'NoAplica'          => array_search('na3', $radio) !== false ? true : false,
				'FechaAcordeManual' => date("d-m-Y H:i:s")
			];
			$this->db->trans_start();
			$this->db->where('IdVenta', $existe['IdVenta']);
			$this->db->update("CA_Venta", $data);
			$this->db->trans_complete();
			if($this->db->trans_status() === FALSE)
			{
				$creado = false;
				$this->db->trans_rollback();
			}else
			{
				$this->db->trans_commit();
				$creado = true;
			}
		}else {
			$data = [
				'IdVenta'           => $id_orden,
				'AcordeManual'      => array_search('yes1', $radio) !== false ? true : false,
				'NoAcordeManual'    => array_search('not2', $radio) !== false ? true : false,
				'NoAplica'          => array_search('na3', $radio) !== false ? true : false,
				'FechaAcordeManual' => date("d-m-Y H:i:s")
			];
			$this->db->trans_start();
			$this->db->insert("CA_Venta", $data);
			$this->db->trans_complete();
			if($this->db->trans_status() === FALSE)
			{
				$creado = false;
				$this->db->trans_rollback();
			}else
			{
				$this->db->trans_commit();
				$creado = true;
			}
		}
			return $creado;
	}
	public function obtener_configEmail()
	{
		$response = [];
			try {
				include(APPPATH.'config/database'.EXT);
				if (!isset($db['recepcion'])) {
				 throw new Exception('La base de datos de recepción no existe');
				}
				$recepcion = $this->load->database("recepcion", TRUE);
				//se agreg en caso de que no detecte variable de session mandar datos smtp de sucursal 1
				$suc_sess_mail = 1;
				if (isset($this->session->userdata["logged_in"]["id_sucursal"])) {
					$suc_sess_mail= $this->session->userdata["logged_in"]["id_sucursal"];
				}
				
				if (!$recepcion->table_exists('sucursal')) {
					throw new Exception('La tabla sucrusal de recepción no existe');
				}
				$query = $recepcion->query(" SELECT mail_host, mail_smtpAuth, mail_userName, mail_password, mail_smtpSecure, mail_port 
						FROM sucursal 
						WHERE id = ".  $suc_sess_mail . "");
				if($query->num_rows() > 0){
					$response['conf'] = $query->row_array();
					$response['mensaje'] = 'Configuración encontrada';
				}else
					throw new Exception("No existe información de envio de correo");
					
			}catch(\Exception $e){
				/*{"mail_host":"smtp.gmail.com","mail_smtpAuth":1,"mail_userName":"fordserviceexcellence@gmail.com","mail_password":"9F8a*37x","mail_smtpSecure":"ssl","mail_port":465}]}*/
				$response['mensaje'] = $e->getMessage();
				$response['conf'] = [
					'mail_host'       => HOST_MAIL,
					'mail_smtpAuth'   => AUTH_MAIL,
					'mail_userName'   => USERNAME_MAIL,
					'mail_password'   => PASSWORD_MAIL,
					'mail_smtpSecure' => SECURE_MAIL,
					'mail_port'       => PORT_MAIL
				];

			}finally{
				return $response;
			}
	}
}