<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class MY_Controller extends CI_Controller {
	function __construct() {
		parent::__construct();
		// $this->versionIntelisis();
	}
	public function versionIntelisis($sucursal)
	{
		try{
			$this->load->library('ConfigWriter', array(
				'file'          => ENVIRONMENT.'/config.php' ,
				'variable_name' => 'config'
			));
			$int = $this->load->database("default", TRUE);
			// Obtener empresa
			$empresa = $int->select('Empresa')->from('Empresa')->where(['Estatus' => 'ALTA'])->get()->row_array();
			$empresa = isset($empresa['Empresa']) ? $empresa['Empresa'] : null;
			$this->config->set_item('ConfigEmpresa', $empresa);
			$this->configwriter->write('ConfigEmpresa', $empresa);

			// Obtener versión intelisis
			// Parche para la version de INLOSA
			if (in_array($empresa, ['ARSA', 'GMC', 'MASA']))
			{
				$version = 'V4000';
			}
			else 
			{
				$version = $int->select('version')->from('Version')->get()->row_array();
				$version = isset($version['version']) ? $version : 4000;
				$version = $version['version'] < 6000 ? 'V4000' : 'V6000';
			}
			
			$this->config->set_item('ConfigVersionIntelisis', $version);
			$this->configwriter->write('ConfigVersionIntelisis', $version);
			// Obtener marca
			$marca = $int->select('Version')->from('Sucursal')->where(['Estatus' => 'ALTA', 'Sucursal' => $sucursal])->get()->row_array();
			$marca = isset($marca['Version']) ? $marca['Version'] : null;
			$this->config->set_item('ConfigMarca', $marca);
			$this->configwriter->write('ConfigMarca', $marca);
		}catch(Exception $ex){
			/*$this->config->set_item('ConfigVersionIntelisis', getenv("VERSION"));
			$this->config->set_item('ConfigMarca', getenv("MARCA"));
			$this->config->set_item('ConfigEmpresa', getenv("EMPRESA"));
			$this->configwriter->write('ConfigMarca', getenv("MARCA"));
			$this->configwriter->write('ConfigVersionIntelisis', getenv("VERSION"));
			$this->configwriter->write('ConfigEmpresa', getenv("EMPRESA"));*/
		}
	}
	public function reemplazar_unidad_red($ruta,$busqueda,$reemplazo)
	{
		if ($this->config->item('ConfigUnidadRedUso')) {
			$ruta = str_replace($busqueda,$reemplazo, $ruta);
			$ruta = str_replace(base_url(),$this->config->item('ConfigRootPath').'/', $ruta);
		}
		return $ruta;
	}
}
