<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Navegacion extends MY_Controller {

	function __construct()
    {
        parent::__construct();
        $this->load->model( 'navegacion_model' );
    }

    public function config_perfil()
    {
        $this->load->view( 'configurarUsuario' );
    }

    public function actualizar_datos()
    {
        $data = $this->input->post();
        $data = $this->navegacion_model->actualizar_datos( $data );
        echo json_encode( $data );
    }

    public function seguimiento()
    {
        $this->load->view( 'operaciones2' );
    }

    public function autocomplete_Nombre()
    {
        $nombre = $this->input->get( 'nombre' );
        $data = $this->navegacion_model->autocomplete_Nombre( $nombre );
        echo json_encode( $data );
    }

    public function autocomplete_Clave()
    {
        $clave = $this->input->get( 'clave' );
        $data = $this->navegacion_model->autocomplete_Clave( $clave );
        echo json_encode( $data );
    }

    public function obtener_seguimiento(  )
    {
        $data = $this->input->post();
        $data[ 'operaciones' ] = $this->navegacion_model->obtener_seguimiento( $data );
        echo json_encode( $data );
    }

    public function validar_unico()
    { 
        $data = $this->input->post();
        
        //obtener datos adicionales de una  orden de servicio
        $dataOrden = $this->navegacion_model->obtener_dataOrden( $data[ 'movIdCheck' ] );
        foreach ($dataOrden as $row)
        {
            $tipoOrden  = $row['ServicioTipoOrden'];
        }

        $data1[ 'unico' ][ 'unico' ] = 'si';
        $data1[ 'valPlanReal' ][ 'msj' ] = 'ok';
        // se agrega definicion de variable valPlanRealGrantia vacia para no tenga problemas con las demás operaciones
        $data1[ 'valPlanRealGrantia' ][ 'msj' ] = 'ok';
        //En caso de que la operación sea poner en curso, validar si es única. 
        if( $data[ 'operacionSeleccionada' ] == 'imgEnCurso' )
        {
            //Según sea la cantidad de movimientos es la validación de ser movimientos u operaciones únicas
            if( $data[ 'multiple' ] == 'si' )
            {
                $data1[ 'unico' ] = $this->navegacion_model->validaUnicaOperacion( $data );
                $data1[ 'multiple' ] = 'si';
            }
            else
            {
                $data1[ 'unico' ] = $this->navegacion_model->validaUnicoMovimiento( $data );
                $data1[ 'multiple' ] = 'no';
            }
        } 
        
         // En caso que la operacion seleccionada para iniciar y variable $val_garantias = True (navegacion_model), validara que la operacion este 
         // autorizada por jefe de taller
         // Aplica solo en caso de la digitalizacion de garantías para la marca Ford 
         if( $data[ 'operacionSeleccionada' ] == 'imgEnCurso' && $this->config->item('ConfigMarca') == 'Ford')
         {
             //nombre de funcion en sql fnCA_fordValidaPlanRealGarantias BD Recepcion
            if ($this->config->item('configGarantiasFord') == TRUE){
                $data1[ 'valPlanRealGrantia' ] = $this->navegacion_model->fordValidaPlanRealGrantias( $data[ 'idCheck' ],$data[ 'renglonCheck' ], $tipoOrden );
            }
             
             //fnCA_fordValidaPlaneacionRealWeb
            // en este caso no se envia el tipo de orden como parametro debido a que se puede obtner  dentro de la funcion
            $data1[ 'valPlanReal' ] = $this->navegacion_model->fordValidaPlaneacionRealWeb( $data[ 'idCheck' ],$data[ 'renglonIdCheck' ] );
        
        }
        
        //En caso que la operacion seleccionada sea completada y $grupo = 'ford' en navegacion_model, validara reglas de negocio dashborad 
        if( $data[ 'operacionSeleccionada' ] == 'imgCompletada' && $this->config->item('ConfigMarca') == 'Ford')
        {
            //fnCA_fordValidaPlaneacionRealWeb
            // en este caso no se envia el tipo de orden como parametro debido a que se puede obtner  dentro de la funcion
            $data1[ 'valPlanReal' ] = $this->navegacion_model->fordValidaPlaneacionRealWeb( $data[ 'idCheck' ],$data[ 'renglonIdCheck' ] );

             //nombre de funcion en sql fnCA_fordValidaPlanRealGarantias BD Recepcion
            if ($this->config->item('configGarantiasFord') == TRUE){
                $data1[ 'valPlanRealGrantia' ] = $this->navegacion_model->fordValidaPlanRealGrantias( $data[ 'idCheck' ],$data[ 'renglonCheck' ], $tipoOrden );
            }
        }

        //Si la respuesta es que no es único, no avanzar con el proceso y dar resúesta de que no es posible por que existe una operación mas en proceso.
        if( $data1[ 'unico' ]['unico'] == 'no' ){
             // se envia que existe otra operacion para que se active la siguiente validación en wiew operaciones2.php (data.existe == 'si')
            $data1[ 'existe' ] = 'si';
        }
        
        else if( $data1[ 'valPlanRealGrantia' ]['msj'] != 'ok' && $data[ 'operacionSeleccionada' ] == 'imgEnCurso' ){
            // se envia que no existe otra operacion para que pueda avanzar a la siguiente validación en wiew operaciones2.php (data.valPlanRealGrantia.msj != 'ok')
            $data1[ 'existe' ] = 'no';
        }
        // Si la respuesta es un msj diferente a ok se ejecutara validacion en view operaciones2.php
        elseif( $data1[ 'valPlanReal' ]['msj'] != 'ok'){
            // se envia que no existe otra operacion para que pueda avanzar a la siguiente validación en wiew operaciones2.php (data.valPlanReal.msj != 'ok')
            $data1[ 'existe' ] = 'no';
        }

        else
        {
            $data1[ 'existe' ] = 'no';
            if( $data[ 'multiple' ] == 'no' )
            {
                $data1[ 'SP' ] = $this->seguimientoOperacion( $data[ 'idCheck' ], $data[ 'estadoCheck' ], $data[ 'operacionSeleccionada' ], $data[ 'situacionCheck' ], $data[ 'renglonCheck' ], $data[ 'renglonIdCheck' ], $data[ 'comentariosCambio' ], $data[ 'agente' ], $data[ 'busquedaIni2' ], $data[ 'busquedaFin2' ], $tipoOrden );
                $data1[ 'multiple' ] = 'no';
            }
            else{
                $data1[ 'multiple' ] = 'si';
            }
                
            if( $data[ 'situacion' ] == 'Si' ){
                $data1[ 'SP2' ] = $this->navegacion_model->seguimientoSituacion( $data );
            }
            //Llamado a función que hace la ejecución
        }
        //echo "<pre>";
        //print_r($data1);
        //echo "</pre>";
        echo json_encode( $data1 );
    }

    public function seguimientoOperacion( $IdVenta = null, $Edo = null, $Nuevo = null, $Situacion = null, $Renglon = null, $RenglonId = null, $Comentarios = null, $agente = NULL, $busquedaIn = NULL, $busuqedaFin = NULL, $tipoOrden = NULL ) 
    {
        $data[ 'IdVenta' ] = $IdVenta;
        $data[ 'Edo' ] = $Edo;
        $data[ 'Nuevo' ] = $Nuevo;
        $data[ 'Situacion' ] = $Situacion;
        $data[ 'Renglon' ] = $Renglon;
        $data[ 'RenglonId' ] = $RenglonId;
        $data[ 'Comentarios' ] = $Comentarios;
        $data[ 'agente' ] = $agente;
        $data[ 'fechaBusinic' ] = $busquedaIn;
        $data[ 'fechaBusfin' ] = $busuqedaFin;
        $data[ 'garantia' ] = $tipoOrden == 'Garantia' ? 1 : 0;
        $data1 = $this->navegacion_model->seguimientoOperacion( $data );
        return $data1; 
    }

    public function seguimientoOperaciones()
    {
        $data[ 'IdVenta' ] = $this->input->get( 'idCheck' );
        $data[ 'Edo' ] = $this->input->get( 'estadoCheck' );
        $data[ 'Nuevo' ] = $this->input->get( 'operacionSeleccionada' );
        $data[ 'Situacion' ] = $this->input->get( 'situacionCheck' );
        $data[ 'Renglon' ] = $this->input->get( 'renglonCheck' );
        $data[ 'RenglonId' ] = $this->input->get( 'renglonIdCheck' );
        $data[ 'Comentarios' ] = $this->input->get( 'comentarios' );
        $data[ 'agente' ] = $this->input->get( 'agente' );
        $data[ 'fechaBusinic' ] = $this->input->get( 'busquedaIn' );
        $data[ 'fechaBusfin' ] = $this->input->get( 'busquedaFin' );
        $data1 = $this->navegacion_model->seguimientoOperacion( $data );
        
        echo json_encode( $data1 ); 
    }
    
}    