<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Multipuntos extends MY_Controller {
	private $dir_fotos = '../Recepcion/assets/uploads/';

	function __construct()
    {
        parent::__construct();
        $this->dir_fotos = $this->config->item('url_formats');
        $this->load->model( 'multipuntos_model' );
        //datos de configuracion por default para envio de correos
		$this->mail_host = "";
		$this->mail_smtpAuth = true;
		$this->mail_username = "";
		$this->mail_password = "";
		$this->mail_smtpSecure = "";
		$this->mail_port = 465;
        $this->obtener_configEmail();
        //$this->load->model( 'navegacion_model' );
    }

	public function index()
	{
		$error['error'] = "ok";
		//$error[ 'menu' ] = 'no';
	
		$this->load->view('login', $error);
	}

	// Muestra las ordenes cuando se ingresa a la pagina, la busqueda la hace sin fechas por lo que muestra las del dia en curso
	public function carga()
	{
		switch($this->config->item('ConfigMarca')){
			case 'BYD':
				$data = $this->multipuntos_model->get_listado_multipuntos_byd();
				$data['formName'] = 'formatos/hoja_multipuntos_byd';
				$this->load->view('multipuntos_dinamico', $data);
				break;
			default:
				$data = $this->multipuntos_model->datos_ordenes();
				$this->load->view("multipuntos", $data);
			break;
		}
	}
	// Obtiene las ordenes cuando se usa el boton de busqueda tomando el rango de fechas
	public function recargar($fecha_inic = 0, $fecha_fin = 0)
	{
		switch($this->config->item('ConfigMarca')){
			case 'BYD':
				$data = $this->multipuntos_model->get_listado_multipuntos_byd($fecha_inic, $fecha_fin);
				break;
			default:
				$data = $this->multipuntos_model->datos_ordenes($fecha_inic, $fecha_fin);
				break;
		}
		echo json_encode($data);
	}

	// Obtiene el formato multipuntos correspondiente, si hay informacion se carga automaticamente
	public function formato($orden = null)
	{
		if($orden == null){
			$error['heading'] = 'Error 404';
			$error['message'] = 'Numero de orden no proporcionado.';
			return $this->load->view('../errors/error_404', $error);
		}

		switch($this->config->item('ConfigMarca')){
			case 'BYD':
				$datos = $this->multipuntos_model->contenido_din($orden);
				$datos['tecnicos'] = $this->get_tecnicos_disponibles($orden); 
				$this->load->view('formatos/hoja_multipuntos_byd', $datos);
				break;
			default:
				return 'No se encontro el formato de la marca';
			break;
		}
	}
	public function guardar() {
		$response_data = json_decode(file_get_contents('php://input'), true);
		$evaluation = $response_data['evaluation'];
		$data = $response_data['data'];
	
		// Datos adicionales para CA_MultipointResponses
		$info = [
			'order_id' => $data['order_id'],
			'comments' => $data['comentarios'],
			'technical_id'	=> $data['tecnico'],
			'next_maintenance' => $data['proximo_mantenimiento'],
		];
		
		if (!empty($data['firma_tecnico'])) {
			$info['technical_signature'] = $data['firma_tecnico'];
		}
	
		// Check if record exists
		$existing_record = $this->multipuntos_model->check_existing_record($data['order_id']);
		if ($existing_record) {
			$info['updated_at'] = gmdate('Y-m-d\TH:i:s');
			$result = $this->multipuntos_model->update_respuestas($info, $evaluation);
		} else {
			$result = $this->multipuntos_model->guardar_respuestas($info, $evaluation);
		}
		if ($result) {
			echo json_encode(['status' => 'success']);
		} else {
			echo json_encode(['status' => 'error']);
		}
	}

	public function get_tecnicos_disponibles($id_orden = 0)
	{
		$tec = $this->multipuntos_model->get_tecnicos_disponibles($id_orden);
		return $tec['tecnicos'];
	}

	public function guardar_multipuntos($id_orden=null, $datos=null)
	{
		$data = $this->input->post();

		$ret = $this->multipuntos_model->guardar_multipuntos($data);
		if ($this->config->item('configGarantiasFord') == TRUE){
			$ret = $this->multipuntos_model->acorde_manual($id_orden, $data);
		}
		if($data["comentario_tec"] != "" && $data["comentario_tec"] != null){
			$correo = $this->multipuntos_model->email_refacciones();
			if($correo["estatus"] == true){
				$info["correo"] = $correo["correo"];
				$info["comentario"] = $data["comentario_tec"];
				$info["folio"] = $data["folio"];
				$info["cliente"] = $data["cliente"];
				$info["ord"] = $data["ord"];
				$data['email_refacciones'] = $this->notificar_refacciones($info, $id_orden);
			}
			else{
				$data["mail"] = "no hay un correo configurado para notificar a refacciones";
			}
		}
		if($data['bandera_llenado'])
			$data['email_asesor'] = $this->notificar_asesor($data['id_orden'],$data['folio'],$data['ord']);
		echo json_encode($data);
	}

	public function notificar_asesor($id_orden,$folio,$ord )
	{
		ini_set('memory_limit', '1024M');
		
		$asesor = $this->multipuntos_model->obtener_datosAsesor($id_orden);
		// $asesor["email"] = "lorozco@intelisis.com";
		$this->load->library("PhpMailerLib");
		$mail = $this->phpmailerlib->load();
		$filepath = base_url()."index.php/multipuntos/ver_hojaMultipuntos/".$ord;
		try {
			    $mail->isSMTP();// Set mailer to use SMTP
			    $mail->Host = $this->mail_host;// Specify main and backup SMTP servers
			    $mail->SMTPAuth = $this->mail_smtpAuth;// Enable SMTP authentication
			    $mail->Username = $this->mail_username; // SMTP username
			    $mail->Password = $this->mail_password;  // SMTP password
			    $mail->SMTPSecure = $this->mail_smtpSecure;   // Enable TLS encryption, `ssl` also accepted
			    $mail->Port = $this->mail_port;// TCP port to connect to
			    
			    //Recipients
			    if ($this->config->item('ConfigMarca') == 'Ford'){
			    	$mail->SetFrom($this->mail_username, 'Service Solutions');

			    }else{
			    	$mail->SetFrom($this->mail_username, 'Service Excellence'); 	//Quien envía el correo
				}
			    $mail->addAddress($asesor["email"]);// Name is optional
			    //$mail->addAddress("fsanjuan@intelisis.com");// Name is optional

			    //Content
			    																			// Set email format to HTML
			    $mail->CharSet = 'UTF-8';
			    $mail->Subject = 'Estatus Revisión Multipuntos';
				$mail->Body      = "<html><body><p>Buen día, ".$asesor["nombre"]." ".$asesor["apellidos"].".<br>
				La revisión multipuntos con <b>folio número: ".$folio."</b> fue marcada como \"Verificada\" en su totalidad.
				<br><a href='".$filepath."'>Orden ".$ord."</a>
			    <p></body></html>";
				$mail->isHTML(true);
				$enviar = $mail->send();
				
			    $data = array('success' => 1, 'data' => ('Notificación enviada.'));

			    if($enviar)
			    {
			    	$envio = ['estatus' => true, 'mensaje' => 'Correo enviado.'];
			    }else 
			    {
			    	$envio = ['estatus' => false, 'mensaje' => 'No fue posible enviar el correo, favor de notificar al administrador de correos.'];
			    }
			} catch (Exception $e) {
				$envio = ['estatus' => false, 'mensaje' => $mail->ErrorInfo];
			}

		return $envio;	
	}

	public function notificar_refacciones($info, $id_orden)
	{
		if ($this->config->item('configGarantiasFord') == TRUE){
			$existe = $this->db->select("NoAplica AS no_aplica")->from("CA_Venta")->where("IdVenta", $id_orden)->get()->row_array();
		}
		$cliente = $info["cliente"];
		$folio = $info["folio"];
		$comentario_email = $info["comentario"];
		$correo = $info["correo"];
        // enviar correo       
       	$this->load->library("PhpMailerLib");
		$mail = $this->phpmailerlib->load();
			try {
			    //Server settings
			    // $mail->SMTPDebug = 2;// Enable verbose debug output
			    //$mail->ErrorInfo;
			    $mail->isSMTP();// Set mailer to use SMTP
			    $mail->Host = $this->mail_host;// Specify main and backup SMTP servers
			    $mail->SMTPAuth = $this->mail_smtpAuth;// Enable SMTP authentication
			    $mail->Username = $this->mail_username; // SMTP username
			    $mail->Password = $this->mail_password;  // SMTP password
			    $mail->SMTPSecure = $this->mail_smtpSecure;   // Enable TLS encryption, `ssl` also accepted
			    $mail->Port = $this->mail_port;// TCP port to connect to
			    
			    //Recipients
			    if ($this->config->item('ConfigMarca') == 'Ford'){
			    	$mail->SetFrom($this->mail_username, 'Service Solutions');
			    }else {
			    	$mail->SetFrom($this->mail_username, 'Service Excellence');  	//Quien envía el correo
			    }
			    // $mail->addAddress("eheredia@intelisis.com");// Name is optional
			    //$mail->addAddress($correo);// Name is optional
			    // $mail->AddReplyTo($correo_asesor,'Service Excellence');  //A quien debe ir dirigida la respuesta  "fsanjuan@intelisis.com;fsanjuan@intelisis.com
			    //$mail->addCC("fsanjuan@intelisis.com");
			   					  			  			//Con copia a
			    //$mail->addBCC('tpena@intelisis.com');	
			    // correos con copia de refacciones y por sucursal 
				$emails = explode(';', $correo);
				for($i = 0; $i < count($emails); $i++) {
					$mail->addAddress($emails[$i]);
					//echo $emails[$i]."<br>";
				}					  			//Con copia oculta a
				$filepath = base_url()."index.php/multipuntos/ver_hojaMultipuntos/".$info["ord"];
			    //Content
			                                     // Set email format to HTML
			    $mail->CharSet = 'UTF-8';
			    // cambio de subject solicitado por planta el 30/mayo/2022
			    if ($this->config->item('configGarantiasFord') == TRUE){
					$mail->Subject = ($existe['no_aplica'] > 0) ? 'Solicitud de generación de presupuesto' : 'Solicitud de generación de presupuesto para Garantías';
				}else{
					$mail->Subject = 'Solicitud de generación de presupuesto';
				}
				$mail->Body      = "<html><body><p>Buen día, este mensaje es para informarle que se han detectado uno o varios detalles en el vehículo una vez realizada la inspección de la orden con folio: ".$folio.".<br> Dichos detalles se mencionan enseguida:<br> ".$comentario_email."<br> Favor de ingresar al sistema para verificar y realizar presupuesto necesario a la brevedad.
				<br><a href='".$filepath."'>Orden ".$info["ord"]."</a>
				<br>Saludos.</p></html></body>";
			    $mail->isHTML(true); 
				$enviar = $mail->send();
				
			    $data = array('success' => 1, 'data' => ('presupuesto enviada.'));
			    //$this->eliminar_archivoTemp($formato["ruta"]);

			    if($enviar)
			    {
			    	$envio = ['estatus' => true, 'mensaje' => 'Correo enviado.'];
			    }else 
			    {
			    	$envio = ['estatus' => false, 'mensaje' => 'No fue posible enviar el correo, favor de notificar al administrador de correos.'];
			    }
			} catch (Exception $e) {
				$envio = ['estatus' => false, 'mensaje' => $mail->ErrorInfo];
			}
       
        return $envio;	
	}
	public function tecnicos_disponibles($id_orden = 0)
	{
		$ret = $this->multipuntos_model->tecnicos_disponibles($id_orden);
		echo json_encode($ret);
	}
	
	public function obtener_idTblOrden_Servicio()
	{
		$id_tblVenta = $this->input->post("id_tblVenta");
		$id_orden = $this->multipuntos_model->obtener_idTblOrden_Servicio($id_tblVenta);
		
		echo json_encode($id_orden);
	}

	public function ver_hojaMultipuntos($id_orden = null)
	{
		$datos = $this->multipuntos_model->ver_datosHojaMult($id_orden);
		$this->load->view("formatos/hoja_multipuntos", $datos);
	}
	public function traer_orden_servicio(){
		$id = $this->input->post('id');
		$data = $this->multipuntos_model->traer_orden_servicio($id);
		$data["info"] = $this->multipuntos_model->ver_datosHojaMult($data["id"]);
		$data["images"] = $this->multipuntos_model->get_pictures_multipuntos($data["id"],"id,ruta_archivo,fecha_actualizacion");
		echo json_encode($data);
	}
	public function guardar_pdf_(){
		ini_set('memory_limit', '1024M');
		$multipunto  = $this->input->post('multi');
		$id_orden    = $this->input->post('id_orden');
		$id_vennta   = $this->input->post('id_venta');
		$multipunto  = $this->crear_pdf_multipunto($multipunto, $id_orden,$id_vennta);
		$saveIntelisis = $this->multipuntos_model->SaveDocsIntelisis($multipunto["ruta"], $id_orden,$id_vennta );

		// var_dump($saveIntelisis);die;

		if($multipunto["estatus"])
        {
			$envio = true;
		}else{
			$envio = false;
		}
		
		echo json_encode($envio);	
	}

	public function crear_pdf_multipunto($multipunto = null, $id_orden = null,$id_vennta=null){
		//$intelisis = $this->load->database("other",true);
		$orde = $this->db->select('ServicioSerie')->from('Venta')->where(['ID' => $id_vennta])->get()->row_array();
		$ruta_tmp = $this->dir_fotos.$orde["ServicioSerie"].'/'.$id_orden;
		if ($this->config->item('ConfigUnidadRedUso')) {
			// $ruta = $this->reemplazar_unidad_red($ruta,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
			$ruta_tmp = $this->reemplazar_unidad_red($ruta_tmp,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
		}
		if(!file_exists($ruta_tmp)) 
        {
            mkdir($ruta_tmp, 0777, true);
        }
		include_once('./application/libraries/MPDF60/mpdf.php');
		$nombre = "HojaMultipuntos".$id_orden.".pdf";
		$imagenb64 = "".$multipunto."";
		//$img_reverso = "".$img_reverso."";
		/*Frente*/
		$mpdf = new mPDF('c','legal');
		$mpdf->simpleTables = true;
		$mpdf->packTableData = true;
		$mpdf->SetDefaultBodyCSS('background-image', "url('".$imagenb64."')");
		$mpdf->SetDefaultBodyCSS('background-image-resize', 6);
		$html = "";
		$mpdf->WriteHTML($html);
		
		$mpdf->Output($ruta_tmp.$nombre, "F"); 	//www\WebProyectos\seguimientoTecnicos\assets\archivos_recepcion

		if(file_exists($ruta_tmp.$nombre))
		{
			$creado["estatus"] = true;
			$creado["ruta"] = $ruta_tmp.$nombre;
		}else
		{
			$creado["estatus"] = true;
			$creado["ruta"] = $ruta_tmp.$nombre;
		}
		return $creado;

	}

	public function guardar_fotosTecnico()
	{
		$datos = $this->input->post();
		$vin = $datos["vin"];
		$id_orden_int = $datos["id_orden_int"];
		$id_orden = $this->multipuntos_model->traer_orden_servicio($id_orden_int);
		$id_orden = json_decode(json_encode($id_orden), true);
		$ruta = '../Recepcion/assets/uploads/'.$vin.'/'.$id_orden["id"];
		$total = count($_FILES);
		$c = 0;
		if ($this->config->item('ConfigUnidadRedUso')) {
			$ruta = $this->reemplazar_unidad_red($ruta,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
			// $ruta_tmp = $this->reemplazar_unidad_red($ruta_tmp,$this->config->item('url_formats'),$this->config->item('ConfigUnidadRedCarpeta'));
		}
		if(!file_exists($ruta)) 
        {
            mkdir($ruta, 0777, true);
        }

        $bd_recep = $this->load->database("recepcion", TRUE);

        foreach($_FILES as $key => $value) 
        {
        	$ext = explode(".", $value["name"]);
        	$archivo = $ruta.'/'.$key.'.'.$ext[1];

        	move_uploaded_file($value["tmp_name"], $archivo);

        	if(file_exists($archivo))
        	{
        		$c++;

        		$arc["id_orden_servicio"] = $id_orden["id"];
	        	$arc["tipo_archivo"] = 2;
	        	$arc["ruta_archivo"] = $archivo;
	        	$arc["fecha_creacion"] = date("d-m-Y H:i:s");
	        	$arc["fecha_actualizacion"] = date("d-m-Y H:i:s");  
	        	$arc["eliminado"] = 0;

	        	$bd_recep->insert("archivo", $arc);
        	}
        }

        $bd_recep->close();

		if($c == $total)
		{
			$guardar = true;
		}else 
		{
			$guardar = false;
		}

		echo json_encode($guardar);
	}
	public function guardar_archivo_multipuntos(){
		$datos = $this->input->post();
		$orden_servicio=$this->multipuntos_model->custom_data_orden($datos["id_orden_servicio"],"id,cliente,vin");
		$datos["id_orden_servicio"]=$orden_servicio["id"];
		$datos["cve_cliente"]=$orden_servicio["cliente"];
		$datos["vin"]=$orden_servicio["vin"];
		$archivo = $this->multipuntos_model->guardar_foto_multipuntos($datos);
		echo json_encode($archivo);
	}
	public function remover_archivo_multipuntos(){
		$datos = $this->input->post();
		$archivo = $this->multipuntos_model->remover_foto_multipuntos($datos);
		echo json_encode($archivo);
	}
	public function obtener_configEmail()
	{
		$response = $this->multipuntos_model->obtener_configEmail();
		$this->mail_host       = $response['conf']['mail_host'];
		$this->mail_smtpAuth   = $response['conf']['mail_smtpAuth'];
		$this->mail_username   = $response['conf']['mail_userName'];
		$this->mail_password   = $response['conf']['mail_password'];
		$this->mail_smtpSecure = $response['conf']['mail_smtpSecure'];
		$this->mail_port       = $response['conf']['mail_port'];
		// echo json_encode($response);
	}
}