IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID('dbo.xpGenerarServicioRecepcion') AND Type = 'p')
	DROP PROCEDURE dbo.xpGenerarServicioRecepcion
GO

SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER OFF
GO
/*
-- =============================================
-- Author:  Francisco San Juan
-- Create date: 27-Oct-2023
-- Description: Store que se utlizará en la recepcion activa web para generar una orden de servicio afectada 
-- Salida de @OK= 1.- Ocurrio un error 0.- Ejecucion correcta
-- =============================================
*/
CREATE PROCEDURE [dbo].[xpGenerarServicioRecepcion]
	@IdVenta INT
AS
BEGIN
	SET NOCOUNT ON    
	DECLARE
	@OK             INT,
	@OkRef          VARCHAR(1000),
	@MovId   VARCHAR(20)

	--* Inicio de las validaciones principales
	DECLARE
	@Mov		VARCHAR(20),
	@Sucursal	INT, 
	@Concepto	VARCHAR(50),
	@UenValida	INT,
	@Uen		INT,
	@Agente		VARCHAR(50),
	@Usuario	VARCHAR(50)

	SELECT @MovId = '', @OkRef = '', @Ok = 0

	SELECT 
		@Mov		=	mov, 
		@Sucursal	=	sucursal, 
		@Concepto	=	concepto,
		@Uen		=	UEN,
		@Agente		= 	Agente,
		@Usuario	=	Usuario
	FROM 
		Venta 
	WHERE 
		id = @IdVenta

	IF NOT EXISTS(SELECT Agente FROM Agente WHERE Agente = @Agente)
		SELECT @Ok = 1, @OkRef = @OkRef + ' El agente no existe en Intelisis . <br>'

	IF NOT EXISTS(SELECT Usuario FROM Usuario WHERE Usuario = @Usuario)
		SELECT @Ok = 1, @OkRef = @OkRef + ' El usuario no existe en Intelisis. <br>'

	IF NOT EXISTS(SELECT * FROM SUCURSAL WHERE Id = @Sucursal)
		SELECT @Ok = 1, @OkRef = @OkRef + ' Sucursal de la venta  no valida. <br>'
	
	IF ISNULL(@Uen, 0) = 0
		SELECT @Ok = 1, @OkRef = @OkRef + ' UEN no asignada a la venta. <br>'

	IF ISNULL(@Mov, '') <> 'Servicio'
		SELECT @Ok = 1, @OkRef = @OkRef + ' Solo se afectan movimientos de servicio. <br>'


	SELECT @UenValida = dbo.fnCA_GeneraUENValida( 'VTAS', @Mov, @Sucursal, @Concepto)

	IF @UEN <> @UenValida
		SELECT @Ok = 1, @OkRef = @OkRef + ' UEN Invalida. <br>'

	IF @Ok = 1
		GOTO Salida

	BEGIN TRANSACTION  

		BEGIN TRY
		DECLARE 
		@OutputTable   TABLE (OutputLine NVARCHAR(MAX))

		INSERT INTO @OutputTable
		EXEC spAfectar 'VTAS', @IdVenta, 'AFECTAR', 'Todo', NULL, 'SOPDESA', @Estacion=1000, @EnSilencio=1, @Ok=@OK OUTPUT, @OkRef=@OkRef OUTPUT
		END TRY
		BEGIN CATCH
			SELECT @OK = 1065, @OkRef = ERROR_MESSAGE() + ' ' + CONVERT(VARCHAR(100), ERROR_LINE())
		END CATCH

		IF @OkRef IS NULL AND @Ok IS NULL
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION

	IF EXISTS(SELECT MovId FROM Venta WHERE ID = @IdVenta) AND @OkRef IS NULL
	BEGIN
		SELECT TOP 1 
			@MovId = MovId
		FROM 
			venta 
		WHERE 
			ID = @IdVenta 
		ORDER BY 
			FechaEmision DESC

		SELECT TOP 1 @OkRef = ISNULL(OutputLine, '') FROM @OutputTable
	END
	ELSE
	BEGIN
		IF ISNUMERIC(@Ok) = 1 AND @OkRef IS NULL
			SELECT @OkRef = Descripcion  FROM MENSAJELISTA WHERE MENSAJE = @OK
		ELSE
			SELECT @MovId = '', @Ok = 1,  @OkRef = ISNULL(@OkRef,'SQLInfo: xpGenerarServicioRecepcion')
	END

Salida: 

		SELECT @OK AS Ok, @OkRef AS OkRef, @MovId AS MovId

END
