$(document).ready(function() {

	
	/*$('.datepicker').pickadate({
	  	monthsFull: [ 'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre' ],
	    monthsShort: [ 'ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic' ],
	    weekdaysFull: [ 'domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado' ],
	    weekdaysShort: [ 'dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb' ],
	    weekday: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
	    today: '',
	    clear: 'Borrar',
	    close: 'Cerrar',
	    format: 'dd-mm-yyyy',
	    formatSubmit: 'dd-mm-yyyy',
	    labelMonthNext: 'Mes Siguiente',
		labelMonthPrev: 'Mes Anterior',
		labelMonthSelect: 'Seleccione un Mes',
		labelYearSelect: 'Seleccione un Año',
		selectYears: true,
  		selectMonths: true,
  		firstDay: 2,
  		closeOnSelect: true,
  		selectYears: 4,
  		max: true
	});*/

	$(".datepicker").flatpickr({
		"altInput": true,
    	"altFormat": "j F, Y",
    	"dateFormat": "Y-m-d",
		"locale": "es",
		onReady: function(dateObj, dateStr, instance) {
	        $('.flatpickr-calendar').each(function() {
	            var $this = $(this);
	            if ($this.find('.flatpickr-clear').length < 1) {
	                $this.append('<div class="flatpickr-clear">Borrar</div>');
	                $this.find('.flatpickr-clear').on('click', function() {
	                    instance.clear();
	                    instance.close();
	                });
	            }
	        });
	    }
	});

	var tabla_historico = $(".tabla_hist").dataTable(
    {
         "oLanguage": {
            "sProcessing":     "Procesando...",
            "sLengthMenu":     "Mostrar _MENU_ registros",
            "sZeroRecords":    "No se encontraron resultados",
            "sEmptyTable":     "Ning&uacute;n dato disponible en esta tabla",
            "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
            "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix":    "",
            "sSearch":         "Buscar:",
            "sUrl":            "",
            "sInfoThousands":  ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst":    "<i class='fa fa-step-backward'></i>",
                "sLast":     "<i class='fa fa-step-forward'></i>",
                "sNext":     "<i class='fa fa-forward'></i>",
                "sPrevious": "<i class='fa fa-backward'></i>"
                        },
            "oAria": {
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                    }
            },
        "bSort": true,
        "bDestroy": true,
        "sPaginationType": "full_numbers",
        "pageLength": 5,
        "aoColumnDefs": [
            { 
            "bVisible": false, 
            "aTargets": [0]
            }
        ]
    });

	$("select.picker__select--month, select.picker__select--year").addClass("form-control");

	$.each($(".picker__weekday"), function(index, val) 
	{
		switch ($(this).prop("title")) 
		{
			case "lunes":
				$(this).text("L");
			break;
			case "martes":
				$(this).text("M");
			break;
			case "miércoles":
				$(this).text("M");
			break;
			case "jueves":
				$(this).text("J");
			break;
			case "viernes":
				$(this).text("V");
			break;
			case "sábado":
				$(this).text("S");
			break;
			case "domingo":
				$(this).text("D");
			break;
			default:
				//
			break;
		}
	});

	$("#btn_mostrar").on("click", function(e){
		var fecha_ini = $("#fecha_ini").val();
		var fecha_fin = $("#fecha_fin").val();
		var sucursal = $("#sucursal").val();
		var tipo = $("#tipo").val();
		var afectadas = $("#afectadas").val();

		if(fecha_ini == "" || fecha_fin == "")
		{
			toastr.error("Por favor, seleccione una fecha inicio y una fecha fin.");
			return;
		}

		$("#loading_spin").show();

		$.ajax({
			cache: false,
			url: base_url+ "index.php/servicio/obtener_ordenesReportes",
			type: 'POST',
			dataType: 'json',
			data: {fecha_ini: fecha_ini, fecha_fin: fecha_fin, sucursal:sucursal,tipo:tipo, afectadas:afectadas}
		})
		.done(function(data) {
			
			console.log('Datos tabla reportes');
			console.log(data);

			var tabla = "", nombre = "", folio = "";
			var btn1 = "", btn2 = "";
			var btn_comentario = "";
			//variables que contienen valor del correoE del cliente, si la orden esta firmada o no
			// trae_signGrtia valor de la firma para el formato de rechazo extension de garantia 
			

			tabla_historico.fnClearTable();

			$("#loading_spin").hide();

			if(data.length == 0)
			{
				toastr.error("No se encontraron órdenes.");
				return;
			}

			$.each(data, function(index, val) 
			{
				folio   = (val.MovID == null ) ? "-" : val.MovID;
					tabla_historico.fnAddData([
						val.IdRecepcion,
						val.SucursalNombre,	
						val.FechaEmision,	
						folio,
						val.Vin,
						val.Cliente,
						val.TipoOrden,
						val.Asesor,
						val.Estatus,
						val.Fotos > 0 ? 'Tiene '+val.Fotos+`${val.Fotos>1? ' fotos.' : ' foto.'}` : 'Sin fotos'
					]);
			});		
		})
		.fail(function() {
			toastr.error("Hubo un error al mostrar los datos");
		});	
	});

	$("#btn_pdf").on("click", function(e){
		var fecha_ini = $("#fecha_ini").val();
		var fecha_fin = $("#fecha_fin").val();
		var sucursal = $("#sucursal").val();
		var tipo = $("#tipo").val();
		var afectadas = $("#afectadas").val();

		if(fecha_ini == "" || fecha_fin == "")
		{
			toastr.error("Por favor, seleccione una fecha inicio y una fecha fin.");
			return;
		}

		$("#loading_spin").show();

		$.ajax({
			cache: false,
			url: base_url+ "index.php/servicio/generar_pdfReportes",
			type: 'POST',
			dataType: 'json',
			data: {fecha_ini: fecha_ini, fecha_fin: fecha_fin, sucursal:sucursal,tipo:tipo, afectadas:afectadas}
		})
		.done(function(data) {
			a = $('<a>');
			a.attr('href', data.archivo);
			a.attr('target', '_blank');
			a.attr('download', 'ReporteOrdenesRecepcion.pdf');
			a[ 0 ].click();
			var referencia_objeto_window = window.open(
			  data.archivo,
			  'Vista Preliminar Reporte Ordenes Recepción',
			);
			// document.body.appendChild(a);
		})
		.fail(function() {
			toastr.error("Hubo un error al mostrar los datos");
		}).always(function(){
			$("#loading_spin").hide();
		});	
	});

});