//Carga de tabla usuarios
$(document).ready(function () {
   getEmpresas()
   getUsuarios()
})
//Abre modal editar usuario
$(document).on("click", '.btn_editUsr', function (e) {
   $("#pass").val("");
   $("#fordstarDiv").hide()
   perfil = $(this).data("perfil")
   $("#usuario ").val($(this).data("usuario"));
   $("#nombre").val($(this).data("nombre"));
   $("#apellidos").val($(this).data("apellidos"));
   $("#email").val($(this).data("email"));
   $("#cve").val($(this).data("intelisis"));
   setEmpresa($(this).data("sucursal"))
   if ((ConfigMarca == 'Ford') && (perfil == 3 || perfil == 5)) {
      $("#fordstarDiv").show();
      $("#fordStar").val($(this).data("fordstar"))
   }
   $("#rol").val(perfil);
   $("#eliminado").val($(this).data("eliminado"));
   $("div.div_firma_usu input").val($(this).data("firma"));
   $("div.id input").val($(this).data("id"));
   $('#modalEditarUsuario').modal('show');

});
$(document).on('keyup', '#fordStar, #fordStar_nvo', function (e) {
   regex = /[0-9]+$/
   texto = $(this).val()
   if (texto.length > 9) {
      $(this).val(texto.substring(0, 9))
   }
   if (!texto.match(regex)) {
      $($(this)).val(texto.substring(0, texto.length - 1))
   }
})
//Abre modal nuevo usuario
$(document).on("click", '#btn_nuevoUsuario', function (e) {
   $('#modalNuevoUsuario').modal('show');
});
$(document).on('change', '#rol_nvo', function (e) {
   perfil = $(this).val()
   if ((ConfigMarca == 'Ford') && (perfil == 3 || perfil == 5)) {
      $("#fordstarDiv_nvo").show()
   } else {
      $("#fordstarDiv_nvo").hide()
   }
})
//Envia datos en actualizacion de perfil
$(document).on("click", '#btn_editarUsuario', function (e) {
   e.preventDefault();
   form = $("#form_edit_usr input,#form_edit_usr select");
   $("#btn_editarUsuario").prop("disabled", true);
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/editar_perfil/",
      type: 'POST',
      dataType: 'json',
      data: form,
      beforeSend: function(){
			$("#loading_spin").show();
		},
   }).done(function (data) {
	      if (data["success"] == 1) {
	         toastr.success("Se han actualizado los datos");
	         $('#modalEditarUsuario').modal('toggle');
	         getUsuarios()
	      } else {
	         error = Object.values(data["errors"])
	         toastr.info(error[0]);
	      }
	   })
      .fail(function (e) {
         alert("Hubo un error al actualizar los datos");
      }).always(function(resp) {
			$("#loading_spin").hide();
         $("#btn_editarUsuario").prop("disabled", false);
		});
});
//Envia datos en creacion de perfil
$(document).on("click", '#btn_crearUsuario', function (e) {
   $("#btn_crearUsuario").prop("disabled", true);
   var estado = true;
   form = {}
   $("#form_create_usr input,#form_create_usr select").each(function () {
      if ($(this).val() != "" || (($("#rol_nvo").val() != 3 | $("#rol_nvo").val() != 5) && $('#fordStar_nvo').val() == "")) {
         form[$(this).attr("id")] = $(this).val();
      } else {
         toastr.info("Se deben llenar todos los campos para continuar")
         estado = false;
         $("#btn_crearUsuario").prop("disabled", false);
         return false;
      }
   })
   console.log(form)
   if (estado == true) {
      $.ajax({
         cache: false,
         url: base_url + "index.php/user/crear_perfil/",
         type: 'POST',
         dataType: 'json',
         data: form,
         beforeSend: function(){
				$("#loading_spin").show();
			},
      })
         .done(function (data) {
            if (data["success"] == 1) {
               //Actualiza la tabla al registrar un usuario
               getUsuarios()
               //Vaciar los campos del formulario
               $("#form_create_usr input,#form_create_usr select").each(function () { $(this).val("") })
               $('#modalNuevoUsuario').modal('toggle');
               toastr.success("Se registro el nuevo usuario");
            } else {
               //Muestra el mensaje de error que brinda la validación de CI
               error = data['errors'] ? Object.values(data["errors"]) : data.data;
               toastr.error(error);
               $("#loading_spin").hide();
            }
         })
         .fail(function (e) {
            alert("Hubo un error al registrar el usuario: ");
         }).always(function(resp) {
				$("#loading_spin").hide();
            $("#btn_crearUsuario").prop("disabled", false);
			});
   }

});
$(document).on("change", '#empresa_nuevo', function (e) {
   $("div.sucursales_nuevo select").empty()
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/obtener_sucursales",
      data: { empresa: $(this).val() },
      type: 'POST',
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         var sucursales = "<option value=''>Seleccionar</option>"
         $.each(data, function (index, val) {
            sucursales += "<option value='" + val["id"] + "'>" + val["nombre"] + "</option>"
         });
         $("div.sucursales_nuevo select").append(sucursales);
      })
      .fail(function () {
         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
});
$(document).on("change", '#empresa', function (e) {
   setSucursal($(this).val())
});
$(document).on("click", '#btn_resPassword', function (e) {
   id = $("#id").val()
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/reset_password",
      type: 'POST',
      data: { id: id },
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         if(data == true){
            sendNotification()
         }else{
            toastr.error("Ocurrió un error")
         }
         
      })
      .fail(function (e) {
         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
})
function sendNotification() {
   usuario = $("#usuario").val()
   correo = $("#email").val()
   $.ajax({
      cache: false,
      url: base_url + "index.php/Servicio/notificarCambioPass",
      type: 'POST',
      data: { usuario: usuario ,
              correo: correo},
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         if(data == true){
            toastr.success("Se restableció la contraseña correctamente")
         }
      })
      .fail(function (e) {

         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
}
$(document).on("keyup", '#apellidos, #usuario_nvo,#nombre_nvo, #apellido_nvo', function (e) {
   regex = /[a-zA-Z\sñ]+$/
   texto = $(this).val()
   if(texto.length > 45){
      $(this).val(texto.substring(0, 45))
   }
   if (!texto.match(regex)) {
      $(this).val(texto.substring(0, texto.length - 1))
   }

})
$(document).on("keyup", '#usuario, #nombre', function (e) {
   regex = /[a-zA-Z\sñ]+$/
   texto = $(this).val()
   if(texto.length > 30){
      $(this).val(texto.substring(0, 30))
   }
   if (!texto.match(regex)) {
      $(this).val(texto.substring(0, texto.length - 1))
   }

})
$(document).on("keyup", '#cve_nvo, #cve', function (e) {
   regex = /[\w]+$/
   texto = $(this).val()
   if (!texto.match(regex)) {
      $(this).val(texto.replace(/[^\w]+/, ""))
      
   }

})
function validar_password(password) {
   var valido = true;
   if (password.length < 6 || password.length > 50) {
      toastr.info("La contraseña debe tener, mínimo, 6 caracteres");
      valido = false;
   }
   return valido;
}
function getUsuarios() {
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/obtener_usuarios",
      type: 'POST',
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         var tabla_usuarios = $("#tabla_usuarios").dataTable(
            {
               "oLanguage": {
                  "sProcessing": "Procesando...",
                  "sLengthMenu": "Mostrar _MENU_ registros",
                  "sZeroRecords": "No se encontraron resultados",
                  "sEmptyTable": "Ning&uacute;n dato disponible en esta tabla",
                  "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                  "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                  "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sSearch": "Buscar:",
                  "sUrl": "",
                  "sInfoThousands": ",",
                  "sLoadingRecords": "Cargando...",
                  "oPaginate": {
                     "sFirst": "<i class='fa fa-step-backward'></i>",
                     "sLast": "<i class='fa fa-step-forward'></i>",
                     "sNext": "<i class='fa fa-forward'></i>",
                     "sPrevious": "<i class='fa fa-backward'></i>"
                  },
                  "oAria": {
                     "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                     "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                  }
               },
               "bSort": true,
               "bDestroy": true,
               "sPaginationType": "full_numbers",
               "pageLength": 10,
               "aoColumnDefs": [
                  {
                     "bVisible": true,
                     "aTargets": [0]
                  }
               ]
            });
         tabla_usuarios.fnClearTable();

         $.each(data, function (index, val) {
            if (val["perfil"] != 1) {
               var pefil;
               switch (val["perfil"]) {
                  case 2:
                     pefil = "Recepcionista"
                     break
                  case 3:
                     pefil = "Asesor"
                     break
                  case 4:
                     pefil = "Jefe de Taller"
                     break
                  case 5:
                     pefil = "Técnico"
                     break
                  case 6:
                     pefil = "Refacciones"
                     break
                  case 7:
                     pefil = "Administrador de Garantías"
                     break
                  case 8:
                     pefil = "Jefe de Servicio"
                     break
                  case 9:
                     pefil = "Soporte"
                     break
                  default:
                  	pefil = "N/A"

               }
               tabla_usuarios.fnAddData([
                  val["id"],
                  val["usuario"],
                  val["nombre"],
                  val["apellidos"],
                  val["email"],
                  pefil,
                  val["sucursal"],
                  "<div><div style='text-align: center;'><button class='btn btn-success btn_editUsr' data-eliminado='" + val["eliminado"] + "', data-fordstar='" + val['fordStar'] + "', data-firma='" + val["firma_electronica"] + "' data-id='" + val["id"] + "' data-usuario='" + val["usuario"] + "' data-nombre='" + val["nombre"] + "'data-apellidos='" + val["apellidos"] + "' data-email='" + val["email"] + "' data-perfil='" + val["perfil"] + "' data-sucursal='" + val["id_sucursal"] + "' data-intelisis='" + val["cve_intelisis"] + "' id='editUsr'><i class='fa fa-pencil-square' aria-hidden='true'></i></button></div></div>"
               ]);
            }
         })
         $("select[name='tabla_usuarios_length']").attr("style", "display: inline !important;")
      }).always(function(resp) {
			$("#loading_spin").hide();
		})
}
function setSucursal(empresa, sucursal) {
   $("div.sucursales_editar select").empty()
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/obtener_sucursales",
      data: { empresa: empresa },
      type: 'POST',
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         var sucursales = "<option value=''>Seleccionar</option>"
         $.each(data, function (index, val) {
            if (sucursal == val["id"]) {
               sucursales += "<option selected value='" + val["id"] + "'>" + val["nombre"] + "</option>"
            } else {
               sucursales += "<option value='" + val["id"] + "'>" + val["nombre"] + "</option>"
            }

         });
         $("#sucursal").append(sucursales);
      })
      .fail(function () {
         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
}
function getEmpresas() {
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/obtener_empresas",
      type: 'POST',
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         var empresas = "<option value=''>Seleccionar</option>"
         $.each(data, function (index, val) {
            empresas += "<option value='" + val["id"] + "'>" + val["nombre"] + "</option>"
         });
         $("div.empresa_nuevo select").append(empresas);
         $("div.empresa select").append(empresas);
      })
      .fail(function () {
         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
}
function setEmpresa(sucursal) {
   $.ajax({
      cache: false,
      url: base_url + "index.php/user/getEmpresa",
      data: { sucursal: sucursal },
      type: 'POST',
      dataType: 'json',
      beforeSend: function(){
			$("#loading_spin").show();
		},
   })
      .done(function (data) {
         empresa = data[0]["id_agencia"]
         $("#empresa").val(empresa)
         setSucursal(empresa, sucursal)
      })
      .fail(function () {
         console.log("Fallo la solicitud");
      }).always(function(resp) {
			$("#loading_spin").hide();
		});
}
