$(document).ready(function () {
	// Recorre todos los input para eliminar espacios si existen 
	$("#form_emailConfig input").each(function () {
		$(this).val($.trim($(this).val())) 
	})
});
/* Consulta la configuración de la sucursal seleccionada en el select #sucursal_select*/
$(document).on('change', '#sucursal_select', function (e) {
	id_sucursal = $("#sucursal_select option:selected").attr('id');
	$.ajax({
		cache: false,
		url: base_url + "index.php/servicio/get_configSmtp_sucursal",
		data: { sucursal:id_sucursal },
		type: 'POST',
		dataType: 'json',
	 })
	 .done(function (data){
		email = data['email']
		$('#mail_host').val(email['mail_host'])
		$('#mail_userName').val(email['mail_userName'])
		$('#mail_password').val(email['mail_password'])
		$('#mail_port').val(email['mail_port'])
		$('#mail_smtpSecure').val(email['mail_smtpSecure'])
		$('#mail_smtpAuth').val(email['mail_smtpAuth'] == null ? '0' : email['mail_smtpAuth'])
	 })
	 .fail(function (e){
		console.log(e)
	 })
})
// Validación de datos validos en inputs
$(document).on('keyup', '#form_emailConfig input', function (e) {
	$(this).val($.trim($(this).val())); 
	$(this).val().toLowerCase()
})
var form = {}
// Si se logra hacer la conexion esta funcion guarda los cambios en la base de datos 
$(document).on("click", '#guardarCambiosSMTP', function (e) {
	$.ajax({
		cache: false,
		url: base_url + "index.php/servicio/actualizar_smtp/",
		type: 'POST',
		dataType: 'json',
		data: form,
		beforeSend: function(){
			   $("#loading_spin").show();
		   },
		 })
		.done(function (data) {
			if(data.estatus == true){
				toastr.success('Se actualizaron los datos correctamente');
				$('#testEmail').toggle()
				$('#guardarCambiosSMTP').toggle()
				$("#form_emailConfig input, select").each(function () {
					$(this).prop( "disabled", false );
				})
			}else{
				toastr.error('No fue posible guardar los cambios');
			}
		})
		.fail(function (e){
			toastr.error('Ocurrio un error al actualizar los datos, intentalo mas tarde')
		})
		.always(function (e){
			$("#loading_spin").hide();
		})
})
// Accion del boton "probar conexion" 
$(document).on("click", '#testEmail', function (e) {
	estado = true;
   $("#form_emailConfig input, select").each(function () {
      // Se verifica que ningún campo este vació si se encuentra alguno se notifica y se detiene el proceso
		if ($(this).val() != "" ) {
        	form[$(this).attr("id")] = $(this).val();
      	} else {
        	toastr.info("Debes llenar todos los campos para continuar")
        	estado = false;
			return false;
      	}
   })
   if(estado == true){
		$.ajax({
		cache: false,
		url: base_url + "index.php/servicio/probar_SMTP/",
		type: 'POST',
		data: form,
		beforeSend: function(){
			   $("#loading_spin").show();
			   toastr.info('Se esta verificando la conexión con los datos proporcionados');
		   },
	 	})
		.done(function (data) {
			// Cuando el puerto esta incorrecto llega vacia la respuesta
			if(data == ''){
				toastr.info('No fue posible realizar la conexion por medio del puerto proporcionado')
			}else {
				// Verificamos si viene en json, sino lo convertimos
				if(!data.hasOwnProperty('estado')){
				data = jQuery.parseJSON(data)
				}		
				// Se verifica el valor de estado 
				if(data['estado'] == true){
					// Si se logra la conexión ocualtamos el boton de prueba y activamos guardar cambios
					$('#testEmail').toggle()
					$('#guardarCambiosSMTP').toggle()
					toastr.success('Conexion exitosa, ahora puedes guardar los cambios')
					// Se desactivan todos los input para evitar que modifiquen los datos 
					$("#form_emailConfig input,#form_emailConfig select").each(function () {
						$(this).prop( "disabled", true );
					})
				}else{
					toastr.info(verificarMensaje(data['mensaje']));
				}
			}
		})
		.fail(function (e) {
			toastr.info('No fue posible realizar la conexión con las configuraciones de servidor proporcionado');
		}).always(function(resp) {
			   $("#loading_spin").hide();
	    });
   }
});
function verificarMensaje(mensaje){
	salida = "Ocurrió un error desconocido, inténtalo mas tarde"
	// Recorremos el arreglo de errores para identificarlo
	for(i = 0; i < mensaje.length ; i++){
		// Se valida si es error de usuario o contraseña
		if(mensaje[i].indexOf("SMTP ERROR: Password command failed: 535-5.7.8 Username and Password not accepted") == 0 ){
			salida = "El usuario y/o la contraseña no son correctos"
			break
		}else if(mensaje[i].indexOf("SMTP ERROR: Failed to connect to server: php_network_getaddresses: getaddrinfo failed: Host desconocido.") == 0 ){
			salida = "El host ingresado no es valido"
			break
		}else if(mensaje[i].indexOf('SMTP ERROR: MAIL FROM command failed: 530-5.7.0 Authentication Required.') == 0){
			salida = "Se requiere activar la autenticación SMTP"
			break
		}else if(mensaje[i].indexOf('SMTP NOTICE: EOF caught while checking if connected') == 0){
			salida = "Protocolo de seguridad SMTP invalido"
			break
		}
	}
	return salida
}