<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orden de Trabajo</title>
    <style>
        @page {
            size: letter;
            margin: 0;
        }
        .footer{
            border: 1px solid black;
            padding: 5px;
            text-align: center;
            width: 100%;
            word-wrap: break-word;
        }
        .footer p{
            margin: 0;
            line-height: 1.2;
        }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            font-size: 10px !important;
        }
        textarea {
            font-size: 10px;
        }
        .container {
            width: 205.9mm;
            margin: 0 5mm 10mm 5mm;
            padding: 0;
        }
        .header td {
            border: none;
        }
        .logo {
            width: 200px;
            height: auto;
            padding: 5px;
        }
        .logo img {
            width: 100%;
            height: auto;
            object-fit: contain;
        }
        .section {
            display: flex;
        }
        .subsection {
            flex-direction: column;
            flex: 1;
        }
        .vehiculo-table td {
            text-align: left;
            width: 25%;
            border: 1px solid black;
        }
        .subsection-title {
            min-width: fit-content;
            width: 20%;
            background-color: rgba(179, 179, 179, 0.32);
            margin: 0 0 5px 0;
            white-space: nowrap;
        }
        .field-title {
            font-weight: bold;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        .revision td {
            min-width: 15px;
            height: 25px !important;
            border: 1px solid black;
            padding: 2px;
        }
        .id-item {
            width: fit-content;
            white-space: nowrap;
        }
        .desc-item {
            width: 100%;
        }
        .amount-item {
            width: fit-content;
        }
        .img-inspeccion {
            display: flex;
            width: 20%;
            height: 100px;
            border: 1px solid black;
        }
        #observations, #annotations {
            resize: none;
            width: 100%;
            height: auto;
            min-height: 30px;
            overflow: hidden;
            border: 1px solid gray;
            font-family: Arial, sans-serif;
        }
        @media print, .pdfdom {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            body {
                /* width: 215.9mm;
                height: 279.4mm; */
                margin: 0;
                padding: 0;
            }
            .subsection-title {
                background-color: rgba(128, 128, 128, 0.319) !important;
            }
            .revision td {
                min-width: 15px;
                height: 25px !important;
                border: 1px solid black;
                padding: 2px;
            }
            #observations, #annotations {
                margin-top: 5px; 
                resize: none;
                width: 100%;
                min-height: 30px;
                height: auto;
                max-height: 164px;
                border: none;
                overflow: hidden;
                font-family: Arial, sans-serif;
            }
            .footer{
                border: 1px solid black;
                padding: 5px;
                text-align: center;
                width: 100%;
                word-wrap: break-word;
            }
            .tbl-job{
                margin-bottom: 5px;
            }
            #annotations {
                height: 50px !important;
            }
            table, td, th {
                border-color: black !important;
            }
            .inspeccion-canvas {
                width: 100%;
                height: auto;
            }
        }
        .inspeccion-canvas {
            width: 100%;
            height: auto;
        }
        .info-table {
            margin-bottom: 10px;
        }
        .info-table > tbody > tr > td {
            padding: 2px;
            border: 1px solid black;
        }
        .tbl-job td, .tbl-job th {
            padding: 2px;
            border: 1px solid black;
        }
        .cliente-section {
            width: 65%;
        }
        .cliente-section > td {
            border: none;
        }
        .orden-section {
            width: 35%;
        }
        .td-to-check {
            max-width: 25px !important;
            min-width: 25px !important;
        }
        .sucInfo{
            padding-left : 170px;
            font-weight: bold;
        }
        .tbl-one{
            heigth: 100px !important;
        }
    </style>
</head>
<!-- TODO bandera debe ser enviada como parametro segun si se va a editar o regresar el PDF -->
<?php $prefijoAssets = false ? base_url() : '.\\' ?>
<body>
    <div class="container">
        <table class="header">
            <tr>
                <td class="logo" style="width: 200px;"> 
                    <img src="<?= $prefijoAssets ?>assets\img\logo\logo_byd_gris.png" alt="Logo BYD">
                </td>
                <td class="sucInfo">
                    <?= $empresa['nombre'] ?><br> 
                    <?= $empresa['rfc'] ?><br>
                    <?= $empresa['direccion'] ?><br>
                    <?= $empresa['ubicacion'] ?><br>
                    <?= $empresa['telefono'] ?><br>
                    <?= $empresa['web'] ?><br>
                </td>
            </tr>
        </table>

        <div class="section">
            <table class="tbl-one">
                <tr>
                    <td class="cliente-section" style="vertical-align: top;">
                        <h3 class="subsection-title">Cliente</h3>
                        <table class="info-table">
                            <tr>
                                <td style="width:75%">
                                    <span class="field-title">Nombre: </span>
                                    <span class="field-value">(<?= $cliente['IdCliente'] ?>) <?= $cliente['nombre'] ?></span>
                                </td>
                                <td>
                                    <span class="field-title">Fecha: </span>
                                    <span class="field-value"><?= $orden['fecha'] ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span class="field-title">Dirección: </span>
                                    <span class="field-value"><?= $cliente['direccion'] ?></span>
                                </td>
                                <td>
                                    <span class="field-title">Teléfono: </span>
                                    <span class="field-value"><?= $cliente['telefono'] ?></span>
                                    <br>
                                    <span class="field-title">Celular: </span>
                                    <span class="field-value"><?= $cliente['celular'] ?></span>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td class="orden-section" style="vertical-align: top;">
                        <h3 class="subsection-title">Orden de Trabajo</h3>
                        <table class="info-table" style="width:100%;">
                            <tr>
                                <td class="field-title">No. <span class="field-value"><?= $orden['MovId'] ?></span></td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="field-title">Tipo:</div>
                                    <table class="tbl-tipo" style="width:100%">
                                        <tr>
                                            <td>Público</td>
                                            <td>Aseguradora</td>
                                        </tr>
                                        <tr>
                                            <td>Garantía</td>
                                            <td>Interno</td>
                                        </tr>
                                        <tr>
                                            <td>Campaña</td>
                                            <td>Diagnóstico</td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <div class="section">
            <div class="subsection">
                <h3 class="subsection-title">Recepción del Vehículo</h3>
                <table class="vehiculo-table">
                    <tr>
                        <td>
                            <span class="field-title">Auto</span><br>
                            <span class="field-value"><?= $vehiculo['descripcion'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Modelo</span><br>
                            <span class="field-value"><?= $vehiculo['modelo'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Color</span><br>
                            <span class="field-value"><?= $vehiculo['color'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Fecha y Hora de Recepción</span><br>
                            <span class="field-value"><?= $orden['recepcion'] ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <span class="field-title">Placas</span><br>
                            <span class="field-value"><?= $vehiculo['placas'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Asesor</span><br>
                            <span class="field-value"><?= $orden['nombreAsesor'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Odómetro</span><br>
                            <span class="field-value"><?= $vehiculo['km'] ?></span>
                        </td>
                        <td>
                            <span class="field-title">Fecha y Hora de Entrega</span><br>
                            <span class="field-value"><?= $orden['entrega'] ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="1">
                            <span class="field-title">VIN</span><br>
                            <span class="field-value"><?= $vehiculo['vin'] ?></span>
                        </td>
                        <td colspan="3" style="border:none;"></td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="section">
            <div class="subsection">
                <h3 class="subsection-title">Descripción del Trabajo</h3>
                <table class="tbl-job">
                    <tr>
                        <th class="id-item">No. Parte / MO / Item</th>
                        <th class="desc-item">Descripción</th>
                        <th class="amount-item">Cantidad</th>
                        <th>Importe</th>
                    </tr>
                    <?php 
                    $total = 0;
                    foreach ($articulos as $articulo): ?>
                    <tr>
                        <td class="id-item"><?= $articulo['articulo'] ?></td>
                        <td class="desc-item"><?= $articulo['descripcion'] ?></td>
                        <td class="amount-item"><?= $articulo['cantidad'] ?></td>
                        <td><?= $articulo['importe'] ?></td>
                    </tr>
                    <?php $total += $articulo['importe']; ?>
                    <?php endforeach; ?>
                    <tr>
                        <td colspan="2" style="text-align: right;"></td>
                        <td>Total</td>
                        <td>$<?= $total ?></td>
                </table>
            </div>
        </div>
        <div class="section">
            <textarea name="observations" id="observations"><?= preg_replace('/\n{3,}/', "\n\n", $orden['comentarios']) ?></textarea>
        </div>
        
        <h3 class="subsection-title">Revisión Inicial</h3>
        <span>Se pone / si el vehículo trae dichos accesorios, documentos, en comodidad cuando ya se tomó nota de las preferencias del cliente, de otra 
        manera se deja en blanco.</span>
        <div class="section">
            <div class="subsection">
                <table class="revision">
                    <tr>
                        <th colspan="4" class="subsection-title">Accesorios</th>
                        <th colspan="2" class="subsection-title">Documentos</th>
                        <th colspan="2" class="subsection-title">Comodidad</th>
                    </tr>
                    <tr>
                        <td>Gato</td>
                        <td class="td-to-check"></td>
                        <td>Llanta de refacción o kit de reparación</td>
                        <td class="td-to-check"></td>
                        <td>Póliza de garantía</td>
                        <td class="td-to-check"></td>
                        <td>Estación de radio</td>
                        <td class="td-to-check"></td>
                    </tr>
                    <tr>
                        <td>Seguro de birlos</td>
                        <td class="td-to-check"></td>
                        <td>Adaptador</td>
                        <td class="td-to-check"></td>
                        <td>Manual</td>
                        <td class="td-to-check"></td>
                        <td>Temperatura A/C</td>
                        <td class="td-to-check">°C</td>
                    </tr>
                    <tr>
                        <td>Kit de herramientas</td>
                        <td class="td-to-check"></td>
                        <td class="td-to-check">VTOL</td>
                        <td class="td-to-check"></td>
                        <td>Tarjeta de circulación</td>
                        <td class="td-to-check"></td>
                        <td>Posición asiento</td>
                        <td class="td-to-check"></td>
                    </tr>
                    <tr>
                        <td>Triángulo de seguridad</td>
                        <td class="td-to-check"></td>
                        <td>Cargador de emergencia</td>
                        <td class="td-to-check"></td>
                        <td>Road assistance </td>
                        <td class="td-to-check"></td>
                        <td>Espejos</td>
                        <td class="td-to-check"></td>
                    </tr>
                    <tr>
                        <td>Clip</td>
                        <td class="td-to-check"></td>
                        <td class="td-to-check"></td>
                        <td class="td-to-check"></td>
                        <td>Call center</td>
                        <td class="td-to-check"></td>
                        <td>Posición de pantalla</td>
                        <td class="td-to-check">V u H</td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="section">
            <div class="subsection">
                <h3 class="subsection-title">Anotaciones</h3>
                <textarea name="annotations" id="annotations"></textarea>
            </div>
        </div>
        <div class="img-section">
            <img class="inspeccion-canvas" src="<?= $prefijoAssets ?>\assets\img\canvas\inspeccion_byd.bmp">
        </div>
        <div class="section footer">
            <p>Aclaraciones y quejas favor de llamar al número oficial de servicio al cliente y quejas de BYD Auto México 55-9408-0293 en los horarios 7:00 am a 9:00 pm Lunes a Viernes y 8:00 am a 6:00 pm Sábados.</p>
        </div>

        <table style="width: 100%; height: 150px;">
            <tr>
                <td style="text-align: center; vertical-align: bottom;">
                    <span><?= $orden['nombreAsesor'] ?></span>
                    <hr style="width: 80%; border: 1px solid black; margin-top: 0px;">
                    <span>Asesor de servicio</span>
                </td>
                <td style="text-align: center; vertical-align: bottom;">
                    <span><?= $cliente['nombre'] ?></span>
                    <hr style="width: 80%; border: 1px solid black; margin-top: 0px;">
                    <span>Cliente</span>
                </td>
            </tr>
        </table>
    </div>
    <script>
        const observationsTextarea = document.getElementById('observations');
        const annotationsTextarea = document.getElementById('annotations');
        
        // Función para ajustar altura
        function adjustHeight(textarea) {
            textarea.style.height = 'auto';
            textarea.style.height = textarea.scrollHeight + 'px';
        }
        
        // Función para normalizar los saltos de línea (no más de una línea vacía consecutiva)
        function normalizeEmptyLines(textarea) {
            if (textarea.value) {
                // Replace multiple consecutive line breaks with just two (one empty line)
                textarea.value = textarea.value.replace(/\n{3,}/g, '\n\n');
            }
        }
        
        // Procesar el contenido inicial
        normalizeEmptyLines(observationsTextarea);
        
        // Ajustar altura inicial
        adjustHeight(observationsTextarea);
        adjustHeight(annotationsTextarea);
        
        // Ajustar altura mientras se escribe
        observationsTextarea.addEventListener('input', () => {
            normalizeEmptyLines(observationsTextarea);
            adjustHeight(observationsTextarea);
        });
        annotationsTextarea.addEventListener('input', () => adjustHeight(annotationsTextarea));
    </script>
</body>
</html>
