<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<link rel="stylesheet" href="<?= base_url() ?>assets/librerias/fontawesome-free-5.2.0-web/css/all.css" />
	<link href="<?= base_url() ?>assets/css/bootstrap.min.css" rel="stylesheet" media="all">
	<link href="<?= base_url() ?>assets/css/style_acueducto.css" rel="stylesheet">
	<title>Orden de Servicio</title>
</head>

<body>
	<?php
		$acueducto = explode(",", $inspeccion["profecoAcueducto"]);
	?>
	<div class="hoja" style="page-break-after: always;">
		<div class="row">
			<div class="col-2">
				<img class="logo" src="./assets/img/logo/logo_nissan.svg" />
			</div>
			<div class="col-10 encabezado negritas">
				<div><?= strtoupper($sucursal["razon_social"]) ?></div>
				<div>DOMICILIO: <?=
								strtoupper($sucursal["dom_calle"] . " No." . $sucursal["dom_numExt"] . ", COL. " . $sucursal["dom_colonia"] . " C.P. " . $sucursal["dom_cp"] . " " . $sucursal["dom_ciudad"] . ",  " . $sucursal["dom_estado"] . ", MÉXICO")
								?>
				</div>
				<div>RFC. <?= $sucursal["rfc"] ?></div>
				<div>CORREO ELECTRÓNICO: <?php echo ($sucursal["email_contacto"]) ? $sucursal["email_contacto"] : '.'; ?></div>
			</div>
		</div>
		<div class="row">
			<div class="segundos_datos">
				<div><span class="negritas ancho_definido">ORDEN DE SERVICIO NO. </span><span class="text_subrayado"> <?= $cliente["MovID"] ?></span></div>
				<div><span class="negritas ancho_definido">LUGAR Y FECHA: </span><span class="text_subrayado"><?= strtoupper($sucursal["dom_ciudad"]) ?> , <?= strtoupper($sucursal["dom_estado"]) ?> a <?= date("d-m-Y") ?></span></div>
				<div>HORARIO DE ATENCIÓN AL PUBLICO DE <?= strtoupper($sucursal["horario_recep"]) ?></div>
			</div>
		</div>
		<div class="contenedor">
			<span class="negritas">DATOS DEL CONSUMIDOR Y RECEPCIÓN DEL VEHÍCULO</span>
			<!-- Filas con la informacion sobre la orden -->
			<div>
				<div class="borde campo">
					NOMBRE CONSUMIDOR: <?php
										$nom_cli = $cliente["nombre_cliente"] . " " . $cliente["ap_cliente"] . " " . $cliente["am_cliente"];
										?>
					<?= $nom_cli ?>
				</div>
				<div class="borde campo">
					DOMICILIO: <?= $cliente["dir_calle"] . " " . $cliente["dir_num_ext"] . ", " . $cliente["dir_num_int"] . " " . $cliente["dir_colonia"] . " " . $cliente["dir_cp"] . " " . $cliente["dir_municipio"] . " " . $cliente["dir_estado"] ?>
				</div>
				<div class="borde campo">
					<div class="row">
						<div class="campo-1_3">
							CORREO ELECTRONICO: <?= $cliente["email_cliente"] ?>
						</div>
						<div class="campo-2_3">
							TELEFONO: <?= $cliente["tel_movil"] . " " . $cliente["otro_tel"] ?>
						</div>
						<div class="campo-3_3">
							R.F.C. <?= $cliente["rfc_cliente"] ?>
						</div>
					</div>
				</div>
				<div class="borde campo">
					<div class="row">
						<div class="campo-1_5">
							MODELO: <?= $cliente['anio_modelo_v'] ?>
						</div>
						<div class="campo-2_5">
							TIPO: <?= $cliente['Descripcion1'] ?>
						</div>
						<div class="campo-3_5">
							MARCA: <?= $cliente["marca_v"] ?>
						</div>
						<div class="campo-4_5">
							COLOR: <?= $cliente['color_v'] ?>
						</div>
						<div class="campo-5_5">
							PLACAS: <?= $cliente['placas_v'] ?>
						</div>
					</div>
				</div>
				<div class="borde campo">
					<div class="row">
						<div class="campo-1_3">
							Nº DE SERIE: <?= $cliente['vin_v'] ?>
						</div>
						<div class="campo-2_3">
							Nº DE MOTOR:
						</div>
						<div class="campo-3_3">
							KM RECORRIDOS: <?= $cliente['kilometraje_v'] ?>
						</div>
					</div>
				</div>
				<div class="borde campo">
					<div class="row">
						<div class="campo-1_4">
							<?php
							$cliente["fecha_recepcion"] = explode(" ", $cliente["fecha_recepcion"]);
							$fecha_recepcion = date("d-m-Y", strtotime($cliente['fecha_recepcion'][0]));
							?>
							FECHA DE INGRESO: <?= $fecha_recepcion ?>
						</div>
						<div class="campo-2_4">
							HORA: <?= $cliente['hora_recepcion'] ?>
						</div>
						<div class="campo-3_4">
							<?php
							$cliente["fecha_entrega"] = explode(" ", $cliente["fecha_entrega"][0]);
							$fecha_entrega = date("d-m-Y", strtotime($cliente['fecha_entrega'][0]));
							?>
							FECHA ESTIMADA DE ENTREGA: <?= $fecha_entrega ?>
						</div>
						<div class="campo-4_4">
							HORA ESTIMADA DE ENTREGA:
						</div>
					</div>
				</div>
			</div>
			<!-- Inventario del vehículo -->
			<div class="borde inventario">
				<span class="negritas">INVENTARIO DEL VEHÍCULO</span>
				<div class="letra_menor row">
					<div class="col-inv_1">
						EXTERIORES
						<table>
							<tr>
								<td class="titulo_opcion"></td>
								<td class="opciones">SI</td>
								<td class="opciones">NO</td>
							</tr>
							<tr>
								<?php
								$checked_luces = ($inspeccion["luces_int"] == "SI") ? true : false;
								?>
								<td class="titulo_opcion">UNIDAD DE LUCES</td>
								<td class="opciones"><?php if ($checked_luces) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_luces) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $check_lucesCuarto = $acueducto[1] == 'cuatoLuces_si' ? true : false; ?>
								<td class="titulo_opcion">1/4 LUCES<?= $check_lucesCuarto ?></td>
								<td class="opciones"><?php if($check_lucesCuarto){echo "X";} 
														?></td>
								<td class="opciones"><?php if(!$check_lucesCuarto){echo "X";} 
														?></td>
							</tr>
							<tr>
								<?php $antn = explode(",", $inspeccion["exteriores"]);
								$checked_antn = ($antn[2] == "n/a") ? false : true;
								?>
								<td class="titulo_opcion">ANTENA</td>
								<td class="opciones"><?php if ($checked_antn) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_antn) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $checked_espejos = ($inspeccion["espejos"] == "SI") ? true : false; ?>
								<td class="titulo_opcion">ESPEJO LATERAL</td>
								<td class="opciones"><?php if ($checked_espejos) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_espejos) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
							<?php $check_emblema = $acueducto[0] == 'emblema_no' ? true : false ?>
								<td class="titulo_opcion">EMBLEMA</td>
								<td class="opciones"><?php if($check_emblema){echo "X";} 
														?></td>
								<td class="opciones"><?php if(!$check_emblema){echo "X";} 
														?></td>
							</tr>
							<tr>
							<?php $check_llantasCuarto = $acueducto[2] == 'cuatroLlantas_si' ? true : false ?>
								<td class="titulo_opcion">LLANTAS (4)</td>
								<td class="opciones"><?php if($check_llantasCuarto){echo "X";} 
														?></td>
								<td class="opciones"><?php if(!$check_llantasCuarto){echo "X";} 
														?></td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$checked_llantaRefac = ($cajuela[5] == "Llanta de Refaccion") ? true : false;
								?>
								<td class="titulo_opcion">LLANTA DE REFACCIÓN</td>
								<td class="opciones"><?php if ($checked_llantaRefac) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$checked_llantaRefac) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php
								$tapons_rueds = explode(",", $inspeccion["exteriores"]);
								$checked_tapons_rueds = ($tapons_rueds[0] == "n/a") ? false : true;
								?>
								<td class="titulo_opcion">TAPÓN DE RUEDAS (4)</td>
								<td class="opciones"><?php if ($checked_tapons_rueds) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_tapons_rueds) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php
								$molduras = explode(",", $inspeccion["exteriores"]);
								if (count($molduras) > 4) {
									$checked_molduras = ($molduras[4] == "n/a") ? false : true;
								} else {
									$checked_molduras = false;
								}
								?>
								<td class="titulo_opcion">MOLDURAS COMPLETAS</td>
								<td class="opciones"><?php if ($molduras) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$molduras) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php
								$tapn_gas = explode(",", $inspeccion["exteriores"]);
								$checked_tapn_gas = ($tapn_gas[3] == "n/a") ? false : true;
								?>
								<td class="titulo_opcion">TAPÓN DE GASOLINA</td>
								<td class="opciones"><?php if ($tapn_gas) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$tapn_gas) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $checked_claxon = ($inspeccion["claxon"] == 'SI') ? true : false; ?>
								<td class="titulo_opcion">BOCINAS DE CLAXON</td>
								<td class="opciones"><?php if ($checked_claxon) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_claxon) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $checked_plumas = ($inspeccion["plumas"] == "Buen Estado") ? true : false; ?>
								<td class="titulo_opcion">LIMPIADORES (PLUMAS)</td>
								<td class="opciones"><?php if ($checked_plumas) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_plumas) {
															echo "X";
														} ?></td>
							</tr>
						</table>
					</div>
					<div class="col-inv_2">
						<img class="inspeccion" src="<?=$inspeccion['img']?>" />
					</div>
					<div class="col-inv_3">
						INTERIORES
						<table>
							<tr>
								<td class="titulo_opcion"></td>
								<td class="opciones">SI</td>
								<td class="opciones">NO</td>
							</tr>
							<tr>
								<?php $checked_ac = ($inspeccion["ac"] == "SI") ? true : false; ?>
								<td class="titulo_opcion">A/C FUNCIONAL</td>
								<td class="opciones"><?php if ($checked_ac) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_ac) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $checked_radio = ($inspeccion["radio"] == "SI") ? true : false; ?>
								<td class="titulo_opcion">RADIO/TIPO</td>
								<td class="opciones"><?php if ($checked_radio) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_radio) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $check_bocinas = $acueducto[3] == 'bocinas_si' ? true : false; ?>
								<td class="titulo_opcion">BOCINAS</td>
								<td class="opciones"><?php if($check_bocinas){echo "X";} 
														?></td>
								<td class="opciones"><?php if(!$check_bocinas){echo "X";} 
														?></td>
							</tr>
							<tr>
								<?php $checked_encendedor = ($inspeccion["encendedor"] == "SI") ? true : false; ?>
								<td class="titulo_opcion">ENCENDEDOR</td>
								<td class="opciones"><?php if ($checked_encendedor) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_encendedor) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php
								$retrovisor = explode(",", $inspeccion["profecoFame"]);
								$checked_retrovisor = ($retrovisor[1] == "retrovisor_si") ? true : false;
								?>
								<td class="titulo_opcion">ESPEJO RETROVISOR</td>
								<td class="opciones"><?php if ($retrovisor) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$retrovisor) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php
								$cenicero = explode(",", $inspeccion["profecoFame"]);
								$checked_cenicero = ($cenicero[2] == "cenicero_si") ? true : false;
								?>
								<td class="titulo_opcion">CENICERO</td>
								<td class="opciones"><?php if ($cenicero) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$cenicero) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php
								$cinturon = explode(",", $inspeccion["profecoFame"]);
								$checked_cinturon = ($cinturon[3] == "cinturon_si") ? true : false;
								?>
								<td class="titulo_opcion">CINTURONES</td>
								<td class="opciones"><?php if ($cinturon) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$cinturon) {
															echo "X";
														} ?></td>
							</tr>
							<tr>
								<?php $checked_tapetes = ($inspeccion["tapetes"] == "SI") ? true : false; ?>
								<td class="titulo_opcion">TAPETES</td>
								<td class="opciones"><?php if ($checked_tapetes) {
															echo "X";
														} ?></td>
								<td class="opciones"><?php if (!$checked_tapetes) {
															echo "X";
														} ?></td>
							</tr>
						</table>
					</div>
				</div>
				<div class="objetos_reportados">
					OBJETOS DE VALOR REPORTADOS:
				</div>
			</div>
			<!-- Segunda sección del inventario -->
			<div class="borde inventario_2">
				<div class="row">
				<?php 
					$gasolina = $inspeccion['gasolina'];
					switch($gasolina){
						case 'V':
							$img_gasolina = "Gasolina_auto_0-8.jpg" ;
							break;
						case '1/8':
							$img_gasolina = "Gasolina_auto_1-8.jpg" ;
							break;
						case '1/4':
							$img_gasolina = "Gasolina_auto_2-8.jpg" ;
							break;
						case '3/8':
							$img_gasolina = "Gasolina_auto_3-8.jpg" ;
							break;
						case '1/2':
							$img_gasolina = "Gasolina_auto_4-8.jpg" ;
							break;
						case '5/8':
							$img_gasolina = "Gasolina_auto_5-8.jpg" ;
							break;
						case '3/4':
							$img_gasolina = "Gasolina_auto_6-8.jpg" ;
							break;
						case '7/8':
							$img_gasolina = "Gasolina_auto_7-8.jpg" ;
							break;
						case 'LL':
							$img_gasolina = "Gasolina_auto_8-8.jpg" ;
							break;
						default:
							$img_gasolina = "Gasolina_auto_0-8.jpg" ;
							break;
					}
				?>
					<div class="col-4 div_gasolina">
						<img class="gasolina_img" src="./assets/img/gasolina/FAME/<?= $img_gasolina ?>">
					</div>
					<div class="col-4 accesorios">
						ACCESORIOS
						<table>
							<tr>
								<td class="titulo_opcion"></td>
								<td class="opciones">SI</td>
								<td class="opciones">NO</td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$check_gato = ($cajuela[1] == "Gato/Llave") ? true : false;
								?>
								<td class="titulo_opcion">GATO</td>
								<td class="opciones"><?php if ($check_gato) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$check_gato) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$check_gato = ($cajuela[1] == "Gato/Llave") ? true : false;
								?>
								<td class="titulo_opcion">MANERAL DE GATO</td>
								<td class="opciones"><?php if ($check_gato) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$check_gato) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$check_herramienta = ($cajuela[0] == "herramienta") ? true : false;
								?>
								<td class="titulo_opcion">ESTUCHE DE HERRAMIENTAS</td>
								<td class="opciones"><?php if ($check_herramienta) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$check_herramienta) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$check_triangulo = ($cajuela[2] == "Reflejantes") ? true : false;
								?>
								<td class="titulo_opcion">TRIANGULO DE SEGURIDAD</td>
								<td class="opciones"><?php if ($check_triangulo) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$check_triangulo) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php
								$cajuela = explode(",", $inspeccion["cajuela"]);
								$checked_llantaRefac = ($cajuela[5] == "Llanta de Refaccion") ? true : false;
								?>
								<td class="titulo_opcion">LLANTA DE REFACCIÓN</td>
								<td class="opciones"><?php if ($checked_llantaRefac) {
															echo "X";
														}
														?></td>
								<td class="opciones"><?php if (!$checked_llantaRefac) {
															echo "X";
														}
														?></td>
							</tr>
							<tr>
								<?php $check_birlo = $acueducto[4] == 'birlo_si' ? true : false; ?>
								<td class="titulo_opcion">BIRLO DE SEGURIDAD</td>
								<td class="opciones"><?php if ($check_birlo) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_birlo) {echo "X";}
														?></td>
							</tr>
						</table>
					</div>
					<div class="col-4 componentes">
						COMPONENTES MECÁNICOS
						<table>
							<tr>
								<td class="titulo_opcion"></td>
								<td class="opciones">SI</td>
								<td class="opciones">NO</td>
							</tr>
							<tr>
								<td class="titulo_opcion">CLAXON</td>
								<td class="opciones"><?= ($inspeccion["claxon"] == 'SI') ? "X" : "" ?></td>
								<td class="opciones"><?= ($inspeccion["claxon"] != 'SI') ? "X" : "" ?></td>
							</tr>
							<tr>
							<?php $check_taponAceite = $acueducto[5] == 'taponAceite_si' ? true : false; ?>
								<td class="titulo_opcion">TAPÓN DE ACEITE</td>
								<td class="opciones"><?php if ($check_taponAceite) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_taponAceite) {echo "X";}
														?></td>
							</tr>
							<tr>
							<?php $check_taponRadiador = $acueducto[6] == 'taponRadiador_si' ? true : false; ?>
								<td class="titulo_opcion">TAPÓN DE RADIADOR</td>
								<td class="opciones"><?php if ($check_taponRadiador) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_taponRadiador) {echo "X";}
														?></td>
							</tr>
							<tr>
							<?php $check_varillaAceite = $acueducto[7] == 'varillaAceite_si' ? true : false; ?>
								<td class="titulo_opcion">VARILLA DE ACEITE</td>
								<td class="opciones"><?php if ($check_varillaAceite) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_varillaAceite) {echo "X";}
														?></td>
							</tr>
							<tr>
							<?php $check_filtroAire = $acueducto[8] == 'filtroAire_si' ? true : false; ?>
								<td class="titulo_opcion">FILTRO DE AIRE</td>
								<td class="opciones"><?php if ($check_filtroAire) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_filtroAire) {echo "X";}
														?></td>
							</tr>
							<tr>
							<?php $check_bateriaMCA = $acueducto[9] == 'bateriaMCA_si' ? true : false; ?>
								<td class="titulo_opcion">BATERIA (MCA)</td>
								<td class="opciones"><?php if ($check_bateriaMCA) {echo "X";}
														?></td>
								<td class="opciones"><?php if (!$check_bateriaMCA) {echo "X";}
														?></td>
							</tr>
						</table>
					</div>
				</div>
			</div>
			<!-- Presupuesto -->
			<div>
				<?php
				$print_operaciones = "";
				$print_precios = "";
				$print_subtotales = "";
				$total_refacciones = 0;
				foreach ($desglose as $key => $value) {
					if ($key <= 5) {
						// Agrega el nombre de los las operaciones 
						$print_operaciones .= $value["cantidad"] . " - " . $value["descripcion"] . "<br>";
						// Se divide en columnas, la primera es el precio unitario y la segunda el subtotal
						$print_precios .= "<div class='row' style='line-height: 5.3px;'><div class='col' style='text-align:left;'>$" . number_format($value["precio_unitario"], 2, '.', ',') . "</div><div class='col' style='text-align:center;'>$" . number_format(($value["precio_unitario"] * $value["cantidad"]), 2, '.', ',') . "</div></div>";
						$total_refacciones += $value["precio_unitario"] * $value["cantidad"];
					}
				}
				?>
				<table class="presupuesto">
					<tr>
						<td class="encabezado_presupuesto">PRESUPUESTO</td>
						<td class="encabezado_presupuesto">FECHA DE VIGENCIA DEL PRESUPUESTO</td>
					</tr>
					<tr>
						<td>OPERACIONES A EFECTUAR, ELEMENTOS A REPARAR O SUSTITUIR O DESCRIPCIÓN DEL SERVICIO POR EL CLIENTE:</td>
						<td>IMPORTE</td>
					</tr>
					<?php echo "<tr><td style='text-align:left;'>" . $print_operaciones . "</td><td style='text-align:center; padding-top:6px; margin-top:6px;'>" . $print_precios . "</td></tr>"; ?>
					<tr>
						<td>SERVICIOS ADICIONALES</td>
						<td style="text-align:left;">ANTICIPO</td>
					</tr>
					<tr>
						<td>MANO DE OBRA</td>
						<td><?= floatval($cliente['subtotal_orden']) - $total_refacciones  ?> M.N.</td>
					</tr>
					<tr>
						<td>REFACCIONES</td>
						<td><?= $total_refacciones ?> M.N.</td>
					</tr>
					<tr>
						<td>OTROS MATERIALES</td>
						<td>M.N.</td>
					</tr>
					<tr>
						<td>SUBTOTAL </td>
						<td><?= number_format(floatval($cliente['subtotal_orden']), 2, '.', ',') ?> M.N.</td>
					</tr>
					<tr>
						<td>I.V.A.</td>
						<td><?= number_format(floatval($cliente['iva_orden']), 2, '.', ',') ?> M.N.</td>
					</tr>
					<tr>
						<td>PRECIO TOTAL</td>
						<td><?= number_format(floatval($cliente['total_orden']), 2, '.', ',') ?> M.N.</td>
					</tr>
					<tr>
						<td>RIESGOS DEL VEHÍCULO DERIVADOS DE LA REALIZACIÓN DE DIAGNÓSTICO</td>
						<td></td>
					</tr>
				</table>
			</div>
			<!-- Información del pie de pagina -->
			<div class="pie_pagina">
				<span class="letra_menor">EN CASO DE QUE EL PRESUPUESTO NO SEA ACEPTADO, EL CONSUMIDOR PAGARA EXCLUSIVAMENTE EL COSTO POR LA REVISIÓN Y
					DIAGNÓSTICO Y EL PROVEEDOR SE OBLIGA A DEVOLVER EL VEHÍCULO EN LAS CONDICIONES EN LAS QUE LE FUE ENTREGADO,
					EXCEPTUANDO LAS CONSECUENCIAS INEVITABLES DEL DIAGNÓSTICO.
				</span><br>
				<span class="letra_menor">EL COSTO DE LA REVISIÓN SERA DE $_____________</span><br>
				<span class="letra_menor">EL COSTO POR SERVICIO A DOMICILIO SERÁ DE $_____________</span><br>
				<span class="letra_menor">AUTOMOTRIZ ACUEDUCTO S.A DE C.V.</span><br>

				<div class="row seccion_firmas">
					<div class="col-1_2 text_centrado">
						<div class="contenedor_firma"><img src="<?= $asesor["firma_electronica"] ?>" class="firma_cliente" alt="firma del cliente"></div>
						<div>&nbsp;</div>
						<div class="linea_firma">FIRMA DEL PROVEEDOR</div>
					</div>
					<div class="col-2_2 text_centrado">
						<div class="contenedor_firma"><img src="<?= $firma_cliente["firma"] ?>" class=" firma_cliente" alt="firma del cliente"></div>
						<div><?= date("d-m-Y") ?></div>
						<div class="linea_firma">FECHA Y FIRMA DEL CONSUMIDOR ACEPTANDO EL PRESUPUESTO</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="hoja">
		<div class="negritas">
			CONTRATO DE PRESTACIÓN DE SERVICIOS DE REPARACIÓN Y/O MANTENIMIENTO DE VEHÍCULOS QUE CELEBRAN POR UNA
			PARTE AUTOS FAME, S.A. DE C.V. COMO “EL PROVEEDOR” Y POR LA OTRA PARTE COMO “EL CONSUMIDOR” CUYOS NOMBRES
			Y DATOS CONSTAN EN LA CARÁTULA DE ESTE CONTRATO COMO PARTE INTEGRAL DEL MISMO, SUJETÁNDOSE AL TENOR DE
			LAS SIGUIENTES:
		</div>
		<div class="text_centrado negritas">
			CLAUSULAS
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">PRIMERA.-</span> EL CONSUMIDOR expresa ser el dueño del vehículo y/o estar facultado por éste para autorizar los servicios descritos en el
			presente contrato, por lo que acepta las condiciones y términos del mismo. Asimismo, EL CONSUMIDOR, es sabedor de las posibles
			consecuencias que puede sufrir el vehículo con motivo de diagnóstico, reparación y/o mantenimiento, por lo que las acepta y responsabiliza
			de las mismas. El consumidor manifiesta y acepta haber tenido a la vista los precios por mano de obra, partes y/o refacciones a emplear en
			las operaciones a efectuar por LA AGENCIA. <br>
			EL PROVEEDOR realizará todas las operaciones y composturas descritas en el anverso del presente contrato, solicitadas por EL
			CONSUMIDOR que suscribe el presente contrato, a las que se someterá el vehículo para obtener condiciones de funcionamiento de acuerdo
			al estado de éste. EL PROVEDOR garantizará los servicios contratados, ya que no podrá deslindarse de su responsabilidad ante el
			CONSUMIDOR. EL PROVEEDOR no condicionará la prestación de los servicios de reparación y/o mantenimiento de vehículos a la
			adquisición o renta de otros productos o servicios en el establecimiento o en otro taller o agencia predeterminada.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">SEGUNDA.-</span> El precio total de los servicios contratados se establece en el presupuesto que forma parte del presente y se describe en el
			anverso del presente contrato, el cual será pagado por EL CONSUMIDOR, de la siguiente forma: Al momento de celebrar el presente contrato
			por concepto de anticipo la cantidad que se indica en el anverso del presente contrato y el resto en la fecha de entrega del vehículo, salvo en
			aquellas reparaciones en que el anticipo sea para el suministro de componentes y piezas específicas y/o de costo mayor, en tal caso EL
			CONSUMIDOR deberá cubrir el costo total de estas anticipadamente. <br>
			Todo pago efectuado por EL CONSUMIDOR deberá realizarse única y exclusivamente en las cajas ubicadas en el establecimiento del
			PROVEEDOR, al contado y en moneda nacional. El pago será en efectivo, salvo que las partes acuerden o acepten otra forma distinta, como
			pudiese ser en cheque, tarjeta de crédito o depósito bancario.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">TERCERA.-</span>EL PROVEEDOR pondrá a disposición de EL CONSUMIDOR los precios de los servicios, mano de obra, refacciones y materiales
			a usar en las reparaciones ofrecidas. Asimismo, previo a la realización del servicio EL PROVEEDOR presentará a EL CONSUMIDOR el
			presupuesto al que se refiere la cláusula Segunda del presente contrato. Una vez aprobado el presupuesto por EL CONSUMIDOR, EL
			PROVEEDOR procederá a efectuar el servicio solicitado. Los incrementos que resulten durante la reparación por costos no previsibles en
			rubros específicos que su cotización este fuera del control de EL PROVEEDOR, deberán ser autorizados por EL CONSUMIDOR, en forma
			escrita, siempre y cuando éstos excedan al 20% del presupuesto. Si el incremento citado es inferior lo podrán autorizar vía telefónica,
			WhatsApp o correo electrónico, en este caso la fecha de entrega podría variar y será informada al consumidor por los medios ya referidos.
			Las quejas y sugerencias serán atendidas en el domicilio y horarios de atención señalados en la caratula o anverso del presente contrato
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">CUARTA.-</span> La entrega del vehículo será en la fecha contemplada en el anverso del presente contrato. Para el caso de que EL CONSUMIDOR,
			sea quien proporcione las refacciones la fecha de entrega será __ días posteriores en los que EL PROVEEDOR las reciba en sus
			instalaciones
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">QUINTA.-</span>EL PROVEEDOR exclusivamente utilizará para los servicios objeto de este contrato, partes, refacciones u otros materiales nuevos
			y apropiados para el vehículo, salvo que EL CONSUMIDOR autorice expresamente se usen otras. Si EL PROVEEDOR lo autoriza, EL
			CONSUMIDOR suministrará las partes, refacciones o materiales necesarios para la reparación y/o mantenimiento del vehículo. En ambos
			casos, la autorización respectiva se hará constar en el anverso de presente contrato.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">SEXTA.- </span>EL PROVEEDOR hará entrega de las refacciones, partes o piezas sustituidas en la reparación y/o mantenimiento del vehículo al
			momento de entrega de ésta, excepto en los siguientes casos: <br>
			A) Cuando EL CONSUMIDOR, exprese lo contrario. <br>
			B) Las partes, refacciones o piezas sean cambiadas en uso de garantía; <br>
			C) Se trate de residuos considerados peligrosos de acuerdo con las disposiciones legales aplicables.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">SÉPTIMA.-</span>Las reparaciones a que se refiere el presupuesto aceptado por EL CONSUMIDOR, tiene una garantía de 90 días en mano de
			obra, contados a partir de la fecha de entrega del vehículo ya reparado; y en refacciones la especificada por el fabricante, siempre y cuando
			no se manifieste mal uso, negligencia o descuido imputables al CONSUMIDOR; lo anterior de conformidad a lo establecido en el artículo 77
			de la Ley Federal de Protección al Consumidor. Si el vehículo es intervenido por un tercero, EL PROVEEDOR no será responsable y la
			garantía quedará sin efecto. Las reclamaciones por garantía se harán en el establecimiento de EL PROVEEDOR, para lo cual EL
			CONSUMIDOR, deberá presentar su vehículo en dicho establecimiento. Las reparaciones efectuadas por EL PROVEEDOR en cumplimiento
			a la garantía del servicio, serán sin cargo alguno para EL CONSUMIDOR, salvo aquellos trabajos que no deriven de las reparaciones
			aceptadas en el presupuesto. No se computará dentro del plazo de garantía, el tiempo que dure la reparación y/o mantenimiento del vehículo
			para el cumplimiento de la misma.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">OCTAVA.-</span>EL CONSUMIDOR, autoriza el uso del vehículo en zonas aledañas con un radio de 5 Km. al área del establecimiento a efectos
			de pruebas o verificación de las reparaciones a efectuar o efectuadas. EL PROVEEDOR no podrá utilizar el vehículo para uso personal, fines
			propios o de terceros.

		</div>
		<div class="clausula">
			<span class="text_centrado negritas">NOVENA.-</span>EL PROVEEDOR se hace responsable por los daños causados al vehículo de EL CONSUMIDOR, como consecuencia de los
			recorridos de prueba por parte del personal de EL PROVEEDOR. El riesgo en un recorrido de prueba, es por cuenta de EL CONSUMIDOR,
			cuando él mismo solicite que será él o un representante suyo quién conduzca el vehículo. Asimismo, EL PROVEEDOR se hace responsable
			por las descomposturas, daños, perdidas parciales o totales, imputables a él o a sus empleados, que sufra el vehículo, el equipo y aditamentos
			que EL CONSUMIDOR haya notificado al momento de la recepción del vehículo, mientras se encuentren bajo su responsabilidad para llevar
			a cabo la reparación y/o mantenimiento solicitado, así como para hacer efectiva la garantía otorgada. Para tal efecto EL PROVEEDOR cuenta
			con un seguro suficiente para cubrir dichas eventualidades, cuyo número de póliza es _____ con la compañía _____ EL PROVEEDOR no se
			hace responsable por la pérdida de objetos dejados en el interior del vehículo, salvo que estos hayan sido notificados y puestos bajo su
			resguardo al momento de la recepción del vehículo.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA.-</span>EL PROVEEDOR se obliga a expedir la factura o comprobante de pago por los trabajos efectuados, en la que se especificará los
			precios por mano de obra, refacciones, materiales y accesorios empleados, conforme el artículo 62 de la Ley Federal de Protección al
			Consumidor. No se expedirá factura fuera del mes en que se haya realizado el pago de los servicios.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA PRIMERA.-</span>Se establece como pena convencional por el incumplimiento de cualquiera de las partes a las obligaciones contraídas
			en el presente contrato, el 10 % del precio total de la operación para la parte que incumpla.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA SEGUNDA.-</span>EI consumidor deberá de recoger el vehículo en la fecha y lugar establecida en el presente contrato, en un plazo
			máximo de 48 horas a partir de la fecha señalada para la entrega, o en su caso, a partir de la entrega del presupuesto de reparación y/o
			diagnostico si éste no es aceptado por EL CONSUMIDOR para llevar a cabo los trabajos por parte del PROVEEDOR. De no hacerlo, el
			consumidor pagará al PROVEEDOR por concepto de depósito el equivalente a un salario mínimo vigente por cada 24 horas que el vehículo
			permanezca en el establecimiento del PROVEEDOR. Si al trascurrir ____ días naturales a partir la fecha señalada para la entrega del
			vehículo o de la negativa del CONSUMIDOR para llevar a cabo los trabajos presupuestados, El CONSUMIDOR acepta y autoriza mediante
			la firma del presente contrato que el vehículo sea puesto a disposición de las autoridades correspondientes o sea llevado a un depósito
			vehicular, para el caso será EL CONSUMIDOR quien asuma los gastos costas y las consecuencias legales y administrativas que de ello se
			deriven, El CONSUMIDOR deslinda a EL PROVEEDOR de toda responsabilidad por tal motivo. Sin perjuicio de lo anterior, EL PROVEEDOR
			podrá realizar el cobro correspondien
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA TERCERA.-</span> EL CONSUMIDOR puede desistirse dentro de 5 días hábiles posteriores a la firma del presente contrato, para
			cancelar la operación, sin responsabilidad y/o penalización alguna . EL PROVEEDOR se obliga a reintegrar las cantidades que EL
			CONSUMIDOR le haya entregado en un plazo de 5 días hábiles posteriores a la solicitud de cancelación, la cancelación no procederá
			cuando EL PROVEEDOR haya realizado compra de refacciones y/o piezas y demás suministros contemplados en el presupuesto. La
			cancelación aplica siempre y cuando EL PROVEEDOR no haya iniciado el servicio objeto del presente contrato. EL CONSUMIDOR pagará
			de manera inmediata y previa entrega del vehículo, el importe de los trabajos realizados, armado y/o desarmado del vehículo que se
			hubiesen realizado para efectos de diagnóstico. Los consumibles como aceites, fluidos, lubricantes que el vehículo hubiese perdido para
			efectos de diagnóstico no serán repuestos por EL PROVEEDOR. Las cancelaciones deberán presentarse por escrito en el domicilio
			señalado en el presente contrato o bien por correo registrado o certificado tomando como fecha de revocación la de recepción para su
			envío.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA CUARTA.-</span>EL PROVEEDOR es responsable ante EL CONSUMIDOR por el incumplimiento de los servicios contratados, aun cuando
			subcontrate con terceros dicha prestación, dicha condición será informada al CONSUMIDOR a la firma del contrato.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA QUINTA.-</span>Cuando se preste el servicio a domicilio, el personal de EL PROVEEDOR debe identificarse plenamente ante EL
			CONSUMIDOR, mediante la presentación del documento que lo acredite para este propósito. En caso de que dicho servicio tenga un costo,
			éste se indicará en el anverso del presente contrato.

		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA SEXTA.-</span>EL CONSUMIDOR libera a EL PROVEEDOR de cualquier responsabilidad que hubiere surgido o pudiese surgir con
			relación al origen, propiedad, posesión o cualquier otro derecho inherente al vehículo, partes o componentes del mismo.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA SÉPTIMA.-</span>EL PROVEEDOR se obliga a observar en lo relativo a información y publicidad, promociones y ofertas a lo dispuesto
			en los capítulos III y IV de la Ley Federal de Protección al Consumidor.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA OCTAVA.-</span>Son causales de terminación del presente contrato sin penalización para ninguna de las partes: a) El cumplimiento de
			las partes a sus obligaciones contraídas en el presente contrato. b) La imposibilidad de las partes para su cumplimiento por causas de
			fuerza mayor como desastres naturales, restricciones de las autoridades para la prestación de los servicios por parte del PROVEEDOR.
			Son causales de terminación del presente contrato con penalización para ambas partes: a: I. Que EL PROVEEDOR incumpla en la fecha y
			lugar de entrega del vehículo por causas imputables a él. II. Que EL CONSUMIDOR incumpla con su obligación de pago.
			La parte que corresponda notificará a la que hubiese incurrido en incumplimiento de su obligación, por escrito en el domicilio señalado en
			el presente para tales efectos dentro de los 5 días posteriores a la fecha señalada para cumplimiento de su obligación. La parte que
			incumplió deberá hacer el pago dentro de 5 (cinco) días hábiles siguientes de haber recibido dicha solicitud por escrito.
			Se establece como pena convencional por el Incumplimiento de cualquiera de las partes a las obligaciones contraídas en el presente
			Contrato, el 10 % (diez por ciento) del precio total de la prestación del Servicio de reparación o mantenimiento del vehículo sin incluir el
			Impuesto al Valor Agregado (IVA). En el evento que la parte obligada incumpla con el pago de pena convencional deberá cubrir a favor de
			la otra el 10% mensual sobre saldos insolutos y por los días efectivamente devengados.
		</div>
		<div class="clausula">
			<span class="text_centrado negritas">DÉCIMA NOVENA.-</span>AVISO DE PRIVACIDAD.- Previo a la firma del presente Contrato y en cumplimiento a lo dispuesto en la Ley Federal
			de Protección de Datos Personales en Posesión de los Particulares, EL PROVEEDOR hizo del conocimiento al CONSUMIDOR el aviso de
			privacidad, así como el procedimiento para ejercer sus derechos de acceso, rectificación, cancelación y oposición al tratamiento de sus datos
			personales en adelante, derechos ARCO
		</div>
		<div class="clausula">
			AUTORIZACIÓN PARA LA UTILIZACIÓN DE INFORMACIÓN CON FINES MERCADOTÉCNICOS O PUBLICITARIOS EL CONSUMIDOR
			SI ( ) NO ( ) ACEPTA QUE LA AGENCIA CEDA O TRANSMITA A TERCEROS, CON FINES MERCADOTÉCNICOS O PUBLICITARIOS, LA
			INFORMACIÓN PROPORCIONADA POR ÉL CON MOTIVO DEL PRESENTE CONTRATO Y SI ( ) NO ( ) ACEPTA QUE LA AGENCIA LE
			ENVÍE PUBLICIDAD SOBRE BIENES Y SERVICIOS.
		</div>
		<div class="clausula">
			La Procuraduría Federal del Consumidor es competente en la vía administrativa para resolver cualquier controversia que se suscite sobre la
			interpretación o cumplimiento del presente contrato. Sin perjuicio de lo anterior, las partes se someten a la jurisdicción de los Tribunales
			competentes en Morelia, Michoacán, renunciando expresamente a cualquier otra jurisdicción que pudiera corresponderles, por razón de sus
			domicilios presentes o futuros o por cualquier otra razón. Leído que fue por las partes el contenido del presente contrato y sabedoras de su
			alcance legal, lo firman por duplicado en la Ciudad de <?= $sucursal["dom_ciudad"] ?> a los <?= date("d") ?> días de mes de <?= date("m") ?> del año <?= date("Y") ?>.
		</div>
		<div class="row seccion_firmas">
			<div class="col-1_2 text_centrado">
				<div class="contenedor_firma"><img src="<?= $asesor["firma_electronica"] ?>" class="firma_cliente" alt="firma del cliente"></div>
				<div class="linea_firma">El PROVEEDOR</div>
			</div>
			<div class="col-2_2 text_centrado">
				<div class="contenedor_firma"><img src="<?= $firma_cliente["firma"] ?>" class="firma_cliente" alt="firma del cliente"></div>
				<div class="linea_firma">El CONSUMIDOR</div>
			</div>
		</div>
		<div class="negritas">
			Este contrato fue aprobado y registrado por la Procuraduría Federal del Consumidor bajo el número 3471-2022 de fecha 10 de agosto
			de 2022. Cualquier variación del presente contrato en perjuicio de EL CONSUMIDOR, frente al contrato de adhesión registrado, se
			tendrá por no puesta.
		</div>
	</div>
</body>

</html>