<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orden de Servicio</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            color: #0a2961;
            padding: 20px;
        }
        p {
            color: #0a2961 !important;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            padding: 20px;
            border: 2px solid #1c3b6c;
            border-radius: 8px;
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        .highlight {
            font-weight: bold;
            color: #1c3b6c;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
    <?php 
    setlocale(LC_TIME, 'es_ES.UTF-8', 'Spanish_Spain.1252');
    $fecha_obj = DateTime::createFromFormat('d/m/Y', $orden['fecha']);
    $formatoEnTexto = strftime('%e de %B de %Y', $fecha_obj->getTimestamp());
    ?>
        <p>Estimado/a Cliente, <span class="bold"><?= $cliente['nombre'] ?></span>:</p>
        <p>Ponemos a su disposición una copia de la <span class="highlight">Orden de Servicio</span> (ver archivo PDF adjunto 📎) creada el día: <span class="highlight"><?= $formatoEnTexto ?></span>.</p>
        <p>Sin más por el momento, agradecemos su visita al Taller de <?= $sucursal['Nombre'] ?>.</p>
        <br>
        <p>Le atendió:<br>
        <span class="bold"><?= $orden['nombreAsesor'] ?></span> (Asesor)<br>
        <span class="highlight">Servicio <?= $sucursal['Nombre'] ?></span></p>
    </div>
</body>
</html>
