<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Reporte Ordenes Recepcion</title>
	<style>
		* {font-family: Helvetica Neue, Arial, sans-serif; }
		table {
		  text-align: center;
		  line-height: 40px;
		  border-collapse: separate;
		  border-spacing: 0;
		  width: 100%;
		  margin: 50px auto;
		  font-size: 10px;
		  font-style: normal;
		  font-weight: normal;
		}
		td{
			font-size: 8px;
			text-align: center;
		}
		.sucursal{
			border: 1px solid black !important;
		}
		.totales{
			border-top: 1px solid black !important;
			border-bottom: 1px solid black !important;
		}
	</style>
</head>
<body>
	<table border="0">
		<thead>
			<tr>
				<th>Sucursal</th>
				<th>Fecha Generación</th>
				<th>Orden</th>
				<th>Vin</th>
				<th>Cliente</th>
				<th>Tipo</th>
				<th>Asesor</th>
				<th>Estatus</th>
				<th>Fotos</th> 	
			</tr>
		</thead>
		<?php
			$sucursal = null;
			$total = 0;
			$afectadas = 0;
			$borradores = 0;
		 ?>
		<tbody>
			<?php foreach ($ordenes as $key => $orden): ?>
				
				<?php if ($sucursal != $orden['SucursalNombre']): ?>
					<?php  $sucursal = $orden['SucursalNombre'];?>
					<tr ><td class="sucursal" colspan="9"><?=$orden['SucursalNombre'];?></td></tr>
				<?php endif ?>
				<tr>
					<td><?=$orden['SucursalNombre'];?></td>
					<td><?=$orden['FechaEmision'];?></td>
					<td><?=$orden['MovID'] ? $orden['MovID'] : '-';?></td>
					<td><?=$orden['Vin'];?></td>
					<td><?=$orden['Cliente'];?></td>
					<td><?=$orden['TipoOrden'];?></td>
					<td><?=$orden['Asesor'];?></td>
					<td><?=$orden['Estatus'];?></td>
					<td><?=$orden['Fotos'] > 0 ? 'Tienen '.$orden['Fotos'].($orden['Fotos'] > 1 ? 'fotos' : 'foto' ) : 'Sin fotos';?></td>
				</tr>
				<?php if ($key == sizeof($ordenes)-1 || ($sucursal != $ordenes[$key+1]['SucursalNombre']) ): ?>
					<?php $totales = array_filter($ordenes, function($val) use($sucursal){return $val['SucursalNombre'] == $sucursal;}); ?>
					<?php
						$total += sizeof($totales);
						$afectadas += sizeof(array_filter($totales, function($val) {return $val['MovID'];}));
						$borradores += sizeof(array_filter($totales, function($val) {return !$val['MovID'];}));
					?>
					<tr>
						<td class="totales" colspan="9">
							Total ordenes : <?= sizeof($totales); ?>
							Afectadas: <?= sizeof(array_filter($totales, function($val) {return $val['MovID'];})); ?>
							Borradores: <?= sizeof(array_filter($totales, function($val) {return !$val['MovID'];})); ?>
						</td>
					</tr>
				<?php endif ?>
			<?php endforeach ?>
		</tbody>
		<tfooter>
			<tr>
				<th colspan="9" class="totales">
					Total ordenes : <?= $total; ?>
					Afectadas: <?= $afectadas; ?>
					Borradores: <?= $borradores; ?>
				</th>
			</tr>
		</tfooter>
	</table>
</body>
</html>