<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once dirname(__FILE__) . '/tcpdf/tcpdf.php';

class MYTCPDF extends TCPDF
{
    function __construct($orientation = 'P',$unit = 'mm',$format = 'A4',$unicode = true, $encoding = 'UTF-8',$diskcache = false)
    {
        $this->ci =& get_instance();
        parent::__construct($orientation,$unit,$format,$unicode, $encoding,$diskcache);
    }
    //Page header
    public function Header() {
        // Logo
        $image_file =  $this->ci->config->item('ConfigAssets').'logo.png';
        $this->Image($image_file, 10, 15, 20, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 8);
        // Title
        $this->Cell(0, 15, 'Reporte órdenes generadas en Recepción', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'B', 6);
        $this->Cell(0, 15, $this->ci->config->item('ConfigNombre'), 0, false, 'R', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}