<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2015-08-03 17:19
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: PaquetesModel.php
*    Type: Model
*    Description: This model manage the SQL for the Paquetes
*/

class  PaquetesModel extends CI_Model
{

	public function datos_usuario()
	{
		return $this->db->select("*")->from("ctrl_usuario")->where("id", $this->session->userdata("id_usuario"))->get()->row_array();
	}

	public function actualizar_vendedor($data=null)
	{
		$usuario['nombre'] = $data["nombre"];
		$usuario['apellido_paterno'] = $data['apellido_paterno'];
		$usuario['apellido_materno'] = $data['apellido_materno'];
		if($data['pass'] != "" && $data['pass'] != null)
			$usuario['password'] = sha1($this->config->item('encryption_key').''.$data['pass']);

		$this->db->trans_start();

		$this->db->where("id", $this->session->userdata('id_usuario'));
		$this->db->update("ctrl_usuario", $usuario);

		$this->db->trans_complete();

		if($this->db->trans_status() == true){
			$ret['saved'] = "ok";
			$this->session->set_userdata('nombre', $data["nombre"]);
			$this->session->set_userdata('apellido_paterno', $data["apellido_paterno"]);
			$this->session->set_userdata('apellido_materno', $data["apellido_materno"]);
			$ret['nom'] = $data["nombre"];
			$ret['ap_p'] = $data["apellido_paterno"];
		}
		else
			$ret['saved'] = "ko";

		return $ret;
	}

	public function cat_TipoPaquete()
	{
		return $this->db->select("csd.Descripcion, csd.Alias")->from("cat_sistema_detalle AS csd")
			->join("cat_sistema", "csd.id_cat_sistema = cat_sistema.id")
			->where("cat_sistema.Nombre", "TipoPaquete")->where("csd.eliminado", 0)
			->get()->result_array();
	}

	/*public function Articulos()
	{
		return $this->db->select("Articulo AS Articulo, Descripcion1 AS Descripcion, Tipo AS Tipo")->from("dms_art")
						->where_in("tipo", ["Servicio", "Normal"])
						->where("Estatus", "ALTA")
						->limit(20)
				->get()->result_array();
		// return $this->db->select("Articulo, Descripcion1, Tipo")->from("dms_art")->where_in("tipo", ["Servicio"])->where("Estatus", "ALTA")->get()->result_array();
	}*/

	public function GuardaPaquete($data)
	{
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		$idPaquete = $db_intelisis->select("id")->from($tabla_ServicioPaquetes)->where("id", $data['idPaquete'])->get()->row_array();

		$fields['DescripcionC'] = $data['Nombre'];
		$fields['DescripcionL'] = $data['Descripcion'];
		$fields['TipoPaquete'] = $data['STipoPaquete'];
		// $fields['TipoArticulo'] = $data['TipoArticulo'];
		$fields['kilometraje'] = $data['Kilometraje'];
		$fields['Precio'] = $data['Precio'];
		$fields['TipoPrecio'] = $data['TipoPrecio'];
		$fields['Prorrateo'] = $data['Prorrateo'];
		$fields['TTabulador'] = $data['TTabulador'];
		$fields['TFacturado'] = $data['TFacturado'];
		$fields['ClavePlanta'] = $data['ClavePlanta'];
		$fields['Estatus'] = 1;
		$fields['Actualizacion'] = date("d-m-Y H:i:s");

		$db_intelisis->trans_start();
			if(!$idPaquete){
				$db_intelisis->insert($tabla_ServicioPaquetes, $fields);
				$ret['id_paquet'] = $db_intelisis->insert_id();
			}else{
				$db_intelisis->where('id', $idPaquete['id']);
				$db_intelisis->update($tabla_ServicioPaquetes, $fields);
				$ret['id_paquet'] = $idPaquete['id'];

				$db_intelisis->where('IdPaquete', $idPaquete['id']);
				$db_intelisis->delete($tabla_ServicioPaquetesD);
			}

			// insertar registros de cada articulo
			foreach ( $data[ 'renglones' ] as $renglon )
				$db_intelisis->insert( $tabla_ServicioPaquetesD, [
					'IdPaquete'             => $ret['id_paquet'],
					'Renglon'      			=> $renglon[ 'renglon' ],
					'Articulo'  			=> $renglon[ 'articulo' ],
					'SubtipoCuenta'         => $renglon[ 'supt_cuenta' ],
					'Cantidad'          	=> $renglon[ 'cantidad' ],
					'TTabulado'         	=> $renglon[ 'tmp_tabulador' ],
					'AlmacenEsp'      		=> $renglon[ 'alm_especial' ],
					'ListaPreciosEsp'       => $renglon[ 'lis_pre_esp' ],
					'PrecioUnitario'        => $renglon[ 'pre_unit' ],
					'Actualizacion' 		=> date( 'd-m-Y H:i:s' ),
					'TipoArticulo'          => $renglon[ 'tipo_articulo' ],
					'Descripcion'  			=> $renglon[ 'descripcion' ]
					]);

		$db_intelisis->trans_complete();

		if($db_intelisis->trans_status() == true)
			$ret['saved'] = 'ok';
		else
			$ret['saved'] = 'ko';
		if($idPaquete)
			$ret['saved'] = 'ok_act';
		return $ret;
	}

	public function AsignaPaquete($data)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		$idPaquete = $db_intelisis->select("IdPaquete")->from($tabla_ServicioPaquetesR)->where("IdPaquete", $data['idPaquete'])->get()->row_array();
		$db_intelisis->trans_start();
			if($idPaquete){
				$db_intelisis->where('IdPaquete', $idPaquete['IdPaquete']);
				$db_intelisis->delete($tabla_ServicioPaquetesR);
			}

			// insertar reglas de la tabla
			foreach ( $data[ 'renglones' ] as $renglon ){
				// Asigna Articulos
				$detalle_regla = null;
				$detalle_regla = preg_split("/[,]+/", $renglon[ 'articulo' ]);
				while (count($detalle_regla) > 0) {
					$db_intelisis->insert( $tabla_ServicioPaquetesR, [
						'IdPaquete'             => $data['idPaquete'],
						'Regla'      			=> $renglon[ 'regla' ],
						'Condicion'  			=> "Articulo",
						'Definicion'  			=> array_pop($detalle_regla),
						'Actualizacion' 		=> date( 'd-m-Y H:i:s' )
						]);
				}
				// Asigna Modelos
				$detalle_regla = null;
				$detalle_regla = preg_split("/[,]+/", $renglon[ 'modelo' ]);
				while (count($detalle_regla) > 0) {
					$db_intelisis->insert( $tabla_ServicioPaquetesR, [
						'IdPaquete'             => $data['idPaquete'],
						'Regla'      			=> $renglon[ 'regla' ],
						'Condicion'  			=> "Modelo",
						'Definicion'  			=> array_pop($detalle_regla),
						'Actualizacion' 		=> date( 'd-m-Y H:i:s' )
						]);
				}
				// Asigna Cilindros
				$detalle_regla = null;
				$detalle_regla = preg_split("/[,]+/", $renglon[ 'cilindros' ]);
				while (count($detalle_regla) > 0) {
					$db_intelisis->insert( $tabla_ServicioPaquetesR, [
						'IdPaquete'             => $data['idPaquete'],
						'Regla'      			=> $renglon[ 'regla' ],
						'Condicion'  			=> "Cilindros",
						'Definicion'  			=> array_pop($detalle_regla),
						'Actualizacion' 		=> date( 'd-m-Y H:i:s' )
						]);
				}
				// Asigna Transmision
				$detalle_regla = null;
				$detalle_regla = preg_split("/[,]+/", $renglon[ 'transmision' ]);
				while (count($detalle_regla) > 0) {
					$db_intelisis->insert( $tabla_ServicioPaquetesR, [
						'IdPaquete'             => $data['idPaquete'],
						'Regla'      			=> $renglon[ 'regla' ],
						'Condicion'  			=> "Transmision",
						'Definicion'  			=> array_pop($detalle_regla),
						'Actualizacion' 		=> date( 'd-m-Y H:i:s' )
						]);
				}
				// Asigna Motor
				$detalle_regla = null;
				$detalle_regla = preg_split("/[,]+/", $renglon[ 'motor' ]);
				while (count($detalle_regla) > 0) {
					$db_intelisis->insert( $tabla_ServicioPaquetesR, [
						'IdPaquete'             => $data['idPaquete'],
						'Regla'      			=> $renglon[ 'regla' ],
						'Condicion'  			=> "Motor",
						'Definicion'  			=> array_pop($detalle_regla),
						'Actualizacion' 		=> date( 'd-m-Y H:i:s' )
						]);
				}
			}
		$db_intelisis->trans_complete();

		$ret['id_paquet'] = $data['idPaquete'];

		if($db_intelisis->trans_status() == true)
			$ret['saved'] = 'ok';
		else
			$ret['saved'] = 'ko';
		if($idPaquete)
			$ret['saved'] = 'ok_act';
		return $ret;
	}

	public function catalogo_articulos()
	{
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		if( $this->session->userdata("sw") == 1 ){
			return $this->db->select("Articulo, Descripcion1")->from($view_dms_art)->where("tipo", "VIN")->where("Estatus", "ALTA")->where("Id_Ag", $this->session->userdata('id_ag'))->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			return $db_intelisis->select("Articulo, Descripcion1")->from($view_dms_art)->where("tipo", "VIN")->where("Estatus", "ALTA")
			//->where("Id_Ag", $this->session->userdata('id_ag'))
			->get()->result_array();	//<--- Conexion sin servicios web
		}
	}

	public function catalogo_cilindros()
	{
		if( $this->session->userdata("sw") == 1 ){
			return $this->db->select("dcd.Descripcion")
			->from("dms_catalogo_detalle AS dcd")
			->join("dms_catalogo", "dcd.id_catalogo = dms_catalogo.id")
			->where("dms_catalogo.Catalogo", "Cilindros")
			->where("dms_catalogo.eliminado", 0)->where("dcd.eliminado", 0)
			->where("dcd.Id_Ag", $this->session->userdata('id_ag'))
			->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			return $db_intelisis->select("DISTINCT(Cilindros) AS Descripcion")->from("VIN")->order_by("Cilindros")->get()->result_array(); //<--- Conexion sin servicios web
		}
	}

	public function catalogo_transmision()
	{
		if( $this->session->userdata("sw") == 1 ){
			return $this->db->select("dcd.Descripcion")
			->from("dms_catalogo_detalle AS dcd")
			->join("dms_catalogo", "dcd.id_catalogo = dms_catalogo.id")
			->where("dms_catalogo.Catalogo", "Transmision")
			->where("dms_catalogo.eliminado", 0)->where("dcd.eliminado", 0)
			->where("dcd.Id_Ag", $this->session->userdata('id_ag'))
			->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			return $db_intelisis->select("DISTINCT(Transmision) AS Descripcion")->from("VIN")->order_by("Transmision")->get()->result_array(); //<--- Conexion sin servicios web
		}
	}

	public function catalogo_motor()
	{
		if( $this->session->userdata("sw") == 1 ){
			return $this->db->select("dcd.Descripcion")
			->from("dms_catalogo_detalle AS dcd")
			->join("dms_catalogo", "dcd.id_catalogo = dms_catalogo.id")
			->where("dms_catalogo.Catalogo", "Motor")
			->where("dms_catalogo.eliminado", 0)->where("dcd.eliminado", 0)
			->where("dcd.Id_Ag", $this->session->userdata('id_ag'))
			->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			return $db_intelisis->query('SELECT TOP 0 Motor AS Descripcion FROM VIN')->result_array();
			// return $db_intelisis->select('TOP 0 Motor AS Descripcion')->from("VIN")->order_by("Motor")->get()->result_array();
			// return $db_intelisis->select("DISTINCT(Motor) AS Descripcion")->from("VIN")->order_by("Motor")->get()->result_array(); //<--- Conexion sin servicios web
		}
	}

	public function RegresaPaquetes()
	{
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		// return $db_intelisis->select("*")->from("PaquetesWebListado")->order_by("Id", "desc")->get()->result_array();
		return $db_intelisis->select("(SELECT COUNT(Renglon) FROM ".$tabla_ServicioPaquetesD." WHERE IdPaquete = ".$tabla_ServicioPaquetes.".Id) AS Detalle, (SELECT COUNT(IdPaquete) FROM {$tabla_ServicioPaquetesR} WHERE IdPaquete = ".$tabla_ServicioPaquetes.".Id) AS Configurado, *")
			->from($tabla_ServicioPaquetes)->where_in("Estatus", [1, 2])->order_by("Id", "desc")->get()->result_array();
	}

	public function DetallePaquete($id_paquete)
	{
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		// return $this->db->select("ServicioPaquetesD.*, dms_art.Descripcion1 as Descrip")->from("ServicioPaquetesD")->join("dms_art", "ServicioPaquetesD.Articulo = dms_art.Articulo")->where("ServicioPaquetesD.IdPaquete", $id_paquete)->order_by("ServicioPaquetesD.Renglon", "desc")->get()->result_array();
		return $db_intelisis->select("*")->from($tabla_ServicioPaquetesD)->where("IdPaquete", $id_paquete)->order_by("Renglon", "desc")->get()->result_array();
	}

	public function ObtienePaquete($id_paquete)
	{
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		return $db_intelisis->select("*")->from($tabla_ServicioPaquetes)->where("Id", $id_paquete)->where_in("Estatus", [1, 2])->get()->row_array();
	}

	public function AsignadoAPaquete($id_paquete)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		return $db_intelisis->select("*")->from($tabla_ServicioPaquetesR)->where("IdPaquete", $id_paquete)->order_by("Definicion", "asc")->get()->result_array();
	}

	public function ReglasPaquete($id_paquete)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		return $db_intelisis->select("MAX(Regla) AS Reglas")->from($tabla_ServicioPaquetesR)->where("IdPaquete", $id_paquete)->get()->row_array();
	}

	public function NomPaquete($id_paquete=null)
	{
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		return $db_intelisis->select("DescripcionC")->from($tabla_ServicioPaquetes)->where("id", $id_paquete)->get()->row_array();
	}

	public function autocompleteArt($Cve_Art)
	{
		// $xxx = $this->db->select("TOP 12 Articulo")->from("dms_art")->like('Articulo', $Cve_Art['Cve_Art'])->get()->result_array();
		// print_r($xxx["Articulo"]);
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		if( $this->session->userdata("sw") == 1 ){
			$data["suggestions"] = $this->db->limit(12)->select("Articulo AS value, Articulo AS data")->from($view_dms_art)->where('Tipo', 'VIN')->where('Estatus', 'ALTA')->like('Articulo', $Cve_Art['Cve_Art'])->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			$data["suggestions"] = $db_intelisis->limit(12)->select("Articulo AS value, Articulo AS data")->from($view_dms_art)->where('Tipo', 'VIN')->where('Estatus', 'ALTA')->like('Articulo', $Cve_Art['Cve_Art'])->get()->result_array();	//<--- Conexion sin servicios web
		}

		// echo $this->db->last_query();
		// echo "var->".$Cve_Art."<-";
		return $data;
	}

	public function autocompleteArtPkt($Cve_Art)
	{
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		if( $this->session->userdata("sw") == 1 ){
			$data["suggestions"] = $this->db->limit(10)->select("Articulo AS value, Descripcion1 AS data, Tipo AS tipo")->from($view_dms_art)->where_in("tipo", ["Servicio", "Normal"])->where("Estatus", "ALTA")->like('Articulo', $Cve_Art['Cve_Art'])->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			$data["suggestions"] = $db_intelisis->limit(10)->select("Articulo AS value, Descripcion1 AS data, Tipo AS tipo")->from($view_dms_art)->where_in("tipo", ["Servicio", "Normal"])->where("Estatus", "ALTA")->like('Articulo', $Cve_Art['Cve_Art'])->get()->result_array();	//<--- Conexion sin servicios web
		}
		
		
		
		return $data;
	}

	public function FltrPkts($CveArtPkt)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		// echo "var->".$CveArtPkt."<-";
		$PktsValidos = $db_intelisis->select("DISTINCT (IdPaquete)")->from($tabla_ServicioPaquetesR)
									->where_in("Definicion", [$CveArtPkt, "Todos"])
									->where("Condicion", "Articulo")
								->get();
		// echo "var->".$db_intelisis->last_query()."<-";
		$PktVal = array();
		foreach ($PktsValidos->result_array() as $row)
		{
		   array_push($PktVal, $row['IdPaquete']);
		}

		return $db_intelisis->select("(SELECT COUNT(Renglon) FROM ".$tabla_ServicioPaquetesD." WHERE IdPaquete = ".$tabla_ServicioPaquetes.".Id) AS Detalle, (SELECT COUNT(IdPaquete) FROM {$tabla_ServicioPaquetesR} WHERE IdPaquete = ".$tabla_ServicioPaquetes.".Id) AS Configurado, *")
			->from($tabla_ServicioPaquetes)->where_in("Id", $PktVal)->where_in("Estatus", [1, 2])->order_by("Id", "asc")->get()->result_array();
	}

	public function readercsv($result)
	{
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
		// $this->load->dbforge();
		// $db_intelisis->create_table('#CargaPcksTemp');
		$db_intelisis->trans_start();
			// $db_intelisis->query('CREATE TABLE ##CargaPcksTemp (vehiculo VARCHAR(100), clave_pck VARCHAR(100), pck VARCHAR(100), parte VARCHAR(100), cantidad FLOAT, precio money)');
			// $db_intelisis->query("INSERT INTO CargaPcksTemp ( vehiculo, clave_pck, pck, parte, cantidad, precio) VALUES('AVEO', 'S5', 'S5AVEO-14-15', 'CADX', '0.5', '217.5')");
			foreach ( $result as $renglon )
				$db_intelisis->insert( 'CargaPcksTemp', $renglon);
			// $rettt = $db_intelisis->query("SELECT * FROM #CargaPcksTemp");
		$db_intelisis->trans_complete();
		// if($db_intelisis->trans_status() == true)
		// 	echo 'ok';
		// else
		// 	echo 'ko';
		// echo "var->".$result["rettt"]."<-";
		/*$fields = array(
				'vehiculo' => array('type' => 'VARCHAR(100)'),
				'clave_pck' => array('type' => 'VARCHAR(100)'),
				'pck' => array('type' => 'VARCHAR(100)'),
				'parte' => array('type' => 'VARCHAR(100)'),
				'cantidad' => array('type' => 'FLOAT'),
				'precio' => array('type' => 'money')
			);*/
		// $db_intelisis->add_column('##CargaPcksTemp', $fields);
		return $result;
	}

	public function GenerarExcel($obj_excel, $name)
	{

		$objPHPExcel = new PHPExcel();
		$filename = 'ArchivoPkts.xlsx';
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';

		try { // Verifica que exista el archivo, si no existe lo crea
			$objPHPExcel = PHPExcel_IOFactory::load("assets/PaquetesWeb/ArchivoPkts.xlsx");
		} catch (Exception $e) {
			$New_objPHPExcel = new PHPExcel();
			$New_objPHPExcel->getProperties()->setCreator("Roberto Ortiz");
			$New_objPHPExcel->getProperties()->setTitle("Paquetes Web");
 			$New_objPHPExcel->getProperties()->setLastModifiedBy("Sistema_Paquetes_Web");
 			$New_objPHPExcel->getProperties()->setSubject("Archivo valido para carga de paquetes web");

 			// formato match
			$New_objPHPExcel->getActiveSheet()->setTitle('Match');
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->setCellValue('A1','Estatus (ALTA/BAJA)');
			$New_objPHPExcel->getActiveSheet()->setCellValue('B1','Id Paquete');
			$New_objPHPExcel->getActiveSheet()->setCellValue('C1','Paquetes Existentes');
			$New_objPHPExcel->getActiveSheet()->setCellValue('D1','Actualizar por Paquete');
			$New_objPHPExcel->getActiveSheet()->setCellValue('E1','Paquetes Nuevos');
			$New_objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray(array('font' => array('size' => 12,'bold' => true,'color' => array('rgb' => 'f2f2f2'))));
			$New_objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
			$New_objPHPExcel->getActiveSheet()->getStyle('A1:D1')->getFill()->getStartColor()->setARGB('366092');
			$New_objPHPExcel->getActiveSheet()->getStyle('E1')->getFill()->getStartColor()->setARGB('00b050');

			// formato de rangos
			$New_objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
			$New_objPHPExcel->getActiveSheet()->setCellValue('G2','Rango 1 del Km:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('G3','Al Km:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('G4','Valor en fórmula:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H2','0');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H3','6000');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H4','0');
			
			$New_objPHPExcel->getActiveSheet()->setCellValue('G6','Rango 2 del Km:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('G7','Al Km:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('G8','Valor en fórmula:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H6','6001');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H7','60000');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H8','60');

			$New_objPHPExcel->getActiveSheet()->setCellValue('G10','A partir del Km:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('G11','Valor sin fórmula:');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H10','60001');
			$New_objPHPExcel->getActiveSheet()->setCellValue('H11','50');

			$New_objPHPExcel->getActiveSheet()->getStyle('G1:G11')->applyFromArray(array('font' => array('size' => 11,'bold' => true,'color' => array('rgb' => '000000'))));
			$New_objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
			$New_objPHPExcel->getActiveSheet()->getStyle('H3')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
			$New_objPHPExcel->getActiveSheet()->getStyle('G4:H4')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));
			$New_objPHPExcel->getActiveSheet()->getStyle('H6')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
			$New_objPHPExcel->getActiveSheet()->getStyle('H7')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
			$New_objPHPExcel->getActiveSheet()->getStyle('G8:H8')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));
			$New_objPHPExcel->getActiveSheet()->getStyle('H10')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
			$New_objPHPExcel->getActiveSheet()->getStyle('G11:H11')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));

			// crea el formato
			$New_objPHPExcel->createSheet();
			$New_objPHPExcel->setActiveSheetIndex(1);
			$New_objPHPExcel->getActiveSheet()->setTitle('DMS-MO-REF');
			/*$New_objPHPExcel->createSheet();
			$New_objPHPExcel->setActiveSheetIndex(2);
			$New_objPHPExcel->getActiveSheet()->setTitle('DMS-REF');*/
			$New_objWriter = PHPExcel_IOFactory::createWriter($New_objPHPExcel, 'Excel2007');
			$New_objWriter->save('assets/PaquetesWeb/'.$filename);
			$objPHPExcel = PHPExcel_IOFactory::load("assets/PaquetesWeb/ArchivoPkts.xlsx");
		}
/*print_r($obj_excel->getSheetNames());
die();*/
		$sheets = $obj_excel->getSheetNames();
		if (in_array("DMS-MO", $sheets) && in_array("DMS-REF", $sheets)) {

			/*$clonedWorksheet = clone $obj_excel->getSheetByName('DMS-MO');*/
			// $clonedWorksheet->setTitle('Copy of Worksheet 1');
			// $obj_excel->addSheet($clonedWorksheet);

######### Escribe Archivo ##################

			// $objPHPExcel = PHPExcel_IOFactory::load("assets/PaquetesWeb/GenerarArchivoPkts.xlsx");
			// $objPHPExcel->setActiveSheetIndex(1); // Activa la primer pestaña
/*$clonedWorksheet = $obj_excel->getSheetByName('DMS-MO')->copy();*/
			$objPHPExcel->setActiveSheetIndexByName('DMS-MO-REF');
			$sheetData = $obj_excel->getSheetByName('DMS-MO')->toArray(null,true,true,true);
			
			// $sheetData = array_merge( $sheetData_mo, $sheetData_ref );
			// print_r($sheetData);
			
			// $objPHPExcel->getActiveSheet()->setCellValue('A2','Robert Corw');
			for ($col = 'A'; $col != 'I'; $col++)
				$objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
			foreach ($sheetData as $index => $value) {
				$objPHPExcel->getActiveSheet()->setCellValue('A'.$index, $value['A']);
				$objPHPExcel->getActiveSheet()->setCellValue('B'.$index, $value['B']);
				$objPHPExcel->getActiveSheet()->setCellValue('C'.$index, $value['C']);
				$objPHPExcel->getActiveSheet()->setCellValue('D'.$index, $value['D']);
				$objPHPExcel->getActiveSheet()->setCellValue('E'.$index, $value['E']);
				$objPHPExcel->getActiveSheet()->setCellValue('F'.$index, $value['F']);
				$objPHPExcel->getActiveSheet()->setCellValue('G'.$index, $value['G']);
				$objPHPExcel->getActiveSheet()->setCellValue('H'.$index, $value['H']);
				if ($value['A'] != '')
					$filaActual = $index;
			}
			// $filaActual = sizeof($sheetData);
			// print_r($filaActual);
			// die();
			// $objPHPExcel->setActiveSheetIndexByName('DMS-REF');
			
			// $objPHPExcel->getActiveSheet()->setCellValue('A2','Robert Corw');
			/*for ($col = 'A'; $col != 'I'; $col++)
				$objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);*/
			$sheetData = $obj_excel->getSheetByName('DMS-REF')->toArray(null,true,true,true);
			array_shift($sheetData);
			foreach ($sheetData as $index => $value) {
				$filaActual++;
				$objPHPExcel->getActiveSheet()->setCellValue('A'.$filaActual, $value['A']);
				$objPHPExcel->getActiveSheet()->setCellValue('B'.$filaActual, $value['B']);
				$objPHPExcel->getActiveSheet()->setCellValue('C'.$filaActual, $value['C']);
				$objPHPExcel->getActiveSheet()->setCellValue('D'.$filaActual, $value['D']);
				$objPHPExcel->getActiveSheet()->setCellValue('E'.$filaActual, $value['E']);
				$objPHPExcel->getActiveSheet()->setCellValue('F'.$filaActual, $value['F']);
				$objPHPExcel->getActiveSheet()->setCellValue('G'.$filaActual, $value['G']);
				$objPHPExcel->getActiveSheet()->setCellValue('H'.$filaActual, $value['H']);
			}
			$result['DMS_MO_REF'] = "Ok";
/*
//here template is copied
for ($i=1;$i<8;$i++){
  $sheet2 = clone $sheet1;
  //notice that here sheet is cloned
 //it works and solved problem with memory leaks
  $sheet_title = 'Cloned'.$i;
  $sheet2->setTitle($sheet_title);
 $objPHPExcel->addSheet($sheet2);
 unset($sheet2);
}
unset($sheet1);*/
			/*$objPHPExcel->addSheet($clonedWorksheet);
			unset($clonedWorksheet);*/
			$objPHPExcel->setActiveSheetIndexByName('Match');
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
			$paquete_Sistema = $db_intelisis->select('Id, DescripcionC')->from($tabla_ServicioPaquetes)->where_in("Estatus", [1, 2])->get()->result_array();
			/*print_r($paquete_Sistema);
			die();*/
			foreach ($paquete_Sistema as $index => $value) {
				$objPHPExcel->getActiveSheet()->setCellValue('A'.($index+2), 'ALTA');
				$objPHPExcel->getActiveSheet()->setCellValue('B'.($index+2), '# '.$value['Id']);
				$objPHPExcel->getActiveSheet()->setCellValue('C'.($index+2), $value['DescripcionC']);
			}

			$sheetData_MO = $obj_excel->getSheetByName('DMS-MO')->toArray(null,true,true,true);
			$sheetData_REF = $obj_excel->getSheetByName('DMS-REF')->toArray(null,true,true,true);
			$CodigoPaquete_MO = array_column($sheetData_MO, 'C');	array_shift($CodigoPaquete_MO);
			$CodigoPaquete_REF = array_column($sheetData_REF, 'C');	array_shift($CodigoPaquete_REF);
			$CodigoPaquete = array_merge( $CodigoPaquete_MO, $CodigoPaquete_REF );	//Extrae los codigos de paquetes a insertar de las dos hojas
			$NuevosPaquetes = array_unique($CodigoPaquete);
			$cont = 2;
			$Cve_pkts = array_column($paquete_Sistema, 'DescripcionC');
			/*print_r($Cve_pkts);
			die();*/
			foreach ($NuevosPaquetes as $index => $value) {
				if(in_array($value, $Cve_pkts))
					$objPHPExcel->getActiveSheet()->setCellValue('D'.(array_search($value, $Cve_pkts)+2), $value);
				else{
					$objPHPExcel->getActiveSheet()->setCellValue('E'.($cont), $value);
					$cont++;
				}
			}

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('assets/PaquetesWeb/'.$filename);
			$result['filename'] = $filename;
######### FIN Escribe Archivo ##############

			$result['valid'] = true;
			$result['message'] = 'Datos importados correctamente';
			$result['changes'] = "";
		}else{
			// print_r(count($sheets));
			foreach ($sheets as $key => $sheet) {
				$sheetData = $obj_excel->getSheetByName($sheet)->toArray(null,true,true,true);
				if($sheetData[2]['A'] === 'NOMENCLATURA MATRIZ'){	
					$sheetsPkts = $objPHPExcel->getSheetNames();
					if (!in_array($sheet, $sheetsPkts)) {
						$objPHPExcel->createSheet();
						$objPHPExcel->setActiveSheetIndex($objPHPExcel->getSheetCount()-1);
						$objPHPExcel->getActiveSheet()->setTitle($sheet);
						$New_objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
						$New_objWriter->save('assets/PaquetesWeb/'.$filename);
						$objPHPExcel = PHPExcel_IOFactory::load("assets/PaquetesWeb/ArchivoPkts.xlsx");
					}
					$objPHPExcel->setActiveSheetIndexByName($sheet);
					foreach ($sheetData as $index => $value) {
						foreach ($value as $key => $value2) {
							/*print_r($value2);
							print_r($index);*/
							if (isset($value2) || $value2 != null || $value2 != '') {
								// print_r($key);
								if ($key > 'A' && $index == 1) {
									$objPHPExcel->getActiveSheet()->getStyle($key.'1')->applyFromArray(array('font' => array('size' => 12,'bold' => true,'color' => array('rgb' => 'f2f2f2'))));
									$objPHPExcel->getActiveSheet()->getStyle($key.'1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
									$objPHPExcel->getActiveSheet()->getStyle($key.'1')->getFill()->getStartColor()->setARGB('366092');
								}
								if ($index == 2)
									$objPHPExcel->getActiveSheet()->getColumnDimension($key)->setAutoSize(true);
								if ($key > 'A' && $index == 1 || $index > 1 )
									$objPHPExcel->getActiveSheet()->setCellValue($key.$index, $value2);
							}
						}
						/*$objPHPExcel->getActiveSheet()->setCellValue('C'.$index, $value['C']);
						$objPHPExcel->getActiveSheet()->setCellValue('D'.$index, $value['D']);
						$objPHPExcel->getActiveSheet()->setCellValue('E'.$index, $value['E']);
						$objPHPExcel->getActiveSheet()->setCellValue('F'.$index, $value['F']);
						$objPHPExcel->getActiveSheet()->setCellValue('G'.$index, $value['G']);
						$objPHPExcel->getActiveSheet()->setCellValue('H'.$index, $value['H']);
						$objPHPExcel->getActiveSheet()->setCellValue('I'.$index, $value['I']);
						$objPHPExcel->getActiveSheet()->setCellValue('J'.$index, $value['J']);
						$objPHPExcel->getActiveSheet()->setCellValue('K'.$index, $value['K']);
						$objPHPExcel->getActiveSheet()->setCellValue('L'.$index, $value['L']);*/
					}
					$result['STANDARD_PRICES'] = "Ok";
					$objPHPExcel->setActiveSheetIndexByName('Match');
					$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
					// ob_end_clean();
					$objWriter->save('assets/PaquetesWeb/'.$filename);
					$result['filename'] = $filename;

					$result['valid'] = true;
					$result['message'] = 'Datos importados correctamente';
					$result['changes'] = "";
				}else{
					$result['valid'] = false;
            		$result['message'] = 'Pestaña "DMS-MO" Y/o "DMS-REF" no encontrada en archivo: <strong>'.$name."</strong></br>(Verifica que no contentenga espacios en el nombre).";
				}
				/*
				print_r($sheetData);*/
				/*foreach ($sheetData as $index => $value) {
					$objPHPExcel->getActiveSheet()->setCellValue('A'.$index, $value['A']);
				}*/
			}
			// die();
		}

		return $result;
	}

	public function LimpiaArchivosPktsM()
	{
		$this->load->library('excel');
		$New_objPHPExcel = new PHPExcel();
		$filename = 'ArchivoPkts.xlsx';
		$New_objPHPExcel->getProperties()->setCreator("Roberto Ortiz");
		$New_objPHPExcel->getProperties()->setTitle("Paquetes Web");
		$New_objPHPExcel->getProperties()->setLastModifiedBy("Sistema_Paquetes_Web");
		$New_objPHPExcel->getProperties()->setSubject("Archivo valido para carga de paquetes web");

		// formato match
		$New_objPHPExcel->getActiveSheet()->setTitle('Match');
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->setCellValue('A1','Estatus (ALTA/BAJA)');
		$New_objPHPExcel->getActiveSheet()->setCellValue('B1','Id Paquete');
		$New_objPHPExcel->getActiveSheet()->setCellValue('C1','Paquetes Existentes');
		$New_objPHPExcel->getActiveSheet()->setCellValue('D1','Actualizar por Paquete');
		$New_objPHPExcel->getActiveSheet()->setCellValue('E1','Paquetes Nuevos');
		$New_objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray(array('font' => array('size' => 12,'bold' => true,'color' => array('rgb' => 'f2f2f2'))));
		$New_objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
		$New_objPHPExcel->getActiveSheet()->getStyle('A1:D1')->getFill()->getStartColor()->setARGB('366092');
		$New_objPHPExcel->getActiveSheet()->getStyle('E1')->getFill()->getStartColor()->setARGB('00b050');
		
		// formato de rangos
		$New_objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$New_objPHPExcel->getActiveSheet()->setCellValue('G2','Rango 1 del Km:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('G3','Al Km:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('G4','Valor en fórmula:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H2','0');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H3','6000');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H4','0');
		
		$New_objPHPExcel->getActiveSheet()->setCellValue('G6','Rango 2 del Km:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('G7','Al Km:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('G8','Valor en fórmula:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H6','6001');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H7','60000');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H8','60');

		$New_objPHPExcel->getActiveSheet()->setCellValue('G10','A partir del Km:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('G11','Valor sin fórmula:');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H10','60001');
		$New_objPHPExcel->getActiveSheet()->setCellValue('H11','50');

		$New_objPHPExcel->getActiveSheet()->getStyle('G1:G11')->applyFromArray(array('font' => array('size' => 11,'bold' => true,'color' => array('rgb' => '000000'))));
		$New_objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
		$New_objPHPExcel->getActiveSheet()->getStyle('H3')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
		$New_objPHPExcel->getActiveSheet()->getStyle('G4:H4')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));
		$New_objPHPExcel->getActiveSheet()->getStyle('H6')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
		$New_objPHPExcel->getActiveSheet()->getStyle('H7')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
		$New_objPHPExcel->getActiveSheet()->getStyle('G8:H8')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));
		$New_objPHPExcel->getActiveSheet()->getStyle('H10')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN))));
		$New_objPHPExcel->getActiveSheet()->getStyle('G11:H11')->applyFromArray(array('borders' => array('bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOUBLE))));
		
		// crea formato
		$New_objPHPExcel->createSheet();
		$New_objPHPExcel->setActiveSheetIndex(1);
		$New_objPHPExcel->getActiveSheet()->setTitle('DMS-MO-REF');
		
		/*$New_objPHPExcel->createSheet();
		$New_objPHPExcel->setActiveSheetIndex(2);
		$New_objPHPExcel->getActiveSheet()->setTitle('DMS-REF');*/
		
		$New_objPHPExcel->setActiveSheetIndexByName('Match');
		$New_objWriter = PHPExcel_IOFactory::createWriter($New_objPHPExcel, 'Excel2007');
		$New_objWriter->save('assets/PaquetesWeb/'.$filename);

		return 0;
	}

	public function importarExcelV2($obj_excel, $name, $TipoPkt)
	{
		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);

		$Rangos = array();

		$sheets = $obj_excel->getSheetNames();	//Obtener los nombres de las hojas
		//<--- Rules --->
		if ( in_array("Reglas", $sheets) )														//<--- Pestaña Reglas
			return $this->ImportarReglas($obj_excel, $name, $db_intelisis);
		//<--- FORD --->
		if ( in_array("Ford", $sheets) )														//<--- Pestaña Ford
			return $this->ImportarFord($obj_excel, $name, $TipoPkt, $db_intelisis);
		//<--- GM --->
		if ( in_array("Match", $sheets) ) 														//<--- Pestaña Match
			$Rangos = $this->ImportarMarchGM($Rangos, $obj_excel, $db_intelisis);
		foreach ($sheets as $key => $sheet)														//<--- Todas las Pestañas buscando "NOMENCLATURA MATRIZ" en A2
			$this->ImportarHomologacionGM($sheet, $obj_excel, $db_intelisis);
		if ( in_array("DMS-MO-REF", $sheets) )													//<--- Pestaña DMS-MO-REF
			return $this->ImportarMORefGM($obj_excel, $name, $TipoPkt, $Rangos, $db_intelisis);
		else{
            $result['valid'] = false;
            $result['message'] = 'Pestaña "DMS-MO-REF" no encontrada en archivo: <strong>'.$name."</strong>";
            return $result;
        }

	}

 	public function importarExcel($obj_excel, $name, $TipoPkt)
	{
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
 		$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);
 		$inserts = "";
         $updats = "";
         $ArticulosNoExistentes = "";
         $indexinsert = 0;
         $indexupdat = 0;
         $PaquetesExcel = array();

         $sheets = $obj_excel->getSheetNames();

         if (in_array("GLOBAL", $sheets)) {
             // $obj_excel->getSheetByName('GLOBAL');
             // $sheetData = $obj_excel->getActiveSheet()->toArray(null,true,true,true);
             $sheetData = $obj_excel->getSheetByName('GLOBAL')->toArray(null,true,true,true);
             $arr_datos = array();
             // **********INSERTA PAQUETES DEL ARCHIVO**********
             foreach ($sheetData as $index => $value) {            
                 if ( $index != 1 && isset( $value['A'] ) && isset( $value['C'] ) ){
                 	if (!in_array($value['C'], $PaquetesExcel)) {
 					    array_push($PaquetesExcel, $value['C']);

 // ########################## CLAVES DE PAQUETES DESDE ARCHIVO ########################################
 /*print_r($value['A'].' -> ');
 // print_r(substr($value['A'], -3).' | ');
 $x = substr($value['A'], -3);
 // print_r( ' >' . substr($x, 1, 1) . '< ');
 if ( substr($x, 0, 1) === '-' ){
     print_r('Valido para 2 años | ');
 }else if ( substr($x, 1, 1) === '.' ){
     print_r('Valido para 1/2 año | ');
 }else{
 	print_r('Valido para 1 año | ');
 }*/
 // ####################################################################################################
 	                	$arr_datos = array(
 	                    	'DescripcionC'	=> $value['C'],
 							'DescripcionL'	=> $value['E'],
 							'TipoPaquete'	=> $TipoPkt['value'],
 							'kilometraje'	=> intval(preg_replace('/[^0-9]+/', '', $value['B']), 10)*1000, 
 							// 'Precio' 		=> $value[''], //<--- Se calcula del detalle
 							'TipoPrecio'	=> "Suma de componentes",
 							'Prorrateo'		=> "Ambos",
 							// 'TTabulador'	=> $value[''], //<--- Se calcula del detalle
 							// 'TFacturado'	=> $value[''], //<--- Se calcula del detalle
 							'ClavePlanta'	=> $value['E'],
 							'Estatus'		=> 1,
 							'Actualizacion'	=> date("d-m-Y H:i:s")
 	                    );
 	                    foreach ($arr_datos as $llave => $valor) {
 	                        $arr_datos[$llave] = $valor;
 	                    }
 	                    // $key = $this->db->select('COUNT(vehiculo) as count')->from('CargaPcksTemp')->where('vehiculo', $value['A'])->get()->row_array();
 	                    $key = $db_intelisis->select('COUNT(DescripcionC) as count')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value['C'])->get()->row_array();
 	                    if( $key['count'] == 0 ){
 	                        $db_intelisis->insert($tabla_ServicioPaquetes,$arr_datos);  
 	                        $indexinsert++;
 	                        $inserts = $inserts."Id Paquete -> ".$db_intelisis->insert_id()." - ".$value['C']."<br>";
 	                    }else{
 	                    	$db_intelisis->where('DescripcionC', $value['C']);
 	                    	$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos);
 	                    	$ultimo_actualizado = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value['C'])->get()->row_array();
 	                        $indexupdat++;
 	                        $updats = $updats."Id Paquete -> ".$ultimo_actualizado['Id']." - ".$value['C']."<br>";
 	                    }
                     }
                 } 
             }
 // die();
             // $PaquetesExcelId = $db_intelisis->select("Id")->from("ServicioPaquetes")->where_in("DescripcionC", $PaquetesExcel)->get()->result_array();
             // $PaquetesExcelDelete = $db_intelisis->select("IdPaquete")->from("ServicioPaquetesD")->where_in("IdPaquete", $PaquetesExcelId['id_paquete_e'])->get()->result_array();
             /*$db_intelisis->where_in('IdPaquete', $PaquetesExcelId['Id']);
             $db_intelisis->delete('ServicioPaquetesD');*/
            
             // **********LIMPIA DETALLE DE PAQUETES DEL ARCHIVO**********
             foreach ($PaquetesExcel as $key => $value) {
             	// print_r(" key->".$key." value->".$value);
             	$id_paquete_excel = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value)->get()->row_array();
             	$db_intelisis->where('IdPaquete', $id_paquete_excel['Id']);
             	$db_intelisis->delete($tabla_ServicioPaquetesD);
             }

             // **********INSERTA DETALLE DE PAQUETES DEL ARCHIVO**********
             foreach ($sheetData as $index => $value) {
             // print_r($value);            
                 if ( $index != 1 && isset( $value['A'] ) && isset( $value['C'] ) ){
                 	$existeArticulo = $db_intelisis->select('COUNT(*) as count')->from($view_dms_art)->where('Articulo', $value["G"].'')->where('Estatus', 'ALTA')->get()->row_array();
                 	if( $existeArticulo['count'] > 0 )
                 	{
                 		$id_paquete_excel_d = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value['C'])->get()->row_array();
                 		$existeDetalle = $db_intelisis->select('COUNT(*) as count')->from($tabla_ServicioPaquetesD)->where('Articulo', $value["G"].'')->where('IdPaquete', $id_paquete_excel_d['Id'])->get()->row_array();
                 		if( $existeDetalle['count'] == 0 )
                 		{
                 			$renglon_d = $db_intelisis->select('MAX(Renglon) as NR')->from($tabla_ServicioPaquetesD)->where('IdPaquete', $id_paquete_excel_d['Id'])->get()->row_array();
		                	
 		                	$renglon_d['NR'] = ( $renglon_d['NR'] == null ) ? 1 : $renglon_d['NR'] + 1;

 		                	if( $value['F'] == 'MO' )
 		                		$Tipo_Art = 'Servicio';
 		                	else
 		                		$Tipo_Art = 'Normal';

 		                	if( $value['J'][0] == '$' ) //Quitar $
 		                		$PrecioUnitario = substr($value['J'], 1);
 		                	else
 		                		$PrecioUnitario = $value['J'];

 		                	$PrecioUnitario = str_replace(',', '',$PrecioUnitario); //Quitar ,
		                	
 		                	$arr_datos_d = array(
 		                		'IdPaquete'			=> $id_paquete_excel_d['Id'], //Se obtiene del insert o update
 		                		'Renglon'			=> $renglon_d['NR'], //Consecutivo Max del paquete
		                		'Articulo'			=> $value['G'],
 		                		'SubtipoCuenta'		=> "", //Vacio
 		                		'Cantidad'			=> $value['I'],
 		                		'TTabulado'			=> $value['I'],
 		                		'AlmacenEsp'		=> "", //Vacio
 		                		'ListaPreciosEsp'	=> "", //Vacio
 		                		'PrecioUnitario'	=> $PrecioUnitario, 
 		                		'Actualizacion'		=> date("d-m-Y H:i:s"),
 		                		'TipoArticulo'		=> $Tipo_Art, //Convertir Servicio Normal
 		                		'Descripcion'		=> $value['H']
 		                		);
 		                	foreach ($arr_datos_d as $llave_d => $valor_d) {
 		                		$arr_datos_d[$llave_d] = $valor_d;
 		                	}
		                	
 		                    $db_intelisis->insert($tabla_ServicioPaquetesD,$arr_datos_d);  
                 		}
                 	}
                 	else{
                 		$ArticulosNoExistentes = $ArticulosNoExistentes."Clave -> ".$value['G']."<br>";
                 	}
                 } 
             }

             // **********CALCULO DE FINALES PARA PAQUETES DEL ARCHIVO**********
             foreach ($PaquetesExcel as $key => $value) {
             	// print_r(" key->".$key." value->".$value);
             	// $id_paquete_excel = $db_intelisis->select('Id')->from('ServicioPaquetes')->where('DescripcionC', $value)->get()->row_array();
             	// $sums_paquete = $db_intelisis->select_sum('PrecioUnitario')->from('ServicioPaquetesD')->where('IdPaquete', $id_paquete_excel['Id'])->get()->row_array();
             	$sums_paquete = $db_intelisis->select_sum('(ISNULL(PrecioUnitario, 0)*ISNULL(Cantidad,0))','PrecioUnitario')->select_sum('Cantidad')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->get()->row_array();
             	$sums_TTabulado = $db_intelisis->select_sum('TTabulado')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->where("".$tabla_ServicioPaquetesD.".TipoArticulo", 'Servicio')->get()->row_array();
             	// print_r($sums_paquete);
             	/*$db_intelisis->where('IdPaquete', $id_paquete_excel['Id']);
             	$db_intelisis->delete('ServicioPaquetesD');*/
             	$arr_datos_sum['Precio'] = $sums_paquete['PrecioUnitario'];
             	$arr_datos_sum['TTabulador'] = $sums_paquete['Cantidad'];
             	$arr_datos_sum['TFacturado'] = ( $sums_TTabulado['TTabulado'] == null ) ? 0 : $sums_TTabulado['TTabulado'];

             	$db_intelisis->where('DescripcionC', $value);
 				$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_sum);
             }
             $result['valid'] = true;
             $result['message'] = 'Productos importados correctamente';
             $result['changes'] = "";
 			if( $indexinsert > 0 )
             	$result['changes'] = $result['changes']."<strong>".$indexinsert." Paquetes insertados...</strong><br>".$inserts;
 			if( $indexupdat > 0 )            
             	$result['changes'] = $result['changes']."<strong>".$indexupdat." Paquetes actualizados...</strong><br>".$updats;
             if( $ArticulosNoExistentes != '' )
             	$result['changes'] = $result['changes']."<strong>Las siguientes claves de Números de pieza y/o Mano de obra no están registrados en Intelisis</strong><br>".$ArticulosNoExistentes;
             $result['name_a'] = $name;
             // $result['changes'] = "cargado...";
         }else{
             $result['valid'] = false;
             $result['message'] = 'Pestaña "GLOBAL" no encontrada en archivo: <strong>'.$name."</strong>";
         }
        
 		return $result;
 	}

	private function ImportarReglas($obj_excel, $name, $db_intelisis)
	{
		$ReglaSinArticulo = array(); $ReglaModeloKO = array(); $ReglaPaquetesKO = array();
		$rows_Reglas = $obj_excel->getSheetByName('Reglas')->toArray(null,true,true,true);	//<--- Guarda contenido de pestaña Reglas

		foreach ($rows_Reglas as $keyFila => $Fila) {	//<--- revisa cada Fila
			$Fila=array_filter($Fila, "strlen");
			if(!isset($Fila['A']))
				continue;
			switch ($Fila['A']) {
				case 'Paquetes':
					$PktRules = array_slice($Fila, 1);			//<--- extrae Paquetes en $PktRules
					break;
				case 'Artículo':
				case 'Articulo':
					$PktArticulos = array_slice($Fila, 1);		//<--- extrae Articulos en $PktArticulos
					break;
				case 'Modelo':
					$PktModelos = array_slice($Fila, 1);		//<--- extrae Modelos en $PktModelos
					break;
				case 'Cilindros':
					$PktCilindros = array_slice($Fila, 1);		//<--- extrae Cilindros en $PktCilindros
					break;
				case 'Transmisión':
				case 'Transmision':
					$PktTransmisiones = array_slice($Fila, 1);	//<--- extrae Transmisiones en $PktTransmisiones
					break;
				case 'Motor':
					$PktMotores = array_slice($Fila, 1);		//<--- extrae Motores en $PktMotores
					if(count($PktRules) > 0){					//<--- si existen paquetes para la regla continua
						$returnReglas = $this->InsertaReglas($db_intelisis,$PktRules,$PktArticulos,$PktModelos,$PktCilindros,$PktTransmisiones,$PktMotores);	//<--- envia una regla a la vez para insertar
						$ReglaSinArticulo = array_merge($ReglaSinArticulo, $returnReglas['ReglaSinArticulo']);		//<--- articulos no registrados
						$ReglaModeloKO = array_merge($ReglaModeloKO, $returnReglas['ReglaModeloKO']);				//<--- modelos no numericos
						$ReglaPaquetesKO = array_merge($ReglaPaquetesKO, $returnReglas['ReglaPaquetesKO']);			//<--- paquetes no existentes
					}
					break;
				default:
					break;
			}
		}

		$result['valid'] = true;
        $result['message'] = 'Reglas importadas correctamente';
        $result['changes'] = "";
        if (count($ReglaPaquetesKO) > 0) {
        	$ReglaPaquetesKO = array_unique($ReglaPaquetesKO);
        	$result['changes'] = $result['changes']."<br><strong>Las siguientes ".count($ReglaPaquetesKO)." claves de Paquetes No están registradas en el Sistema de Paquetes</strong><br>".implode('<BR>', $ReglaPaquetesKO);
        }
        if (count($ReglaSinArticulo) > 0) {
        	$ReglaSinArticulo = array_unique($ReglaSinArticulo);
        	$result['changes'] = $result['changes']."<br><strong>Las siguientes ".count($ReglaSinArticulo)." claves de Artículo No están registradas en Intelisis</strong><br>".implode('<BR>', $ReglaSinArticulo);
        }
        if (count($ReglaModeloKO) > 0) {
        	$ReglaModeloKO = array_unique($ReglaModeloKO);
        	$result['changes'] = $result['changes']."<br><strong>Los siguientes ".count($ReglaModeloKO)." Modelos No son valores numéricos</strong><br>".implode('<BR>', $ReglaModeloKO);
        }
        if(count($ReglaPaquetesKO) == 0 && count($ReglaSinArticulo) == 0 && count($ReglaModeloKO) == 0)
        	$result['changes'] = "<strong>Reglas asignadas a los paquetes satisfactoriamente</strong><br>";

        $result['name_a'] = $name;

		return $result;
	}

	private function InsertaReglas($db_intelisis,$PktRules,$PktArticulos,$PktModelos,$PktCilindros,$PktTransmisiones,$PktMotores)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		$returnReglas['ReglaSinArticulo'] = array(); $returnReglas['ReglaModeloKO'] = array(); $returnReglas['ReglaPaquetesKO'] = array();
		// $db_intelisis->query("DELETE FROM ServicioPaquetesR WHERE IdPaquete IN ( SELECT Id FROM ServicioPaquetes WHERE DescripcionC IN ('".implode("','", $PktRules)."') )");
		// print_r($db_intelisis->last_query());
		$id_PktsRules = $db_intelisis->select("sp.Id, NumRegla = (SELECT ISNULL(MAX(spr.Regla), 0)+1 from {$tabla_ServicioPaquetesR} spr WHERE spr.IdPaquete = sp.Id), sp.DescripcionC")
									->from('ServicioPaquetes sp')->where_in('sp.DescripcionC', $PktRules)->get()->result_array();		//<--- Obtiene id, nombre del paquete y num de regla a insertar
		print_r($db_intelisis->last_query());
		$returnReglas['ReglaPaquetesKO'] = array_diff($PktRules, array_column($id_PktsRules, 'DescripcionC'));
		// $CalagoloCilindros = $db_intelisis->select("DISTINCT(Cilindros) AS Descripcion")->from("VIN")->order_by("Cilindros")->get()->result_array();
		/*$CalagoloCilindros = $this->catalogo_cilindros();
		$CalagoloCilindros = array_column($CalagoloCilindros, 'Descripcion');*/
		// $CalagoloTransmision = $db_intelisis->select("DISTINCT(Transmision) AS Descripcion")->from("VIN")->order_by("Transmision")->get()->result_array();
		/*$CalagoloTransmision = $this->catalogo_transmision();
		$CalagoloTransmision = array_column($CalagoloTransmision, 'Descripcion');*/
		/*$CalagoloMotor = $this->catalogo_motor();
		$CalagoloMotor = array_column($CalagoloMotor, 'Descripcion');*/
		
		/*if(array_search( '' ,$CalagoloCilindros))
			unset($CalagoloCilindros[array_search( '' ,$CalagoloCilindros)]);*/
		// print_r($id_PktsRules);
		/*if(count($PktRules) > 0){
			print_r($PktRules);
			print_r("\n");
		}*/
		$reglas = array();
		foreach ($id_PktsRules as $key => $idPaqueteR) {
			// print_r($idPaqueteR);
			if(count($PktArticulos) > 0){
				$R_datos = array(
					'IdPaquete'		=> $idPaqueteR['Id'],
					'Regla'			=> $idPaqueteR['NumRegla'],
					'Condicion'		=> null,
					'Definicion'	=> null, 
					'Actualizacion'	=> date("d-m-Y H:i:s")
				);
				foreach ($PktArticulos as $key => $ArticuloR) {
					$R_datos['Condicion'] = 'Articulo';
					$R_datos['Definicion'] = $ArticuloR;
					$existeArt = $db_intelisis->select('COUNT(Articulo) AS NArticulo')->from($view_dms_art)->where('Articulo', $ArticuloR."")->get()->row_array();
					// print_r($db_intelisis->last_query());
					if($existeArt['NArticulo'] > 0){
						array_push($reglas, $R_datos);
						if(count($PktModelos) == 0){
							$R_datos['Condicion'] = 'Modelo';
							$R_datos['Definicion'] = 'Todos';
							array_push($reglas, $R_datos);
						}else
							foreach ($PktModelos as $key => $ModeloR) {
								$R_datos['Condicion'] = 'Modelo';
								$R_datos['Definicion'] = $ModeloR;
								if(is_numeric($ModeloR))
									array_push($reglas, $R_datos);
								else
									array_push($returnReglas['ReglaModeloKO'], $ModeloR);
							}
						if(count($PktCilindros) == 0){
							$R_datos['Condicion'] = 'Cilindros';
							$R_datos['Definicion'] = 'Todos';
							array_push($reglas, $R_datos);
						}else
							foreach ($PktCilindros as $key => $CilindrosR) {
								$R_datos['Condicion'] = 'Cilindros';
								$R_datos['Definicion'] = $CilindrosR;
								// if(array_search( $CilindrosR ,$CalagoloCilindros))
									array_push($reglas, $R_datos);
							}
						if(count($PktTransmisiones) == 0){
							$R_datos['Condicion'] = 'Transmision';
							$R_datos['Definicion'] = 'Todos';
							array_push($reglas, $R_datos);
						}else
							foreach ($PktTransmisiones as $key => $TransmisionR) {
								$R_datos['Condicion'] = 'Transmision';
								$R_datos['Definicion'] = $TransmisionR;
								// if(array_search( $TransmisionR ,$CalagoloTransmision))
									array_push($reglas, $R_datos);
							}
						if(count($PktMotores) == 0){
							$R_datos['Condicion'] = 'Motor';
							$R_datos['Definicion'] = 'Todos';
							array_push($reglas, $R_datos);
						}else
							foreach ($PktMotores as $key => $MotorR) {
								$R_datos['Condicion'] = 'Motor';
								$R_datos['Definicion'] = $MotorR;
								// if(array_search( $MotorR ,$CalagoloMotor))
									array_push($reglas, $R_datos);
							}
					}else
						array_push($returnReglas['ReglaSinArticulo'], $ArticuloR);
				}
				
			}
		}
		// print_r($CalagoloCilindros);
		/*$db_intelisis->where_in('IdPaquete', implode(",", array_column($id_PktsRules, 'Id')));
		$db_intelisis->delete('ServicioPaquetesR');*/
		foreach ($reglas as $key => $regla) {
			// print_r($regla);
			$db_intelisis->insert($tabla_ServicioPaquetesR,$regla);
		}
		// print_r($returnReglas);
		unset($id_PktsRules,$PktRules,$PktArticulos,$PktModelos,$PktCilindros,$PktTransmisiones,$PktMotores);
		// die();
		return $returnReglas;
	}

	private function ImportarFord($obj_excel, $name, $TipoPkt, $db_intelisis)
	{
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		########################################################################################################################
		#################################                 PESTAÑA FORD                         #################################
		########################################################################################################################
		$rows_Ford = $obj_excel->getSheetByName('Ford')->toArray(null,true,true,true);
		$PaquetesFord = array(); $RefaccionesFord = array(); $SinRefaccionesFord = array(); $MOFord = array(); $SinMOFord = array();
		// print_r('entra a pestaña');
		/*print_r("Cantidad en Array:");
		print_r("--->");
		print_r(count($rows_Ford));
		print_r("<---");*/
		unset($rows_Ford[1],$rows_Ford[2],$rows_Ford[3],$rows_Ford[4],$rows_Ford[5]);

		foreach ($rows_Ford as $index => $columns) {
			//<--- Paquetes FORD
			// print_r('Paquete: ');
			// print_r('--->' . implode('', array_slice($columns, 0,5)) . '<---');
			// $PaqueteFord = implode('', array($columns['A'], $columns['B'], $columns['C'], $columns['D'], $columns['E']));
			$PaqueteFord = implode('', array_slice($columns, 0,5));
			$PaqueteFord .= implode('', array_slice($columns, 15));
			if ($PaqueteFord == '')
				continue;
			// *****************************************************************************************************************
			// **************************            REGISTRA  PAQUETES                        *********************************
			// *****************************************************************************************************************
			if(!in_array($PaqueteFord,$PaquetesFord))
			{
				$arr_datos = array(
					'DescripcionC'	=> $PaqueteFord,
					'DescripcionL'	=> $PaqueteFord,
					'TipoPaquete'	=> $TipoPkt['value'],
					'kilometraje'	=> intval(preg_replace('/[^0-9]+/', '', $columns['A'] ), 10)*1000, 
					// 'Precio' 		=> $columns[''], //<--- Se calcula del detalle
					'TipoPrecio'	=> "Suma de componentes",
					'Prorrateo'		=> "Ambos",
					// 'TTabulador'	=> $columns[''], //<--- Se calcula del detalle
					// 'TFacturado'	=> $columns[''], //<--- Se calcula del detalle
					'ClavePlanta'	=> $columns['P'],
					'Estatus'		=> 1,
					'Actualizacion'	=> date("d-m-Y H:i:s")
				);
				// print_r($arr_datos);
				$db_intelisis->trans_start();
					$key = $db_intelisis->select('COUNT(DescripcionC) as count')->from($tabla_ServicioPaquetes)->where('DescripcionC', $PaqueteFord)->get()->row_array();
					if( $key['count'] == 0 ){
						$db_intelisis->insert($tabla_ServicioPaquetes,$arr_datos);
					}
					else{
						$id_PaqueteFord = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $PaqueteFord)->order_by("Estatus", "desc")->get()->row_array();
						$db_intelisis->where('Id', $id_PaqueteFord['Id']);
						$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos);

						$db_intelisis->where('IdPaquete', $id_PaqueteFord['Id']);
						$db_intelisis->delete($tabla_ServicioPaquetesD);
					}
				$db_intelisis->trans_complete();
				if($db_intelisis->trans_status() == true)
					array_push($PaquetesFord, $PaqueteFord);

				/*if(array_search($PaqueteFord,$PaquetesFord) == NULL)
					print_r(' parametros invalidos ');*/
			}

			$id_PaqueteFord = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $PaqueteFord)->order_by("Estatus", "desc")->get()->row_array();
				// print_r('Id Paquete: '.$id_PaqueteFord['Id']);

			//<--- Refacciones de Paquetes FORD
			// *****************************************************************************************************************
			// **************************            REGISTRA DETALLE REFACCIONES              *********************************
			// *****************************************************************************************************************
			if ($columns['G'] != 'N/A') {
				if(!in_array($columns['G'],$RefaccionesFord) && !in_array($columns['G'],$SinRefaccionesFord)){
					$existeArticulo = $db_intelisis->select('COUNT(*) as count')->from($view_dms_art)->where('Articulo', $columns['G'].'')->where('Tipo', 'Normal')->where('Estatus', 'ALTA')->get()->row_array();
					// print_r("REALIZO CONSULTA");
				}else{
					$existeArticulo['count'] = 0;
					if (in_array($columns['G'],$RefaccionesFord))
						$existeArticulo['count'] = 1;
					// print_r("SIN CONSULTA");
				}

				if( $existeArticulo['count'] > 0 ){
					// print_r(' Existe Refaccion ');
					$existeDetalle = $db_intelisis->select('COUNT(*) as count')->from($tabla_ServicioPaquetesD)->where('Articulo', $columns['G'].'')->where('IdPaquete', $id_PaqueteFord['Id'])->get()->row_array();
					if (!is_numeric($columns['H']))
	                		$columns['H'] = 0;

					if( $existeDetalle['count'] == 0 )
            		{
            			// print_r(' Nueva Refaccion en Paquete ');
            			$renglon_d = $db_intelisis->select('MAX(Renglon) as NR')->from($tabla_ServicioPaquetesD)->where('IdPaquete', $id_PaqueteFord['Id'])->get()->row_array();
	                	$renglon_d['NR'] = ( $renglon_d['NR'] == null ) ? 1 : $renglon_d['NR'] + 1;
	                	
	                	$arr_datos_d = array(
	                		'IdPaquete'			=> $id_PaqueteFord['Id'], //Se obtiene del insert o update
	                		'Renglon'			=> $renglon_d['NR'], //Consecutivo Max del paquete
	                		'Articulo'			=> $columns['G'],
	                		'SubtipoCuenta'		=> "", //Vacio
	                		'Cantidad'			=> $columns['H'],
	                		'TTabulado'			=> $columns['H'],
	                		'AlmacenEsp'		=> "", //Vacio
	                		'ListaPreciosEsp'	=> "", //Vacio
	                		'PrecioUnitario'	=> 0, 
	                		'Actualizacion'		=> date("d-m-Y H:i:s"),
	                		'TipoArticulo'		=> 'Normal', //Convertir Servicio Normal
	                		'Descripcion'		=> $columns['F']
	                	);
	                	$db_intelisis->insert($tabla_ServicioPaquetesD,$arr_datos_d);
            		}else{
            			// print_r(' Ya Existe Refaccion en Paquete ');
            			$db_intelisis->query("UPDATE ".$tabla_ServicioPaquetesD." SET Cantidad = Cantidad +'".$columns['H']."', TTabulado = TTabulado +'".$columns['H']."', Actualizacion = '".date("d-m-Y H:i:s")."' WHERE Articulo = '".$columns['G']."' AND IdPaquete = ".$id_PaqueteFord['Id']);
            		}

            		if (!in_array($columns['G'],$RefaccionesFord))
						array_push($RefaccionesFord, $columns['G']);
				}else{
					// print_r(' No Existe Refaccion ');
					$arr_datos_e = array(
						'Estatus'		=> 2,
						'Actualizacion'	=> date("d-m-Y H:i:s")
					);
					$db_intelisis->where('Id', $id_PaqueteFord['Id']);
					$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_e);

					if (!in_array($columns['G'],$SinRefaccionesFord))
						array_push($SinRefaccionesFord, $columns['G']);
				}
			}
			
			//<--- Mano de Obra de Paquetes FORD
			// *****************************************************************************************************************
			// **************************            REGISTRA DETALLE MANO DE OBRA             *********************************
			// *****************************************************************************************************************
			if ($columns['K'] != '') {
				if(!in_array($columns['K'],$MOFord) && !in_array($columns['K'],$SinMOFord)){
					$existeArticulo = $db_intelisis->select('COUNT(*) as count')->from($view_dms_art)->where('Articulo', $columns['K'].'')->where('Tipo', 'Servicio')->where('Estatus', 'ALTA')->get()->row_array();
					// print_r("REALIZO CONSULTA");
				}else{
					$existeArticulo['count'] = 0;
					if (in_array($columns['K'],$MOFord))
						$existeArticulo['count'] = 1;
					// print_r("SIN CONSULTA");
				}

				if( $existeArticulo['count'] > 0 ){
					// print_r(' Existe Mano de Obra ');
					$existeDetalle = $db_intelisis->select('COUNT(*) as count')->from($tabla_ServicioPaquetesD)->where('Articulo', $columns['K'].'')->where('IdPaquete', $id_PaqueteFord['Id'])->get()->row_array();
					if (!is_float($columns['M']))
                		$columns['M'] = 0;

					if( $existeDetalle['count'] == 0 )
            		{
            			// print_r(' Nueva Mano de Obra en Paquete ');
            			$renglon_d = $db_intelisis->select('MAX(Renglon) as NR')->from($tabla_ServicioPaquetesD)->where('IdPaquete', $id_PaqueteFord['Id'])->get()->row_array();
	                	$renglon_d['NR'] = ( $renglon_d['NR'] == null ) ? 1 : $renglon_d['NR'] + 1;
	                	
	                	$arr_datos_d = array(
	                		'IdPaquete'			=> $id_PaqueteFord['Id'], //Se obtiene del insert o update
	                		'Renglon'			=> $renglon_d['NR'], //Consecutivo Max del paquete
	                		'Articulo'			=> $columns['K'],
	                		'SubtipoCuenta'		=> "", //Vacio
	                		'Cantidad'			=> $columns['M'],
	                		'TTabulado'			=> $columns['M'],
	                		'AlmacenEsp'		=> "", //Vacio
	                		'ListaPreciosEsp'	=> "", //Vacio
	                		'PrecioUnitario'	=> 0, 
	                		'Actualizacion'		=> date("d-m-Y H:i:s"),
	                		'TipoArticulo'		=> 'Servicio', //Convertir Servicio Normal
	                		'Descripcion'		=> $columns['J']
	                	);
	                	$db_intelisis->insert($tabla_ServicioPaquetesD,$arr_datos_d);
            		}else{
            			// print_r(' Ya Existe Mano de Obra en Paquete ');
            			$db_intelisis->query("UPDATE ".$tabla_ServicioPaquetesD." SET Cantidad = Cantidad +'".$columns['M']."', TTabulado = TTabulado +'".$columns['M']."', Actualizacion = '".date("d-m-Y H:i:s")."' WHERE Articulo = '".$columns['K']."' AND IdPaquete = ".$id_PaqueteFord['Id']);
            		}

            		if (!in_array($columns['K'],$MOFord))
						array_push($MOFord, $columns['K']);
				}else{
					// print_r(' No Existe Mano de Obra ');
					$arr_datos_e = array(
						'Estatus'		=> 2,
						'Actualizacion'	=> date("d-m-Y H:i:s")
					);
					$db_intelisis->where('Id', $id_PaqueteFord['Id']);
					$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_e);

					if (!in_array($columns['K'],$SinMOFord))
						array_push($SinMOFord, $columns['K']);
				}
			}
			unset($rows_Ford[$index]);
		}
		// *****************************************************************************************************************
		// **************************          CALCULO DE TOTALES PAQUETES DEL ARCHIVO     *********************************
		// *****************************************************************************************************************
		foreach ($PaquetesFord as $key => $value) {
        	$sums_paquete = $db_intelisis->select_sum('Cantidad')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->where_in("".$tabla_ServicioPaquetes.".Estatus", [1, 2])->get()->row_array();
        	$sums_TTabulado = $db_intelisis->select_sum('TTabulado')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->where("".$tabla_ServicioPaquetesD.".TipoArticulo", 'Servicio')->where_in("".$tabla_ServicioPaquetes.".Estatus", [1, 2])->get()->row_array();

        	$arr_datos_sum['TTabulador'] = $sums_paquete['Cantidad'];
        	$arr_datos_sum['TFacturado'] = ( $sums_TTabulado['TTabulado'] == null ) ? 0 : $sums_TTabulado['TTabulado'];

        	$db_intelisis->where('DescripcionC', $value);
			$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_sum);
        }
		//<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- //<--- 
		$result['valid'] = true;
        $result['message'] = 'Productos importados correctamente';
        $result['changes'] = "";
        // Paquetes
        if (count($PaquetesFord) > 0) {
        	$result['changes'] = $result['changes']."<strong>".count($PaquetesFord)." Paquetes insertados...</strong><br>".implode('<BR>', $PaquetesFord);
        }
        if (count($SinRefaccionesFord) >0) {
        	$result['changes'] = $result['changes']."<br><strong>Las siguientes claves de Refacción No están registradas en Intelisis</strong><br>".implode('<BR>', $SinRefaccionesFord);
        }
        if (count($SinMOFord) >0) {
        	$result['changes'] = $result['changes']."<br><strong>Las siguientes claves de Mano de Obra No están registradas en Intelisis</strong><br>".implode('<BR>', $SinMOFord);
        }
        $result['name_a'] = $name;

		return $result;
	}
	
	private function ImportarMarchGM($Rangos, $obj_excel, $db_intelisis)
	{
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		########################################################################################################################
		#################################                 PAQUETES GM                          #################################
		########################################################################################################################
		#################################                 PESTAÑA MATCH                        #################################
		########################################################################################################################
		$sheetData_Match = $obj_excel->getSheetByName('Match')->toArray(null,true,true,true);

		// *****************************************************************************************************************
		// **************************            RANGOS DE PAQUETES                        *********************************
		// *****************************************************************************************************************
		$Rangos['Rango1']		= $sheetData_Match[2]['H'];
		$Rangos['AlRango1']		= $sheetData_Match[3]['H'];
		$Rangos['ValorRango1']	= $sheetData_Match[4]['H'];

		$Rangos['Rango2']		= $sheetData_Match[6]['H'];
		$Rangos['AlRango2']		= $sheetData_Match[7]['H'];
		$Rangos['ValorRango2']	= $sheetData_Match[8]['H'];

		$Rangos['Rango3']		= $sheetData_Match[10]['H'];
		$Rangos['ValorRango3']	= $sheetData_Match[11]['H'];

		// *****************************************************************************************************************
		// **************************            BAJA DE REGISTROS DE PAQUETES             *********************************
		// *****************************************************************************************************************
		$db_intelisis->trans_start();
		foreach ($sheetData_Match as $index => $value) {
		// print_r($value);            
		    if ( $index != 1 && in_array( $value['A'], array('BAJA', 'Baja', 'baja') ) ){
		    	$db_intelisis->set('Estatus', 0);
		    	$db_intelisis->where('Id', intval(preg_replace('/[^0-9]+/', '', $value['B']), 10) );
				$db_intelisis->update($tabla_ServicioPaquetes);
		    }
		    if ( $index != 1 && isset( $value['D'] ) ){
				$PaquetesRemplazar[$index] = $value['D'];
		    }

		}
		$db_intelisis->trans_complete();
		return $Rangos;
		// print_r($PaquetesRemplazar);
		// die();
	}

	private function ImportarHomologacionGM($sheet, $obj_excel, $db_intelisis)
	{
		$tabla_paquetesHomologacionPrecio = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_PaquetesHomologacionPrecio' : 'PaquetesHomologacionPrecio';
		########################################################################################################################
		#################################                 PAQUETES GM                          #################################
		########################################################################################################################
		#################################       PESTAÑAS PARA HOMOLOGACIÓN DE PRECIOS          #################################
		########################################################################################################################
		$Km = 1;
		// $KmPaquetes = array();
		$sheetData = $obj_excel->getSheetByName($sheet)->toArray(null,true,true,true);
		if(isset($sheetData[2]['A']) && $sheetData[2]['A'] === 'NOMENCLATURA MATRIZ'){
			foreach ($sheetData[1] as $key => $value) {
				if (!is_numeric($value) && $value != '')
					$ServiciosNoNumericos = $ServiciosNoNumericos."Hoja: ".$sheet." Clave -> ".$value."<br>";
					// array_push($KmPaquetes, $value);
			}
		// print_r($KmPaquetes);
			$CodigoVehiculos = array_column($sheetData, 'A');
			unset($CodigoVehiculos[0]);unset($CodigoVehiculos[1]);
			if(array_search( '' ,$CodigoVehiculos))
				unset($CodigoVehiculos[array_search( '' ,$CodigoVehiculos)]);
		// print_r($CodigoVehiculos);
		// print_r('####################################################################');
			foreach ($sheetData as $keyFila => $Fila) {
				if ($keyFila > 2) {
					foreach ($Fila as $Columna => $PrecioPkt) {
						if ( $Columna > 'A') { //(isset($value) || $value != null || $value != '') &&
							// print_r($Columna);
							if( isset( $CodigoVehiculos[$keyFila-1] ) ){
								if($Km == 1){
									$fields['Vehiculo'] = $CodigoVehiculos[$keyFila-1];
									// print_r($CodigoVehiculos[$keyFila-1]);
									$fields['Servicio'] = $sheetData[1][$Columna];
									// print_r($sheetData[1][$Columna]);
									$fields['CodigoPaquete'] = 'S'.$sheetData[1][$Columna].$CodigoVehiculos[$keyFila-1];
									$Km = 0;
								}else{
									if( $PrecioPkt[0] == '$' ) //Quitar $
	                					$fields['Homologacion'] = substr($PrecioPkt, 1);//print_r(substr($PrecioPkt, 1));
	                				else
	                					$fields['Homologacion'] = $PrecioPkt;//print_r($PrecioPkt);
	                				$fields['Homologacion'] = str_replace(',', '',$fields['Homologacion']); //Quitar ,
	                				$fields['Actualizacion'] = date("d-m-Y H:i:s");
									$Km = 1;
									if (is_numeric($fields['Servicio'])) {
										$PrecioPaquete = $db_intelisis->select("Vehiculo")->from($tabla_paquetesHomologacionPrecio)->where("Vehiculo", $fields['Vehiculo'])->where("Servicio", $fields['Servicio'])->get()->row_array();
										// print_r($fields);
										$db_intelisis->trans_start();
										if(!$PrecioPaquete){
											$db_intelisis->insert($tabla_paquetesHomologacionPrecio, $fields);
										}else{
											$db_intelisis->where("Vehiculo", $fields['Vehiculo'])->where("Servicio", $fields['Servicio']);
											$db_intelisis->update($tabla_paquetesHomologacionPrecio, $fields);
										}
										$db_intelisis->trans_complete();
									}
								}
							}
						}
					}
				}

			}
		}
		unset($CodigoVehiculos);
		// unset($KmPaquetes);
	}

	private function ImportarMORefGM($obj_excel, $name, $TipoPkt, $Rangos, $db_intelisis)
	{
		$tabla_ServicioPaquetes = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetes' : 'ServicioPaquetes';
		$tabla_ServicioPaquetesR = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesR' : 'ServicioPaquetesR';
		$tabla_ServicioPaquetesD = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_ServicioPaquetesD' : 'ServicioPaquetesD';
		$view_dms_art = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
		$tabla_paquetesHomologacionPrecio = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'CA_PaquetesHomologacionPrecio' : 'PaquetesHomologacionPrecio';
		########################################################################################################################
		#################################                 PAQUETES GM                          #################################
		########################################################################################################################
		#################################                 PESTAÑA DMS-MO-REF                   #################################
		########################################################################################################################
		$inserts = "";
        $updats = "";
        $ArticulosNoExistentes = "";
        $ServiciosNoNumericos = "";
        $indexinsert = 0;
        $indexupdat = 0;
        $PaquetesRemplazar = array();
		$sheetData_MO_REF = $obj_excel->getSheetByName('DMS-MO-REF')->toArray(null,true,true,true);
		$arr_datos = array();											//<--- array para insert de registro de paquetes
		// $sheetData_REF = $obj_excel->getSheetByName('DMS-REF')->toArray(null,true,true,true);
		$CodigoPaquete_MO_REF = array_column($sheetData_MO_REF, 'C');	//<--- obtiene columa C con el registro de todos los paquetes
		array_shift($CodigoPaquete_MO_REF);								//<--- elimina el primer registro del array
		$CodigoPktsInsertar = array_unique($CodigoPaquete_MO_REF);		//<--- elimina los registros repetidos
		if(array_search( '' ,$CodigoPktsInsertar)){
			unset($CodigoPktsInsertar[array_search( '' ,$CodigoPktsInsertar)]);	//<--- si eiste un campo con clave '' lo elimina
			// print_r("entro");
		}

		// array_pop($CodigoPktsInsertar);
		// $CodigoPaquete_REF = array_column($sheetData_REF, 'C');	array_shift($CodigoPaquete_REF);
		// $CodigoPaquete = array_merge( $CodigoPaquete_MO, $CodigoPaquete_REF );	//Extrae los codigos de paquetes a insertar de las dos hojas

		// *****************************************************************************************************************
		// **************************         INSERTA REGISTRO DE PAQUETES DEL ARCHIVO     *********************************
		// *****************************************************************************************************************
		foreach ($CodigoPktsInsertar as $index => $value) {	//Recorre la Hoja MO_REF
			$arr_datos = array(
            	'DescripcionC'	=> $sheetData_MO_REF[($index+2)]['C'],
				'DescripcionL'	=> $sheetData_MO_REF[($index+2)]['C'],
				'TipoPaquete'	=> $TipoPkt['value'],
				'kilometraje'	=> intval(preg_replace('/[^0-9]+/', '', $sheetData_MO_REF[($index+2)]['B']), 10)*1000, 
				// 'Precio' 		=> $value[''], //<--- Se calcula del detalle
				'TipoPrecio'	=> "Suma de componentes",
				'Prorrateo'		=> "Ambos",
				// 'TTabulador'	=> $value[''], //<--- Se calcula del detalle
				// 'TFacturado'	=> $value[''], //<--- Se calcula del detalle
				'ClavePlanta'	=> $sheetData_MO_REF[($index+2)]['A'],
				'Estatus'		=> 1,
				'Actualizacion'	=> date("d-m-Y H:i:s")
			);

			// print_r($CodigoPktsInsertar);

			// ********** COMPRUEBA SI SE DEBE REMPLAZAR ALGUN PAQUETE EXISTENTE  ****************************
			if( array_search( $sheetData_MO_REF[($index+2)]['C'] ,$PaquetesRemplazar) ){
				// print_r('Paquete a remplazar: '.$sheetData_MO_REF[($index+2)]['C'].'<---');
				$id_remplazar['Id'] = intval(preg_replace('/[^0-9]+/', '', $sheetData_Match[array_search($sheetData_MO_REF[($index+2)]['C'],$PaquetesRemplazar)]['B']), 10);
				$key = $db_intelisis->select('COUNT(DescripcionC) as count')->from($tabla_ServicioPaquetes)->where('Id', $id_remplazar['Id'])->get()->row_array();
			}else{
				// print_r('Paquete a insertar: '.$sheetData_MO_REF[($index+2)]['C'].'<---');
				$key = $db_intelisis->select('COUNT(DescripcionC) as count')->from($tabla_ServicioPaquetes)->where('DescripcionC', $sheetData_MO_REF[($index+2)]['C'])->get()->row_array();
				$id_remplazar = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value)->order_by("Estatus", "desc")->get()->row_array();
			}

			// **********LIMPIA TABLA DETALLE DE PAQUETES DEL LOS PAQUETES QUE SE VAN A INSERTAR**********
			$db_intelisis->where('IdPaquete', $id_remplazar['Id']);
			$db_intelisis->delete($tabla_ServicioPaquetesD);
			// **********INSERTA O ACTUALIZA PAQUETE EN TABLA ServicioPaquetes****************************
			if( $key['count'] == 0 ){
				$db_intelisis->insert($tabla_ServicioPaquetes,$arr_datos);  
				// print_r('Insertado');
				$indexinsert++;
				$inserts = $inserts."Id Paquete -> ".$db_intelisis->insert_id()." - ".$sheetData_MO_REF[($index+2)]['C']."<br>";
			}else{
				$db_intelisis->where('Id', $id_remplazar['Id']);
				$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos);
				// $ultimo_actualizado = $db_intelisis->select('Id')->from('ServicioPaquetes')->where('DescripcionC', $sheetData_MO_REF[($index+2)]['C'])->get()->row_array();
				// print_r('Actualizado');
				$indexupdat++;
				$updats = $updats."Id Paquete -> ".$id_remplazar['Id']." - ".$sheetData_MO_REF[($index+2)]['C']."<br>";
			}
		}
// die();
		// *****************************************************************************************************************
		// **************************          INSERTA DETALLE DE PAQUETES DEL ARCHIVO     *********************************
		// *****************************************************************************************************************
        foreach ($sheetData_MO_REF as $index => $value) {
        // print_r($value);            
            if ( $index != 1 && isset( $value['C'] ) ){
            	$existeArticulo = $db_intelisis->select('COUNT(*) as count')->from($view_dms_art)->where('Articulo', $value["E"].'')->where('Estatus', 'ALTA')->get()->row_array();
            	if( $existeArticulo['count'] > 0 )
            	{
            		$id_paquete_excel_d = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value['C'])->order_by("Estatus", "desc")->get()->row_array();
            		$existeDetalle = $db_intelisis->select('COUNT(*) as count')->from($tabla_ServicioPaquetesD)->where('Articulo', $value["E"].'')->where('IdPaquete', $id_paquete_excel_d['Id'])->get()->row_array();
            		if( $existeDetalle['count'] == 0 )
            		{
            			$renglon_d = $db_intelisis->select('MAX(Renglon) as NR')->from($tabla_ServicioPaquetesD)->where('IdPaquete', $id_paquete_excel_d['Id'])->get()->row_array();
	                	
	                	$renglon_d['NR'] = ( $renglon_d['NR'] == null ) ? 1 : $renglon_d['NR'] + 1;

	                	if( $value['D'] == 'MO' )
	                		$Tipo_Art = 'Servicio';
	                	else
	                		$Tipo_Art = 'Normal';

	                	$PrecioUnitario = 0;

	                	if( $value['H'][0] == '$' ) //Quitar $
	                		$PrecioUnitario = substr($value['H'], 1);
	                	else
	                		$PrecioUnitario = $value['H'];

	                	$PrecioUnitario = str_replace(',', '',$PrecioUnitario); //Quitar ,

	                	$PrecioTotal = $PrecioUnitario;
	                	if (is_numeric($value['G']) && $value['G'] != 0) {
	                		/*print_r("\n Antes ");
	                		print_r($PrecioUnitario);*/
	                		$PrecioUnitario = ( $PrecioUnitario / $value['G'] );
	                		/*print_r(" Despues: ");
	                		print_r($PrecioUnitario);*/
	                	}
	                	
	                	$arr_datos_d = array(
	                		'IdPaquete'			=> $id_paquete_excel_d['Id'], //Se obtiene del insert o update
	                		'Renglon'			=> $renglon_d['NR'], //Consecutivo Max del paquete
	                		'Articulo'			=> $value['E'],
	                		'SubtipoCuenta'		=> "", //Vacio
	                		'Cantidad'			=> $value['G'],
	                		'TTabulado'			=> $value['G'],
	                		'AlmacenEsp'		=> "", //Vacio
	                		'ListaPreciosEsp'	=> "", //Vacio
	                		'PrecioUnitario'	=> $PrecioUnitario, 
	                		'Actualizacion'		=> date("d-m-Y H:i:s"),
	                		'TipoArticulo'		=> $Tipo_Art, //Convertir Servicio Normal
	                		'Descripcion'		=> $value['F'],
	                		'PrecioTotal'		=> $PrecioTotal
	                		);
	                	foreach ($arr_datos_d as $llave_d => $valor_d) {
	                		$arr_datos_d[$llave_d] = $valor_d;
	                	}
	                	
	                    $db_intelisis->insert($tabla_ServicioPaquetesD,$arr_datos_d);  
            		}
            	}
            	else{
            		$ArticulosNoExistentes = $ArticulosNoExistentes."Clave -> ".$value['E']."<br>";
            		$id_paquete_excel = $db_intelisis->select('Id')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value['C'])->order_by("Estatus", "desc")->get()->row_array();
            		$arr_datos_e = array(
            			'Estatus'		=> 2,
            			'Actualizacion'	=> date("d-m-Y H:i:s")
            		);
            		$db_intelisis->where('Id', $id_paquete_excel['Id']);
					$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_e);
            	}
            } 
        }

        // *****************************************************************************************************************
		// **************************          CALCULO DE TOTALES PAQUETES DEL ARCHIVO     *********************************
		// *****************************************************************************************************************
		foreach ($CodigoPktsInsertar as $key => $value) {
        	// print_r(" key->".$key." value->".$value);
        	// $id_paquete_excel = $db_intelisis->select('Id')->from('ServicioPaquetes')->where('DescripcionC', $value)->get()->row_array();
        	// $sums_paquete = $db_intelisis->select_sum('PrecioUnitario')->from('ServicioPaquetesD')->where('IdPaquete', $id_paquete_excel['Id'])->get()->row_array();
        	$sums_paquete = $db_intelisis->select_sum($tabla_ServicioPaquetesD.'.PrecioTotal')->select_sum('Cantidad')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->where_in("".$tabla_ServicioPaquetes.".Estatus", [1, 2])->get()->row_array();
        	$sums_TTabulado = $db_intelisis->select_sum('TTabulado')->from($tabla_ServicioPaquetesD)->join($tabla_ServicioPaquetes, "".$tabla_ServicioPaquetes.".Id = ".$tabla_ServicioPaquetesD.".IdPaquete")->where("".$tabla_ServicioPaquetes.".DescripcionC", $value)->where($tabla_ServicioPaquetesD.".TipoArticulo", 'Servicio')->where_in("".$tabla_ServicioPaquetes.".Estatus", [1, 2])->get()->row_array();
        	$CostoHomologacion = $db_intelisis->select('Homologacion')->from($tabla_paquetesHomologacionPrecio)->where('CodigoPaquete', $value)->get()->row_array();
        	$Servicio = $db_intelisis->select('Kilometraje')->from($tabla_ServicioPaquetes)->where('DescripcionC', $value)->get()->row_array();
        	// print_r($sums_paquete);
        	/*$db_intelisis->where('IdPaquete', $id_paquete_excel['Id']);
        	$db_intelisis->delete('ServicioPaquetesD');*/
/*print_r(" Nombre ");
print_r($value);
print_r(" Precio ");
print_r($sums_paquete['PrecioTotal']);*/
			$VariableV = 0;
			if ($Servicio['Kilometraje'] >= $Rangos['Rango1'] && $Servicio['Kilometraje'] <= $Rangos['AlRango1'])
				$VariableV = $Rangos['ValorRango1'];
			if ($Servicio['Kilometraje'] >= $Rangos['Rango2'] && $Servicio['Kilometraje'] <= $Rangos['AlRango2'])
				$VariableV = $Rangos['ValorRango2'];
			if ($Servicio['Kilometraje'] >= $Rangos['Rango3'])
				$CostoVarios = $Rangos['ValorRango3'];
			else
				$CostoVarios = ((((ceil((($sums_paquete['PrecioTotal'])*1.16)/10-1)+1)*10-1)-(($sums_paquete['PrecioTotal'])*1.16))/1.16+$VariableV/1.16);
/*print_r(" Nombre ");
print_r($value);
print_r(" formula ");
print_r($VariableV);*/
			$arr_datos_varios['Varios'] = $CostoVarios;
			$db_intelisis->where('CodigoPaquete', $value);
			$db_intelisis->update($tabla_paquetesHomologacionPrecio,$arr_datos_varios);

        	$PrecioP = $sums_paquete['PrecioTotal'] + $CostoVarios;
/*print_r(" Extra ");
print_r($CostoVarios);
print_r(" Suma ");
print_r($PrecioP);
print_r(" CostoHomologacion ");
print_r('>'.$CostoHomologacion['Homologacion'].'<');
*/

			if (isset($CostoHomologacion['Homologacion'])) {
				if (is_numeric($CostoHomologacion['Homologacion']))
					$PrecioP = $PrecioP + $CostoHomologacion['Homologacion'];
			}
/*print_r(" Homologacion ");
print_r($PrecioP);*/

        	$IvaPrecio = $PrecioP * 0.16;
/*print_r(" Total ");
print_r($PrecioP + $IvaPrecio);*/
        	$arr_datos_sum['Precio'] = $PrecioP + $IvaPrecio ;
        	$arr_datos_sum['TTabulador'] = $sums_paquete['Cantidad'];
        	$arr_datos_sum['TFacturado'] = ( $sums_TTabulado['TTabulado'] == null ) ? 0 : $sums_TTabulado['TTabulado'];

        	/*
        	
			print_r(" Total ");
			print_r( $sums_paquete['PrecioUnitario'] + ((((ceil((($sums_paquete['PrecioUnitario'])*1.16)/10-1)+1)*10-1)-(($sums_paquete['PrecioUnitario'])*1.16))/1.16+0/1.16));*/

        	$db_intelisis->where('DescripcionC', $value);
			$db_intelisis->update($tabla_ServicioPaquetes,$arr_datos_sum);
        }

// die();

        $result['valid'] = true;
        $result['message'] = 'Productos importados correctamente';
        $result['changes'] = "";
        // PRECIOS HOMOLOGACIÓN
        if( $ServiciosNoNumericos != '' )
        	$result['changes'] = $result['changes']."<strong>Las siguientes claves de kilometraje de Servicio no son Numercias</strong><br>".$ServiciosNoNumericos;
        // Paquetes
		if( $indexinsert > 0 )
        	$result['changes'] = $result['changes']."<strong>".$indexinsert." Paquetes insertados...</strong><br>".$inserts;
		if( $indexupdat > 0 )            
        	$result['changes'] = $result['changes']."<strong>".$indexupdat." Paquetes actualizados...</strong><br>".$updats;
        if( $ArticulosNoExistentes != '' )
        	$result['changes'] = $result['changes']."<strong>Las siguientes claves de Números de pieza y/o Mano de obra no están registrados en Intelisis</strong><br>".$ArticulosNoExistentes;
        $result['name_a'] = $name;

		return $result;
	}

	public function catalogo_pkts()
	{
		$table = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_ServicioPaquetes' : 'vwServicioPaquetes';
        $filtro_consulta = "Estatus IN (1,2) ";
		if( $this->session->userdata("sw") == 1 ){
			return $this->db->select("*")
			->from($table)
			->where($filtro_consulta)
			->order_by("Id")
			->get()->result_array();	// REGRESAR A USO DE SERVICIOS WEB
		}else{
			$db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);	//<--- Conexion sin servicios web
			return $db_intelisis->select("*")->from($table)->where($filtro_consulta)->order_by("Id")->get()->result_array(); //<--- Conexion sin servicios web
		}
	}

	public function AsignarMultiPaquete($data)
	{
		$response  = [
			'nuevos' => ['saved' => false, 'message' => ''],
			'errores' => ['saved' => false, 'message' => ''],
			'actualizados' => ['saved' => false, 'message' => '']
		];
		foreach ($data['id_pkts'] as $key => $pkt) {
			$result = $this->AsignaPaquete($pkt);
			if ($result['saved'] == 'ok') {
				$response['nuevos']['message'] .= 'IdPaquete: '.$pkt['idPaquete']."\n";
				$response['nuevos']['saved'] = true;
			}elseif ($result['saved'] == 'ok_act') {
				$response['actualizados']['message'] .= 'IdPaquete: '.$pkt['idPaquete']."\n";
				$response['actualizados']['saved'] = true;
			}else{
				$response['errores']['message'] .= 'IdPaquete: '.$pkt['idPaquete']."\n";
				$response['errores']['saved'] = true;
			}
		}
		return $response;
	}

}