<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2016-06-29 10:40
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: MenuLModel.php
*    Type: Model
*    Description: This model manage the SQL for the MenuL
*/

class  MenuLModel extends CI_Model
{
	public function autocompleteML($Cve_Prosp)
	{
		$data["suggestions"] = $this->db->limit(12)->select("cp.Nombre+' '+cp.ApPaterno+' '+cp.ApMaterno AS value, cp.Nombre+' '+cp.ApPaterno+' '+cp.ApMaterno AS data, cp.id, cu.nombre+' '+cu.apellido_paterno+' '+cu.apellido_materno AS Propietario, cp.idUsuario AS idPropietario")
									->from("cte_prospecto cp")
									->join("ctrl_usuario cu", "cp.idUsuario = cu.id", "left")
									->where("cp.Activo", 1)
									->where("cp.idSuc", $this->session->userdata("id_suc"))
									// ->where("idUsuario", $this->session->userdata('id_usuario'))
									->like("cp.Nombre+' '+cp.ApPaterno+' '+cp.ApMaterno", $Cve_Prosp)
								->get()->result_array();
								// print_r($this->db->last_query());
		return $data;
	}

	public function DatosCliente($idCliente)
	{
		$data['Cte'] = $this->db->select("id, Nombre, ApPaterno, ApMaterno, Celular, LadaTel, Telefono, LadaTO, TelOficina, Ext, Email")
						->from("cte_prospecto")
						->where("id", $idCliente)
					->get()->row_array();
		$data['Vehiculos'] = $this->db->select("cp.idProspecto, cp.idVehiculo, cv.VIN, cv.Modelo, cv.Estatus")
								->from("cte_propietario cp")
								->join("cte_vehiculo cv", "cp.idVehiculo = cv.id")
								->where("cp.idProspecto", $idCliente)
								->where("cp.Activo", 1)
								->where("cp.Principal", 1)
								->order_by("cv.FechaActualizacion", "DESC")
							->get()->result_array();
		/*if (isset($data['Vehiculos'][0])) {
			$data['Vehiculo'] = $this->db->select("VIN, Modelo, Anio, Marca")
									->from("cte_vehiculo")
									->where("id", $data["Vehiculos"][0]["idVehiculo"])
								->get()->row_array();
			$data['Eventos'] = $this->db->select("id, Descripcion, Estatus")
									->from("cte_evento")
									->where("idVehiculo", $data["Vehiculos"][0]["idVehiculo"])
									->order_by("FechaEvento", "DESC")
							->get()->result_array();
		}*/
		// print_r($data);
		return $data;
	}
}