<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2017-06-28 18:57
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: FacturasModel.php
*    Type: Model
*    Description: This model manage the SQL for the Facturas
*/

class  FacturasModel extends CI_Model
{
	public function DatosFactura($idFactura)
	{
		$db_intelisis = $this->load->database('intelisis', TRUE);
		$data = $db_intelisis->select("Sucursal, Mov, Factura, NumeroEconomico, VIN, TipoVenta, FechaEmision, Agente, NombreAgente, Fabricante, Descripcion, Utilidad, Cliente, Nombre, Direccion, Colonia, CodigoPostal, Poblacion, Telefonos, RFC, Estatus, Articulo, UbicacionFisica")
						->from("WebFacturacion")
						->where("Factura", $idFactura)
						->where("Estacion", $this->session->userdata("id_usuario"))
					->get()->row_array();
		// echo $db_intelisis->last_query();
		/*$data['Vehiculos'] = $this->db->select("cp.idProspecto, cp.idVehiculo, cv.VIN, cv.Modelo, cv.Estatus")
								->from("cte_propietario cp")
								->join("cte_vehiculo cv", "cp.idVehiculo = cv.id")
								->where("cp.idProspecto", $idCliente)
								->where("cp.Activo", 1)
								->where("cp.Principal", 1)
								->order_by("cv.FechaActualizacion", "DESC")
							->get()->result_array();*/
		return $data;
	}

	public function DatosCliente($idCliente)
	{
		$db_intelisis = $this->load->database('intelisis', TRUE);
		$data = $db_intelisis->select("DISTINCT(Vin)")->from("vwWEBEventosCteVin")->where("Cliente", $idCliente)->get()->result_array();
		return $data;
	}

	public function ObtenerEventos($VinVehiculoSelect, $ClienteSelect)
	{
		$db_intelisis = $this->load->database('intelisis', TRUE);
		/*$answer['Vehiculo'] = $this->db->select("id, VIN, Modelo, Anio, Marca")
									->from("cte_vehiculo")
									->where("id", $idVehiculoSelect)
								->get()->row_array();*/
		$answer['Eventos'] = $db_intelisis->select("ID, Tipo, Mov, MovId, Fecha, (Convert(char(10), Fecha, 103)) AS FechaEventoMostrar, CONVERT(char(5), Fecha, 108) AS TimeEvento, DAY(Fecha) AS DiaEvento, MONTH(Fecha) AS MesEvento, YEAR(Fecha) AS AnioEvento, Depto, AlgunaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = vwWEBEventosCteVin.ID), EncuestaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = vwWEBEventosCteVin.ID AND Depto = vwWEBEventosCteVin.Depto AND Tipo = 'Encuesta'), LlamadaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = vwWEBEventosCteVin.ID AND Depto = vwWEBEventosCteVin.Depto AND Tipo = 'Llamada')")
						->from("vwWEBEventosCteVin")
						->where("Cliente", $ClienteSelect)
						->where("Vin", $VinVehiculoSelect)
						->order_by("AnioEvento ASC, MesEvento ASC, DiaEvento ASC")
				->get()->result_array();
			// print_r($db_intelisis->last_query());
		$answer['FechasEventos'] = $db_intelisis->select("DISTINCT(Convert(char(10), Fecha, 103)) AS FechaEvento, DAY(Fecha) AS DiaEvento, MONTH(Fecha) AS MesEvento, YEAR(Fecha) AS AnioEvento")
						->from("vwWEBEventosCteVin")
						->where("Cliente", $ClienteSelect)
						->where("Vin", $VinVehiculoSelect)
						->order_by("AnioEvento DESC, MesEvento DESC, DiaEvento DESC")
				->get()->result_array();
				
		return $answer;
	}

	public function Obtenertipos($dpto)
	{
		$db_intelisis = $this->load->database('intelisis', TRUE);
		return $db_intelisis->get_where( 'CCCatEncuestas' , array( 'Depto' => $dpto , 'Estatus' => 'Alta' ) )->result_array();
	}

}