<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2017-06-28 18:57
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: EncuestasModel.php
*    Type: Model
*    Description: This model manage the SQL for the Encuestas
*/

class  EncuestasModel extends CI_Model
{
	protected $db_intelisis;
	public function __construct()
	{
		parent::__construct();
		$this->db_intelisis = $this->load->database('intelisis', TRUE);
	}

	public function getInquiryTypes()
	{
		return $this->db_intelisis->distinct()
		->select( 'Depto' )
		->get( 'EncuestaFacturas' )->result_array();
	}

	public function getFilteredInvoices()
	{
		$filter = $this->input->post();
		
		$var = $this->db_intelisis->select( "ID, Depto, MovID = ISNULL(MovID, ''), Cliente, Nombre, Telefono, Correo, Vehiculo = SUBSTRING(Vehiculo, 1, 15), FechaEmision = ISNULL(REPLACE(CONVERT(varchar, FechaEmision,111),'/','-'), ''), AlgunaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = ID AND Depto = '".$filter["depotType"]."' ), EncuestaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = ID AND Depto = '".$filter["depotType"]."' AND Tipo = 'Encuesta'), LlamadaRealizada = (SELECT COUNT(*) FROM CCEncuestas WHERE Idventa = ID AND Depto = '".$filter["depotType"]."' AND Tipo = 'Llamada')" )
		->from( 'EncuestaFacturas' )
		->where( 'Depto' , $filter[ 'depotType' ] )
		->where( 'Estatus' , 'CONCLUIDO' )
		->where( "FechaEmision BETWEEN '" . $filter[ 'dateBegin' ] . "' AND '" . $filter[ 'dateEnd' ] . "'" )
		->get()
		->result_array();
// print_r($this->db_intelisis->last_query());
		return $var;
	}

	public function getTypeInquiry()
	{
		$filter = $this->input->post();

		return $this->db_intelisis->get_where( 'CCCatEncuestas' , array( 'Depto' => $filter[ 'depotType' ] , 'Estatus' => 'Alta' ) )->result_array();
	}

	public function inquiryDone( $IdCatEncuesta = null, $Idventa = null )
	{
		// check if there is a inquiry already registered in CCEncuestas
		$done = $this->db_intelisis->from( 'CCEncuestas' )
					->where( 'IdCatEncuesta', $IdCatEncuesta )
					->where( 'Idventa', $Idventa )
					->count_all_results();
					// print_r($this->db->last_query());

		return $done;
	}

	public function beginInquiry( $IdCatEncuesta = null, $Idventa = null )
	{
		//Titulo de encuesta
		$data[ 'inquiry' ] = $this->db_intelisis->select( 'Titulo, IdCatEncuesta' )
			->from( 'CCCatEncuestas' )
			->where( 'IdCatEncuesta', $IdCatEncuesta )
			->get()->row_array();

		//Preguntas de encuesta
		$questions = $this->db_intelisis->select( 'IdPregunta, TipoResp, Pregunta,Dependencia,IdDependencia,IdRespuesta,TipoVal, NULL AS SelRespuesta, NULL AS Respuesta' )
			->from( 'CCCatEncuestasPreguntas' )
			->where( 'IdCatEncuesta', $IdCatEncuesta )
			->get()->result_array();
		
		//Opciones multiples de encuesta
		$data[ 'questions' ] = $this->getPossibleAnswers( $questions, $IdCatEncuesta );

		$data[ 'Idventa' ] = $Idventa;

		return $data;
	}

	public function getPossibleAnswers( $questions = null, $IdCatEncuesta = null )
	{
		for( $i = 0; $i < count( $questions ); $i ++ )
			$questions[ $i ][ 'possibleAnswers' ] =
					$this->db_intelisis->select( 'IdResp, SelRespuesta' )
						->from( 'CCEncuestasResp' )
						->where( 'IdCatEncuesta', $IdCatEncuesta )
						->where( 'IdPregunta', $questions[ $i ][ 'IdPregunta' ] )
						->get()->result_array();

		return $questions;
	}

	public function getIdFactura( $Idventa = null )
	{
		$this->db_intelisis->select( 'MovID, Nombre, Telefono, Correo, Serie, EmpresaNombre, TituloFormato, NombreAgente, Vehiculo' )
			->from( 'EncuestaFacturas' )
				->where( 'ID', $Idventa );

		return $this->db_intelisis->get()->row_array();
	}

	public function saveInquiryResult( $inquiryResult = null )
	{
		$inquiryData = $this->db_intelisis->select( 'Depto, Tipo, Titulo' )->from( 'CCCatEncuestas' )
					->where( 'IdCatEncuesta', $inquiryResult[ 'IdCatEncuesta' ] )
					->get()->row_array();
		
		$inquiryData[ 'IdCatEncuesta' ] = $inquiryResult[ 'IdCatEncuesta' ];
		$inquiryData[ 'Idventa' ] = $inquiryResult[ 'Idventa' ];
		$inquiryData[ 'Fecha' ] = date( 'd-m-Y H:i:s' );
		
		$this->db_intelisis->insert( 'CCEncuestas', $inquiryData );

		// in the array, just the question and its data
		$IdCatEncuesta = $inquiryResult[ 'IdCatEncuesta' ];
		$Idventa = $inquiryResult[ 'Idventa' ];

		unset( $inquiryResult[ 'IdCatEncuesta' ], $inquiryResult[ 'Idventa' ] );

		// insert a row for each question and its answer
		foreach ( $inquiryResult as $question )
		{
			if( isset( $question[ 3 ] ) )
				$respuesta = $question[ 3 ];
			else
				$respuesta = '';
			
			$this->db_intelisis->insert( 'CCEncuestasPreguntas',
					[ 
						'IdCatEncuesta' => $IdCatEncuesta,
						'Idventa'       => $Idventa,
						'IdPregunta'    => $question[ 0 ],
						'Pregunta'	    => $question[ 1 ],
						'TipoResp'	    => $question[ 2 ],
						'Respuesta'     => $respuesta
					]
				);
		}
	}

	public function showInquiry( $input = null )
	{
		$data[ 'inquiry' ] = $this->db_intelisis->select( '*' )
								->from( 'CCEncuestas' )
								->where( 'Idventa', $input[ 'Idventa' ] )
								->where( 'IdCatEncuesta', $input[ 'IdCatEncuesta' ] )
								->get()->row_array();

		$data[ 'inquiry' ][ 'Fecha' ] = new DateTime( $data[ 'inquiry' ][ 'Fecha' ] );

		$questions = $this->db_intelisis->select( 'c.IdPregunta, c.TipoResp, c.Pregunta, c.SelRespuesta, c.Respuesta,
	cc.IdDependencia' )
									->from( 'CCEncuestasPreguntas c' )
									->join('CCCatEncuestasPreguntas cc', 'cc.IdPregunta = c.IdPregunta AND cc.IdCatEncuesta = c.IdCatEncuesta')
									->where( 'c.Idventa', $input[ 'Idventa' ] )
									->where( 'c.IdCatEncuesta', $input[ 'IdCatEncuesta' ] )
									->get()->result_array();
// print_r($this->db_intelisis->last_query());
		$data[ 'questions' ] = $this->getPossibleAnswers( $questions, $input[ 'IdCatEncuesta' ] );

		return $data;
	}

	public function getPrintFormat( $IdCatEncuesta = null, $Idventa = null )
	{
		$this->db_intelisis->select( '*' )
			->from( 'FormatoImpresionEncuesta' )
				->where( 'IdCatEncuesta', $IdCatEncuesta )
				->where( 'Idventa', $Idventa );

		return $this->db_intelisis->get()->row_array();
	}

}