<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2016-07-13 12:40
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: SeguimientoModel.php
*    Type: Model
*    Description: This model manage the SQL for the CCWeb
*/

class SeguimientoModel extends CI_Model
{
	 public function __construct()
        {
                // Call the CI_Model constructor
                parent::__construct();
        }

	public function ObtenerEventos($idVehiculoSelect)
	{
		$answer['Vehiculo'] = $this->db->select("id, VIN, Modelo, Anio, Marca")
									->from("cte_vehiculo")
									->where("id", $idVehiculoSelect)
								->get()->row_array();
		$answer['Eventos'] = $this->db->select("id, Descripcion, Estatus, FechaEvento, (Convert(char(10), FechaEvento, 103)) AS FechaEventoMostrar, CONVERT(char(5), FechaEvento, 108) AS TimeEvento, DAY(FechaEvento) AS DiaEvento, MONTH(FechaEvento) AS MesEvento, YEAR(FechaEvento) AS AnioEvento")
						->from("cte_evento")
						->where("idVehiculo", $idVehiculoSelect)
						->order_by("AnioEvento ASC, MesEvento ASC, DiaEvento ASC")
				->get()->result_array();
		$answer['FechasEventos'] = $this->db->select("DISTINCT(Convert(char(10), FechaEvento, 103)) AS FechaEvento, DAY(FechaEvento) AS DiaEvento, MONTH(FechaEvento) AS MesEvento, YEAR(FechaEvento) AS AnioEvento")
						->from("cte_evento")
						->where("idVehiculo", $idVehiculoSelect)
						->order_by("AnioEvento DESC, MesEvento DESC, DiaEvento DESC")
				->get()->result_array();
				// print_r($this->db->last_query());
		return $answer;
	}

	public function autocompleteCP($Search, $cve_cp)
	{
		switch ($Search) {
			case 'CP':
					$data["suggestions"] = $this->db->limit(10)->select("CP+' '+Asentamiento+' / '+Municipio AS value, CP AS data, Asentamiento, Municipio, Estado, Pais")
											->from("cat_codigo_postal")
											->like("CP", $cve_cp)
										->get()->result_array();
				break;
			
			case 'Asentamiento':
					$data["suggestions"] = $this->db->limit(10)->select("CP+' '+Asentamiento+' / '+Municipio AS value, Asentamiento AS data, CP, Municipio, Estado, Pais")
											->from("cat_codigo_postal")
											->like("Asentamiento+' '+Municipio", $cve_cp)
											// ->or_like("Municipio+' '+Asentamiento", $cve_cp)
										->get()->result_array();
				break;
			case 'Municipio':
					$data["suggestions"] = $this->db->select("DISTINCT(Municipio) AS value, Municipio AS data, Estado, Pais")
											->from("cat_codigo_postal")
											->like("Municipio", $cve_cp)
										->get()->result_array();
				break;
			case 'Estado':
					$data["suggestions"] = $this->db->select("DISTINCT(Estado) AS value, Estado AS data, Pais")
											->from("cat_codigo_postal")
											->like("Estado", $cve_cp)
										->get()->result_array();
				break;
			case 'Pais':
					$data["suggestions"] = $this->db->select("DISTINCT(Pais) AS value, Pais AS data")
											->from("cat_codigo_postal")
											->like("Pais", $cve_cp)
										->get()->result_array();
				break;
		}
		// print_r($this->db->last_query());
		return $data;
	}

	public function ObtieneProspecto($idProspecto)
	{
		$answer = $this->db->select('*')->from('cte_prospecto')->where('id', $idProspecto)->get()->row_array();
		return $answer;
	}

	public function GuardarProspecto($NuevoProspecto)
	{
		$NuevoProspecto['rfc'] = strtoupper($NuevoProspecto['rfc']);
		$NuevoProspecto['Nombre'] = ucwords($NuevoProspecto['Nombre']);
		$NuevoProspecto['ApPaterno'] = ucwords($NuevoProspecto['ApPaterno']);
		$NuevoProspecto['ApMaterno'] = ucwords($NuevoProspecto['ApMaterno']);

		$NuevoProspecto['Direccion'] = ucwords($NuevoProspecto['Direccion']);
		$NuevoProspecto['Colonia'] = ucwords($NuevoProspecto['Colonia']);
		$NuevoProspecto['Delegacion'] = ucwords($NuevoProspecto['Delegacion']);
		$NuevoProspecto['Estado'] = ucwords($NuevoProspecto['Estado']);
		$NuevoProspecto['Pais'] = ucwords($NuevoProspecto['Pais']);

		if($NuevoProspecto['rfc'] == "XAXX010101000" || $NuevoProspecto['rfc'] == NULL){
			$existeProspecto = $this->db->select('id, idUsuario')
								->from('cte_prospecto')
								->where('Nombre', $NuevoProspecto['Nombre'])
								->where('ApPaterno', $NuevoProspecto['ApPaterno'])
								->where('ApMaterno', $NuevoProspecto['ApMaterno'])
								->where('Activo', 1)
							->get()->row_array();
		}
		else{
			$existeProspecto = $this->db->select('id, idUsuario')
								->from('cte_prospecto')
								->where('RFC', $NuevoProspecto['rfc'])
								->where('Activo', 1)
							->get()->row_array();
		}

		$answer = count($existeProspecto);
		// print_r($existeProspecto);
		// print_r($answer);

		$insertNProspecto['Nombre'] = $NuevoProspecto['Nombre'];
		$insertNProspecto['ApPaterno'] = $NuevoProspecto['ApPaterno'];
		$insertNProspecto['ApMaterno'] = $NuevoProspecto['ApMaterno'];
		$insertNProspecto['RFC'] = $NuevoProspecto['rfc'];
		
		$insertNProspecto['Celular'] = $NuevoProspecto['Celular'];
		$insertNProspecto['LadaTel'] = $NuevoProspecto['Lada'];
		$insertNProspecto['Telefono'] = $NuevoProspecto['Telefono'];
		$insertNProspecto['LadaTO'] = $NuevoProspecto['LadaO'];
		$insertNProspecto['TelOficina'] = $NuevoProspecto['TelOficina'];
		$insertNProspecto['Ext'] = $NuevoProspecto['Ext'];
		$insertNProspecto['Email'] = $NuevoProspecto['Email'];

		$insertNProspecto['Direccion'] = $NuevoProspecto['Direccion'];
		$insertNProspecto['Numero'] = $NuevoProspecto['Numero'];
		$insertNProspecto['NumInt'] = $NuevoProspecto['NumeroInterior'];
		$insertNProspecto['CP'] = $NuevoProspecto['CodigoPostal'];
		$insertNProspecto['Colonia'] = $NuevoProspecto['Colonia'];
		$insertNProspecto['Delegacion'] = $NuevoProspecto['Delegacion'];
		$insertNProspecto['Estado'] = $NuevoProspecto['Estado'];
		$insertNProspecto['Pais'] = $NuevoProspecto['Pais'];

		if($answer == 0){
			$insertNProspecto['idSuc'] = $this->session->userdata('id_suc');
			$insertNProspecto['idUsuario'] = $this->session->userdata('id_usuario');
			
			$insertNProspecto['idRegistro'] = $this->session->userdata('id_usuario');
			$insertNProspecto['Activo'] = 1;

			$this->db->trans_start();
				$this->db->insert('cte_prospecto', $insertNProspecto);
			$this->db->trans_complete();

			if($this->db->trans_status() == true)
				$answer = "ok";
			else
				$answer = "ko";
		}

		if ($answer > 0 && $existeProspecto['idUsuario'] == $this->session->userdata('id_usuario')) {
			$insertNProspecto['FechaActualizacion'] = date("d-m-Y H:i:s");
			$this->db->trans_start();
				$this->db->where('id', $existeProspecto['id']);
				$this->db->Update('cte_prospecto', $insertNProspecto);
			$this->db->trans_complete();

			if($this->db->trans_status() == true)
				$answer = "act_ok";
			else
				$answer = "ko";
		}

		return $answer;
	}

	public function AgregaVehiculo($NuevoVehiculo, $idCliente)
	{
		$NuevoVehiculo['VIN'] = strtoupper($NuevoVehiculo['VIN']);

		$existeVehiculo = $this->db->select('id, idUsuario')
								->from('cte_vehiculo')
								->where('VIN', $NuevoVehiculo['VIN'])
								->where('Estatus', 'Pendiente')
								->where('idSuc', $this->session->userdata('id_suc'))
							->get()->row_array();
		// printf($this->db->last_query());
		
		if(isset($existeVehiculo['id'])){
			$answer = 'existe';
		}else{
			$insertNVehiculo['idSuc'] = $this->session->userdata('id_suc');
			$insertNVehiculo['idUsuario'] = $this->session->userdata('id_usuario');

			$insertNVehiculo['VIN'] = $NuevoVehiculo['VIN'];
			$insertNVehiculo['Marca'] = $NuevoVehiculo['Marca'];
			$insertNVehiculo['Modelo'] = $NuevoVehiculo['Modelo'];
			$insertNVehiculo['Version'] = $NuevoVehiculo['Version'];
			$insertNVehiculo['Anio'] = $NuevoVehiculo['Anio'];

			$insertNVehiculo['Estatus'] = 'Pendiente';
			$insertNVehiculo['TipoOperacion'] = 'TO';
			$insertNVehiculo['idRegistro'] = $this->session->userdata('id_usuario');

			$insertPropietario['idProspecto'] = $idCliente;
			$insertPropietario['Principal'] = 1;
			$insertPropietario['Activo'] = 1;

			$insertEventoRegistro['TipoEvento'] = 'Registro';
			$insertEventoRegistro['Descripcion'] = 'Registro Prospecto';
			$insertEventoRegistro['idUsuario'] = $this->session->userdata('id_usuario');
			$insertEventoRegistro['Estatus'] = 1;
			$insertEventoRegistro['FechaEvento'] = date("d-m-Y H:i:s");
			$insertEventoRegistro['FechaDebeTerminar'] = date("d-m-Y H:i:s");
			$insertEventoRegistro['FechaRealizado'] = date("d-m-Y H:i:s");
			$insertEventoRegistro['idRegistro'] = $this->session->userdata('id_usuario');

			$this->db->trans_start();
				$this->db->insert('cte_vehiculo', $insertNVehiculo);
				$insertPropietario['idVehiculo'] = $this->db->insert_id();
				$this->db->insert('cte_propietario', $insertPropietario);
				$insertEventoRegistro['idVehiculo'] = $insertPropietario['idVehiculo'];
				$this->db->insert('cte_evento', $insertEventoRegistro);
			$this->db->trans_complete();

			if($this->db->trans_status() == true)
				$answer = "ok";
			else
				$answer = "ko";
		}

		return $answer;
	}

	public function ObtenerTipoEventos()
	{
		$answer = $this->db->select('Evento, Descripcion, Tipo')->from('cte_tipo_evento')->where('Activo', 1)->order_by("Tipo")->get()->result_array();
		return $answer;
	}

	public function AgragaEvento($NuevoEvento)
	{
		$TipoEvento = $this->db->select('Descripcion')->from('cte_tipo_evento')->where('Evento', $NuevoEvento['TipoEvento'])->get()->row_array();

		$insertNuevoEvento['idVehiculo'] = $NuevoEvento['idVehiculo'];
		$insertNuevoEvento['TipoEvento'] = $NuevoEvento['TipoEvento'];
		$insertNuevoEvento['Descripcion'] = $TipoEvento['Descripcion'];
		$insertNuevoEvento['idUsuario'] = $this->session->userdata('id_usuario');
		$insertNuevoEvento['Estatus'] = 0;
		$insertNuevoEvento['FechaEvento'] = $NuevoEvento['FechaEvento'];
		$insertNuevoEvento['FechaDebeTerminar'] = date("d-m-Y H:i:s");
		$insertNuevoEvento['idRegistro'] = $this->session->userdata('id_usuario');

		$this->db->trans_start();
			$this->db->insert('cte_evento', $insertNuevoEvento);
		$this->db->trans_complete();

		if($this->db->trans_status() == true)
			$answer = "ok";
		else
			$answer = "ko";

		return $answer;
	}

	public function SeguimientoEvento($DatosEvento)
	{
		$UpdateEvento['Estatus'] = 1;
		$UpdateEvento['FechaRealizado'] = date("d-m-Y H:i:s");
		$UpdateEvento['FechaActualizacion'] = date("d-m-Y H:i:s");

		$this->db->trans_start();
			$this->db->where('id', $DatosEvento['idEvento']);
			$this->db->Update('cte_evento', $UpdateEvento);
		$this->db->trans_complete();
// print_r($this->db->last_query());
		if($this->db->trans_status() == true)
			$answer = "ok";
		else
			$answer = "ko";

		return $answer;
	}

}