<?php
/*  
*     _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*    |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*      | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*      | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*     _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*    |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Author: Roberto Ortiz
*    Date: 
*    Update: 2017-05-24 12:55
*    Languague: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    File: AntilavadoModel.php
*    Type: Model
*    Description: This model manage the SQL for the Ley Antilavado
*/

class  AntilavadoModel extends CI_Model
{
	protected $db_intelisis;
	public function __construct()
	{
		parent::__construct();
		$this->db_intelisis = $this->load->database('intelisis2', TRUE);
	}

/*#### Consultas para la carga inicial de registros ###########################*/
	public function ConsultaSucursales()
	{
		return $this->db_intelisis->select("Sucursal, Nombre")->from("Sucursal")->get()->result_array();
	}

	//Consulta desechada *
	public function ListadoLeyAntilavado($id_sucursal, $id_periodo) //Funcion de prueba, no se ocupa realmente en el sistema
	{
		if( $id_sucursal == null )
			$id_sucursal = -1;
		return $this->db->query("EXEC spConsultaSuc '".$id_sucursal."', '".$id_periodo."-01'")->result_array();
	}

/*#### Consultas para tabla de registros ####################################*/
	public function ConsultaMovimientos()
	{
		$filter = $this->input->post();

		// $this->db_intelisis->query("xpLaLavObtenerCabecero ".$filter[ 'Month' ].", ".$filter[ 'Year' ].", ".$filter['Sucursal'].", ".$this->session->userdata("id_usuario"))->result_array();

		$Movimientos = $this->db_intelisis->select("ESTACION, id, mov, movid, TotalPagos, cliente, rfc, FechaPago = ISNULL(REPLACE(CONVERT(varchar, FechaPago,111),'/','-'), '')")->from("LALavMovimientos")->where("Estacion", $this->session->userdata("id_usuario"))->get()->result_array();

		/*$var = $this->db->select( '*' )
		->from( 'EncuestaFacturas' )
		->where( 'Depto' , $filter[ 'depotType' ] )
		->where( 'Estatus' , 'CONCLUIDO' )
		->where( "FechaEmision BETWEEN '" . $filter[ 'dateBegin' ] . "' AND '" . $filter[ 'dateEnd' ] . "'" )
		->get()
		->result_array();*/
		return $Movimientos;
	}

	public function ObtenerPagos($idMovimiento){
		$this->db_intelisis->query("xpLaLavObtenerPagos ".$this->session->userdata("id_usuario").", ".$idMovimiento)->result_array();
		$result = $this->db_intelisis->select("MovPago, MovIDPago, Total, Moneda, FechaEmision = ISNULL(REPLACE(CONVERT(varchar, FechaEmision,111),'/','-'), ''), Condicion = ISNULL(Condicion, ''), FormaCobro = ISNULL(FormaCobro, '')")->from("LaLavCXCPagos")->where("Estacion", $this->session->userdata("id_usuario"))->where("IDVenta", $idMovimiento)->order_by("FechaEmision", "desc")->get()->result_array();
		return $result;
	}

/*#### Consultas para la configuracion del modulo ###########################*/
	public function ConsultaConfiguraciones()
	{
		//Falta agregar where empresa
		return $this->db_intelisis->select("TopeAntilavadoAnterior, TopeInfAntilavadoAnterior, TopeAntilavado,  TopeInfAntilavado, TopePagoEfectivo,Ruta,ClaveActividad,PrefijoConsecutivo")->from("LaLavConfiguraciones")->get()->result_array();
	}

	public function actualizar_configuraciones($Configuraciones,$Empresa=null)
	{
		$this->db_intelisis->trans_start();

		$this->db_intelisis->query("xpActualizaLaLavConfiguraciones '".$Configuraciones['TopeAntilavado']."', '".$Configuraciones['TopeAntilavadoAnterior']."', '".
			$Configuraciones['TopePagoEfectivo']."', '". $Configuraciones['TopeInfAntilavado']."', '".$Configuraciones['TopeInfAntilavadoAnterior']."', '".
			 $Configuraciones['Ruta']."', '".$Configuraciones['ClaveActividad']."', '".$Configuraciones['PrefijoConsecutivo']."'");

		$this->db_intelisis->trans_complete();

		if($this->db->trans_status() == true){
			$ret['saved'] = "ok";
		}
		else
			$ret['saved'] = "ko";

		return $ret;
	}

/*#### Consultas para la generacion de xml para validacion ##################*/
	public function ConsultaActividadesVulnerables()
	{
		//Falta agregar where empresa
		return $this->db_intelisis->select("actividadvulnerable, descripcion")->from("ActividadVulnerable")->get()->result_array();	//<--- Conexion sin servicios web

	}

	public function ConsultaPagosVenta($estacion, $idVenta)
	{
		//$db_intelisis->where('idVenta', $idVenta);
		//$db_intelisis->where('estacion', $estacion);
		//return $db_intelisis->select("actividadvulnerable, descripcion")->from("ActividadVulnerable")->get()->result_array();
		return $this->db_intelisis->select("FechaEmision,Condicion,FormaCobro,Total,CveMon")->from("LaLavCXCPagos")->where("idVenta", $idVenta)->where("estacion", $estacion)->get()->row_array();
	}

	public function ConsultaMovimientosPxml($estacion){
		//$db_intelisis->where('idVenta', $idVenta);
		//$db_intelisis->where('estacion', $estacion);
		//return $db_intelisis->select("actividadvulnerable, descripcion")->from("ActividadVulnerable")->get()->result_array();
		return $this->db_intelisis->select("*")->from("LaLavMovimientos")->where("estacion", $estacion)->get()->row_array();
	}

	public function VaciaErrores($estacion)
	{
		$this->db_intelisis->where('estacion', $estacion);
		$this->db_intelisis->delete('LaLavErroresXML');
	}

	public function InsertaError($estacion,$elemento, $linea, $mensaje)
	{
		$data = array(
				'Estacion' => $estacion,
				'elemento' => $elemento,
				'linea' => $linea,
				'mensaje'=>$mensaje,
				);
		//aqui se realiza la inserción, si queremos devolver algo deberíamos usar delantre return
		//y en el controlador despues de $nueva_insercion poner lo que queremos hacer, redirigir,

		//envíar un email, en fin, lo que deseemos hacer
		//$db_intelisis->where('estacion', $estacion);
		//$db_intelisis->delete('ListaDatos');
		$this->db_intelisis->insert('LaLavErroresXML',$data);
	}

}