<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor:Roberto Ortiz
*    Dia: 07-02-2014
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: login.php
*    Tipo: Controller
*    Descripcion: sera el controlador de manipular el login del sistema
*/

class Login extends MY_Controller {

	function __construct()
    {
        parent::__construct();
        $this->load->model('login_model');
    }

	public function index()
	{
		$error['error'] = "ok";
		if($this->session->userdata('loggedIn'))
		{
			$data1 = $this->login_model->login_iniciado();
			$modulos['modulos'] = $this->login_model->modulos($data1['id_nivel']);
			$modulos['img'] = $this->login_model->imagen($data1['id_suc']);
			// $modulos['formatos'] = $this->login_model->formatos($data1['id_suc']);
			$this->load->view('Principal.php', $modulos);	
		}
		else
			$this->load->view('login/login', $error);
	}

	public function login_check()
	{
		$data = $this->input->post();
		$data1 = $this->login_model->login($data);
		if(!empty($data1))
		{
			if(sha1($this->config->item('encryption_key').''.$data['pass']) == $data1['password'])
			{
				$modulos['modulos'] = $this->login_model->modulos($data1['id_nivel']);
				$modulos['img'] = $this->login_model->imagen($data1['id_suc']);
				$data2['id_usuario'] = $data1['id'];
				$data2['nombre'] = $data1['nombre'];
				$data2['apellido_paterno'] = $data1['apellido_paterno'];
				$data2['apellido_materno'] = $data1['apellido_materno'];
				$data2['email'] = $data1['email'];
				$data2['id_suc'] = $data1['id_suc'];
				$data2['suc'] = $data1['nom'];
				$data2['sw'] = $data1['servicios_web'];
				$data2['id_ag'] = $data1['id_ag'];
				$data2['nom_ag'] = $data1['nom_ag'];
				$data2['id_nivel'] = $data1['id_nivel'];
	            $data2['loggedIn'] = true;
	            $data2['f_perfil'] = $data1['vcf_perfil'];
            	$this->session->set_userdata($data2);
            	$this->versionIntelisis($data1['id_suc'], $data1['nom_ag']);
				$this->load->view('Principal.php', $modulos);
			}else
			{
				$error['error'] = "Contrase&ntilde;a incorrecta";
				$this->load->view('login/login', $error);
			}
		}else
		{
			$error['error'] = "Usuario incorrecto";
			$this->load->view('login/login', $error);
		}
	}

	public function salir()
	{
		$this->session->sess_destroy();
		header('Location: '.base_url().'');
	}

	public function offline()
	{
		$this->load->view('login/offline');
	}
	public function forbidden()
	{
		$this->load->view('forbidden');
	}

}