<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 03-08-2015
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: Paquetes.php
*    Tipo: Controller
*    Descripcion: sera el controlador de manipular Los Paquetes del CC.
*/

class Paquetes extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
            redirect('login/offline', 'location');
        $this->load->model('Paquetes/PaquetesModel');
        $data[] = null;
        // $this->load->library('excel');

        // $this->load->model( 'proveedor_model' );
        // $this->load->model( 'modelo_model' );
    }

	public function PaquetesCtrl($id_paq_selec = null)
	{
        // Catalogo del sistema - Tipo Paquete
        $cat_TipoPaquete = $this->PaquetesModel->cat_TipoPaquete();
        // $articulos = $this->PaquetesModel->Articulos();
        $articulos = [];
		$this->load->view('Paquetes/Paquetes.php', compact('cat_TipoPaquete', 'articulos', 'id_paq_selec'));
	}

    public function tablaArt()
    {
        /*$table = 'dms_art';

        $primaryKey = 'Articulo';

        $columns = array(
            array(
                'db' => 'id',
                'dt' => 'DT_RowId'/
                // 'formatter' => function( $d, $row ) {
                //     return 'row_'.$d;
                // }
            ),
            array( 'db' => 'Articulo', 'dt' => 'Articulo' ),
            array( 'db' => 'Descripcion',  'dt' => 'Descripcion' ),
            array( 'db' => 'Tipo',   'dt' => 'Tipo' ),
        );

        $sql_details = array(
            'user' => "sa",
            'pass' => "",
            'db'   => "CCWeb",
            'host' => "192.168.41.111"
        );

        require( 'ssp.class.php' );
 
        echo json_encode(
            SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
        );*/

        // print_r($_GET);

        /*$data["draw"] = 1;
        $data["recordsTotal"] = 20;
        $data["recordsFiltered"] = 20;
        $data["data"] = $this->PaquetesModel->Articulos();
        echo json_encode($data);*/

        // DB table to use
        // El valor se obtiene de la variable de sesion para poder soportat conexion a multiples bases de datos
        $table =  $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_dms_art' : 'dms_art';
        // $table = 'ctrl_usuario';
         
        // Table's primary key
        $primaryKey = 'Articulo';
        // $primaryKey = 'id';
         
        // indexes
        $columns = array(
            array( 'db' => 'Articulo', 'dt' => 'Articulo' ),
            array( 'db' => 'Descripcion1',  'dt' => 'Descripcion' ),
            array( 'db' => 'Tipo',   'dt' => 'Tipo' )
        );
        
        if( $this->session->userdata("sw") == 1 ){
            // SQL server connection information
            $sql_details = array(
                'user' => $this->db->username,
                'pass' => $this->db->password,
                'db'   => $this->db->database,
                'host' => $this->db->hostname   // REGRESAR A USO DE SERVICIOS WEB
            );
        }else{
            $db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);   //<--- Conexion sin servicios web
            // SQL server connection information
            $sql_details = array(
                'user' => $db_intelisis->username,
                'pass' => $db_intelisis->password,
                'db'   => $db_intelisis->database,
                'host' => $db_intelisis->hostname   //<--- Conexion sin servicios web
            );
        }
            
        // print_r(" datos --- ".$this->db->database);
                require( 'ssp.class.php' );
                $post = $this->input->post();
                $filtro_consulta = "Tipo IN ('Servicio', 'Normal') AND Estatus = 'ALTA' ";
                echo json_encode(
                    SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
                );
    }

    public function TSearchPaquetes()
    {
        // DB table to use
        $table = $this->session->userdata('ConfigVersionIntelisis') == 'V6000' ? 'vwCA_ServicioPaquetes' : 'vwServicioPaquetes';

        // Table's primary key
        $primaryKey = 'Id';
         
        // indexes
        $columns = array(
            array( 'db' => 'Id',               'dt' => 'id' ),
            // array( 'db' => 'EspacioD',         'dt' => 'EspacioD' ),
            // array( 'db' => 'Id',                'dt' => 'IdMostrar' ),
            array( 'db' => 'DescripcionC',      'dt' => 'DescripcionC' ),
            array( 'db' => 'DescripcionL',      'dt' => 'DescripcionL' ),
            array( 'db' => 'TipoPaquete',       'dt' => 'TipoPaquete' ),
            array( 'db' => 'kilometraje',       'dt' => 'Kilometraje' ),
            array( 'db' => 'Precio',            'dt' => 'Precio' ),
            array( 'db' => 'TipoPrecio',        'dt' => 'TipoPrecio' ),
            array( 'db' => 'Prorrateo',         'dt' => 'Prorrateo' ),
            array( 'db' => 'TTabulador',        'dt' => 'TTabulador' ),
            array( 'db' => 'TFacturado',        'dt' => 'TFacturado' ),
            array( 'db' => 'ClavePlanta',       'dt' => 'ClavePlanta' ),
            array( 'db' => 'Detalle',           'dt' => 'Detalle' ),
            array( 'db' => 'Configurado',       'dt' => 'Asignado' ),
            array( 'db' => 'Estatus',           'dt' => 'Estatus' )
        );
         
        // SQL server connection information
        if( $this->session->userdata("sw") == 1 ){
            // SQL server connection information
            $sql_details = array(
                'user' => $this->db->username,
                'pass' => $this->db->password,
                'db'   => $this->db->database,
                'host' => $this->db->hostname   // REGRESAR A USO DE SERVICIOS WEB
            );
        }else{
            $db_intelisis = $this->load->database($this->session->userdata('nom_ag'), TRUE);   //<--- Conexion sin servicios web
            // SQL server connection information
            $sql_details = array(
                'user' => $db_intelisis->username,
                'pass' => $db_intelisis->password,
                'db'   => $db_intelisis->database,
                'host' => $db_intelisis->hostname   //<--- Conexion sin servicios web
            );
        }

        require( 'ssp.class.php' );
        $post = $this->input->post();
        $filtro_consulta = "Estatus IN (1,2) ";

        echo json_encode(
            SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
        );
    }

    public function PaquetesGeneral()
    {
        // $paquetes = $this->PaquetesModel->RegresaPaquetes();
        $cat_TipoPaquete = $this->PaquetesModel->cat_TipoPaquete();
        $this->load->view('Paquetes/PaquetesGeneral.php', compact('cat_TipoPaquete'));
    }

    public function AsignaPaquetes($id_paq_selec = null)
    {
        $cat_art = $this->PaquetesModel->catalogo_articulos();
        $cat_cil = $this->PaquetesModel->catalogo_cilindros();
        $cat_trans = $this->PaquetesModel->catalogo_transmision();
        $cat_motor = $this->PaquetesModel->catalogo_motor();
        $this->load->view("Paquetes/AsignaPaquetes.php", compact('cat_art', 'cat_cil', 'cat_trans', 'cat_motor', 'id_paq_selec'));
    }

    public function config_perfil()
    {
        $data['vendedor'] = $this->PaquetesModel->datos_usuario();
        $this->load->view("ConfigPerfil", $data);
    }

    public function actualizar()
    {
        $data1 = $this->input->post();
        $data = $this->PaquetesModel->actualizar_vendedor($data1);
        echo json_encode($data);
    }

    public function GuardaPaquete()
    {
        $data = $this->input->post();
        $data = $this->PaquetesModel->GuardaPaquete($data);
        echo json_encode($data);
    }

    public function DetallePaquete($id_paquete = null)
    {
        $Detalle = $this->PaquetesModel->DetallePaquete($id_paquete);
        echo json_encode($Detalle);
    }

    public function ObtienePaquete($id_paquete = null)
    {
        $Paqueton["Encabezado"] = $this->PaquetesModel->ObtienePaquete($id_paquete);
        $Paqueton["Detalle"] = $this->PaquetesModel->DetallePaquete($id_paquete);
        echo json_encode($Paqueton);
    }

    public function AsignaPaquete()
    {
        $data = $this->input->post();
        $data = $this->PaquetesModel->AsignaPaquete($data);
        echo json_encode($data);
    }

    public function AsignadoAPaquete($id_paquete = null)
    {
        $Asignado["Dtll"] = $this->PaquetesModel->AsignadoAPaquete($id_paquete);
        $Asignado['Reglas'] = $this->PaquetesModel->ReglasPaquete($id_paquete);
        $Asignado['NomPaq'] = $this->PaquetesModel->NomPaquete($id_paquete);
        echo json_encode($Asignado);
    }

    public function autocompleteArt()
    {
        $Cve_Art['Cve_Art'] = $this->input->get('Cve_Art');
        // $datax = $this->input->post();
        $data = $this->PaquetesModel->autocompleteArt($Cve_Art);
        echo json_encode($data);
    }

    public function autocompleteArtPkt()
    {
        $Cve_Art['Cve_Art'] = $this->input->get('Cve_Art');
        $data = $this->PaquetesModel->autocompleteArtPkt($Cve_Art);
        echo json_encode($data);
    }

    public function FltrPkts()
    {
        $CveArtPkt = $this->input->get('Cve_Art');
        $data = $this->PaquetesModel->FltrPkts($CveArtPkt);
        echo json_encode($data);
    }

    public function readercsv()
    {
        // $data = $this->input->post();
        print_r($_FILES);
        die();
        /*$this->load->library('csvreader');
        $result = $this->csvreader->parse_file("Mantenimiento.csv");
        $data['csvData'] = $result;*/
        // print_r($data);

        /*$ruta_destino = 'http://localhost/CCWeb/index.php/Paquetes/readercsv/';
        move_uploaded_file($_FILES['file_data']['name'], $ruta_destino.$_FILES['file_data']['name']);*/

        $this->load->library('csvreader');
        $result =   $this->csvreader->parse_file($_FILES['file_data']['tmp_name']);//path to csv file

        $data['csvData'] = $this->PaquetesModel->readercsv($result);

        // $data['csvData'] =  $result;

        // print_r($_FILES['file_data']['name']);
        echo json_encode($data);
        // print_r($data["csvData"]);
        // $this->load->view('view_csv', $data);
    }

    //Importar desde Excel con libreria de PHPExcel
    public function importarExcel(){
        $TipoPkt = $this->input->post();
        // print_r($_FILES['file_data']);
        //Cargar PHPExcel library
        $this->load->library('excel');

        $name   = $_FILES['file_data']['name'];
        $tname  = $_FILES['file_data']['tmp_name'];

        $obj_excel = PHPExcel_IOFactory::load($tname); 
        //         $post = $this->input->post();      
                // $post_tipo = 
        // print_r($_POST['id']);

        $sheets = $obj_excel->getSheetNames();  //Obtener los nombres de las hojas
        if ( in_array("GLOBAL", $sheets) )  {
            $result = $this->PaquetesModel->importarExcel($obj_excel, $name, $TipoPkt);
        }else{

            $result = $this->PaquetesModel->importarExcelV2($obj_excel, $name, $TipoPkt);
        }
        $this->output
             ->set_content_type('application/json')
             ->set_output(json_encode($result));        
    }

    public function GenerarArchivoPkts(){
        $this->PaquetesModel->LimpiaArchivosPktsM();
        $this->load->view('Paquetes/GenerarArchivoPkts.php');
    }

    public function CargaArchivosPkts(){
        /*print_r($_FILES['file_data']);
        // $ext = pathinfo($_FILES['file_data']['name'], PATHINFO_EXTENSION);
        print_r($_FILES['file_data']['error']);
        die();*/
        //Cargar PHPExcel library
        $this->load->library('excel');

        ############ Leer Archivo #################

        $name   = $_FILES['file_data']['name'];

        if ($_FILES['file_data']['error'] == 1) {
            $result['valid'] = false;
            $result['message'] = 'Archivo No Compatible: <strong>'.$name."</strong></br>FAVOR DE CONVERTIR EL ARCHIVO";
            $this->output->set_content_type('application/json')->set_output(json_encode($result));
            return 0;
        }

        $tname  = $_FILES['file_data']['tmp_name'];

        $obj_excel = PHPExcel_IOFactory::load($tname); 
        //         $post = $this->input->post();      
        // $post_tipo = 

        $result = $this->PaquetesModel->GenerarExcel($obj_excel, $name);

        ######### Fin Leer Archivo #################

        $this->output
             ->set_content_type('application/json')
             ->set_output(json_encode($result));
    }

    public function LimpiaArchivosPkts(){
        $data = $this->PaquetesModel->LimpiaArchivosPktsM();
        echo json_encode($data);
    }

    public function AsignaMultiPaquetes()
    {
        $cat_pkts = $this->PaquetesModel->catalogo_pkts();
        $cat_art = $this->PaquetesModel->catalogo_articulos();
        $cat_cil = $this->PaquetesModel->catalogo_cilindros();
        $cat_trans = $this->PaquetesModel->catalogo_transmision();
        $cat_motor = $this->PaquetesModel->catalogo_motor();
        $this->load->view("Paquetes/AsignaMultiPaquetes.php", compact('cat_art', 'cat_cil', 'cat_trans', 'cat_motor', 'cat_pkts'));
    }

    public function AsignarMultiPaquete()
    {
        $data = $this->input->post();
        $data = $this->PaquetesModel->AsignarMultiPaquete($data);
        echo json_encode($data);
    }

}