<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 29-06-2016
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: MenuL.php
*    Tipo: Controller
*    Descripcion: Controlador que manipula el menu lateral del CC.
*/

class MenuL extends MY_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
           redirect('login/offline', 'location');
        $this->load->model('MenuLModel');
    }

    public function autocompleteML()
    {
        $Cve_Prosp = $this->input->get('Cve_Prosp');
        $data = $this->MenuLModel->autocompleteML($Cve_Prosp);
        echo json_encode($data);
    }

    public function TListaProspectos()
    {
        // DB table to use
        $table = 'cte_prospecto';

        // Table's primary key
        $primaryKey = 'id';
         
        // indexes
        $columns = array(
            array( 'db' => 'id', 'dt' => 'id' ),
            array( 'db' => 'Nombre',  'dt' => 'Nombre' ),
            array( 'db' => 'ApPaterno',  'dt' => 'ApPaterno' ),
            array( 'db' => 'ApMaterno',  'dt' => 'ApMaterno' ),
            array( 'db' => 'Celular',   'dt' => 'Celular' )
        );
         
        // SQL server connection information
        $sql_details = array(
            'user' => $this->db->username,
            'pass' => $this->db->password,
            'db'   => $this->db->database,
            'host' => $this->db->hostname
        );

        require( 'ssp.class.php' );
        $post = $this->input->post();
        $filtro_consulta = "idUsuario = ".$this->session->userdata("id_usuario")." AND Activo = 1 ";
        echo json_encode(
            SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
        );
    }

    public function TSearchList()
    {
        // DB table to use
        $table = 'ListadoProspectos';

        // Table's primary key
        $primaryKey = 'id';
         
        // indexes
        $columns = array(
            array( 'db' => 'id', 'dt' => 'id' ),
            array( 'db' => 'Prospecto',  'dt' => 'Prospecto' ),
            array( 'db' => 'Celular',   'dt' => 'Celular' ),
            array( 'db' => 'idVehiculo', 'dt' => 'Vehiculo' ),
            array( 'db' => 'Modelo', 'dt' => 'Modelo' ),
            array( 'db' => 'Version', 'dt' => 'Version' ),
            array( 'db' => 'TipoEvento', 'dt' => 'Evento' ),
            array( 'db' => 'FechaEvento', 'dt' => 'FechaEvento' )
        );
         
        // SQL server connection information
        $sql_details = array(
            'user' => $this->db->username,
            'pass' => $this->db->password,
            'db'   => $this->db->database,
            'host' => $this->db->hostname
        );

        require( 'ssp.class.php' );
        $post = $this->input->post();
        $filtro_consulta = "idUsuario = ".$this->session->userdata("id_usuario")." AND Activo = 1 ";
        echo json_encode(
            SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
        );
    }

    public function FichaProspectoT()
    {
        $this->load->view('SeguimientoCC/FichaProspectoT');
    }

    public function FichaProspecto($idCliente = NULL)
    {
        $DatosCliente = $this->MenuLModel->DatosCliente($idCliente);
        $this->load->view('SeguimientoCC/FichaProspecto', compact("DatosCliente"));
    }

    public function ListadoProspectos()
    {
        $this->load->view('SeguimientoCC/ListadoProspectos');
    }

    public function AdmonProspectos()
    {
        $this->load->view('AdministradorCC/AdmonProspectos');
    }

    public function ConsultaFacturas()
    {
        $anio_anterior = mktime(0, 0, 0, date("m"), date("d"), date("Y") - 100);
        $ahora = mktime(0, 0, 0, date("m"), date("d"), date("Y") + 3);
        $db_intelisis = $this->load->database('intelisis', TRUE);
        $db_intelisis->query("spWebFacturacion '".$this->session->userdata("id_usuario")."', 'GMGUT', 0, '".date('d-m-Y', $anio_anterior)."', '".date('d-m-Y', $ahora)."', 0")->result_array(); //date("d-m-Y H:i:s")
        // print_r($db_intelisis->last_query());
        $this->load->view('Facturas/ConsultaFacturas');
    }

}