<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 14-06-2017
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: CtrlFacturas.php
*    Tipo: Controller
*    Descripcion: Controlador que manipula el Segumiento de la consulta de Facturas.
*/

class CtrlFacturas extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
           redirect('login/offline', 'location');
        $this->load->model('Facturas/FacturasModel');
    }

    public function TSearchFacturas( $fmin = 'x', $fmax = 'x',  $minK = 'x', $maxK = 'x', $Stipo = null )
    {
        // $min = $this->input->post('min');
        
        $db_intelisis = $this->load->database('intelisis', TRUE);
        // DB table to use
        $table = 'WebFacturacion';

        // Table's primary key
        $primaryKey = 'Estacion';
         
        // indexes
        $columns = array(
            array( 'db' => 'Mov', 'dt' => 'Mov' ),
            array( 'db' => 'Factura', 'dt' => 'Factura' ),
            array( 'db' => 'VIN',  'dt' => 'VIN' ),
            array( 'db' => 'Descripcion',  'dt' => 'Modelo' ),
            array( 'db' => 'Cliente',   'dt' => 'cveCliente' ),
            array( 'db' => 'Nombre',   'dt' => 'Cliente' ),
            array( 'db' => 'KmEst',   'dt' => 'Km' ),
            array( 'db' => 'FechaEmision',   'dt' => 'FechaEmision' ),
            array( 'db' => 'NumeroEconomico',  'dt' => 'NumeroEconomico' ),
            array( 'db' => 'Estatus',   'dt' => 'Estatus' )
        );
         
        // SQL server connection information
        $sql_details = array(
            'user' => $db_intelisis->username,
            'pass' => $db_intelisis->password,
            'db'   => $db_intelisis->database,
            'host' => $db_intelisis->hostname
        );

        require( 'ssp.class.php' );
        $post = $this->input->post();
        $filtro_consulta = "Estacion = ".$this->session->userdata("id_usuario");

        if( $fmin != 'x' && $fmax != 'x' )
            $filtro_consulta .= " AND FechaEmision BETWEEN '".$fmin."' AND '".$fmax."'";
        if($minK != "x")
            $filtro_consulta .= " AND KmEst >= '".$minK."'";
        if($maxK != "x")
            $filtro_consulta .= " AND KmEst <= '".$maxK."'";
        switch ($Stipo) {
            case 'Todos':
                # code...
                break;
            case 'Nuevo':
                $filtro_consulta .= " AND Mov in ('FEL Autofin', 'FEL Flotilla', 'FEL Intercambio', 'FEL Unidad')";
                break;
            case 'Usado':
                $filtro_consulta .= " AND Mov in ('FEL Usados')";
                break;
            case 'Servicio':
                $filtro_consulta .= " AND Mov in ('FEL Seguro', 'FEL Garantía', 'FEL Servicio')";
                break;
        }

        $filtro_consulta .= " ";

        echo json_encode(
            SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
        );
    }

    public function FichaFactura($idFactura = NULL)
    {
        $DatosFactura["Factura"] = $this->FacturasModel->DatosFactura($idFactura);
        $DatosFactura["VinsCliente"] = $this->FacturasModel->DatosCliente($DatosFactura["Factura"]["Cliente"]);
        // print_r($DatosFactura["VinsCliente"]);
        $this->load->view('Facturas/FichaFactura', compact("DatosFactura"));
    }

    public function ObtenerEventos()
    {
        $answer = $this->FacturasModel->ObtenerEventos($this->input->get('VinVehiculoSelect'), $this->input->get('ClienteSelect'));
        echo json_encode($answer);
    }

    public function Obtenertipos($dpto = NULL)
    {
        $data[ 'type' ] = $this->FacturasModel->Obtenertipos($dpto);
        
        echo json_encode($data);
    }

}