<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 05-07-2017
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: CtrlEncuestas.php
*    Tipo: Controller
*    Descripcion: Controlador que manipula el Segumiento de las Encuestas web del CC.
*/

class CtrlEncuestas extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
           redirect('login/offline', 'location');
        $this->load->model('Encuestas/EncuestasModel');
    }

    public function index()
    {
        // $this->load->view( 'Encuestas/end-inquiry' );
        $data[ 'departments' ] = $this->EncuestasModel->getInquiryTypes();
        $this->load->view( 'Encuestas/filter_inquiry' , $data );
    }

    public function Encuesta( $IdCatEncuesta = null, $Idventa = null, $fichaCliente = null )
    {
        $inquiryDone = $this->EncuestasModel->inquiryDone( $IdCatEncuesta, $Idventa );

        if ( $inquiryDone === 0 ) // new inquiry, not done none of the inquirys
        {
            $data = $this->EncuestasModel->beginInquiry( $IdCatEncuesta, $Idventa );

            $data[ 'IdFactura' ] = $this->EncuestasModel->getIdFactura( $Idventa );

            $data[ 'fichaCliente' ] = $fichaCliente;
            
            $this->load->view( 'Encuestas/inquiry', $data );
        }
        elseif ( $inquiryDone >= 1 ) // show an inquiry already done
        {
            $inquiryResult  = array('Idventa' => $Idventa, 'IdCatEncuesta' => $IdCatEncuesta);
            $data = $this->EncuestasModel->showInquiry( $inquiryResult );

            $data[ 'printFormat' ] = $this->EncuestasModel->getPrintFormat( $IdCatEncuesta, $Idventa );

            $data[ 'fichaCliente' ] = $fichaCliente;

            $this->load->view( 'Encuestas/show-inquiry', $data );
        }
  
        // $this->load->view( 'Encuestas/inquiry' );
    }

    public function saveInquiryResult()
    {
        $inquiryResult = $this->input->post();

        $IdCatEncuesta = $inquiryResult[ 'IdCatEncuesta' ];
        $Idventa = $inquiryResult[ 'Idventa' ];

        $inquiryDone = $this->EncuestasModel->inquiryDone( $IdCatEncuesta, $Idventa );

        if ( $inquiryDone >= 1 ) die( 'encuesta realizada!!!!!' );

        $this->EncuestasModel->saveInquiryResult( $inquiryResult );

        $data['IdCatEncuesta'] = $IdCatEncuesta;
        $data['Idventa'] = $Idventa;
        
        echo json_encode($data);
        // $this->load->view( 'Encuestas/end-inquiry', $data ); // the inquiry that was answered
    }

    public function endinquiry($Idventa = null, $IdCatEncuesta = null, $fichaCliente = null)
    {
        $inquiryResult  = array('Idventa' => $Idventa, 'IdCatEncuesta' => $IdCatEncuesta);
        $data = $this->EncuestasModel->showInquiry( $inquiryResult );

        $data[ 'printFormat' ] = $this->EncuestasModel->getPrintFormat( $IdCatEncuesta, $Idventa );

        $data[ 'fichaCliente' ] = $fichaCliente;

        $this->load->view('Encuestas/end-inquiry', $data);
    }

    public function getFilteredInvoices()
    {
        $data[ 'invoices' ] = $this->EncuestasModel->getFilteredInvoices();
        $data[ 'type' ] = $this->EncuestasModel->getTypeInquiry();
        
        echo json_encode($data);
    }

}