<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 13-07-2016
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: Seguimiento.php
*    Tipo: Controller
*    Descripcion: Controlador que manipula el Segumiento del CC.
*/

class Seguimiento extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
           redirect('login/offline', 'location');
        $this->load->model('CCWeb/SeguimientoModel');
    }

    public function ObtenerEventos()
    {
        $answer = $this->SeguimientoModel->ObtenerEventos($this->input->get('idVehiculoSelect'));
        echo json_encode($answer);
    }

    public function AltaProspecto($idProspectoModifica = null)
    {
        // $ProspectoModifica = $this->SeguimientoModel->ObtieneProspecto($idProspectoModifica);
        $this->load->view('SeguimientoCC/AltaProspecto.php', compact("idProspectoModifica"));
        // $this->load->view('SeguimientoCC/AltaProspecto.php');
    }

    public function ObtieneProspecto($idProspecto = null)
    {
        $DatosProspecto = $this->SeguimientoModel->ObtieneProspecto($idProspecto);
        echo json_encode($DatosProspecto);
    }

    public function autocompleteCP()
    {
        $Search = $this->input->get('Search');
        $cve_cp = $this->input->get('Cve_CP');
        $data = $this->SeguimientoModel->autocompleteCP($Search, $cve_cp);
        echo json_encode($data);
    }

    public function GuardarProspecto()
    {
        $NuevoProspecto = $this->input->post();
        $answer =  $this->SeguimientoModel->GuardarProspecto($NuevoProspecto);
        echo json_encode($answer);
    }

    public function AgregaVehiculo($idCliente = null)
    {
        $NuevoVehiculo = $this->input->post();
        $answer = $this->SeguimientoModel->AgregaVehiculo($NuevoVehiculo, $idCliente);
        echo json_encode($answer);
    }

    public function ObtenerTipoEventos()
    {
        $answer = $this->SeguimientoModel->ObtenerTipoEventos();
        echo json_encode($answer);
    }

    public function AgragaEvento()
    {
        $NuevoEvento = $this->input->post();
        $answer = $this->SeguimientoModel->AgragaEvento($NuevoEvento);
        echo json_encode($answer);
    }

    public function SeguimientoEvento()
    {
        $DatosEvento = $this->input->post();
        $answer = $this->SeguimientoModel->SeguimientoEvento($DatosEvento);
        echo json_encode($answer);
    }

}