<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 05-05-2017
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: Administracion.php
*    Tipo: Controller
*    Descripcion: Controlador que manipula administración del CC.
*/

class Administracion extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
           redirect('login/offline', 'location');   // redirect('index', 'location');
        $this->load->model('CCWeb/AdministracionModel');
    }

    public function TSearchList()
    {
        // DB table to use
        $table = 'ListadoProspectos';

        // Table's primary key
        $primaryKey = 'id';
         
        // indexes
        $columns = array(
            array( 'db' => 'id', 'dt' => 'id' ),
            array( 'db' => 'Prospecto',  'dt' => 'Prospecto' ),
            array( 'db' => 'Celular',   'dt' => 'Celular' ),
            array( 'db' => 'idVehiculo', 'dt' => 'Vehiculo' ),
            array( 'db' => 'Modelo', 'dt' => 'Modelo' ),
            array( 'db' => 'Version', 'dt' => 'Version' ),
            array( 'db' => 'TipoEvento', 'dt' => 'Evento' ),
            array( 'db' => 'FechaEvento', 'dt' => 'FechaEvento' )
        );
         
        // SQL server connection information
        $sql_details = array(
            'user' => $this->db->username,
            'pass' => $this->db->password,
            'db'   => $this->db->database,
            'host' => $this->db->hostname
        );

        require( 'ssp.class.php' );
        $post = $this->input->post();
        $filtro_consulta = "idUsuario = ".$this->session->userdata("id_usuario")." AND Activo = 1 ";
        echo json_encode(
            SSP::simple( $post, $sql_details, $table, $primaryKey, $columns, $filtro_consulta )
        );
    }
}