<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*  
*    _____  ____  _____  _________  ________  _____     _____   ______   _____   ______   
*   |_   _||_   \|_   _||  _   _  ||_   __  ||_   _|   |_   _|.' ____ \ |_   _|.' ____ \  
*     | |    |   \ | |  |_/ | | \_|  | |_ \_|  | |       | |  | (___ \_|  | |  | (___ \_| 
*     | |    | |\ \| |      | |      |  _| _   | |   _   | |   _.____`.   | |   _.____`.  
*    _| |_  _| |_\   |_    _| |_    _| |__/ | _| |__/ | _| |_ | \____) | _| |_ | \____) | 
*   |_____||_____|\____|  |_____|  |________||________||_____| \______.'|_____| \______.' 
*                                                                                      
*
*    Autor: Roberto Ortiz
*    Dia: 19-05-2017
*    Actualizacion:
*    Lenguage: PHP
*    FrameworK: CodeIgniter
*    Route: 
*    Archivo: CtrlAntilavado.php
*    Tipo: Controller
*    Descripcion: sera el controlador de manipular los requerimientos de la Ley CtrlAntilavado.
*/

class CtrlAntilavado extends CI_Controller 
{

	function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('loggedIn'))
            redirect('login/offline', 'location');
        $this->load->model('Antilavado/AntilavadoModel');
    }

    // public function index()
    // {
    //     $this->load->view('Base');
    // }

/*#### FUNCIONES PARA LA CONSULTA INICIAL DE REGISTROS ###########################*/
    //Funcion para cargar modulo de consulta
    public function ConsultaRegistros()
    {
        $data['Sucursales'] = $this->AntilavadoModel->ConsultaSucursales();
        $this->load->view('Antilavado/ConsultaRegistros', $data);
    }

    public function ConsultaMovimientos()
    {
        $data[ 'invoices' ] = $this->AntilavadoModel->ConsultaMovimientos(); 
        echo json_encode($data);
    }

    public function ObtenerPagos($idMovimiento = null)
    {
        $data = $this->AntilavadoModel->ObtenerPagos($idMovimiento);
        echo json_encode($data);
    }

    //Vista desechada *
    public function ListadoLeyAntilavado($id_sucursal = null, $id_periodo = null)
    {
        // $id_sucursal = $this->input->get('id_suc');
        $data['ListaLeyAntilavado'] = $this->AntilavadoModel->ListadoLeyAntilavado($id_sucursal, $id_periodo);
        $this->load->view('Antilavado/ListadoLeyAntilavado', $data);
    }

/*#### FUNCIONES PARA LA ESTRUCTURA DEL FORMATO ANTILAVADO #######################*/
    public function FormaAntilavado()
    {
        $this->load->view('Antilavado/FormaAntilavado');
    }

/*#### FUNCIONES PARA LA CONFIGURACION DEL MODULO ###############################*/
    public function Configuraciones()
    {
        $actividades_vulnerables = $this->AntilavadoModel->ConsultaActividadesVulnerables();
        $Config = $this->AntilavadoModel->ConsultaConfiguraciones();
        $this->load->view('Antilavado/Configuraciones.php', compact('Config','actividades_vulnerables'));
    }

    public function ActualizarConfiguraciones()
    {
        $Empresa='NISSA';
        $Configuraciones = $this->input->post();
        $data = $this->AntilavadoModel->actualizar_configuraciones($Configuraciones,$Empresa);
    //    $("#cuerpo").load(base_url+"index.php/Antilavado/Antilavado/Configuraciones/");
    }

/*#### FUNCIONES PARA EXPORTAR A XML Y VALIDAR #################################*/
    public function ExportarXml($estacion=999, $validado=0)
    {
      $n=1;
      $idVenta=1;
      $idPago=1;
        $Config = $this->AntilavadoModel->ConsultaConfiguraciones();
          

        $xml = new DomDocument('1.0', 'UTF-8');



        /****************************************** A **************************************************/
        $archivo = $xml->createElement('archivo'); // OBLIGATORIA <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<====
        $archivo->setAttribute( 'xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance' );
        $archivo->setAttribute( 'xmlns', 'http://www.uif.shcp.gob.mx/recepcion/veh' );
        $archivo->setAttribute( 'xsi:schemaLocation', 'http://www.uif.shcp.gob.mx/recepcion/veh https://sppld.sat.gob.mx/pld/documentos/links/xsd/veh.xsd' );
        if ($validado==0)  { $n++;  $archivo->setAttribute( 'linea', $n);    }
        $archivo = $xml->appendChild($archivo); 
        /******************************************AA***************************************************/
        $informe = $xml->createElement('informe'); // OBLIGATORIA <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<==== <<<====
        $informe = $archivo->appendChild($informe);
        if ($validado==0)  { $n++;  $informe->setAttribute( 'linea', $n);    }
        /******************************************1****************************************************/
        foreach ( $Config as $conf )
        {
          $mes_reportado = $xml->createElement('mes_reportado','201612');
          if ($validado==0) { $n++; $mes_reportado->setAttribute( 'linea', $n);   }
          $mes_reportado = $informe->appendChild($mes_reportado);
        /******************************************2****************************************************/
          $sujeto_obligado = $xml->createElement('sujeto_obligado');
          if ($validado==0) { $n++; $sujeto_obligado->setAttribute( 'linea', $n); }
          $sujeto_obligado = $informe->appendChild($sujeto_obligado);
        /******************************************2.1**************************************************/
        //   $clave_entidad_colegiada = $xml->createElement('clave_entidad_colegiada', 'ASA850513KC2');
        //  if ($validado==0) { $archivo->setAttribute( 'linea', $n);}
        //    $clave_entidad_colegiada = $sujeto_obligado->appendChild($clave_entidad_colegiada);     
        /******************************************2.2**************************************************/
            $clave_sujeto_obligado = $xml->createElement('clave_sujeto_obligado', $conf['RFC']);
            if ($validado==0)  { $n++; $clave_sujeto_obligado->setAttribute( 'linea', $n); }
            $clave_sujeto_obligado = $sujeto_obligado->appendChild($clave_sujeto_obligado);     
        /******************************************2.3**************************************************/
            $clave_actividad = $xml->createElement('clave_actividad', $conf['ClaveActividad']);
            if ($validado==0)  { $n++; $clave_actividad->setAttribute( 'linea', $n); }
            $clave_actividad = $sujeto_obligado->appendChild($clave_actividad);
        /******************************************2.4**************************************************/
        if ($conf['exento']==1)
        {
            $exento = $xml->createElement('exento',$conf['exento']);
            if ($validado==0)  { $n++; $exento->setAttribute( 'linea', $n); }
            $exento = $sujeto_obligado->appendChild($exento);     
        }
        /******************************************3****************************************************/
        }
        $avisos = $this->AntilavadoModel->ConsultaMovimientosPxml($estacion);
        foreach ( $avisos as $aviso )
        {
          $aviso = $xml->createElement('aviso');
          if ($validado==0)  { $n++;  $aviso->setAttribute( 'linea', $n);  $aviso->setAttribute( 'idVenta', $idVenta); }
          $aviso = $informe->appendChild($aviso);
        /******************************************3.1**************************************************/
            $referencia_aviso = $xml->createElement('referencia_aviso', 'ASA20160003018');
            if ($validado==0) { $n++; $referencia_aviso->setAttribute( 'linea', $n);  $referencia_aviso->setAttribute( 'idVenta', $idVenta);  }
            $referencia_aviso = $aviso->appendChild($referencia_aviso);
        /******************************************3.2**************************************************/
            $modificatorio = $xml->createElement('modificatorio', 'ASA20160003018');
            if ($validado==0) { $n++; $modificatorio->setAttribute( 'linea', $n);   $modificatorio->setAttribute( 'idVenta', $idVenta); }
            $modificatorio = $aviso->appendChild($modificatorio);
        /******************************************3.2.1************************************************/
              $folio_modificacion = $xml->createElement('folio_modificacion', 'ASA20160003018');
              if ($validado==0) { $n++; $folio_modificacion->setAttribute( 'linea', $n); $folio_modificacion->setAttribute( 'idVenta', $idVenta); }
              $folio_modificacion = $modificatorio->appendChild($folio_modificacion);
        /******************************************3.2.2************************************************/
              $descripcion_modificacion = $xml->createElement('descripcion_modificacion', 'ASA20160003018');
              if ($validado==0) { $n++; $descripcion_modificacion->setAttribute( 'linea', $n); $descripcion_modificacion->setAttribute( 'idVenta', $idVenta); }
              $descripcion_modificacion = $modificatorio->appendChild($descripcion_modificacion);
        /******************************************3.3**************************************************/
            $prioridad = $xml->createElement('prioridad', '1');
            if ($validado==0) { $n++; $prioridad->setAttribute( 'linea', $n); $prioridad->setAttribute( 'idVenta', $idVenta);   }
            $prioridad = $aviso->appendChild($prioridad);  
        /******************************************3.4**************************************************/
            $alerta = $xml->createElement('alerta');
            if ($validado==0) { $n++; $alerta->setAttribute( 'linea', $n); $alerta->setAttribute( 'idVenta', $idVenta);   }
            $alerta = $aviso->appendChild($alerta);
        /******************************************3.4.1************************************************/
              $tipo_alerta = $xml->createElement('tipo_alerta', '100');
              if ($validado==0) { $n++; $tipo_alerta->setAttribute( 'linea', $n); $tipo_alerta->setAttribute( 'idVenta', $idVenta); }
              $tipo_alerta = $alerta->appendChild($tipo_alerta);
        /******************************************3.4.2************************************************/
              $descripcion_alerta = $xml->createElement('descripcion_alerta', '100');
              if ($validado==0) { $n++; $descripcion_alerta->setAttribute( 'linea', $n); $descripcion_alerta->setAttribute( 'idVenta', $idVenta);   }
              $descripcion_alerta = $alerta->appendChild($descripcion_alerta);
        /******************************************3.5**************************************************/
            $persona_aviso = $xml->createElement('persona_aviso');
            if ($validado==0) { $n++; $persona_aviso->setAttribute( 'linea', $n); $persona_aviso->setAttribute( 'idVenta', $idVenta);    }
            $persona_aviso = $aviso->appendChild($persona_aviso);
        /******************************************3.5.1************************************************/
              $tipo_persona = $xml->createElement('tipo_persona');
              if ($validado==0) { $n++; $tipo_persona->setAttribute( 'linea', $n);  $tipo_persona->setAttribute( 'idVenta', $idVenta);  }
              $tipo_persona = $persona_aviso->appendChild($tipo_persona);
        /******************************************3.5.1.1**********************************************/
                $persona_fisica = $xml->createElement('persona_fisica');
                if ($validado==0)  { $n++; $persona_fisica->setAttribute( 'linea', $n); $persona_fisica->setAttribute( 'idVenta', $idVenta); }
                $persona_fisica = $tipo_persona->appendChild($persona_fisica);
        /******************************************3.5.1.1.1********************************************/
                  $nombre = $xml->createElement('nombre', 'JORGE');
                  if ($validado==0) { $n++; $nombre->setAttribute( 'linea', $n); $nombre->setAttribute( 'idVenta', $idVenta); }
                  $nombre = $persona_fisica->appendChild($nombre);
        /******************************************3.5.1.1.2********************************************/
                  $apellido_paterno = $xml->createElement('apellido_paterno', 'CHAMLATI');
                  if ($validado==0)  { $n++; $apellido_paterno->setAttribute( 'linea', $n);  $apellido_paterno->setAttribute( 'idVenta', $idVenta); }
                  $apellido_paterno = $persona_fisica->appendChild($apellido_paterno);
        /******************************************3.5.1.1.3********************************************/
                  $apellido_materno = $xml->createElement('apellido_materno', 'SALEM');
                  if ($validado==0)  { $n++; $apellido_materno->setAttribute( 'linea', $n); $apellido_materno->setAttribute( 'idVenta', $idVenta);  }
                  $apellido_materno = $persona_fisica->appendChild($apellido_materno);
        /******************************************3.5.1.1.4********************************************/
                  $fecha_nacimiento = $xml->createElement('fecha_nacimiento', '19660313');
                  if ($validado==0)   { $n++; $fecha_nacimiento->setAttribute( 'linea', $n);  $fecha_nacimiento->setAttribute( 'idVenta', $idVenta); }
                  $fecha_nacimiento = $persona_fisica->appendChild($fecha_nacimiento);
       /******************************************3.5.1.1.5********************************************/
                  $rfc = $xml->createElement('rfc', 'CASJ660313D58');
                  if ($validado==0)  { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);   }
                  $rfc = $persona_fisica->appendChild($rfc);
        /******************************************3.5.1.1.6********************************************/
                  $curp = $xml->createElement('curp', 'CASJ660313HDFHLR03');
                  if ($validado==0) { $n++; $curp->setAttribute( 'linea', $n); $curp->setAttribute( 'idVenta', $idVenta);     }
                  $curp = $persona_fisica->appendChild($curp);
        /******************************************3.5.1.1.7********************************************/
                  $pais_nacionalidad = $xml->createElement('pais_nacionalidad', 'CASJ660313HDFHLR03');
                  if ($validado==0) { $n++; $pais_nacionalidad->setAttribute( 'linea', $n);  $pais_nacionalidad->setAttribute( 'idVenta', $idVenta);  }
                  $pais_nacionalidad = $persona_fisica->appendChild($pais_nacionalidad);
        /******************************************3.5.1.1.8********************************************/
                  $actividad_economica = $xml->createElement('actividad_economica', 'CASJ660313HDFHLR03');
                  if ($validado==0) { $n++; $actividad_economica->setAttribute( 'linea', $n); $actividad_economica->setAttribute( 'idVenta', $idVenta);   }
                  $actividad_economica = $persona_fisica->appendChild($actividad_economica);
        /******************************************3.5.1.2**********************************************/
                $persona_moral = $xml->createElement('persona_moral');
                if ($validado==0) { $n++;  $persona_moral->setAttribute( 'linea', $n);   $persona_moral->setAttribute( 'idVenta', $idVenta);  }
                $persona_moral = $tipo_persona->appendChild($persona_moral);
        /******************************************3.5.1.2.1********************************************/
                  $denominacion_razon = $xml->createElement('denominacion_razon', 'AUTOMOTRIZ GEISHA SA DE CV');
                  if ($validado==0) { $n++; $denominacion_razon->setAttribute( 'linea', $n);   $denominacion_razon->setAttribute( 'idVenta', $idVenta); }
                  $denominacion_razon = $persona_moral->appendChild($denominacion_razon);
        /******************************************3.5.1.2.2********************************************/
                  $fecha_constitucion = $xml->createElement('fecha_constitucion', '19940928');
                  if ($validado==0) { $n++; $fecha_constitucion->setAttribute( 'linea', $n); $fecha_constitucion->setAttribute( 'idVenta', $idVenta);   }
                  $fecha_constitucion = $persona_moral->appendChild($fecha_constitucion);                        
        /******************************************3.5.1.2.3********************************************/
                  $rfc = $xml->createElement('rfc', 'AGE941122995');
                  if ($validado==0) { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);   }
                  $rfc = $persona_moral->appendChild($rfc);                     
        /******************************************3.5.1.2.4********************************************/
                  $pais_nacionalidad = $xml->createElement('pais_nacionalidad', 'MX');
                  if ($validado==0){ $n++; $pais_nacionalidad->setAttribute( 'linea', $n);  $pais_nacionalidad->setAttribute( 'idVenta', $idVenta);   }
                  $pais_nacionalidad = $persona_moral->appendChild($pais_nacionalidad);                      
        /******************************************3.5.1.2.5********************************************/
                  $giro_mercantil = $xml->createElement('giro_mercantil', '4720006');
                  if ($validado==0) { $n++; $giro_mercantil->setAttribute( 'linea', $n); $giro_mercantil->setAttribute( 'idVenta', $idVenta);    }
                  $giro_mercantil = $persona_moral->appendChild($giro_mercantil);
       /******************************************3.5.1.2.6********************************************/
                  $representante_apoderado = $xml->createElement('representante_apoderado');
                  if ($validado==0) { $n++; $representante_apoderado->setAttribute( 'linea', $n); $representante_apoderado->setAttribute( 'idVenta', $idVenta);   }
                  $representante_apoderado = $persona_moral->appendChild($representante_apoderado);
       /******************************************3.5.1.2.6.1******************************************/
                    $nombre = $xml->createElement('nombre', 'JORGE');
                    if ($validado==0)  { $n++;  $nombre->setAttribute( 'linea', $n);  $nombre->setAttribute( 'idVenta', $idVenta);  }
                    $nombre = $representante_apoderado->appendChild($nombre);
        /******************************************3.5.1.2.6.2******************************************/
                    $apellido_paterno = $xml->createElement('apellido_paterno', 'CHAMLATI');
                    if ($validado==0)  {$n++; $apellido_paterno->setAttribute( 'linea', $n);  $apellido_paterno->setAttribute( 'idVenta', $idVenta);   }
                    $apellido_paterno = $representante_apoderado->appendChild($apellido_paterno);                  
        /******************************************3.5.1.2.6.3******************************************/
                    $apellido_materno = $xml->createElement('apellido_materno', 'SALEM');
                    if ($validado==0) { $n++;  $apellido_materno->setAttribute( 'linea', $n);   $apellido_materno->setAttribute( 'idVenta', $idVenta); }
                    $apellido_materno = $representante_apoderado->appendChild($apellido_materno);
        /******************************************3.5.1.2.6.4******************************************/
                    $fecha_nacimiento = $xml->createElement('fecha_nacimiento', '19660313');
                    if ($validado==0) { $n++;  $fecha_nacimiento->setAttribute( 'linea', $n); $fecha_nacimiento->setAttribute( 'idVenta', $idVenta);  }
                    $fecha_nacimiento = $representante_apoderado->appendChild($fecha_nacimiento);
        /******************************************3.5.1.2.6.5******************************************/
                    $rfc = $xml->createElement('rfc', 'CASJ660313D58');
                    if ($validado==0) { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);  }
                    $rfc = $representante_apoderado->appendChild($rfc);
        /******************************************3.5.1.2.6.6******************************************/
                    $curp = $xml->createElement('curp', 'CASJ660313HDFHLR03');
                    if ($validado==0)  { $n++; $curp->setAttribute( 'linea', $n);  $curp->setAttribute( 'idVenta', $idVenta);  }
                    $curp = $representante_apoderado->appendChild($curp);
        /******************************************3.5.1.3**********************************************/
                $fideicomiso = $xml->createElement('fideicomiso');
                if ($validado==0)  { $n++;  $fideicomiso->setAttribute( 'linea', $n);  $fideicomiso->setAttribute( 'idVenta', $idVenta);   }
                $fideicomiso = $tipo_persona->appendChild($fideicomiso);
        /******************************************3.5.1.3.1********************************************/
                  $denominacion_razon = $xml->createElement('denominacion_razon', 'AUTOMOTRIZ GEISHA SA DE CV');
                  if ($validado==0) { $n++; $denominacion_razon->setAttribute( 'linea', $n);   $denominacion_razon->setAttribute( 'idVenta', $idVenta);   }
                  $denominacion_razon = $fideicomiso->appendChild($denominacion_razon);
        /******************************************3.5.1.3.2********************************************/
                  $rfc = $xml->createElement('rfc', 'CASJ660313D58');
                  if ($validado==0)  { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);     }
                  $rfc = $fideicomiso->appendChild($rfc);
        /******************************************3.5.1.3.3********************************************/
                  $identificador_fideicomiso = $xml->createElement('identificador_fideicomiso', 'CASJ660313D58');
                  if ($validado==0)  { $n++; $identificador_fideicomiso->setAttribute( 'linea', $n);  $identificador_fideicomiso->setAttribute( 'idVenta', $idVenta);   }
                  $identificador_fideicomiso = $fideicomiso->appendChild($identificador_fideicomiso);
        /******************************************3.5.1.3.4********************************************/
                  $apoderado_delegado = $xml->createElement('apoderado_delegado', 'CASJ660313D58');
                  if ($validado==0) { $n++;  $apoderado_delegado->setAttribute( 'linea', $n);  $apoderado_delegado->setAttribute( 'idVenta', $idVenta);     }
                  $apoderado_delegado = $fideicomiso->appendChild($apoderado_delegado);
        /******************************************3.5.1.3.4.1******************************************/
                    $nombre = $xml->createElement('nombre', 'JORGE');
                    if ($validado==0) {$n++;  $nombre->setAttribute( 'linea', $n); $nombre->setAttribute( 'idVenta', $idVenta);  }
                    $nombre = $apoderado_delegado->appendChild($nombre);
        /******************************************3.5.1.3.4.2******************************************/
                    $apellido_paterno = $xml->createElement('apellido_paterno', 'CHAMLATI');
                    if ($validado==0)  { $n++; $apellido_paterno->setAttribute( 'linea', $n);  $apellido_paterno->setAttribute( 'idVenta', $idVenta);  }
                    $apellido_paterno = $apoderado_delegado->appendChild($apellido_paterno);                          
        /******************************************3.5.1.3.4.3******************************************/
                    $apellido_materno = $xml->createElement('apellido_materno', 'SALEM');
                    if ($validado==0) { $n++; $apellido_materno->setAttribute( 'linea', $n);  $apellido_materno->setAttribute( 'idVenta', $idVenta);  }
                    $apellido_materno = $apoderado_delegado->appendChild($apellido_materno);
        /******************************************3.5.1.3.4.4******************************************/
                    $fecha_nacimiento = $xml->createElement('fecha_nacimiento', '19660313');
                    if ($validado==0) { $n++; $fecha_nacimiento->setAttribute( 'linea', $n); $fecha_nacimiento->setAttribute( 'idVenta', $idVenta);    }
                    $fecha_nacimiento = $apoderado_delegado->appendChild($fecha_nacimiento);             
        /******************************************3.5.1.3.4.5******************************************/
                    $rfc = $xml->createElement('rfc', 'CASJ660313D58');
                    if ($validado==0)  { $n++; $rfc->setAttribute( 'linea', $n);   $rfc->setAttribute( 'idVenta', $idVenta);   }
                    $rfc = $apoderado_delegado->appendChild($rfc);
        /******************************************3.5.1.3.4.6******************************************/
                    $curp = $xml->createElement('curp', 'CASJ660313HDFHLR03');
                    if ($validado==0)  { $n++; $curp->setAttribute( 'linea', $n);  $curp->setAttribute( 'idVenta', $idVenta);    }
                    $curp = $apoderado_delegado->appendChild($curp);
        /******************************************3.5.2************************************************/
              $tipo_domicilio = $xml->createElement('tipo_domicilio');
              if ($validado==0)  { $n++; $tipo_domicilio->setAttribute( 'linea', $n); $tipo_domicilio->setAttribute( 'idVenta', $idVenta);    }
              $tipo_domicilio = $persona_aviso->appendChild($tipo_domicilio);                     
        /******************************************3.5.2.1**********************************************/
                $nacional = $xml->createElement('nacional');
                  if ($validado==0)  { $n++; $nacional->setAttribute( 'linea', $n);  $nacional->setAttribute( 'idVenta', $idVenta);   }
                $nacional = $tipo_domicilio->appendChild($nacional);                           
        /******************************************3.5.2.1.1********************************************/
                  $colonia = $xml->createElement('colonia', 'BARRIO DE SAN BERNABE');
                  if ($validado==0)  { $n++; $colonia->setAttribute( 'linea', $n); $colonia->setAttribute( 'idVenta', $idVenta);    }
                  $colonia = $nacional->appendChild($colonia);                         
        /******************************************3.5.2.1.2********************************************/
                  $calle = $xml->createElement('calle', 'AV.CUITLAHUAC NUM. 3395');
                    if ($validado==0)  { $n++; $calle->setAttribute( 'linea', $n); $calle->setAttribute( 'idVenta', $idVenta);    }
                  $calle = $nacional->appendChild($calle);                       
        /******************************************3.5.2.1.3********************************************/
                  $numero_exterior = $xml->createElement('numero_exterior', '3395');
                   if ($validado==0)  { $n++; $numero_exterior->setAttribute( 'linea', $n); $numero_exterior->setAttribute( 'idVenta', $idVenta);    }
                  $numero_exterior = $nacional->appendChild($numero_exterior);
        /******************************************3.5.2.1.4********************************************/
                  $numero_interior = $xml->createElement('numero_interior', '02830');
                   if ($validado==0)  { $n++; $numero_interior->setAttribute( 'linea', $n); $numero_interior->setAttribute( 'idVenta', $idVenta);    }
                  $numero_interior = $nacional->appendChild($numero_interior);
        /******************************************3.5.2.1.5********************************************/
                  $codigo_postal = $xml->createElement('codigo_postal', '02830');
                  if ($validado==0)  { $n++; $codigo_postal->setAttribute( 'linea', $n); $codigo_postal->setAttribute( 'idVenta', $idVenta);    }
                  $codigo_postal = $nacional->appendChild($codigo_postal);
        /******************************************3.5.2.2**********************************************/
                $extranjero = $xml->createElement('extranjero');
                  if ($validado==0)  { $n++; $extranjero->setAttribute( 'linea', $n); $extranjero->setAttribute( 'idVenta', $idVenta);    }
                $extranjero = $tipo_domicilio->appendChild($extranjero);                           
        /******************************************3.5.2.2.1********************************************/
                  $pais = $xml->createElement('pais', 'BARRIO DE SAN BERNABE');
                   if ($validado==0)  { $n++; $pais->setAttribute( 'linea', $n); $pais->setAttribute( 'idVenta', $idVenta);    }
                  $pais = $extranjero->appendChild($pais);                       
        /******************************************3.5.2.2.2********************************************/
                  $estado_provincia = $xml->createElement('estado_provincia', 'BARRIO DE SAN BERNABE');
                  if ($validado==0)  { $n++; $estado_provincia->setAttribute( 'linea', $n); $estado_provincia->setAttribute( 'idVenta', $idVenta);    }
                  $estado_provincia = $extranjero->appendChild($estado_provincia);                           
        /******************************************3.5.2.2.3********************************************/
                  $ciudad_poblacion = $xml->createElement('ciudad_poblacion', 'BARRIO DE SAN BERNABE');
                  if ($validado==0)  {$n++; $ciudad_poblacion->setAttribute( 'linea', $n); $ciudad_poblacion->setAttribute( 'idVenta', $idVenta);    }
                  $ciudad_poblacion = $extranjero->appendChild($ciudad_poblacion);
        /******************************************3.5.2.2.4********************************************/
                  $colonia = $xml->createElement('colonia', 'BARRIO DE SAN BERNABE');
                  if ($validado==0)  {$n++; $colonia->setAttribute( 'linea', $n); $colonia->setAttribute( 'idVenta', $idVenta);    }
                  $colonia = $extranjero->appendChild($colonia);  
        /******************************************3.5.2.2.5********************************************/
                  $calle = $xml->createElement('calle', 'AV.CUITLAHUAC NUM. 3395');
                  if ($validado==0)  { $n++; $calle->setAttribute( 'linea', $n); $calle->setAttribute( 'idVenta', $idVenta);    }
                  $calle = $extranjero->appendChild($calle);                    
        /******************************************3.5.2.2.6********************************************/
                  $numero_exterior = $xml->createElement('numero_exterior', '3395');
                  if ($validado==0)  {$n++; $numero_exterior->setAttribute( 'linea', $n); $numero_exterior->setAttribute( 'idVenta', $idVenta);    }
                  $numero_exterior = $extranjero->appendChild($numero_exterior);                        
        /******************************************3.5.2.2.7********************************************/
                  $numero_interior = $xml->createElement('numero_interior', '3395');
                  if ($validado==0)  { $n++; $numero_interior->setAttribute( 'linea', $n); $numero_interior->setAttribute( 'idVenta', $idVenta);    }
                  $numero_interior = $extranjero->appendChild($numero_interior);                    
        /******************************************3.5.2.2.8********************************************/
                  $codigo_postal = $xml->createElement('codigo_postal', '02830');
                  if ($validado==0)  { $n++; $codigo_postal->setAttribute( 'linea', $n); $codigo_postal->setAttribute( 'idVenta', $idVenta);    }
                  $codigo_postal = $extranjero->appendChild($codigo_postal);
        /******************************************3.5.3************************************************/
              $telefono = $xml->createElement('telefono');
              if ($validado==0)  { $n++; $telefono->setAttribute( 'linea', $n); $telefono->setAttribute( 'idVenta', $idVenta);    }
              $telefono = $persona_aviso->appendChild($telefono);
        /******************************************3.5.3.1**********************************************/
                $clave_pais = $xml->createElement('clave_pais', 'MX');
                if ($validado==0)  { $n++; $clave_pais->setAttribute( 'linea', $n); $clave_pais->setAttribute( 'idVenta', $idVenta);    }
                $clave_pais = $telefono->appendChild($clave_pais);                
        /******************************************3.5.3.2**********************************************/
                $numero_telefono = $xml->createElement('numero_telefono', '5555544433');
                if ($validado==0)  { $n++; $numero_telefono->setAttribute( 'linea', $n); $numero_telefono->setAttribute( 'idVenta', $idVenta);    }
                $numero_telefono = $telefono->appendChild($numero_telefono);             
        /******************************************3.5.3.3**********************************************/
                $correo_electronico = $xml->createElement('correo_electronico', 'JMARTINEZ@GEISHA.MX');
                if ($validado==0)  { $n++; $correo_electronico->setAttribute( 'linea', $n); $correo_electronico->setAttribute( 'idVenta', $idVenta);    }
                $correo_electronico = $telefono->appendChild($correo_electronico);
        /******************************************3.6**************************************************/
            $dueno_beneficiario = $xml->createElement('dueno_beneficiario');
            if ($validado==0)  { $n++; $dueno_beneficiario->setAttribute( 'linea', $n); $dueno_beneficiario->setAttribute( 'idVenta', $idVenta);    }
            $dueno_beneficiario = $aviso->appendChild($dueno_beneficiario);
        /******************************************3.6.1************************************************/
              $tipo_persona = $xml->createElement('tipo_persona');
              if ($validado==0)  { $n++; $tipo_persona->setAttribute( 'linea', $n); $tipo_persona->setAttribute( 'idVenta', $idVenta);    }
              $tipo_persona = $dueno_beneficiario->appendChild($tipo_persona);
        /******************************************3.6.1.1**********************************************/
                $persona_fisica = $xml->createElement('persona_fisica');
                if ($validado==0)  {$n++; $persona_fisica->setAttribute( 'linea', $n); $persona_fisica->setAttribute( 'idVenta', $idVenta);    }
                $persona_fisica = $tipo_persona->appendChild($persona_fisica);
        /******************************************3.6.1.1.1********************************************/
                  $nombre = $xml->createElement('nombre', 'JORGE');
                  if ($validado==0)  { $n++; $nombre->setAttribute( 'linea', $n); $nombre->setAttribute( 'idVenta', $idVenta);    }
                  $nombre = $persona_fisica->appendChild($nombre);
        /******************************************3.6.1.1.2********************************************/
                  $apellido_paterno = $xml->createElement('apellido_paterno', 'JORGE');
                  if ($validado==0)  {$n++; $apellido_paterno->setAttribute( 'linea', $n); $apellido_paterno->setAttribute( 'idVenta', $idVenta);    }
                  $apellido_paterno = $persona_fisica->appendChild($apellido_paterno);
        /******************************************3.6.1.1.3********************************************/
                  $apellido_materno = $xml->createElement('apellido_materno', 'JORGE');
                  if ($validado==0)  {$n++; $apellido_materno->setAttribute( 'linea', $n); $apellido_materno->setAttribute( 'idVenta', $idVenta);    }
                  $apellido_materno = $persona_fisica->appendChild($apellido_materno);
        /******************************************3.6.1.1.4********************************************/
                  $fecha_nacimiento = $xml->createElement('fecha_nacimiento', 'JORGE');
                  if ($validado==0)  {$n++; $fecha_nacimiento->setAttribute( 'linea', $n); $fecha_nacimiento->setAttribute( 'idVenta', $idVenta);    }
                  $fecha_nacimiento = $persona_fisica->appendChild($fecha_nacimiento);
        /******************************************3.6.1.1.5********************************************/
                  $rfc = $xml->createElement('rfc', 'JORGE');
                  if ($validado==0)  {$n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);    }
                  $rfc = $persona_fisica->appendChild($rfc);
        /******************************************3.6.1.1.6********************************************/
                  $curp = $xml->createElement('curp', 'JORGE');
                  if ($validado==0)  {$n++; $curp->setAttribute( 'linea', $n); $curp->setAttribute( 'idVenta', $idVenta);    }
                  $curp = $persona_fisica->appendChild($curp);
        /******************************************3.6.1.1.7********************************************/
                  $pais_nacionalidad = $xml->createElement('pais_nacionalidad', 'JORGE');
                  if ($validado==0)  { $n++; $pais_nacionalidad->setAttribute( 'linea', $n); $pais_nacionalidad->setAttribute( 'idVenta', $idVenta);    }
                  $pais_nacionalidad = $persona_fisica->appendChild($pais_nacionalidad);
        /******************************************3.6.1.2**********************************************/
                $persona_moral = $xml->createElement('persona_moral');
                if ($validado==0)  { $n++; $persona_moral->setAttribute( 'linea', $n); $persona_moral->setAttribute( 'idVenta', $idVenta);    }
                $persona_moral = $tipo_persona->appendChild($persona_moral);
        /******************************************3.6.1.2.1********************************************/
                  $denominacion_razon = $xml->createElement('denominacion_razon', 'JORGE');
                  if ($validado==0)  {$n++; $denominacion_razon->setAttribute( 'linea', $n); $denominacion_razon->setAttribute( 'idVenta', $idVenta);    }
                  $denominacion_razon = $persona_moral->appendChild($denominacion_razon);
        /******************************************3.6.1.2.2********************************************/
                  $fecha_constitucion = $xml->createElement('fecha_constitucion', 'JORGE');
                  if ($validado==0)  { $n++; $fecha_constitucion->setAttribute( 'linea', $n); $fecha_constitucion->setAttribute( 'idVenta', $idVenta);    }
                  $fecha_constitucion = $persona_moral->appendChild($fecha_constitucion);
        /******************************************3.6.1.2.3********************************************/
                  $rfc = $xml->createElement('rfc', 'JORGE');
                  if ($validado==0)  { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);    }
                  $rfc = $persona_moral->appendChild($rfc);
        /******************************************3.6.1.2.4********************************************/
                  $pais_nacionalidad = $xml->createElement('pais_nacionalidad', 'JORGE');
                  if ($validado==0)  { $n++; $pais_nacionalidad->setAttribute( 'linea', $n); $pais_nacionalidad->setAttribute( 'idVenta', $idVenta);    }
                  $pais_nacionalidad = $persona_moral->appendChild($pais_nacionalidad);
        /******************************************3.6.1.3**********************************************/
                $fideicomiso = $xml->createElement('fideicomiso');
                if ($validado==0)  { $n++; $fideicomiso->setAttribute( 'linea', $n); $fideicomiso->setAttribute( 'idVenta', $idVenta);    }
                $fideicomiso = $tipo_persona->appendChild($fideicomiso);
        /******************************************3.6.1.3.1********************************************/
                  $denominacion_razon = $xml->createElement('denominacion_razon', 'JORGE');
                  if ($validado==0)  { $n++; $denominacion_razon->setAttribute( 'linea', $n); $denominacion_razon->setAttribute( 'idVenta', $idVenta);    }
                  $denominacion_razon = $fideicomiso->appendChild($denominacion_razon);
        /******************************************3.6.1.3.2********************************************/
                  $rfc = $xml->createElement('rfc', 'JORGE');
                  if ($validado==0)  { $n++; $rfc->setAttribute( 'linea', $n); $rfc->setAttribute( 'idVenta', $idVenta);    }
                  $rfc = $fideicomiso->appendChild($rfc);
        /******************************************3.6.1.3.3********************************************/
                  $identificador_fideicomiso = $xml->createElement('identificador_fideicomiso', 'JORGE');
                  if ($validado==0)  { $n++; $identificador_fideicomiso->setAttribute( 'linea', $n); $identificador_fideicomiso->setAttribute( 'idVenta', $idVenta);    }
                  $identificador_fideicomiso = $fideicomiso->appendChild($identificador_fideicomiso);
        /******************************************3.7**************************************************/
            $detalle_operaciones = $xml->createElement('detalle_operaciones');
            if ($validado==0)  { $n++; $detalle_operaciones->setAttribute( 'linea', $n); $detalle_operaciones->setAttribute( 'idVenta', $idVenta);    }
            $detalle_operaciones = $aviso->appendChild($detalle_operaciones);
        /******************************************3.7.1************************************************/
              $datos_operacion = $xml->createElement('datos_operacion');
              if ($validado==0)  { $n++; $datos_operacion->setAttribute( 'linea', $n); $datos_operacion->setAttribute( 'idVenta', $idVenta);    }
              $datos_operacion = $detalle_operaciones->appendChild($datos_operacion);
        /******************************************3.7.1.1**********************************************/
                $fecha_operacion = $xml->createElement('fecha_operacion', '20161229');
                if ($validado==0)  {  $n++; $fecha_operacion->setAttribute( 'linea', $n); $fecha_operacion->setAttribute( 'idVenta', $idVenta);    }
                $fecha_operacion = $datos_operacion->appendChild($fecha_operacion);  
        /******************************************3.7.1.2**********************************************/
                $codigo_postal = $xml->createElement('codigo_postal', '01090');
                if ($validado==0)  { $n++; $codigo_postal->setAttribute( 'linea', $n); $codigo_postal->setAttribute( 'idVenta', $idVenta);    }
                $codigo_postal = $datos_operacion->appendChild($codigo_postal);                   
        /******************************************3.7.1.3**********************************************/
                $tipo_operacion = $xml->createElement('tipo_operacion', '805');
                if ($validado==0)  {$n++; $tipo_operacion->setAttribute( 'linea', $n); $tipo_operacion->setAttribute( 'idVenta', $idVenta);    }
                $tipo_operacion = $datos_operacion->appendChild($tipo_operacion);
        /******************************************3.7.1.4**********************************************/
                $tipo_vehiculo = $xml->createElement('tipo_vehiculo');
                if ($validado==0)  {$n++; $tipo_vehiculo->setAttribute( 'linea', $n); $tipo_vehiculo->setAttribute( 'idVenta', $idVenta);    }
                $tipo_vehiculo = $datos_operacion->appendChild($tipo_vehiculo);
        /******************************************3.7.1.4.1********************************************/
                  $datos_vehiculo_terrestre = $xml->createElement('datos_vehiculo_terrestre');
                  if ($validado==0)  {$n++; $datos_vehiculo_terrestre->setAttribute( 'linea', $n); $datos_vehiculo_terrestre->setAttribute( 'idVenta', $idVenta);    }
                  $datos_vehiculo_terrestre = $tipo_vehiculo->appendChild($datos_vehiculo_terrestre);                               
        /******************************************3.7.1.4.1.1******************************************/
                    $marca_fabricante = $xml->createElement('marca_fabricante', 'NISSAN');
                    if ($validado==0)  {$n++; $marca_fabricante->setAttribute( 'linea', $n); $marca_fabricante->setAttribute( 'idVenta', $idVenta);    }
                    $marca_fabricante = $datos_vehiculo_terrestre->appendChild($marca_fabricante);                             
        /******************************************3.7.1.4.1.2******************************************/
                    $modelo = $xml->createElement('modelo', 'XTRAIL 5/PTAS ADVANCE 2 ROW');
                    if ($validado==0)  {$n++; $modelo->setAttribute( 'linea', $n); $modelo->setAttribute( 'idVenta', $idVenta);    }
                    $modelo = $datos_vehiculo_terrestre->appendChild($modelo);                           
        /******************************************3.7.1.4.1.3******************************************/
                    $anio = $xml->createElement('anio', '2016');
                    if ($validado==0)  {$n++; $anio->setAttribute( 'linea', $n); $anio->setAttribute( 'idVenta', $idVenta);    }
                    $anio = $datos_vehiculo_terrestre->appendChild($anio);                              
        /******************************************3.7.1.4.1.4******************************************/
                    $vin = $xml->createElement('vin', 'JN8BT27TXGW023082');
                    if ($validado==0)  {$n++; $vin->setAttribute( 'linea', $n); $vin->setAttribute( 'idVenta', $idVenta);    }
                    $vin = $datos_vehiculo_terrestre->appendChild($vin);                       
        /******************************************3.7.1.4.1.5******************************************/
                    $repuve = $xml->createElement('repuve', '9');
                    if ($validado==0)  {$n++; $repuve->setAttribute( 'linea', $n); $repuve->setAttribute( 'idVenta', $idVenta);    }
                    $repuve = $datos_vehiculo_terrestre->appendChild($repuve);
        /******************************************3.7.1.4.1.6******************************************/
                    $placas = $xml->createElement('placas', '9');
                    if ($validado==0)  {$n++; $placas->setAttribute( 'linea', $n); $placas->setAttribute( 'idVenta', $idVenta);    }
                    $placas = $datos_vehiculo_terrestre->appendChild($placas);
        /******************************************3.7.1.4.1.7******************************************/
                    $nivel_blindaje = $xml->createElement('nivel_blindaje', '9');
                    if ($validado==0)  {$n++; $nivel_blindaje->setAttribute( 'linea', $n); $nivel_blindaje->setAttribute( 'idVenta', $idVenta);    }
                    $nivel_blindaje = $datos_vehiculo_terrestre->appendChild($nivel_blindaje);
        /******************************************3.7.1.4.2********************************************/
                  $datos_vehiculo_maritimo = $xml->createElement('datos_vehiculo_maritimo');
                  if ($validado==0)  {$n++; $datos_vehiculo_maritimo->setAttribute( 'linea', $n); $datos_vehiculo_maritimo->setAttribute( 'idVenta', $idVenta);    }
                  $datos_vehiculo_maritimo = $tipo_vehiculo->appendChild($datos_vehiculo_maritimo);                
        /******************************************3.7.1.4.2.1******************************************/
                    $marca_fabricante = $xml->createElement('marca_fabricante', 'NISSAN');
                    if ($validado==0)  {$n++; $marca_fabricante->setAttribute( 'linea', $n); $marca_fabricante->setAttribute( 'idVenta', $idVenta);    }
                    $marca_fabricante = $datos_vehiculo_maritimo->appendChild($marca_fabricante);                       
        /******************************************3.7.1.4.2.2******************************************/
                    $modelo = $xml->createElement('modelo', 'XTRAIL 5/PTAS ADVANCE 2 ROW');
                    if ($validado==0)  {$n++; $modelo->setAttribute( 'linea', $n); $modelo->setAttribute( 'idVenta', $idVenta);    }
                    $modelo = $datos_vehiculo_maritimo->appendChild($modelo);
        /******************************************3.7.1.4.2.3******************************************/
                    $anio = $xml->createElement('anio', '2016');
                    if ($validado==0)  {$n++; $anio->setAttribute( 'linea', $n); $anio->setAttribute( 'idVenta', $idVenta);    }
                    $anio = $datos_vehiculo_maritimo->appendChild($anio);                    
        /******************************************3.7.1.4.2.4******************************************/
                    $vin = $xml->createElement('numero_serie', 'JN8BT27TXGW023082');
                    if ($validado==0)  {$n++; $vin->setAttribute( 'linea', $n); $vin->setAttribute( 'idVenta', $idVenta);    }
                    $vin = $datos_vehiculo_maritimo->appendChild($vin); 
        /******************************************3.7.1.4.2.5******************************************/
                    $bandera = $xml->createElement('bandera', '9');
                    if ($validado==0)  {$n++; $bandera->setAttribute( 'linea', $n); $bandera->setAttribute( 'idVenta', $idVenta);    }
                    $bandera = $datos_vehiculo_maritimo->appendChild($bandera);
        /******************************************3.7.1.4.2.6******************************************/
                    $matricula = $xml->createElement('matricula', '9');
                    if ($validado==0)  {$n++; $matricula->setAttribute( 'linea', $n); $matricula->setAttribute( 'idVenta', $idVenta);    }
                    $matricula = $datos_vehiculo_maritimo->appendChild($matricula);                               
        /******************************************3.7.1.4.2.7******************************************/
                    $nivel_blindaje = $xml->createElement('nivel_blindaje', '9');
                    if ($validado==0)  {$n++; $nivel_blindaje->setAttribute( 'linea', $n); $nivel_blindaje->setAttribute( 'idVenta', $idVenta);    }
                    $nivel_blindaje = $datos_vehiculo_maritimo->appendChild($nivel_blindaje);
        /******************************************3.7.1.4.3********************************************/
                  $datos_vehiculo_aereo = $xml->createElement('datos_vehiculo_aereo');
                  if ($validado==0)  {$n++; $datos_vehiculo_aereo->setAttribute( 'linea', $n); $datos_vehiculo_aereo->setAttribute( 'idVenta', $idVenta);    }
                  $datos_vehiculo_aereo = $tipo_vehiculo->appendChild($datos_vehiculo_aereo);            
         /******************************************3.7.1.4.3.1******************************************/
                    $marca_fabricante = $xml->createElement('marca_fabricante', 'NISSAN');
                    if ($validado==0)  {$n++; $marca_fabricante->setAttribute( 'linea', $n); $marca_fabricante->setAttribute( 'idVenta', $idVenta);    }
                    $marca_fabricante = $datos_vehiculo_aereo->appendChild($marca_fabricante);
        /******************************************3.7.1.4.3.2******************************************/
                    $modelo = $xml->createElement('modelo', 'XTRAIL 5/PTAS ADVANCE 2 ROW');
                    if ($validado==0)  {$n++; $modelo->setAttribute( 'linea', $n); $modelo->setAttribute( 'idVenta', $idVenta);    }
                    $modelo = $datos_vehiculo_aereo->appendChild($modelo);
        /******************************************3.7.1.4.3.3******************************************/
                    $anio = $xml->createElement('anio', '2016');
                    if ($validado==0)  {$n++; $anio->setAttribute( 'linea', $n); $anio->setAttribute( 'idVenta', $idVenta);    }
                    $anio = $datos_vehiculo_aereo->appendChild($anio);                     
        /******************************************3.7.1.4.3.4******************************************/
                    $vin = $xml->createElement('numero_serie', 'JN8BT27TXGW023082');
                    if ($validado==0)  {$n++; $vin->setAttribute( 'linea', $n); $vin->setAttribute( 'idVenta', $idVenta);    }
                    $vin = $datos_vehiculo_aereo->appendChild($vin);
        /******************************************3.7.1.4.3.5******************************************/
                    $bandera = $xml->createElement('bandera', '9');
                    if ($validado==0)  {$n++; $bandera->setAttribute( 'linea', $n); $bandera->setAttribute( 'idVenta', $idVenta);    }
                    $bandera = $datos_vehiculo_aereo->appendChild($bandera);
        /******************************************3.7.1.4.3.6******************************************/
                    $matricula = $xml->createElement('matricula', '9');
                    if ($validado==0)  {$n++; $matricula->setAttribute( 'linea', $n); $matricula->setAttribute( 'idVenta', $idVenta);    }
                    $matricula = $datos_vehiculo_aereo->appendChild($matricula);
        /******************************************3.7.1.4.3.7******************************************/
                    $nivel_blindaje = $xml->createElement('nivel_blindaje', '9');
                    if ($validado==0)  {$n++; $nivel_blindaje->setAttribute( 'linea', $n); $nivel_blindaje->setAttribute( 'idVenta', $idVenta);    }
                    $nivel_blindaje = $datos_vehiculo_aereo->appendChild($nivel_blindaje);
        /******************************************3.7.1.5**********************************************/
                $datos_liquidacion = $xml->createElement('datos_liquidacion');
                if ($validado==0)  {$n++; $datos_liquidacion->setAttribute( 'linea', $n); $datos_liquidacion->setAttribute( 'idVenta', $idVenta);    }
                $datos_liquidacion = $datos_operacion->appendChild($datos_liquidacion);          
      
        $pagos_venta = $this->AntilavadoModel->ConsultaPagosVenta($estacion,$idVenta);
        foreach ( $pagos_venta as $pago )
          {
        /******************************************3.7.1.5.1********************************************/
                  $fecha_pago = $xml->createElement('fecha_pago', $pago[ 'FechaEmision' ]);
                  if ($validado==0)  {$n++; $fecha_pago->setAttribute( 'linea', $n); $fecha_pago->setAttribute( 'idVenta', $idVenta);  $fecha_pago->setAttribute( 'idPago', $idPago);   }
                  $fecha_pago = $datos_liquidacion->appendChild($fecha_pago);                        
        /******************************************3.7.1.5.2********************************************/
                  $forma_pago = $xml->createElement('forma_pago',$pago[ 'descripcion' ]);
                  if ($validado==0)  {$n++; $forma_pago->setAttribute( 'linea', $n); $forma_pago->setAttribute( 'idVenta', $idVenta);  $forma_pago->setAttribute( 'idPago', $idPago);   }
                  $forma_pago = $datos_liquidacion->appendChild($forma_pago);  
        /******************************************3.7.1.5.3********************************************/
                  $instrumento_monetario = $xml->createElement('instrumento_monetario', $pago[ 'descripcion' ]);
                  if ($validado==0)  {$n++; $instrumento_monetario->setAttribute( 'linea', $n); $instrumento_monetario->setAttribute( 'idVenta', $idVenta);  $instrumento_monetario->setAttribute( 'idPago', $idPago);   }
                  $instrumento_monetario = $datos_liquidacion->appendChild($instrumento_monetario);                       
        /******************************************3.7.1.5.4********************************************/
                  $moneda = $xml->createElement('moneda', $pago[ 'CveMon' ]);
                  if ($validado==0)  {$n++; $instrumento_monetario->setAttribute( 'linea', $n); $instrumento_monetario->setAttribute( 'idVenta', $idVenta);  $instrumento_monetario->setAttribute( 'idPago', $idPago);   }
                  $moneda = $datos_liquidacion->appendChild($moneda);                      
        /******************************************3.7.1.5.4********************************************/
                  $monto_operacion = $xml->createElement('monto_operacion', $pago[ 'Total' ]);
                  if ($validado==0)  {$n++; $instrumento_monetario->setAttribute( 'linea', $n); $instrumento_monetario->setAttribute( 'idVenta', $idVenta);  $instrumento_monetario->setAttribute( 'idPago', $idPago);   }
                  $monto_operacion = $datos_liquidacion->appendChild($monto_operacion);                 
          }
    }
        

        $xml->formatOutput = true;
        $xml->normalizeDocument();
        $el_xml = $xml->saveXML();
        $xml->save('assets/Antilavado/xml/estructura.xml');
     
        //Mostramos el XML puro
       // $xml_texto=htmlentities($el_xml);
        $this->load->view('Antilavado/XML.php', compact('el_xml'));

      // echo "<p><b>El XML ha sido creado.... Mostrando en texto plano:</b></p>".htmlentities($el_xml)."<br/><hr>";
    }

    public function ValidarXML($nombre_xml = 'Morelia',$estacion=999)
    {
        libxml_use_internal_errors(true);
        $this->AntilavadoModel->VaciaErrores($estacion);
        $xml = new DOMDocument();
        $xml->load('assets/Antilavado/xml/'.$nombre_xml.'.xml');

        if (!$xml->schemaValidate('assets/Antilavado/veh.xsd')) {
            print '<b>DOMDocument::schemaValidate() Generated Errors!</b>';
            $errors = libxml_get_errors();
            foreach ($errors as $error) {
                $return ="<br/>\n";
                switch ($error->level) {
                    case LIBXML_ERR_WARNING:
                        $return .= "<b>Warning $error->code</b>: ";
                        break;
                    case LIBXML_ERR_ERROR:
                        $return .= "<b>Error $error->code</b>: ";
                        break;
                    case LIBXML_ERR_FATAL:
                        $return .= "<b>Fatal Error $error->code</b>: ";
                        break;
                }
                $return .= trim($error->message);

                $return .= " on line $error->line.\n";
                echo $return;
                $elemento=$this->ObtenerValor($return,"'","'");
                $mensaje=$this->ObtenerValor($return,":",".");
                $linea=$this->ObtenerValor($return,"on line ",".");
                $this->AntilavadoModel->InsertaError($estacion,$elemento,$linea+0,$mensaje);    
            }
            libxml_clear_errors();
        }
        else 
        {
            echo "No se detectaron errores. Archivo válidado Correctamente";
            $this->ExportarXML();
        }
    }

    public function ObtenerValor($string, $start, $end)
    {
        $string = " ".$string;
        $string=str_replace("{http://www.uif.shcp.gob.mx/recepcion/veh}","",$string);
        $ini = strpos($string,$start);
        if ($ini == 0) return "";
        $ini += strlen($start);     
        $len = strpos($string,$end,$ini) - $ini;
        return substr($string,$ini,$len);
    }

}